// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
//	NAME:		FileNode.java
//	DATE:		2003.9.23
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.bench.model; 

import java.io.File;
import javax.swing.filechooser.FileSystemView;

public class FileNode {
	private static final File[] NO_DIRECTORY = new java.io.File[0];
	
	private String mAbsPath;
	private String mDisplayedName;
    private File mFile;
	private File[] mSubFiles;
	private java.io.FileFilter mFilter;
	
    public FileNode(java.io.File inFile) {
    	this (inFile, null);
    }
    
    public FileNode(File inFile, java.io.FileFilter inFilter) {
    	if (null == inFile) {
    		throw new IllegalArgumentException("must specified File-object to construct this object");
    	}
    	
        mAbsPath = inFile.getAbsolutePath();
        mDisplayedName = FileSystemView.getFileSystemView().getSystemDisplayName(inFile);
        mFile = inFile;
        mFilter = inFilter;
        
        if (! isLeaf()) {
        	mSubFiles = mFile.listFiles();
        	if (null != mFilter) {
        		java.util.List aFiles = new java.util.ArrayList(mSubFiles.length);
        		for (int i = 0; i < mSubFiles.length; ++i) {
        			if (mFilter.accept(mSubFiles[i])) {
        				aFiles.add(mSubFiles[i]);
        			}
        		}
        		
        		mSubFiles = (File[])aFiles.toArray(new File[aFiles.size()]);
        	}
        }
        else {
        	mSubFiles = NO_DIRECTORY; 
        }
    }

    public String getName() {
    	return mDisplayedName;
    }
	
	public String getAbsolutePath() {
		return mAbsPath;
	}
	
    public void setName(String inName) {
    	throw new UnsupportedOperationException();
    }
	
    public long getSize() {
        return mFile.length();
    }

    public void addChild(FileNode inNode) {
    		FileSystemView.getFileSystemView().createFileObject(mFile, inNode.mAbsPath);
//	    	new java.io.File(fileNode.getName()).createNewFile();
			mSubFiles = mFile.listFiles(mFilter);
    }

    public void addChild(int index, FileNode inNode) {
        addChild(inNode);
    }
    
    public void removeChild(FileNode inNode) {
	        if (inNode.mFile.delete()) {
		        mSubFiles = mFile.listFiles(mFilter);
	        }
    }

    public FileNode getChild(int inIndex) {
        return new FileNode(mSubFiles[inIndex], mFilter);
    }

    public int getIndexOfChild(FileNode inChild) {
		for (int i = 0; i < mSubFiles.length; ++i) {
			if (mSubFiles[i].equals(inChild.mFile)) {
				return i;
			}
		}
		
		return -1;
    }

    public int getChildCount() {
    	if (isLeaf()) {
    		return 0;
    	}
    	else {
        	return mSubFiles.length;
        }
    }

    /**
     *	TreeNodehashCode()equals()I[o[ChĂȂƁA
     *	vO}uTreeexpand/collapse邱ƂoȂȂĂ܂
     */
    public int hashCode() {
    	return mFile.hashCode();
    }
    
    public boolean equals(Object inRHS) {
    	if (inRHS instanceof FileNode) {
    		return mFile.equals(((FileNode)inRHS).mFile);
    	}
    	
    	return false;
    }
    
    /**
     *	toStringI[o[ChĂȂƁAc[ɐ\Ȃ
     */
    public String toString() {
    	return getName();
    }
    
    public boolean isLeaf() {
        return mFile.isFile();
    }
} // FileNode





