/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.app.view;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.model.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.model.NullModel;
import jp.gr.java_conf.ktz.puzzle.framework.util.Command;
import jp.gr.java_conf.ktz.puzzle.framework.view.CommandContainer;
import jp.gr.java_conf.ktz.puzzle.framework.view.DefaultRenderer;
import jp.gr.java_conf.ktz.puzzle.framework.view.awt.AWTDispatchCommandQueue;
import jp.gr.java_conf.ktz.puzzle.framework.view.awt.BoardView;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.AbstractBottomUpCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.BoardSizeCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.LoadCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.PieceSizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.BoardModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.BridgibleCheckModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.HashikakeModelChangeHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.ModelChangeDispatcher;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.ModelChangeEvent;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.SolutionCheckModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.view.RendererFactory;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.view.command.CheckResultCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.AppColors;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.MenuManager;

public class Board
extends Canvas
implements BoardView {
    private static final Logger HASHI_LOGGER = Logger.getLogger((class$jp$gr$java_conf$ktz$puzzle$hashikake$app$view$Board == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$app$view$Board = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.app.view.Board")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$app$view$Board).getPackage().getName());
    private static final int DEFAULT_BOARD_WIDTH = 9;
    private static final int DEFAULT_BOARD_HEIGHT = 9;
    private static final Point NO_CLICKED = ModelConstants.ILLEGAL_POS;
    private Model mModel = NullModel.getInstance();
    private ModelChangeDispatcher mDispatcher = new ModelChangeDispatcher(){

        public void processModelChange(ModelChangeEvent modelChangeEvent) {
        }
    };
    private DefaultRenderer mRenderer;
    private Map mTable;
    private BoardView mParent;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$app$view$Board;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$app$view$command$CheckCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$framework$view$command$BoardSizeCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$framework$view$command$LoadCommand;

    public void initialize() {
        if (HASHI_LOGGER.isLoggable(Level.INFO)) {
            HASHI_LOGGER.info("init");
        }
        this.mModel = NullModel.getInstance();
        this.mRenderer = RendererFactory.create(9, 9);
        this.setBackground(AppColors.BACK_COLOR);
        this.createBoard(9, 9);
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        PieceSizeCommand pieceSizeCommand = new PieceSizeCommand((CommandContainer)this, this.getPieceSize());
        AWTDispatchCommandQueue.postCommand((Command)pieceSizeCommand);
    }

    public void processCommand(Command command) {
        if (!command.isConsumed()) {
            this.processCommandImpl(command);
        }
        if (!command.isConsumed() && command instanceof AbstractBottomUpCommand) {
            this.mParent.processCommand(command);
        }
    }

    protected void processCommandImpl(Command command) {
        Class<?> clazz = command.getClass();
        if (clazz == (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.command.ResetCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand)) {
            this.clear();
            command.consume();
        } else if (clazz == (class$jp$gr$java_conf$ktz$puzzle$hashikake$app$view$command$CheckCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$app$view$command$CheckCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.app.view.command.CheckCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$app$view$command$CheckCommand)) {
            boolean bl = this.check();
            command.consume();
            CheckResultCommand checkResultCommand = new CheckResultCommand((CommandContainer)this, bl);
            AWTDispatchCommandQueue.postCommand((Command)checkResultCommand);
        } else if (clazz == (class$jp$gr$java_conf$ktz$puzzle$framework$view$command$BoardSizeCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$framework$view$command$BoardSizeCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.framework.view.command.BoardSizeCommand")) : class$jp$gr$java_conf$ktz$puzzle$framework$view$command$BoardSizeCommand)) {
            int n = ((BoardSizeCommand)command).getComponentWidth();
            int n2 = ((BoardSizeCommand)command).getComponentHeight();
            this.setComponentSize(n, n2);
        } else if (clazz == (class$jp$gr$java_conf$ktz$puzzle$framework$view$command$LoadCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$framework$view$command$LoadCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.framework.view.command.LoadCommand")) : class$jp$gr$java_conf$ktz$puzzle$framework$view$command$LoadCommand)) {
            ProblemInfo problemInfo = ((LoadCommand)command).getProblem();
            this.load(problemInfo);
            command.consume();
        }
    }

    public void setParent(BoardView boardView) {
        this.mParent = boardView;
    }

    private void load(ProblemInfo problemInfo) {
        if (HASHI_LOGGER.isLoggable(Level.INFO)) {
            HASHI_LOGGER.info("load problem");
        }
        if (null == problemInfo) {
            throw new IllegalArgumentException("pass null object to inInfo");
        }
        if (this.mModel instanceof NullModel) {
            this.mModel = new SolutionCheckModel((Model)new BridgibleCheckModel((Model)new BoardModel(this.mModel)));
            this.mDispatcher = new HashikakeModelChangeHandler(this.mModel);
        }
        this.createBoard(problemInfo.getWidth(), problemInfo.getHeight());
        this.mModel.setProblem(problemInfo);
        if (this.mModel.isModified()) {
            Rectangle rectangle = this.getClipBounds();
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void createBoard(int n, int n2) {
        this.mRenderer.setSize(n, n2);
        this.mModel.createBoard(n, n2);
        Dimension dimension = this.mRenderer.getBoardSize();
        BoardSizeCommand boardSizeCommand = new BoardSizeCommand((CommandContainer)this, dimension.width, dimension.height);
        AWTDispatchCommandQueue.postCommand((Command)boardSizeCommand);
    }

    private boolean check() {
        if (HASHI_LOGGER.isLoggable(Level.INFO)) {
            HASHI_LOGGER.info("check solution");
        }
        return this.mModel.check();
    }

    public boolean isModified() {
        return false;
    }

    public Component getComponent() {
        return this;
    }

    private int getPieceSize() {
        return this.mRenderer.getPieceSize().width;
    }

    private void setComponentSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public void setFocus(boolean bl) {
        this.mParent.setFocus(bl);
    }

    public boolean isFocused() {
        return this.mParent.isFocused();
    }

    private void clear() {
        if (HASHI_LOGGER.isLoggable(Level.INFO)) {
            HASHI_LOGGER.info("clear problem");
        }
        this.mModel.reset();
        MenuManager.currentMenuManager().setEnabledFor("Clear", false);
        if (this.mModel.isModified()) {
            Rectangle rectangle = this.getClipBounds();
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private Point calcPortToBoardPos(int n, int n2) {
        return this.mRenderer.calcPortToBoardPos(n, n2);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (this.mModel.isModified()) {
            rectangle = new Rectangle();
            Point[] pointArray = this.mModel.lastModified();
            for (int i = 0; i < pointArray.length; ++i) {
                this.mRenderer.render(pointArray[i].x, pointArray[i].y, this.mModel.getCurStateAt(pointArray[i].x, pointArray[i].y));
            }
            rectangle = this.getClipBounds();
        }
        graphics.drawImage(this.mRenderer.getImage(), 0, 0, this);
        this.mModel.flush();
    }

    private Rectangle getClipBounds() {
        return this.mRenderer.getClipBounds(this.mModel.lastModified());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        private Point mClickedPos = Board.access$100();

        private MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = Board.this.calcPortToBoardPos(mouseEvent.getX(), mouseEvent.getY());
            if (!Board.this.mModel.isNumberAt(point.x, point.y)) {
                return;
            }
            this.mClickedPos = point;
            ModelChangeEvent modelChangeEvent = ModelChangeEvent.createSelectionEvent(this.mClickedPos.x, this.mClickedPos.y, Direction.NO);
            Board.this.mDispatcher.processModelChange(modelChangeEvent);
            Rectangle rectangle = Board.this.getClipBounds();
            Board.this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Direction direction = this.calcDirection(Board.this.calcPortToBoardPos(mouseEvent.getX(), mouseEvent.getY()));
            ModelChangeEvent modelChangeEvent = ModelChangeEvent.createDeterminationEvent(this.mClickedPos.x, this.mClickedPos.y, direction);
            if (mouseEvent.getModifiers() == 4 || mouseEvent.getModifiers() == 17) {
                modelChangeEvent.changeTransit(false);
            }
            Board.this.mDispatcher.processModelChange(modelChangeEvent);
            this.mClickedPos = NO_CLICKED;
            if (Board.this.mModel.isModified()) {
                MenuManager.currentMenuManager().setEnabledFor("Clear", true);
                Rectangle rectangle = Board.this.getClipBounds();
                Board.this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (NO_CLICKED == this.mClickedPos) {
                return;
            }
            Direction direction = this.calcDirection(Board.this.calcPortToBoardPos(mouseEvent.getX(), mouseEvent.getY()));
            ModelChangeEvent modelChangeEvent = ModelChangeEvent.createSelectionEvent(this.mClickedPos.x, this.mClickedPos.y, direction);
            Board.this.mDispatcher.processModelChange(modelChangeEvent);
            if (Board.this.mModel.isModified()) {
                Rectangle rectangle = Board.this.getClipBounds();
                Board.this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        private Direction calcDirection(Point point) {
            if (this.mClickedPos.equals(point)) {
                return Direction.NO;
            }
            if (point.x == this.mClickedPos.x) {
                if (point.y > this.mClickedPos.y) {
                    return Direction.SOUTH;
                }
                return Direction.NORTH;
            }
            if (point.y == this.mClickedPos.y) {
                if (point.x > this.mClickedPos.x) {
                    return Direction.EAST;
                }
                return Direction.WEST;
            }
            return Direction.NO;
        }
    }
}

