/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import java.util.HashMap;
import java.util.Map;
import jp.gr.java_conf.ktz.puzzle.framework.DecoratedStateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.BigNSBridgeState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.BigWEBridgeState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.BranchState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.HashikakeNumberState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NSBridgeState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NumberState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.SpaceState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.WEBridgeState;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class HashikakeStateManagerImpl
extends DecoratedStateManagerImpl {
    public static final String SPACE_ID = "s";
    public static final String NS_BRIDGE_ID = "i";
    public static final String BIG_NS_BRIDGE_ID = "ii";
    public static final String WE_BRIDGE_ID = "-";
    public static final String BIG_WE_BRIDGE_ID = "=";
    public static final String NULL_ID = "";
    private Map mStateMap = new HashMap();
    private Map mStateToIDMap = new HashMap();
    private Map mTransitMap = new HashMap();
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NSBridgeState;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$WEBridgeState;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigNSBridgeState;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigWEBridgeState;

    public HashikakeStateManagerImpl() {
        this(null);
    }

    public HashikakeStateManagerImpl(StateManagerImpl stateManagerImpl) {
        super(stateManagerImpl);
        State state = SpaceState.getInstance();
        NSBridgeState nSBridgeState = new NSBridgeState();
        BigNSBridgeState bigNSBridgeState = new BigNSBridgeState();
        WEBridgeState wEBridgeState = new WEBridgeState();
        BigWEBridgeState bigWEBridgeState = new BigWEBridgeState();
        StateEventCode stateEventCode = UtilityFuncs.getDetermineDirectionEventCode(Direction.WEST);
        StateEventCode stateEventCode2 = UtilityFuncs.getDetermineDirectionEventCode(Direction.EAST);
        StateEventCode stateEventCode3 = UtilityFuncs.getDetermineDirectionEventCode(Direction.NORTH);
        StateEventCode stateEventCode4 = UtilityFuncs.getDetermineDirectionEventCode(Direction.SOUTH);
        this.installStateMap(SPACE_ID, state);
        this.installStateMap(NS_BRIDGE_ID, nSBridgeState);
        this.installStateMap(BIG_NS_BRIDGE_ID, bigNSBridgeState);
        this.installStateMap(WE_BRIDGE_ID, wEBridgeState);
        this.installStateMap(BIG_WE_BRIDGE_ID, bigWEBridgeState);
        this.installTransitMap((State)nSBridgeState, state, bigNSBridgeState, new StateEventCode[]{stateEventCode3, stateEventCode4});
        this.installTransitMap((State)bigNSBridgeState, (State)nSBridgeState, state, new StateEventCode[]{stateEventCode3, stateEventCode4});
        this.installTransitMap((State)wEBridgeState, state, bigWEBridgeState, new StateEventCode[]{stateEventCode, stateEventCode2});
        this.installTransitMap((State)bigWEBridgeState, (State)wEBridgeState, state, new StateEventCode[]{stateEventCode, stateEventCode2});
        this.installTransitMap(state, state, new BranchState.TransitHint[]{new BranchState.TransitHint(nSBridgeState, new StateEventCode[]{stateEventCode3, stateEventCode4}), new BranchState.TransitHint(wEBridgeState, new StateEventCode[]{stateEventCode, stateEventCode2})}, new StateEventCode[]{stateEventCode3, stateEventCode4, stateEventCode, stateEventCode2});
    }

    private void installTransitMap(State state, State state2, State state3, StateEventCode[] stateEventCodeArray) {
        this.mTransitMap.put(state, new TransitRecord(state2, state3, stateEventCodeArray));
    }

    private void installTransitMap(State state, State state2, BranchState.TransitHint[] transitHintArray, StateEventCode[] stateEventCodeArray) {
        this.installTransitMap(state, state2, new BranchState(transitHintArray), stateEventCodeArray);
    }

    private void installStateMap(String string, State state) {
        this.mStateMap.put(string, state);
        this.mStateToIDMap.put(state, string);
    }

    protected State createStateOfSelf(String string) {
        String string2 = string.trim().toLowerCase();
        if (this.mStateMap.containsKey(string2)) {
            return (State)this.mStateMap.get(string2);
        }
        try {
            int n = Integer.parseInt(string2);
            NumberState numberState = new NumberState(n);
            this.installStateMap(string2, numberState);
            return numberState;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Illegal State ID : " + string);
        }
    }

    protected State createDefaultStateSelf() {
        return this.createStateOf(SPACE_ID);
    }

    protected String findIdentityOfSelf(State state) {
        if (this.isNumberState(state)) {
            return this.findIdentityOf(((HashikakeNumberState)state).getNumberState());
        }
        if (!this.mStateToIDMap.containsKey(state)) {
            throw new IllegalArgumentException("The ID corresponding to the state is no existance.");
        }
        return (String)this.mStateToIDMap.get(state);
    }

    protected State getNextStateSelf(State state) {
        throw new UnsupportedOperationException("The method getNextState(State) is not supported");
    }

    protected State getNextStateSelf(State state, StateEventCode stateEventCode) {
        if (this.isNumberState(state)) {
            return this.getNextNumberState(state, stateEventCode);
        }
        if (!this.mTransitMap.containsKey(state)) {
            throw new IllegalArgumentException("The next State is no existence.");
        }
        TransitRecord transitRecord = (TransitRecord)this.mTransitMap.get(state);
        return transitRecord.mNext.onEnter(stateEventCode);
    }

    private State getNextNumberState(State state, StateEventCode stateEventCode) {
        HashikakeNumberState hashikakeNumberState = (HashikakeNumberState)state;
        Direction direction = UtilityFuncs.resolveDirectionOf(stateEventCode);
        HashikakeNumberState.AdjacentState adjacentState = hashikakeNumberState.findAdjacentOf(direction);
        if (null != adjacentState) {
            State state2 = this.getNextState(adjacentState.getState(), stateEventCode);
            adjacentState.setState(state2);
        }
        return state;
    }

    protected State getPrevStateSelf(State state) {
        throw new UnsupportedOperationException("The method getPrevState(State) is not supported");
    }

    protected State getPrevStateSelf(State state, StateEventCode stateEventCode) {
        if (this.isNumberState(state)) {
            return this.getPrevNumberState(state, stateEventCode);
        }
        if (!this.mTransitMap.containsKey(state)) {
            throw new IllegalArgumentException("The next State is no existence.");
        }
        TransitRecord transitRecord = (TransitRecord)this.mTransitMap.get(state);
        return transitRecord.mPrev.onEnter(stateEventCode);
    }

    private State getPrevNumberState(State state, StateEventCode stateEventCode) {
        HashikakeNumberState hashikakeNumberState = (HashikakeNumberState)state;
        Direction direction = UtilityFuncs.resolveDirectionOf(stateEventCode);
        HashikakeNumberState.AdjacentState adjacentState = hashikakeNumberState.findAdjacentOf(direction);
        if (null != adjacentState) {
            State state2 = this.getPrevState(adjacentState.getState(), stateEventCode);
            adjacentState.setState(state2);
        }
        return state;
    }

    protected boolean isNumberStateSelf(State state) {
        return state instanceof HashikakeNumberState;
    }

    protected boolean isSpaceStateSelf(State state) {
        return state instanceof SpaceState;
    }

    protected boolean isTransitSelf(State state, StateEventCode stateEventCode) {
        if (this.isNumberState(state)) {
            return true;
        }
        if (!this.mTransitMap.containsKey(state)) {
            return false;
        }
        TransitRecord transitRecord = (TransitRecord)this.mTransitMap.get(state);
        for (int i = 0; i < transitRecord.mEvent.length; ++i) {
            if (transitRecord.mEvent[i] != stateEventCode) continue;
            return true;
        }
        return false;
    }

    protected boolean isTransitSelf(State state) {
        throw new UnsupportedOperationException("The method isTransit(State) is not supported");
    }

    protected boolean acceptableEventCode(StateEventCode stateEventCode) {
        return UtilityFuncs.isSelectionType(stateEventCode) || UtilityFuncs.isDeterminationType(stateEventCode);
    }

    public static int countBridge(State state) {
        if ((class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NSBridgeState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NSBridgeState = HashikakeStateManagerImpl.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NSBridgeState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NSBridgeState).equals(state.getClass()) || (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$WEBridgeState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$WEBridgeState = HashikakeStateManagerImpl.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.WEBridgeState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$WEBridgeState).equals(state.getClass())) {
            return 1;
        }
        if ((class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigNSBridgeState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigNSBridgeState = HashikakeStateManagerImpl.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.BigNSBridgeState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigNSBridgeState).equals(state.getClass()) || (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigWEBridgeState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigWEBridgeState = HashikakeStateManagerImpl.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.BigWEBridgeState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigWEBridgeState).equals(state.getClass())) {
            return 2;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class TransitRecord {
        final State mPrev;
        final State mNext;
        final StateEventCode[] mEvent;

        TransitRecord(State state, State state2, StateEventCode[] stateEventCodeArray) {
            this.mPrev = state;
            this.mNext = state2;
            this.mEvent = stateEventCodeArray;
        }
    }
}

