/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import java.awt.Point;
import java.util.Arrays;
import java.util.HashSet;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.model.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.model.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NumberActiveState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.SelectionState;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class BridgibleCheckModel
extends AbstractDecoratedModel {
    private static final Point EMPTY_POS = ModelConstants.ILLEGAL_POS;
    private static final Point[] NO_MODIFIED = ModelConstants.EMPTIES;
    private Point mPressedPos = EMPTY_POS;
    private Point mOppositePos = EMPTY_POS;
    private Point[] mSelectedPos = NO_MODIFIED;
    private Point[] mDeactivatedPos = NO_MODIFIED;
    private boolean mIsModified = false;
    private Direction mDirection = Direction.NO;

    public BridgibleCheckModel(Model model) {
        super(model);
    }

    public State getCurStateAt(int n, int n2) {
        Point point = new Point(n, n2);
        State state = super.getCurStateAt(n, n2);
        if (point.equals(this.mPressedPos)) {
            return new NumberActiveState(state, this.mDirection);
        }
        if (point.equals(this.mOppositePos)) {
            Direction direction = UtilityFuncs.inverseDirection(this.mDirection);
            return new NumberActiveState(state, direction);
        }
        Point[] pointArray = this.mSelectedPos;
        for (int i = 0; i < pointArray.length; ++i) {
            if (!point.equals(pointArray[i])) continue;
            return new SelectionState(state);
        }
        return state;
    }

    protected void createBoardSelf(int n, int n2) {
    }

    protected void resetAtSelf(int n, int n2) {
    }

    protected Point[] lastModifiedSelf() {
        HashSet<Point> hashSet = new HashSet<Point>();
        if (this.mDeactivatedPos != NO_MODIFIED) {
            hashSet.addAll(Arrays.asList(this.mDeactivatedPos));
        }
        if (this.mSelectedPos != NO_MODIFIED) {
            hashSet.addAll(Arrays.asList(this.mSelectedPos));
        }
        return hashSet.toArray(new Point[hashSet.size()]);
    }

    protected boolean isModifiedSelf() {
        return this.mIsModified;
    }

    protected boolean isAcceptableEvent(StateEventCode stateEventCode) {
        return UtilityFuncs.isSelectionType(stateEventCode) || UtilityFuncs.isDeterminationType(stateEventCode);
    }

    protected void nextStateAtSelf(int n, int n2, StateEventCode stateEventCode) {
    }

    public void nextStateAt(int n, int n2, StateEventCode stateEventCode) {
        if (this.isAcceptableEvent(stateEventCode)) {
            if (UtilityFuncs.isSelectionType(stateEventCode)) {
                this.changeSelection(n, n2, stateEventCode);
            } else if (UtilityFuncs.isDeterminationType(stateEventCode)) {
                this.determine();
                if (this.mOppositePos != EMPTY_POS && new Point(n, n2).equals(this.mOppositePos)) {
                    Direction direction = UtilityFuncs.inverseDirection(UtilityFuncs.resolveDirectionOf(stateEventCode));
                    StateEventCode stateEventCode2 = UtilityFuncs.getDetermineDirectionEventCode(direction);
                    this.getDecorated().nextStateAt(this.mOppositePos.x, this.mOppositePos.y, stateEventCode2);
                    this.mOppositePos = EMPTY_POS;
                    return;
                }
            }
        }
        this.getDecorated().nextStateAt(n, n2, stateEventCode);
    }

    private void changeSelection(int n, int n2, StateEventCode stateEventCode) {
        Direction direction = UtilityFuncs.resolveDirectionOf(stateEventCode);
        if (direction == Direction.NO) {
            this.mPressedPos = new Point(n, n2);
            this.mOppositePos = EMPTY_POS;
            this.mDeactivatedPos = this.mSelectedPos;
            this.mSelectedPos = new Point[]{this.mPressedPos};
            this.mDirection = direction;
            this.mIsModified = true;
            return;
        }
        if (direction == this.mDirection) {
            return;
        }
        this.mDirection = direction;
        this.activate(direction);
    }

    private void determine() {
        if (!this.mIsModified) {
            this.mDeactivatedPos = this.mSelectedPos;
            this.mSelectedPos = NO_MODIFIED;
            this.mPressedPos = EMPTY_POS;
            this.mDirection = Direction.NO;
            this.mIsModified = true;
        }
    }

    protected void prevStateAtSelf(int n, int n2, StateEventCode stateEventCode) {
    }

    public void prevStateAt(int n, int n2, StateEventCode stateEventCode) {
        if (this.isAcceptableEvent(stateEventCode)) {
            if (UtilityFuncs.isSelectionType(stateEventCode)) {
                this.changeSelection(n, n2, stateEventCode);
            } else if (UtilityFuncs.isDeterminationType(stateEventCode)) {
                this.determine();
                if (this.mOppositePos != EMPTY_POS && new Point(n, n2).equals(this.mOppositePos)) {
                    Direction direction = UtilityFuncs.inverseDirection(UtilityFuncs.resolveDirectionOf(stateEventCode));
                    StateEventCode stateEventCode2 = UtilityFuncs.getDetermineDirectionEventCode(direction);
                    this.getDecorated().prevStateAt(this.mOppositePos.x, this.mOppositePos.y, stateEventCode2);
                    this.mOppositePos = EMPTY_POS;
                    return;
                }
            }
        }
        this.getDecorated().prevStateAt(n, n2, stateEventCode);
    }

    private void activate(Direction direction) {
        this.mDeactivatedPos = this.mSelectedPos;
        if (!this.isBuildBridge(direction)) {
            this.mSelectedPos = NO_MODIFIED;
            return;
        }
        Point point = direction.getDifference();
        Point point2 = new Point(this.mPressedPos);
        HashSet<Point> hashSet = new HashSet<Point>();
        hashSet.add(new Point(point2));
        point2.translate(point.x, point.y);
        do {
            hashSet.add(new Point(point2));
            point2.translate(point.x, point.y);
        } while (!this.isNumberAt(point2.x, point2.y));
        this.mOppositePos = new Point(point2);
        hashSet.add(this.mOppositePos);
        this.mSelectedPos = hashSet.toArray(new Point[hashSet.size()]);
        this.mIsModified = true;
    }

    private boolean isBuildBridge(Direction direction) {
        Point point = direction.getDifference();
        Point point2 = new Point(this.mPressedPos);
        StateEventCode stateEventCode = UtilityFuncs.getDetermineDirectionEventCode(direction);
        point2.translate(point.x, point.y);
        if (!this.isTransitAt(point2.x, point2.y, stateEventCode)) {
            return false;
        }
        do {
            point2.translate(point.x, point.y);
            if (!this.isNumberAt(point2.x, point2.y)) continue;
            return true;
        } while (this.contains(point2.x, point2.y) && this.isTransitAt(point2.x, point2.y, stateEventCode));
        return false;
    }

    protected void flushSelf() {
        if (this.mIsModified) {
            this.mDeactivatedPos = NO_MODIFIED;
            this.mIsModified = false;
        }
    }
}

