/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.bench.view;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.BenchmarkMediator;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.Colleague;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.view.AbstractFrameColleague;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.view.CancelButtonColleague;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.view.DetailButtonColleague;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.view.ProgressDialog;

public class ProgressDialogColleague
extends AbstractFrameColleague {
    static final String[] DETAIL_BUTON_LABEL = new String[]{"show", "hide"};
    static final String CANCEL_BUTON_LABEL = "Cancel";
    private BenchmarkMediator mMediator;
    private ProgressDialog mProgress;
    private JDialog mDialog;
    private final Colleague mDetailButtonColleague = new DetailButtonColleague(this);
    private final Colleague mCancelButtonColleague = new CancelButtonColleague();
    private int mOffsetCount;

    public ProgressDialogColleague(BenchmarkMediator benchmarkMediator, Component component, int n) {
        this.mProgress = new ProgressDialog(component, "file : ", 0, n);
        this.mMediator = benchmarkMediator;
        this.mDialog = this.mProgress.createDialog(component, "Now measuring");
        this.mDialog.addWindowListener(this.getDefaultWindowListener());
        this.mProgress.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (ProgressDialogColleague.this.mDialog.isVisible() && propertyChangeEvent.getSource() instanceof ProgressDialog && propertyChangeEvent.getPropertyName().equals("value") && propertyChangeEvent.getNewValue() != null) {
                    Colleague colleague = ProgressDialogColleague.this.getColleagueForOption(propertyChangeEvent.getNewValue());
                    ProgressDialogColleague.this.mMediator.colleagueChanged(colleague);
                }
            }
        });
    }

    protected void colleagueCloseOperation() {
        this.mMediator.colleagueChanged(this.mCancelButtonColleague);
    }

    public Colleague getDetailButtonColleague() {
        return this.mDetailButtonColleague;
    }

    public Colleague getCancelButtonColleague() {
        return this.mCancelButtonColleague;
    }

    public void setUp() {
        int n = this.mMediator.getProblemCount();
        if (0 < n) {
            if (1 < n) {
                this.mProgress.addMaxValue(n - 1);
            }
            this.mOffsetCount = this.mProgress.getCurrentValue();
            ProblemInfo problemInfo = this.mMediator.getProblemAt(0);
            String string = "file : " + problemInfo.getProblemName();
            this.mProgress.setMessage(string);
        }
        this.mDialog.setVisible(true);
    }

    public void update() {
        this.mProgress.increse();
        String string = "file : ";
        int n = this.mProgress.getCurrentValue() - this.mOffsetCount + 1;
        if (n < this.mMediator.getProblemCount()) {
            ProblemInfo problemInfo = this.mMediator.getProblemAt(n);
            string = string + problemInfo.getProblemName();
        }
        this.mProgress.setMessage(string);
    }

    public void cleanUp() {
        this.mDialog.setVisible(false);
        this.mDialog.dispose();
    }

    public void changeDetailButtonLabel() {
        this.mProgress.changeDetailButtonLabel();
    }

    public Colleague getColleagueForOption(Object object) {
        Object[] objectArray = this.mProgress.getOptions();
        if (DETAIL_BUTON_LABEL[0].equals(object) || DETAIL_BUTON_LABEL[1].equals(object)) {
            return this.mDetailButtonColleague;
        }
        if (CANCEL_BUTON_LABEL.equals(object)) {
            return this.mCancelButtonColleague;
        }
        return this.mCancelButtonColleague;
    }
}

