/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.bench.view;

import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreePath;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.model.FileNode;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.model.FileViewTreeModel;

public class DirectoryChooser {
    private static final FileFilter DEFAULT_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    private JLabel mDescription;
    private JTree mTree;
    private JComponent mScroller;

    private static DirectoryChooser getInstance() {
        return Holder.CHOOSER;
    }

    private DirectoryChooser() {
        EmptyBorder emptyBorder = new EmptyBorder(12, 0, 12, 0);
        this.mDescription = new JLabel("select the folder performing solver program.");
        this.mDescription.setBorder(emptyBorder);
        File[] fileArray = FileSystemView.getFileSystemView().getRoots();
        FileNode fileNode = new FileNode(fileArray[0], DEFAULT_FILTER);
        this.mTree = new JTree();
        FileViewTreeModel fileViewTreeModel = new FileViewTreeModel(fileNode);
        this.mTree.setModel(fileViewTreeModel);
        this.mScroller = new JScrollPane(this.mTree);
        this.mScroller.setBorder(new BevelBorder(1));
    }

    public static File chooseDirectory(Component component, File file) {
        return DirectoryChooser.getInstance().chooseDirectorySub(component, file);
    }

    public File chooseDirectorySub(Component component, File file) {
        if (file.isDirectory()) {
            this.expandAndSelect(this.mTree, file);
        } else {
            this.mTree.setSelectionRow(0);
        }
        int n = JOptionPane.showConfirmDialog(component, new Object[]{this.mDescription, this.mScroller}, "Reference the folder", 2, -1);
        File file2 = file;
        if (n == 0) {
            FileNode fileNode = (FileNode)this.mTree.getSelectionPath().getLastPathComponent();
            file2 = new File(fileNode.getAbsolutePath());
        }
        return file2;
    }

    public static void main(String[] stringArray) {
        File file = new File("class").getAbsoluteFile();
        JFrame jFrame = new JFrame();
        DirectoryChooser.chooseDirectory(jFrame, file);
        System.exit(0);
    }

    private void expand(JTree jTree, TreePath treePath) {
        TreePath treePath2 = treePath.getParentPath();
        if (null != treePath2 && !jTree.isExpanded(treePath2)) {
            this.expand(jTree, treePath2);
        }
        jTree.expandPath(treePath);
    }

    private TreePath toTreePath(File file) {
        return new TreePath(this.toTreePathSub(file, 1));
    }

    private FileNode[] toTreePathSub(File file, int n) {
        File file2 = FileSystemView.getFileSystemView().getParentDirectory(file);
        FileNode[] fileNodeArray = null;
        fileNodeArray = null == file2 ? new FileNode[n] : this.toTreePathSub(file2, n + 1);
        fileNodeArray[fileNodeArray.length - n] = new FileNode(file, DEFAULT_FILTER);
        return fileNodeArray;
    }

    private void expandAndSelect(JTree jTree, File file) {
        TreePath treePath = this.toTreePath(file);
        this.expand(jTree, treePath);
        jTree.setSelectionPath(treePath);
    }

    private static class Holder {
        static final DirectoryChooser CHOOSER = new DirectoryChooser();

        private Holder() {
        }
    }
}

