/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.IllegalSolverStateException;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SoluteSeparatedException;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolveDiscompleteException;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.QueueIF;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.Queue_2;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverFinishedState;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverProcessingState;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverStartState;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class SolverRI_5
implements SolverHandler {
    private static final State sStartState = new SolverStartState();
    private static final State sProcessingState = new SolverProcessingState();
    private static final State sBuildDisableState = new DisableState();
    private static final State sFinishedState = new SolverFinishedState();
    private static final Logger SOLVER_LOGGER = Logger.getLogger((class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$model$experimental$SolverRI_5 == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$model$experimental$SolverRI_5 = SolverRI_5.class$("jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverRI_5")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$model$experimental$SolverRI_5).getPackage().getName());
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private static final Direction[] DIAGONAL = new Direction[]{Direction.NORTH_WEST, Direction.NORTH_EAST, Direction.SOUTH_WEST, Direction.SOUTH_EAST};
    private static final int NUM_PER_DIRECTION = 2;
    private static final int LOOP_ONCE_LIMIT = 100;
    private static final int PENALTY_WEIGHT = DIRECTIONS.length * 2;
    private Map mRecords = new HashMap();
    private QueueIF mQueue = new Queue_2(new SolverRecordComparator());
    private Map mChainMap = new HashMap();
    private Model mModel;
    private int mLap;
    private int mLoopCount = 0;
    private boolean mIsNotResolve;
    private SolverPattern[] mPatterns = new SolverPattern[]{new HashikakeSolverPattern1(), new HashikakeSolverPattern4(), new HashikakeSolverPattern5(), new HashikakeSolverPattern6(), new HashikakeSolverPattern7(), new HashikakeSolverPattern8()};
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$model$experimental$SolverRI_5;

    public SolverRI_5(Model model) {
        this.mModel = model;
    }

    public void reset() {
        this.initRecords();
        this.mLap = 0;
        this.mLoopCount = 0;
        this.mIsNotResolve = false;
    }

    private void initRecords() {
        this.mRecords.clear();
        this.mChainMap.clear();
        this.mQueue.clear();
        ArrayList<SolverRecord> arrayList = new ArrayList<SolverRecord>();
        for (int i = 0; i < this.mModel.getHeight(); ++i) {
            for (int j = 0; j < this.mModel.getWidth(); ++j) {
                if (!this.mModel.isNumberAt(j, i)) continue;
                SolverRecord solverRecord = this.createSolverRecordAt(j, i);
                arrayList.add(solverRecord);
            }
        }
        this.mQueue.addAll(arrayList.toArray(new SolverRecord[arrayList.size()]));
        this.mQueue.flip();
    }

    public void addSolvePosAt(int n, int n2) {
        if (this.mModel.isNumberAt(n, n2)) {
            SolverRecord solverRecord = this.createSolverRecordAt(n, n2);
            this.mQueue.enqueue(solverRecord);
            this.mQueue.flip();
        }
    }

    private SolverRecord createSolverRecordAt(int n, int n2) {
        Point point = new Point(n, n2);
        SolverRecord solverRecord = this.getSolverRecord(point);
        this.updateSolverRecord(solverRecord);
        return solverRecord;
    }

    public boolean isSolute() {
        return this.mQueue.isEmpty();
    }

    public void nextSolute() {
        if (this.isSolute()) {
            return;
        }
        this.nextSoluteSub();
    }

    private boolean nextSoluteSub() {
        if (this.mLap <= 0) {
            this.mLap = this.mQueue.size();
        }
        SolverRecord solverRecord = null;
        do {
            --this.mLap;
            if (this.mQueue.isEmpty()) {
                return true;
            }
            solverRecord = (SolverRecord)this.mQueue.dequeue();
        } while (this.isFinishedState(solverRecord.mState));
        return this.attemptBuild(solverRecord);
    }

    public boolean nextSoluteAll() throws SolveDiscompleteException {
        if (this.mQueue.isEmpty()) {
            return true;
        }
        int n = 0;
        try {
            do {
                ++this.mLoopCount;
                if (!this.nextSoluteSub()) {
                    if (this.mQueue.size() != ++n) continue;
                    if (this.mIsNotResolve) {
                        throw new SolveDiscompleteException(this.mQueue.size());
                    }
                    this.mIsNotResolve = true;
                    n = 0;
                    continue;
                }
                n = 0;
            } while (this.mLap > 0);
        }
        catch (SoluteSeparatedException soluteSeparatedException) {
            System.out.println(soluteSeparatedException);
            throw new SolveDiscompleteException(soluteSeparatedException.getMessage());
        }
        if (this.isSolute()) {
            if (SOLVER_LOGGER.isLoggable(Level.FINE)) {
                SOLVER_LOGGER.fine("loop count : " + this.mLoopCount);
            }
            return true;
        }
        return false;
    }

    private boolean attemptBuild(SolverRecord solverRecord) {
        boolean bl = false;
        do {
            if (this.isFinishedState(solverRecord.mState)) {
                return true;
            }
            this.updateSolverRecord(solverRecord);
            bl = false;
            SolverInfo solverInfo = new SolverInfo(solverRecord);
            for (int i = 0; i < this.mPatterns.length && !(bl = this.mPatterns[i].build(solverInfo)); ++i) {
            }
        } while (bl);
        if (!this.isFinishedState(solverRecord.mState)) {
            solverRecord.mPenalty += PENALTY_WEIGHT;
            this.mQueue.enqueue(solverRecord);
        }
        return bl;
    }

    private SolverRecord getSolverRecord(Point point) {
        if (this.mRecords.containsKey(point)) {
            return (SolverRecord)this.mRecords.get(point);
        }
        if (this.mModel.isNumberAt(point.x, point.y)) {
            int n = Integer.MIN_VALUE;
            Point point2 = new Point(point);
            try {
                n = Integer.parseInt(StateManager.getInstance().findIdentityOf(this.mModel.getCurStateAt(point2.x, point2.y)));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("The simbol of Number State cannot be parsed as integer.");
            }
            SolverRecord solverRecord = new SolverRecord(this.mRecords.size(), point2, n);
            this.mRecords.put(point2, solverRecord);
            return solverRecord;
        }
        throw new IllegalArgumentException("The state of specified position isnot NumberState (pos : x = " + point.x + ", y = " + point.y + ")");
    }

    private boolean isBuild(Point point, Direction direction, Point point2) {
        Point point3 = new Point(point);
        Point point4 = direction.getDifference();
        point3.translate(point4.x, point4.y);
        if (!this.mModel.contains(point3.x, point3.y)) {
            return false;
        }
        while (this.mModel.contains(point3.x, point3.y)) {
            if (this.mModel.isNumberAt(point3.x, point3.y)) {
                point2.setLocation(point3.x, point3.y);
                return true;
            }
            StateEventCode stateEventCode = UtilityFuncs.getDetermineDirectionEventCode(direction);
            if (!this.mModel.isTransitAt(point3.x, point3.y, stateEventCode)) {
                return false;
            }
            point3.translate(point4.x, point4.y);
        }
        return false;
    }

    private boolean isStartState(State state) {
        return state == sStartState;
    }

    private boolean isFinishedState(State state) {
        return state == sFinishedState;
    }

    private boolean isDisableState(State state) {
        return state == sBuildDisableState;
    }

    private boolean isProcessState(State state) {
        return state == sProcessingState;
    }

    private boolean buildBridge(SolverRecord solverRecord, int n, int n2) {
        int n3;
        Point point = new Point(solverRecord.mPos);
        OppositeRecord oppositeRecord = solverRecord.mOpposite[n2];
        if (null == oppositeRecord) {
            return false;
        }
        if (this.isFinishedState(oppositeRecord.mState)) {
            return false;
        }
        if (n == oppositeRecord.mCount) {
            return false;
        }
        Direction direction = DIRECTIONS[n2];
        StateEventCode stateEventCode = UtilityFuncs.getDetermineDirectionEventCode(direction);
        Point point2 = direction.getDifference();
        do {
            for (n3 = oppositeRecord.mCount; n3 < n; ++n3) {
                this.mModel.nextStateAt(point.x, point.y, stateEventCode);
            }
            point.translate(point2.x, point2.y);
        } while (!this.mModel.isNumberAt(point.x, point.y));
        direction = UtilityFuncs.inverseDirection(direction);
        stateEventCode = UtilityFuncs.getDetermineDirectionEventCode(direction);
        for (n3 = oppositeRecord.mCount; n3 < n; ++n3) {
            this.mModel.nextStateAt(point.x, point.y, stateEventCode);
        }
        oppositeRecord.mCount = n;
        oppositeRecord.mState = sProcessingState;
        SolverRecord solverRecord2 = this.getSolverRecord(point);
        if (solverRecord.mResidue < n - oppositeRecord.mCount || solverRecord2.mResidue < n - oppositeRecord.mCount) {
            throw new IllegalSolverStateException(solverRecord.mPos, solverRecord2.mPos);
        }
        this.addChainMap(solverRecord, solverRecord2);
        this.updateSolverRecord(solverRecord2);
        this.updateSolverRecord(solverRecord);
        return true;
    }

    private boolean coerceFinished(SolverRecord solverRecord, int n) {
        solverRecord.mOpposite[n].mState = sFinishedState;
        int n2 = solverRecord.mOpposite[n].mCount;
        SolverRecord solverRecord2 = this.getSolverRecord(solverRecord.mOppositePos[n]);
        solverRecord2.mResidue -= n2;
        --solverRecord2.mOppositeCount;
        this.updateSolverRecord(solverRecord2);
        solverRecord.mResidue -= n2;
        --solverRecord.mOppositeCount;
        this.updateSolverRecord(solverRecord);
        return true;
    }

    private void addChainMap(SolverRecord solverRecord, SolverRecord solverRecord2) {
        if (solverRecord.mQueueRef == solverRecord2.mQueueRef) {
            return;
        }
        if (solverRecord.mQueueRef > solverRecord2.mQueueRef) {
            this.addChainMap(solverRecord2, solverRecord);
        } else {
            ChainRecord chainRecord = this.getChainRecord(solverRecord);
            ChainRecord chainRecord2 = this.getChainRecord(solverRecord2);
            Integer n = new Integer(solverRecord2.mQueueRef);
            chainRecord.merge(chainRecord2);
            this.mChainMap.remove(n);
        }
    }

    private ChainRecord getChainRecord(SolverRecord solverRecord) {
        Integer n = new Integer(solverRecord.mQueueRef);
        ChainRecord chainRecord = (ChainRecord)this.mChainMap.get(n);
        if (null == chainRecord) {
            chainRecord = new ChainRecord(solverRecord.mQueueRef);
            chainRecord.addRecord(solverRecord);
            this.mChainMap.put(n, chainRecord);
        }
        return chainRecord;
    }

    private void removeChainMap(SolverRecord solverRecord) {
        Integer n = new Integer(solverRecord.mQueueRef);
        ChainRecord chainRecord = (ChainRecord)this.mChainMap.get(n);
        if (null == chainRecord) {
            return;
        }
        chainRecord.removeRecord(solverRecord);
        if (this.mChainMap.size() > 1 && chainRecord.getUnFinishedCount() == 0) {
            throw new SoluteSeparatedException();
        }
    }

    private void updateSolverRecord(SolverRecord solverRecord) {
        if (this.isFinishedState(solverRecord.mState)) {
            return;
        }
        solverRecord.mValied = false;
        solverRecord.mMostPriority = false;
        solverRecord.mAroundResidueSum = 0;
        int n = 0;
        ChainRecord chainRecord = this.getChainRecord(solverRecord);
        boolean bl = !chainRecord.isTerminate(solverRecord);
        solverRecord.mBuiltCount = 0;
        Point point = new Point();
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            if (solverRecord.mOpposite[i] != null) {
                solverRecord.mBuiltCount += solverRecord.mOpposite[i].mCount;
            }
            if (!this.checkOpposite(solverRecord, DIRECTIONS[i], i, point) || this.isFinishedState(solverRecord.mOpposite[i].mState)) continue;
            SolverRecord solverRecord2 = this.getSolverRecord(point);
            if (solverRecord.mQueueRef == solverRecord2.mQueueRef) {
                ++n;
            }
            if (1 < n) {
                bl = false;
            }
            if (!bl) continue;
            bl &= this.checkTerminate(solverRecord, chainRecord, solverRecord2);
        }
        if (solverRecord.mMaxBuildCount == solverRecord.mBuiltCount || 0 == solverRecord.mOppositeCount || 0 == solverRecord.mResidue) {
            bl = false;
            this.finalizeOppositeRecordAll(solverRecord);
        }
        if (bl) {
            chainRecord.toTerminate(solverRecord);
        }
    }

    private boolean checkOpposite(SolverRecord solverRecord, Direction direction, int n, Point point) {
        solverRecord.mOppositePos[n] = null;
        OppositeRecord oppositeRecord = solverRecord.mOpposite[n];
        if (this.isBuild(solverRecord.mPos, direction, point)) {
            SolverRecord solverRecord2 = this.getSolverRecord(point);
            if (null == oppositeRecord) {
                if (!this.isFinishedState(solverRecord2.mState)) {
                    this.initOppositeRecord(solverRecord, solverRecord2, n);
                    oppositeRecord = solverRecord.mOpposite[n];
                }
            } else if (this.isDisableState(oppositeRecord.mState)) {
                if (this.isFinishedState(solverRecord2.mState)) {
                    oppositeRecord = null;
                    solverRecord.mOpposite[n] = null;
                    --solverRecord.mOppositeCount;
                } else {
                    this.initOppositeRecord(solverRecord, solverRecord2, n);
                    oppositeRecord = solverRecord.mOpposite[n];
                }
            } else if (this.isProcessState(oppositeRecord.mState)) {
                if (this.isFinishedState(solverRecord2.mState)) {
                    solverRecord.mResidue -= oppositeRecord.mCount;
                    --solverRecord.mOppositeCount;
                    oppositeRecord.mState = sFinishedState;
                } else {
                    this.updateOppositeRecord(solverRecord, solverRecord2, oppositeRecord);
                    solverRecord.mAroundResidueSum += solverRecord2.mResidue;
                }
            } else if (this.isStartState(oppositeRecord.mState)) {
                solverRecord.mAroundResidueSum += solverRecord2.mResidue;
            }
        } else if (null != oppositeRecord) {
            oppositeRecord = null;
            solverRecord.mOpposite[n] = null;
            --solverRecord.mOppositeCount;
        }
        if (null != oppositeRecord && !this.isFinishedState(oppositeRecord.mState)) {
            solverRecord.mOppositePos[n] = new Point(point);
            return true;
        }
        return false;
    }

    private void updateOppositeRecord(SolverRecord solverRecord, SolverRecord solverRecord2, OppositeRecord oppositeRecord) {
        if (2 == oppositeRecord.mCount) {
            oppositeRecord.mState = sFinishedState;
            solverRecord.mResidue -= oppositeRecord.mCount;
            --solverRecord.mOppositeCount;
            if (0 < solverRecord.mPenalty) {
                solverRecord.mPenalty -= PENALTY_WEIGHT;
            }
            solverRecord2.mResidue -= oppositeRecord.mCount;
            --solverRecord2.mOppositeCount;
            if (0 < solverRecord.mPenalty) {
                solverRecord2.mPenalty -= PENALTY_WEIGHT;
            }
        } else if (0 < oppositeRecord.mCount) {
            oppositeRecord.mState = sProcessingState;
        }
    }

    private void finalizeOppositeRecordAll(SolverRecord solverRecord) {
        solverRecord.mResidue = 0;
        solverRecord.mState = sFinishedState;
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            this.finalizeOppositeRecord(solverRecord, i);
        }
        this.removeChainMap(solverRecord);
    }

    private void finalizeOppositeRecord(SolverRecord solverRecord, int n) {
        if (null != solverRecord.mOpposite[n]) {
            if (0 == solverRecord.mOpposite[n].mCount) {
                solverRecord.mOpposite[n].mState = sBuildDisableState;
                solverRecord.mOpposite[n] = null;
            } else if (this.isFinishedState(solverRecord.mOpposite[n].mState)) {
                return;
            }
            --solverRecord.mOppositeCount;
        }
    }

    private void initOppositeRecord(SolverRecord solverRecord, SolverRecord solverRecord2, int n) {
        Direction direction = UtilityFuncs.inverseDirection(DIRECTIONS[n]);
        int n2 = this.getDirectionToIndex(direction);
        OppositeRecord oppositeRecord = solverRecord2.mOpposite[n2];
        if (null == oppositeRecord) {
            solverRecord2.mOpposite[n2] = oppositeRecord = new OppositeRecord();
            ++solverRecord2.mOppositeCount;
        }
        solverRecord.mOpposite[n] = oppositeRecord;
        ++solverRecord.mOppositeCount;
        solverRecord.mAroundResidueSum += solverRecord2.mResidue;
    }

    private int getDirectionToIndex(Direction direction) {
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            if (DIRECTIONS[i] != direction) continue;
            return i;
        }
        throw new IllegalArgumentException("Direction, " + direction + "is illegal.");
    }

    private boolean checkTerminate(SolverRecord solverRecord, ChainRecord chainRecord, SolverRecord solverRecord2) {
        return solverRecord.mQueueRef == solverRecord2.mQueueRef ? chainRecord.getUnFinishedCount() == 2 && 2 >= solverRecord.mResidue && solverRecord.mResidue == solverRecord2.mResidue : this.getChainRecord(solverRecord2).getUnFinishedCount() == 1 && 1 == solverRecord2.mResidue;
    }

    private int getAroundMax(SolverRecord solverRecord, Point[] pointArray) {
        int n = 0;
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            Point point;
            if (null == solverRecord.mOpposite[i] || this.isFinishedState(solverRecord.mOpposite[i].mState) || !this.isBuild(solverRecord.mPos, DIRECTIONS[i], point = new Point())) continue;
            SolverRecord solverRecord2 = this.getSolverRecord(point);
            n += solverRecord2.mResidue;
            pointArray[i] = point;
        }
        return n;
    }

    private int getRealResidue(SolverRecord solverRecord) {
        int n = solverRecord.mMaxBuildCount;
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            if (null == solverRecord.mOpposite[i]) continue;
            n -= solverRecord.mOpposite[i].mCount;
        }
        return n;
    }

    static /* synthetic */ State access$000() {
        return sStartState;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SolverRecordComparator
    implements Comparator {
        private Point[] mTemp = new Point[SolverRI_5.access$100().length];

        private SolverRecordComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object.equals(object2)) {
                return 0;
            }
            SolverRecord solverRecord = (SolverRecord)object;
            SolverRecord solverRecord2 = (SolverRecord)object2;
            if (SolverRI_5.this.isFinishedState(solverRecord.mState)) {
                return -1;
            }
            if (SolverRI_5.this.isFinishedState(solverRecord2.mState)) {
                return 1;
            }
            int n = solverRecord.mOppositeCount * 2 - solverRecord.mResidue + solverRecord.mPenalty;
            int n2 = solverRecord2.mOppositeCount * 2 - solverRecord2.mResidue + solverRecord2.mPenalty;
            if (n == n2) {
                return solverRecord.mResidue < solverRecord2.mResidue ? -1 : 1;
            }
            return n > n2 ? -1 : 1;
        }

        private boolean valiedPriority(SolverRecord solverRecord) {
            if (!solverRecord.mValied) {
                Point[] pointArray = this.mTemp;
                int n = SolverRI_5.this.getAroundMax(solverRecord, pointArray);
                solverRecord.mValied = true;
                for (int i = 0; i < pointArray.length; ++i) {
                    if (null == pointArray[i] || null == solverRecord.mOpposite[i]) continue;
                    SolverRecord solverRecord2 = SolverRI_5.this.getSolverRecord(pointArray[i]);
                    pointArray[i] = null;
                    if (n - solverRecord2.mResidue > solverRecord.mResidue) continue;
                    solverRecord.mMostPriority = true;
                    break;
                }
            }
            return solverRecord.mMostPriority;
        }
    }

    private class HashikakeSolverPattern8
    implements SolverPattern {
        private HashikakeSolverPattern8() {
        }

        public boolean build(SolverInfo solverInfo) {
            ChainRecord chainRecord;
            SolverRecord solverRecord = solverInfo.mRec;
            if (2 != solverRecord.mResidue) {
                return false;
            }
            boolean bl = false;
            if (2 < solverRecord.mOppositeCount) {
                bl = this.willRetry(solverRecord);
            }
            if (3 != (chainRecord = SolverRI_5.this.getChainRecord(solverRecord)).getUnFinishedCount()) {
                return false;
            }
            boolean bl2 = false;
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                SolverRecord solverRecord2;
                if (null == solverRecord.mOppositePos[i] || null == solverRecord.mOpposite[i] || 0 == solverRecord.mOpposite[i].mCount || !this.patternCheck(solverRecord2 = SolverRI_5.this.getSolverRecord(solverRecord.mOppositePos[i]), solverRecord.mOpposite[i], 3, bl)) continue;
                bl2 |= SolverRI_5.this.coerceFinished(solverRecord, i);
            }
            return bl2;
        }

        private boolean patternCheck(SolverRecord solverRecord, OppositeRecord oppositeRecord, int n, boolean bl) {
            if (n != solverRecord.mResidue) {
                return false;
            }
            if (n == 1) {
                return SolverRI_5.this.getChainRecord(solverRecord).isLivedOnly(solverRecord);
            }
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                if (null == solverRecord.mOppositePos[i] || null == solverRecord.mOpposite[i] || oppositeRecord == solverRecord.mOpposite[i]) continue;
                SolverRecord solverRecord2 = SolverRI_5.this.getSolverRecord(solverRecord.mOppositePos[i]);
                if (n > 2 && 0 == solverRecord.mOpposite[i].mCount) continue;
                if (!this.patternCheck(solverRecord2, solverRecord.mOpposite[i], n - 1, bl)) {
                    return false;
                }
                if (n <= 2) continue;
                return true;
            }
            if (n == 2) {
                if (bl) {
                    return 2 < solverRecord.mOppositeCount;
                }
                return true;
            }
            return false;
        }

        private boolean willRetry(SolverRecord solverRecord) {
            boolean bl = false;
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                if (null == solverRecord.mOppositePos[i] || null == solverRecord.mOpposite[i]) continue;
                SolverRecord solverRecord2 = SolverRI_5.this.getSolverRecord(solverRecord.mOppositePos[i]);
                if (0 != solverRecord.mOpposite[i].mCount && 3 == solverRecord2.mResidue) {
                    if (bl) {
                        return false;
                    }
                    bl = true;
                    continue;
                }
                if (1 >= solverRecord2.mResidue) continue;
                return false;
            }
            return bl;
        }
    }

    private class HashikakeSolverPattern7
    implements SolverPattern {
        private HashikakeSolverPattern7() {
        }

        public boolean build(SolverInfo solverInfo) {
            SolverRecord solverRecord = solverInfo.mRec;
            if (!SolverRI_5.this.getChainRecord(solverRecord).isLivedOnly(solverRecord)) {
                return false;
            }
            int n = Integer.MIN_VALUE;
            boolean bl = false;
            int n2 = solverRecord.mOppositeCount;
            int n3 = solverRecord.mMaxBuildCount - solverRecord.mBuiltCount;
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                if (null == solverRecord.mOppositePos[i] || null == solverRecord.mOpposite[i]) continue;
                SolverRecord solverRecord2 = SolverRI_5.this.getSolverRecord(solverRecord.mOppositePos[i]);
                if (solverRecord.mQueueRef == solverRecord2.mQueueRef) {
                    --n2;
                    continue;
                }
                int n4 = solverRecord2.mMaxBuildCount - solverRecord2.mBuiltCount;
                if (SolverRI_5.this.getChainRecord(solverRecord2).isLivedOnly(solverRecord2) && n3 == 1 && n3 == n4) {
                    --n2;
                    continue;
                }
                n = i;
            }
            if (1 == n2 && Integer.MIN_VALUE != n) {
                bl |= SolverRI_5.this.buildBridge(solverRecord, 1, n);
            }
            return bl;
        }
    }

    private class HashikakeSolverPattern6
    implements SolverPattern {
        private int mDepth;
        private Point mTermPos = new Point();

        private HashikakeSolverPattern6() {
        }

        public boolean build(SolverInfo solverInfo) {
            boolean bl = false;
            SolverRecord solverRecord = solverInfo.mRec;
            if (2 != solverRecord.mResidue) {
                return bl;
            }
            if (4 < solverRecord.mOppositeCount) {
                return bl;
            }
            if (4 > SolverRI_5.this.getChainRecord(solverRecord).getUnFinishedCount()) {
                return bl;
            }
            Point point = new Point();
            if (!this.patternCheck(solverRecord, point)) {
                return bl;
            }
            int n = Integer.MIN_VALUE;
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                if (null == solverRecord.mOppositePos[i] || null == solverRecord.mOpposite[i] || solverRecord.mOppositePos[i].equals(point) || solverRecord.mOppositePos[i].equals(this.mTermPos)) continue;
                n = n == Integer.MIN_VALUE ? i : Integer.MIN_VALUE;
            }
            if (n != Integer.MIN_VALUE) {
                bl |= SolverRI_5.this.buildBridge(solverRecord, 1, n);
            }
            return bl;
        }

        private boolean patternCheck(SolverRecord solverRecord, Point point) {
            if (null == solverRecord) {
                throw new IllegalArgumentException("null value is passed to inRec");
            }
            if (null == point) {
                throw new IllegalArgumentException("null value is passed to outAdjacentPos");
            }
            return this.patternCheckSub(solverRecord, null, point, 1, false);
        }

        private boolean patternCheckSub(SolverRecord solverRecord, OppositeRecord oppositeRecord, Point point, int n, boolean bl) {
            boolean bl2 = bl;
            this.mDepth = n;
            SolverRecord solverRecord2 = null;
            Point point2 = new Point();
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                if (!SolverRI_5.this.isBuild(solverRecord.mPos, DIRECTIONS[i], point2)) continue;
                solverRecord2 = SolverRI_5.this.getSolverRecord(point2);
                if (SolverRI_5.this.isFinishedState(solverRecord2.mState) || oppositeRecord == solverRecord.mOpposite[i] || solverRecord.mQueueRef != solverRecord2.mQueueRef) continue;
                if (3 == solverRecord2.mResidue) {
                    if (2 != solverRecord2.mOppositeCount || !(bl2 = n % 2 == 0 ? this.patternCheckSub(solverRecord2, solverRecord.mOpposite[i], point, n + 1, true) : this.patternCheckSub(solverRecord2, solverRecord.mOpposite[i], point, n + 1, false))) continue;
                    point.setLocation(point2);
                    return bl2;
                }
                if (!bl2 || 2 != solverRecord2.mResidue || SolverRI_5.this.getChainRecord(solverRecord2).getUnFinishedCount() != n + 1) continue;
                this.mTermPos.setLocation(point2);
                return bl2;
            }
            return false;
        }
    }

    private class HashikakeSolverPattern5
    implements SolverPattern {
        private HashikakeSolverPattern5() {
        }

        public boolean build(SolverInfo solverInfo) {
            boolean bl = false;
            SolverRecord solverRecord = solverInfo.mRec;
            int n = solverRecord.mOppositeCount * 2 - solverRecord.mResidue;
            if (solverRecord.mOppositeCount > 2 && n >= 2 && n < 4) {
                Point point = new Point();
                for (int i = 0; i < DIAGONAL.length; ++i) {
                    if (!this.isBuildDiagonal(solverRecord, DIAGONAL[i], point)) continue;
                    Direction direction = UtilityFuncs.inverseDirection(DIAGONAL[i]);
                    Direction[] directionArray = UtilityFuncs.getUnitDirection(direction);
                    SolverRecord solverRecord2 = SolverRI_5.this.getSolverRecord(point);
                    SolverRI_5.this.updateSolverRecord(solverRecord2);
                    if (this.isBuildForExceptsAround(solverRecord2, directionArray[0], directionArray[1])) continue;
                    for (int j = 0; j < DIRECTIONS.length; ++j) {
                        if (DIRECTIONS[j] != directionArray[0] && DIRECTIONS[j] != directionArray[1]) continue;
                        bl |= SolverRI_5.this.buildBridge(solverRecord, 1, j);
                    }
                }
            }
            return bl;
        }

        private boolean isBuildDiagonal(SolverRecord solverRecord, Direction direction, Point point) {
            Point point2 = direction.getDifference();
            Point point3 = new Point(point2.x + solverRecord.mPos.x, point2.y + solverRecord.mPos.y);
            if (!SolverRI_5.this.mModel.isNumberAt(point3.x, point3.y)) {
                return false;
            }
            Direction[] directionArray = UtilityFuncs.getUnitDirection(direction);
            int n = 0;
            boolean bl = true;
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                if (DIRECTIONS[i] == directionArray[0] || DIRECTIONS[i] == directionArray[1]) {
                    if (null != solverRecord.mOpposite[i] && null != solverRecord.mOpposite[i]) continue;
                    bl = false;
                    continue;
                }
                if (null == solverRecord.mOpposite[i] || 0 >= solverRecord.mOpposite[i].mCount) continue;
                ++n;
            }
            point.setLocation(point3);
            return bl && directionArray.length != n;
        }

        private boolean isBuildForExceptsAround(SolverRecord solverRecord, Direction direction, Direction direction2) {
            if (solverRecord.mOppositeCount == 0) {
                return true;
            }
            int n = 0;
            Point point = new Point();
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                if (direction == DIRECTIONS[i] || direction2 == DIRECTIONS[i] || !SolverRI_5.this.isBuild(solverRecord.mPos, DIRECTIONS[i], point)) continue;
                SolverRecord solverRecord2 = SolverRI_5.this.getSolverRecord(point);
                n += solverRecord2.mResidue > 2 ? 2 : solverRecord2.mResidue;
            }
            return n >= solverRecord.mResidue;
        }
    }

    private class HashikakeSolverPattern4
    implements SolverPattern {
        private HashikakeSolverPattern4() {
        }

        public boolean build(SolverInfo solverInfo) {
            boolean bl = false;
            SolverRecord solverRecord = solverInfo.mRec;
            int n = this.getEffectiveAroundMax(solverRecord);
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                if (null == solverRecord.mOpposite[i] || null == solverRecord.mOppositePos[i]) continue;
                SolverRecord solverRecord2 = SolverRI_5.this.getSolverRecord(solverRecord.mOppositePos[i]);
                int n2 = solverRecord.mOpposite[i].mCount;
                int n3 = solverRecord2.mMaxBuildCount - (solverRecord2.mBuiltCount - n2);
                if (n2 == (n3 = solverRecord.mResidue - (n - n3)) && 0 == n2) {
                    bl |= this.attemptBuildLater(solverRecord, i, n);
                    continue;
                }
                if (n2 > n3) continue;
                bl |= SolverRI_5.this.buildBridge(solverRecord, n3, i);
            }
            return bl;
        }

        private int getEffectiveAroundMax(SolverRecord solverRecord) {
            int n = 0;
            Point point = new Point();
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                if (null == solverRecord.mOpposite[i] || null == solverRecord.mOppositePos[i]) continue;
                SolverRecord solverRecord2 = SolverRI_5.this.getSolverRecord(solverRecord.mOppositePos[i]);
                n += solverRecord2.mMaxBuildCount - (solverRecord2.mBuiltCount - solverRecord.mOpposite[i].mCount);
            }
            return n;
        }

        private boolean attemptBuildLater(SolverRecord solverRecord, int n, int n2) {
            ChainRecord chainRecord = SolverRI_5.this.getChainRecord(solverRecord);
            int n3 = chainRecord.getUnFinishedCount() - 1;
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                if (null == solverRecord.mOpposite[i] || null == solverRecord.mOppositePos[i]) continue;
                SolverRecord solverRecord2 = SolverRI_5.this.getSolverRecord(solverRecord.mOppositePos[i]);
                int n4 = solverRecord2.mMaxBuildCount - (solverRecord2.mBuiltCount - solverRecord.mOpposite[i].mCount);
                if (n == i) {
                    n2 -= n4;
                    continue;
                }
                if (solverRecord.mQueueRef == solverRecord2.mQueueRef) {
                    --n3;
                    n2 -= n4;
                    continue;
                }
                if (!SolverRI_5.this.getChainRecord(solverRecord2).isLivedOnly(solverRecord2)) continue;
                n2 -= n4;
            }
            if (0 == n3 && 0 == n2) {
                return SolverRI_5.this.buildBridge(solverRecord, 1, n);
            }
            return false;
        }
    }

    private class HashikakeSolverPattern1
    implements SolverPattern {
        private HashikakeSolverPattern1() {
        }

        public boolean build(SolverInfo solverInfo) {
            SolverRecord solverRecord = solverInfo.mRec;
            int n = 2 - (solverRecord.mOppositeCount * 2 - solverRecord.mResidue);
            if (2 < n) {
                n = 1;
            }
            boolean bl = false;
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                if (null == solverRecord.mOppositePos[i] || null == solverRecord.mOpposite[i] || 0 >= n || n <= solverRecord.mOpposite[i].mCount) continue;
                SolverRecord solverRecord2 = SolverRI_5.this.getSolverRecord(solverRecord.mOppositePos[i]);
                if (n > solverRecord2.mResidue) {
                    n = solverRecord2.mResidue;
                }
                bl |= SolverRI_5.this.buildBridge(solverRecord, n, i);
            }
            return bl;
        }
    }

    private static class DisableState
    implements State {
        private DisableState() {
        }

        public State onEnter(StateEventCode stateEventCode) {
            return this;
        }
    }

    private static interface SolverPattern {
        public boolean build(SolverInfo var1);
    }

    private static class ChainRecord {
        private final int mQueueRef;
        private List mChainList = new LinkedList();
        private List mTerminateList = new LinkedList();

        ChainRecord(int n) {
            this.mQueueRef = n;
        }

        int getUnFinishedCount() {
            return this.mChainList.size();
        }

        int getTerminateCount() {
            return this.mTerminateList.size();
        }

        void toTerminate(SolverRecord solverRecord) {
            this.mTerminateList.add(solverRecord);
        }

        void addRecord(SolverRecord solverRecord) {
            this.mChainList.add(solverRecord);
        }

        void removeRecord(SolverRecord solverRecord) {
            this.mChainList.remove(solverRecord);
            this.mTerminateList.remove(solverRecord);
        }

        void merge(ChainRecord chainRecord) {
            SolverRecord solverRecord;
            Iterator iterator = chainRecord.mChainList.iterator();
            while (iterator.hasNext()) {
                solverRecord = (SolverRecord)iterator.next();
                solverRecord.mQueueRef = this.mQueueRef;
                this.mChainList.add(solverRecord);
            }
            iterator = chainRecord.mTerminateList.iterator();
            while (iterator.hasNext()) {
                solverRecord = (SolverRecord)iterator.next();
                solverRecord.mQueueRef = this.mQueueRef;
                this.mTerminateList.add(solverRecord);
            }
        }

        boolean isTerminate(SolverRecord solverRecord) {
            return this.mTerminateList.contains(solverRecord);
        }

        boolean isLivedOnly(SolverRecord solverRecord) {
            if (1 < this.getUnFinishedCount() - this.getTerminateCount()) {
                return false;
            }
            return !this.mTerminateList.contains(solverRecord);
        }
    }

    private static class SolverInfo {
        SolverRecord mRec;
        int mAroundMax;
        Point[] mAroundPos;

        SolverInfo(SolverRecord solverRecord) {
            this.mRec = solverRecord;
        }
    }

    static class SolverRecord {
        int mQueueRef;
        Point mPos;
        final int mMaxBuildCount;
        int mResidue;
        int mAroundResidueSum;
        int mBuiltCount;
        int mOppositeCount;
        OppositeRecord[] mOpposite = new OppositeRecord[SolverRI_5.access$100().length];
        Point[] mOppositePos = new Point[SolverRI_5.access$100().length];
        State mState = SolverRI_5.access$000();
        int mPenalty = 0;
        boolean mValied;
        boolean mMostPriority;

        SolverRecord(int n, Point point, int n2) {
            this.mQueueRef = n;
            this.mPos = point;
            this.mMaxBuildCount = this.mResidue = n2;
        }

        public String toString() {
            return "count = " + this.mOppositeCount + ", residue = " + this.mResidue + ", priority = " + this.mMostPriority + ", pos = [x=" + this.mPos.x + ",y=" + this.mPos.y + "]";
        }
    }

    static class OppositeRecord {
        int mCount;
        State mState = SolverRI_5.access$000();

        OppositeRecord() {
        }
    }
}

