/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.QueueIF;

class Queue_2
implements QueueIF {
    private static final Logger SOLVER_LOGGER = Logger.getLogger((class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$model$experimental$Queue_2 == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$model$experimental$Queue_2 = Queue_2.class$("jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.Queue_2")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$model$experimental$Queue_2).getPackage().getName());
    private List mContainer = new ArrayList();
    private Comparator mComp;
    private int mInitialSize;
    private int mLaeveCount;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$model$experimental$Queue_2;

    public Queue_2(Comparator comparator) {
        this.mComp = comparator;
    }

    public void enqueue(Object object) {
        this.mContainer.add(object);
    }

    public Object dequeue() {
        if (0 >= --this.mLaeveCount) {
            this.sort();
            --this.mLaeveCount;
        }
        Object e = this.mContainer.remove(0);
        return e;
    }

    public void addAll(Object[] objectArray) {
        this.mContainer.addAll(Arrays.asList(objectArray));
    }

    public void flip() {
        this.mInitialSize = this.size();
    }

    public void clear() {
        this.mContainer.clear();
    }

    public void sort() {
        if (this.mInitialSize / this.size() < 4) {
            this.makeHeap();
            this.heapSort();
            this.mLaeveCount = this.size();
            if (SOLVER_LOGGER.isLoggable(Level.FINER)) {
                SOLVER_LOGGER.finer("queue sorted. (" + this.mLaeveCount + " leaves.)");
            }
            if (SOLVER_LOGGER.isLoggable(Level.FINEST)) {
                this.printQueue();
            }
        }
    }

    public boolean isEmpty() {
        return this.mContainer.isEmpty();
    }

    public int size() {
        return this.mContainer.size();
    }

    private void pushHeap(int n, int n2, Comparator comparator) {
        int n3 = n2 - n - 1;
        int n4 = (n3 - 1) / 2;
        Object e = this.mContainer.get(n3);
        while (n4 != n3 && 0 < comparator.compare(this.mContainer.get(n4), e)) {
            this.mContainer.set(n3, this.mContainer.get(n4));
            n3 = n4;
            n4 = (n3 - 1) / 2;
        }
        this.mContainer.set(n3, e);
    }

    private void popHeap(int n, int n2, Comparator comparator) {
        int n3 = 0;
        int n4 = 1;
        int n5 = n2 - n - 1;
        Object e = this.mContainer.get(n5);
        this.mContainer.set(n5, this.mContainer.get(0));
        while (n4 < n5) {
            if (n4 < n5 - 1 && 0 < comparator.compare(this.mContainer.get(n4), this.mContainer.get(n4 + 1))) {
                ++n4;
            }
            if (0 >= comparator.compare(e, this.mContainer.get(n4))) break;
            this.mContainer.set(n3, this.mContainer.get(n4));
            n3 = n4;
            n4 = (n3 + 1) * 2 - 1;
        }
        this.mContainer.set(n3, e);
    }

    private void makeHeap() {
        for (int i = 1; i < this.size(); ++i) {
            this.pushHeap(0, i, this.mComp);
        }
    }

    private void heapSort() {
        int n = this.size();
        while (n > 1) {
            this.popHeap(0, n--, this.mComp);
        }
    }

    public void printQueue() {
        SOLVER_LOGGER.finest("-------------------------------------------");
        SOLVER_LOGGER.finest("print queue entry.");
        for (int i = 0; i < this.size(); ++i) {
            SOLVER_LOGGER.finest(this.mContainer.get(i).toString());
        }
        SOLVER_LOGGER.finest("");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

