/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.util.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.util.ComponentUsher;
import jp.gr.java_conf.ktz.puzzle.framework.util.GUIUtility;
import jp.gr.java_conf.ktz.puzzle.framework.util.marshal.ProblemUnmarshalable;
import jp.gr.java_conf.ktz.puzzle.hashikake.io.ProblemReader;
import jp.gr.java_conf.ktz.puzzle.hashikake.io.XMLProblemReader;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.Bundle;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.PropertyBundle;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ResourceLoader;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.TextUtility;

public class OpenProblemDialog
extends JFrame {
    private static final String COMMON_RESOURCE_KEY = "common_resource";
    private ProblemUnmarshalable mLoadOwner;
    private ProblemReader mReader = new XMLProblemReader();
    private JList mList;
    private JLabel mPathLabel;
    private File mCurPath = new File(new File("problem").getAbsolutePath());
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$util$gui$OpenProblemDialog;

    public static void showLoadDialog() {
        OpenProblemDialog.showLoadDialog((ProblemUnmarshalable)ComponentUsher.getInstance().getActiveComponent());
    }

    public static void showLoadDialog(ProblemUnmarshalable problemUnmarshalable) {
        InitHolder.sDialog.setLoadOwner(problemUnmarshalable);
        InitHolder.sDialog.show();
    }

    void init() {
        ResourceBundle resourceBundle = PropertyBundle.getInstance();
        String string = resourceBundle.getString("title");
        this.setTitle(string);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        container.add((Component)jPanel, "North");
        jPanel.setPreferredSize(new Dimension(250, 45));
        jPanel.setBackground(Color.white);
        JPanel jPanel2 = new JPanel();
        container.add((Component)jPanel2, "Center");
        jPanel2.setPreferredSize(new Dimension(270, 190));
        jPanel2.setBackground(Color.white);
        this.setResizable(false);
        this.pack();
        SpringLayout springLayout = new SpringLayout();
        jPanel.setLayout(springLayout);
        this.mPathLabel = new JLabel(this.mCurPath.getAbsolutePath());
        this.mPathLabel.setSize(210, 35);
        string = PropertyBundle.getInstance().getString("path");
        this.mPathLabel.setBorder(new TitledBorder(string));
        jPanel.add((Component)this.mPathLabel, new SpringLayout.Constraints(Spring.constant(5), Spring.constant(5), Spring.constant(210), Spring.constant(35)));
        Insets insets = this.mPathLabel.getInsets();
        int n = this.mPathLabel.getWidth() - insets.left - insets.right;
        String string2 = TextUtility.truncText(this.mPathLabel.getFontMetrics(this.mPathLabel.getFont()), n, this.mCurPath.getAbsolutePath(), 1);
        this.mPathLabel.setText(string2);
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = OpenProblemDialog.this.mCurPath;
                if (!file.isDirectory()) {
                    file = new File(OpenProblemDialog.this.mCurPath.getParent());
                }
                JFileChooser jFileChooser = new JFileChooser(file);
                jFileChooser.setFileFilter(new FileFilter(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        int n = file.getName().toLowerCase().indexOf(".xml");
                        return 0 < n;
                    }

                    public String getDescription() {
                        return "XML file (version 1.0)";
                    }
                });
                int n = jFileChooser.showOpenDialog(OpenProblemDialog.this);
                if (n == 0) {
                    OpenProblemDialog.this.mCurPath = jFileChooser.getSelectedFile();
                    Insets insets = OpenProblemDialog.this.mPathLabel.getInsets();
                    int n2 = OpenProblemDialog.this.mPathLabel.getWidth() - insets.left - insets.right;
                    String string = TextUtility.truncText(OpenProblemDialog.this.mPathLabel.getFontMetrics(OpenProblemDialog.this.mPathLabel.getFont()), n2, OpenProblemDialog.this.mCurPath.getAbsolutePath(), 1);
                    OpenProblemDialog.this.mPathLabel.setText(string);
                }
            }
        });
        jPanel.add((Component)jButton, new SpringLayout.Constraints(Spring.constant(225), Spring.constant(15), Spring.constant(20), Spring.constant(20)));
        jPanel2.setLayout(springLayout);
        this.mList = new JList();
        this.mList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.setComponentOrientation(jList.getComponentOrientation());
                if (bl) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
                ProblemInfo problemInfo = (ProblemInfo)object;
                this.setText("Q. " + (n + 1) + " (" + problemInfo.getWidth() + " X " + problemInfo.getHeight() + ")");
                this.setEnabled(jList.isEnabled());
                this.setFont(jList.getFont());
                this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
                return this;
            }
        });
        this.mList.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (2 != mouseEvent.getClickCount()) {
                    return;
                }
                int n = OpenProblemDialog.this.mList.locationToIndex(mouseEvent.getPoint());
                if (n < 0) {
                    return;
                }
                OpenProblemDialog.this.setVisible(false);
                ProblemInfo problemInfo = OpenProblemDialog.this.mReader.getProblemAt(n);
                OpenProblemDialog.this.mLoadOwner.loadProblem(OpenProblemDialog.this.mCurPath, problemInfo);
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        jPanel2.add((Component)new JScrollPane(this.mList, 22, 31), new SpringLayout.Constraints(Spring.constant(5), Spring.constant(5), Spring.constant(150), Spring.constant(180)));
        string = resourceBundle.getString("Load");
        JButton jButton2 = new JButton(string);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (OpenProblemDialog.this.mPathLabel.getText().equals("")) {
                    return;
                }
                File file = null;
                try {
                    file = new File(OpenProblemDialog.this.mCurPath.getAbsolutePath());
                    OpenProblemDialog.this.mReader.load(file);
                    ProblemInfo[] problemInfoArray = OpenProblemDialog.this.mReader.getAllProblems();
                    OpenProblemDialog.this.mList.setListData(problemInfoArray);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("specified file : " + file.getName() + ", could not be found !");
                }
                catch (IOException iOException) {
                    System.out.println("the specified file is not a problem file");
                    OpenProblemDialog.this.mList.setListData(new ProblemInfo[0]);
                }
            }
        });
        jPanel2.add((Component)jButton2, new SpringLayout.Constraints(Spring.constant(165), Spring.constant(10), Spring.constant(100), Spring.constant(25)));
        string = resourceBundle.getString("OK");
        JButton jButton3 = new JButton(string);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = OpenProblemDialog.this.mList.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                OpenProblemDialog.this.setVisible(false);
                ProblemInfo problemInfo = OpenProblemDialog.this.mReader.getProblemAt(n);
                OpenProblemDialog.this.mLoadOwner.loadProblem(OpenProblemDialog.this.mCurPath, problemInfo);
            }
        });
        jPanel2.add((Component)jButton3, new SpringLayout.Constraints(Spring.constant(165), Spring.constant(45), Spring.constant(100), Spring.constant(25)));
        string = resourceBundle.getString("Cancel");
        JButton jButton4 = new JButton(string);
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProblemUnmarshalable problemUnmarshalable = OpenProblemDialog.this.mLoadOwner;
                OpenProblemDialog.this.setLoadOwner(null);
                OpenProblemDialog.this.setVisible(false);
                problemUnmarshalable.loadCanceled();
            }
        });
        jPanel2.add((Component)jButton4, new SpringLayout.Constraints(Spring.constant(165), Spring.constant(75), Spring.constant(100), Spring.constant(25)));
    }

    void toCenter() {
        GUIUtility.LayoutToCenter((Component)this);
    }

    public void show() {
        this.toCenter();
        super.show();
    }

    private void setLoadOwner(ProblemUnmarshalable problemUnmarshalable) {
        this.mLoadOwner = problemUnmarshalable;
    }

    private OpenProblemDialog() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                OpenProblemDialog.this.setVisible(false);
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = Bundle.getString(COMMON_RESOURCE_KEY);
        URL uRL = ResourceLoader.loadProperty(class$jp$gr$java_conf$ktz$puzzle$hashikake$util$gui$OpenProblemDialog == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$util$gui$OpenProblemDialog = OpenProblemDialog.class$("jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.OpenProblemDialog")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$util$gui$OpenProblemDialog, string);
        PropertyBundle.initialize(uRL);
    }

    private static class InitHolder {
        static OpenProblemDialog sDialog = new OpenProblemDialog();

        private InitHolder() {
        }

        static {
            sDialog.init();
            sDialog.toCenter();
        }
    }
}

