/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.util;

import java.awt.Point;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.DirectionStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.SelectionStateEventCode;

public class UtilityFuncs {
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH};

    public static StateEventCode createSpaceCode() {
        return HashikakeStateEventCode.createSpaceCode();
    }

    public static StateEventCode createNumberCodeOf(int n) {
        return HashikakeStateEventCode.createNumberCodeOf(n);
    }

    public static StateEventCode getSelectDirectionEventCode(Direction direction) {
        return DirectionStateEventCode.createSelectDirectionCode(direction);
    }

    public static StateEventCode getDetermineDirectionEventCode(Direction direction) {
        return DirectionStateEventCode.createDetermineDirectionCode(direction);
    }

    public static boolean isSelectionType(StateEventCode stateEventCode) {
        if (stateEventCode instanceof DirectionStateEventCode) {
            return DirectionStateEventCode.isSelectionType((DirectionStateEventCode)stateEventCode);
        }
        return false;
    }

    public static boolean isDeterminationType(StateEventCode stateEventCode) {
        if (stateEventCode instanceof DirectionStateEventCode) {
            return DirectionStateEventCode.isDeterminationType((DirectionStateEventCode)stateEventCode);
        }
        return false;
    }

    public static StateEventCode getSelectionEventCode() {
        return SelectionStateEventCode.getInstance();
    }

    public static Direction resolveDirectionOf(int n) {
        if (n == 37) {
            return Direction.WEST;
        }
        if (n == 39) {
            return Direction.EAST;
        }
        if (n == 38) {
            return Direction.NORTH;
        }
        if (n == 40) {
            return Direction.SOUTH;
        }
        return Direction.NO;
    }

    public static Direction resolveDirectionOf(StateEventCode stateEventCode) {
        if (stateEventCode instanceof DirectionStateEventCode) {
            return ((DirectionStateEventCode)stateEventCode).getDirection();
        }
        return Direction.NO;
    }

    public static Direction inverseDirection(Direction direction) {
        if (Direction.WEST == direction) {
            return Direction.EAST;
        }
        if (Direction.EAST == direction) {
            return Direction.WEST;
        }
        if (Direction.NORTH == direction) {
            return Direction.SOUTH;
        }
        if (Direction.SOUTH == direction) {
            return Direction.NORTH;
        }
        if (Direction.NORTH_WEST == direction) {
            return Direction.SOUTH_EAST;
        }
        if (Direction.NORTH_EAST == direction) {
            return Direction.SOUTH_WEST;
        }
        if (Direction.SOUTH_WEST == direction) {
            return Direction.NORTH_EAST;
        }
        if (Direction.SOUTH_EAST == direction) {
            return Direction.NORTH_WEST;
        }
        return Direction.NO;
    }

    public static Direction[] getUnitDirection(Direction direction) {
        Direction[] directionArray = new Direction[]{Direction.NO, Direction.NO};
        Point point = direction.getDifference();
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            Point point2 = DIRECTIONS[i].getDifference();
            if (point.x != 0 && point.x == point2.x) {
                directionArray[0] = DIRECTIONS[i];
            }
            if (point.y == 0 || point.y != point2.y) continue;
            directionArray[1] = DIRECTIONS[i];
        }
        return directionArray;
    }
}

