/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.bench.view;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.BenchReport;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.BenchmarkMediator;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.Colleague;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.TableInsertable;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.TableSortHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.model.HashikakeBenchResultSorter;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.model.HashikakeBenchmarkHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.model.ResultTableModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.model.SortedTableModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.view.BenchmarkResultTableProxy;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.view.CancelButtonColleague;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.view.DetailButtonColleague;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.view.ProgressDialogColleague;
import jp.gr.java_conf.ktz.puzzle.hashikake.io.XMLProblemReader;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SoluteSeparatedException;

class HashikakeBenchmarkMediator
implements BenchmarkMediator {
    private TableInsertable mModel;
    private XMLProblemReader mReader = new XMLProblemReader();
    private boolean mCanceled;
    private Component mRootComponent;
    private Map mColleagueMap = new HashMap();
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$bench$view$BenchmarkResultTableProxy;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$bench$view$DetailButtonColleague;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$bench$view$ProgressDialogColleague;

    private HashikakeBenchmarkMediator(Component component) {
        this.mRootComponent = component;
        if (component instanceof Colleague) {
            this.addColleague((Colleague)((Object)component));
        }
    }

    public static BenchmarkMediator getInstance(Component component) {
        return new HashikakeBenchmarkMediator(component);
    }

    private void setTableInsertable(TableInsertable tableInsertable) {
        this.mModel = tableInsertable;
    }

    private void initColleague(int n) {
        Object object = new HashikakeBenchResultSorter();
        ResultTableModel resultTableModel = new ResultTableModel(new String[]{"problem name", "width X height", "min time", "max time", "average time", "count", "solved"});
        SortedTableModel sortedTableModel = new SortedTableModel(resultTableModel, resultTableModel, (TableSortHandler)object);
        BenchmarkResultTableProxy benchmarkResultTableProxy = new BenchmarkResultTableProxy(this, sortedTableModel, (TableSortHandler)object);
        this.addColleague(benchmarkResultTableProxy);
        this.setTableInsertable(sortedTableModel);
        object = new ProgressDialogColleague(this, this.mRootComponent, n);
        this.addColleague((Colleague)object);
        this.addColleague(((ProgressDialogColleague)object).getDetailButtonColleague());
        this.addColleague(((ProgressDialogColleague)object).getCancelButtonColleague());
    }

    public void start(File file, int n) {
        File[] fileArray = this.resetMeasureFiles(file);
        this.initColleague(fileArray.length);
        this.setUpColleagues();
        new Thread((Runnable)new BenchmarkRunner(fileArray, n), "Benchmark").start();
    }

    public void addColleague(Colleague colleague) {
        this.mColleagueMap.put(colleague.getClass(), colleague);
    }

    public void terminate() {
        this.measureCanceled();
    }

    private void setUpColleagues() {
        Iterator iterator = this.mColleagueMap.values().iterator();
        while (iterator.hasNext()) {
            ((Colleague)iterator.next()).setUp();
        }
    }

    private void cleanUpColleagues() {
        class CleanUpHandler
        implements Runnable {
            CleanUpHandler() {
            }

            public void run() {
                Iterator iterator = HashikakeBenchmarkMediator.this.mColleagueMap.values().iterator();
                while (iterator.hasNext()) {
                    ((Colleague)iterator.next()).cleanUp();
                }
            }
        }
        CleanUpHandler cleanUpHandler = new CleanUpHandler();
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(cleanUpHandler);
        } else {
            cleanUpHandler.run();
        }
    }

    private synchronized void measureCanceled() {
        this.mCanceled = true;
    }

    private synchronized boolean isCanceled() {
        return this.mCanceled;
    }

    public ProblemInfo getProblemAt(int n) {
        return this.mReader.getProblemAt(n);
    }

    public int getProblemCount() {
        return this.mReader.size();
    }

    public void colleagueChanged(Colleague colleague) {
        if (colleague instanceof DetailButtonColleague) {
            Colleague colleague2 = (Colleague)this.mColleagueMap.get(class$jp$gr$java_conf$ktz$puzzle$hashikake$bench$view$BenchmarkResultTableProxy == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$bench$view$BenchmarkResultTableProxy = HashikakeBenchmarkMediator.class$("jp.gr.java_conf.ktz.puzzle.hashikake.bench.view.BenchmarkResultTableProxy")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$bench$view$BenchmarkResultTableProxy);
            colleague2.update();
            colleague.update();
        } else if (colleague instanceof CancelButtonColleague) {
            this.terminate();
        } else if (colleague instanceof BenchmarkResultTableProxy) {
            Colleague colleague3 = (Colleague)this.mColleagueMap.get(class$jp$gr$java_conf$ktz$puzzle$hashikake$bench$view$DetailButtonColleague == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$bench$view$DetailButtonColleague = HashikakeBenchmarkMediator.class$("jp.gr.java_conf.ktz.puzzle.hashikake.bench.view.DetailButtonColleague")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$bench$view$DetailButtonColleague);
            colleague3.update();
        } else {
            colleague.update();
        }
    }

    private File[] resetMeasureFiles(File file) {
        return file.listFiles(new FileFilter(){
            Pattern mExtPattern = Pattern.compile(".xml$");

            public boolean accept(File file) {
                if (!file.isFile()) {
                    return false;
                }
                return this.mExtPattern.matcher(file.getName()).find();
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BenchmarkRunner
    implements Runnable {
        private final File[] mFiles;
        private final int mSolveCount;

        public BenchmarkRunner(File[] fileArray, int n) {
            this.mFiles = fileArray;
            this.mSolveCount = n;
        }

        public void run() {
            SetUpRunner setUpRunner = new SetUpRunner();
            UpdateRunner updateRunner = new UpdateRunner();
            File file = null;
            try {
                for (int i = 0; i < this.mFiles.length; ++i) {
                    file = this.mFiles[i];
                    HashikakeBenchmarkMediator.this.mReader.load(file);
                    setUpRunner.setUp();
                    this.runBenchmark(updateRunner);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println(file + " is not found.");
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (IOException iOException) {
                System.out.println("IOException occured.");
            }
            HashikakeBenchmarkMediator.this.cleanUpColleagues();
        }

        private void runBenchmark(UpdateRunner updateRunner) throws InterruptedIOException {
            BenchReport benchReport = null;
            int n = HashikakeBenchmarkMediator.this.getProblemCount();
            for (int i = 0; i < n; ++i) {
                if (HashikakeBenchmarkMediator.this.isCanceled()) {
                    throw new InterruptedIOException();
                }
                ProblemInfo problemInfo = null;
                try {
                    problemInfo = HashikakeBenchmarkMediator.this.getProblemAt(i);
                    HashikakeBenchmarkHandler hashikakeBenchmarkHandler = new HashikakeBenchmarkHandler();
                    hashikakeBenchmarkHandler.reset(problemInfo);
                    benchReport = hashikakeBenchmarkHandler.solve(this.mSolveCount);
                }
                catch (SoluteSeparatedException soluteSeparatedException) {
                    benchReport = BenchReport.illegalBenchReport(problemInfo, 0L);
                }
                updateRunner.update(benchReport);
            }
        }

        private class SetUpRunner
        implements Runnable {
            private SetUpRunner() {
            }

            public void run() {
                Colleague colleague = (Colleague)HashikakeBenchmarkMediator.this.mColleagueMap.get(class$jp$gr$java_conf$ktz$puzzle$hashikake$bench$view$ProgressDialogColleague == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$bench$view$ProgressDialogColleague = HashikakeBenchmarkMediator.class$("jp.gr.java_conf.ktz.puzzle.hashikake.bench.view.ProgressDialogColleague")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$bench$view$ProgressDialogColleague);
                colleague.setUp();
            }

            public void setUp() {
                try {
                    EventQueue.invokeAndWait(this);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }

        private class UpdateRunner
        implements Runnable {
            private BenchReport mReport;

            private UpdateRunner() {
            }

            public void run() {
                HashikakeBenchmarkMediator.this.mModel.addRow(this.mReport.flatten());
                HashikakeBenchmarkMediator.this.colleagueChanged((Colleague)HashikakeBenchmarkMediator.this.mColleagueMap.get(class$jp$gr$java_conf$ktz$puzzle$hashikake$bench$view$ProgressDialogColleague == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$bench$view$ProgressDialogColleague = HashikakeBenchmarkMediator.class$("jp.gr.java_conf.ktz.puzzle.hashikake.bench.view.ProgressDialogColleague")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$bench$view$ProgressDialogColleague));
            }

            public void update(BenchReport benchReport) {
                this.mReport = benchReport;
                try {
                    EventQueue.invokeAndWait(this);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }
}

