/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.util.ArrayList;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.BoundClass;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.classes.ExceptionMethodBuilder;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.binding.classes.MungedClass;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.DefinitionContext;
import org.jibx.binding.def.DirectObject;
import org.jibx.binding.def.DirectProperty;
import org.jibx.binding.def.ElementWrapper;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IMapping;
import org.jibx.binding.def.LinkableBase;
import org.jibx.binding.def.NameDefinition;
import org.jibx.binding.def.NamespaceDefinition;
import org.jibx.binding.def.PropertyDefinition;
import org.jibx.runtime.JiBXException;

public class MappingDefinition
extends LinkableBase
implements IMapping {
    private static final String ADAPTERCLASS_SUFFIX = "_access";
    private static final String IMARSHALLABLE_INTERFACE = "org.jibx.runtime.IMarshallable";
    private static final String IUNMARSHALLABLE_INTERFACE = "org.jibx.runtime.IUnmarshallable";
    private static final String GETMARSHALLER_METHOD = "org.jibx.runtime.IMarshallingContext.getMarshaller";
    private static final String GETMARSHALLER_SIGNATURE = "(ILjava/lang/String;)Lorg/jibx/runtime/IMarshaller;";
    private static final String GETUNMARSHALLER_METHOD = "org.jibx.runtime.IUnmarshallingContext.getUnmarshaller";
    private static final String GETUNMARSHALLER_SIGNATURE = "(I)Lorg/jibx/runtime/IUnmarshaller;";
    private static final String MARSHAL_METHODNAME = "marshal";
    private static final String BASEMARSHAL_METHODNAME = "baseMarshal";
    private static final String UNMARSHAL_METHODNAME = "unmarshal";
    private static final String ISPRESENT_METHODNAME = "isPresent";
    private static final String UNMARSHALCONTEXT_CLASS = "org.jibx.runtime.impl.UnmarshallingContext";
    private static final String MARSHALCONTEXT_CLASS = "org.jibx.runtime.impl.MarshallingContext";
    private static final String UNMARSHAL_ISATMETHOD = "org.jibx.runtime.IUnmarshallingContext.isAt";
    private static final String UNMARSHAL_ISATSIGNATURE = "(Ljava/lang/String;Ljava/lang/String;)Z";
    private static final String UNMARSHALLERUNMARSHAL_METHOD = "org.jibx.runtime.IUnmarshaller.unmarshal";
    private static final String UNMARSHALLERUNMARSHAL_SIGNATURE = "(Ljava/lang/Object;Lorg/jibx/runtime/IUnmarshallingContext;)Ljava/lang/Object;";
    private static final String MARSHALLERMARSHAL_METHOD = "org.jibx.runtime.IMarshaller.marshal";
    private static final String MARSHALLERMARSHAL_SIGNATURE = "(Ljava/lang/Object;Lorg/jibx/runtime/IMarshallingContext;)V";
    private static final String CHECKEXTENDS_METHOD = "org.jibx.runtime.IMarshaller.isExtension";
    private static final String GETINDEX_METHOD = "org.jibx.runtime.IMarshallable.JiBX_getIndex";
    private static final String UNMARSHALLERPRESENT_METHOD = "org.jibx.runtime.IUnmarshaller.isPresent";
    private static final String UNMARSHALLERPRESENT_SIGNATURE = "(Lorg/jibx/runtime/IUnmarshallingContext;)Z";
    private static final String UNMARSHALCONTEXT_INTERFACE = "org.jibx.runtime.IUnmarshallingContext";
    private static final String MARSHALCONTEXT_INTERFACE = "org.jibx.runtime.IMarshallingContext";
    private static final String CURRENTELEMENT_METHOD = "org.jibx.runtime.impl.UnmarshallingContext.currentNameString";
    private static final String CURRENTELEMENT_SIGNATURE = "()Ljava/lang/String;";
    private static final String ADDUNMARSHALLER_METHOD = "org.jibx.runtime.impl.UnmarshallingContext.addUnmarshalling";
    private static final String ADDUNMARSHALLER_SIGNATURE = "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
    private static final String REMOVEUNMARSHALLER_METHOD = "org.jibx.runtime.impl.UnmarshallingContext.removeUnmarshalling";
    private static final String REMOVEUNMARSHALLER_SIGNATURE = "(I)V";
    private static final String ADDMARSHALLER_METHOD = "org.jibx.runtime.impl.MarshallingContext.addMarshalling";
    private static final String ADDMARSHALLER_SIGNATURE = "(ILjava/lang/String;)V";
    private static final String REMOVEMARSHALLER_METHOD = "org.jibx.runtime.impl.MarshallingContext.removeMarshalling";
    private static final String REMOVEMARSHALLER_SIGNATURE = "(I)V";
    private static final Type[] ISPRESENT_METHOD_ARGS = new Type[]{new ObjectType("org.jibx.runtime.IUnmarshallingContext")};
    private static final Type[] UNMARSHAL_METHOD_ARGS = new Type[]{Type.OBJECT, new ObjectType("org.jibx.runtime.IUnmarshallingContext")};
    private static final Type[] MARSHAL_METHOD_ARGS = new Type[]{Type.OBJECT, new ObjectType("org.jibx.runtime.IMarshallingContext")};
    private static final String UNMARSHALLER_INTERFACE = "org.jibx.runtime.IUnmarshaller";
    private static final String[] UNMARSHALLER_INTERFACES = new String[]{"org.jibx.runtime.IUnmarshaller"};
    private static final String MARSHALLER_INTERFACE = "org.jibx.runtime.IMarshaller";
    private static final String ABSTRACTMARSHALLER_INTERFACE = "org.jibx.runtime.IAbstractMarshaller";
    private static final String[] MARSHALLER_INTERFACES = new String[]{"org.jibx.runtime.IMarshaller"};
    private static final String[] BOTH_INTERFACES = new String[]{"org.jibx.runtime.IUnmarshaller", "org.jibx.runtime.IMarshaller"};
    private static final String MARSHALLABLE_METHODNAME = "marshal";
    private static final String MARSHALLABLE_SIGNATURE = "(Lorg/jibx/runtime/IMarshallingContext;)V";
    private static final String GETINDEX_METHODNAME = "JiBX_getIndex";
    private static final String GETINDEX_SIGNATURE = "()I";
    private static final String CHECKEXTENDS_METHODNAME = "isExtension";
    private static final String CHECKEXTENDS_SIGNATURE = "(I)Z";
    private static final String UNMARSHALLABLE_METHODNAME = "unmarshal";
    private static final String UNMARSHALLABLE_SIGNATURE = "(Lorg/jibx/runtime/IUnmarshallingContext;)V";
    private final IContainer m_container;
    private final DefinitionContext m_defContext;
    private final BoundClass m_class;
    private final NameDefinition m_name;
    private final boolean m_isAbstract;
    private final int m_indexNumber;
    private final String m_baseType;
    private IMapping m_baseMapping;
    private ClassFile m_marshaller;
    private ClassFile m_unmarshaller;
    private ArrayList m_extensions;

    public MappingDefinition(IContainer contain, DefinitionContext defc, String type, NameDefinition name, boolean abs, String base, IComponent bind) throws JiBXException {
        if (name == null) {
            this.setWrappedComponent(bind);
        } else {
            this.setWrappedComponent(new ElementWrapper(defc, name, bind));
        }
        this.m_container = contain;
        this.m_defContext = defc;
        this.m_class = BoundClass.getInstance(type, null);
        this.m_name = name;
        this.m_isAbstract = abs;
        if (abs) {
            this.m_extensions = new ArrayList();
        }
        this.m_baseType = base;
        this.m_indexNumber = contain.getBindingRoot().getMappedClassIndex(type);
    }

    boolean hasNamespace() {
        return this.m_defContext.hasNamespace();
    }

    void genLoadNamespaces(MethodBuilder mb) throws JiBXException {
        this.m_defContext.genLoadNamespaces(mb);
    }

    private void addIMarshallableMethod() throws JiBXException {
        ClassFile cf = this.m_class.getMungedFile();
        ContextMethodBuilder mb = new ContextMethodBuilder("marshal", MARSHALLABLE_SIGNATURE, cf, 1, 0, this.m_class.getClassFile().getName(), 1, MARSHALLER_INTERFACE);
        mb.loadContext();
        mb.appendLoadConstant(this.m_indexNumber);
        mb.appendLoadConstant(cf.getName());
        mb.appendCallInterface(GETMARSHALLER_METHOD, GETMARSHALLER_SIGNATURE);
        mb.loadObject();
        mb.loadContext();
        mb.appendCallInterface(MARSHALLERMARSHAL_METHOD, MARSHALLERMARSHAL_SIGNATURE);
        mb.append((Instruction)InstructionConstants.RETURN);
        this.m_class.getUniqueNamed(mb);
        ExceptionMethodBuilder xb = new ExceptionMethodBuilder(GETINDEX_METHODNAME, GETINDEX_SIGNATURE, cf, 1);
        xb.appendLoadConstant(this.m_indexNumber);
        xb.append((Instruction)InstructionConstants.IRETURN);
        this.m_class.getUniqueNamed(xb);
        this.m_class.getClassFile().addInterface(IMARSHALLABLE_INTERFACE);
    }

    private void addIUnmarshallableMethod() throws JiBXException {
        ClassFile cf = this.m_class.getMungedFile();
        ContextMethodBuilder mb = new ContextMethodBuilder("unmarshal", UNMARSHALLABLE_SIGNATURE, cf, 1, 0, this.m_class.getClassFile().getName(), 1, UNMARSHALLER_INTERFACE);
        mb.loadContext();
        mb.appendLoadConstant(this.m_indexNumber);
        mb.appendCallInterface(GETUNMARSHALLER_METHOD, GETUNMARSHALLER_SIGNATURE);
        mb.loadObject();
        mb.loadContext();
        mb.appendCallInterface(UNMARSHALLERUNMARSHAL_METHOD, UNMARSHALLERUNMARSHAL_SIGNATURE);
        mb.append((Instruction)InstructionConstants.RETURN);
        this.m_class.getUniqueNamed(mb);
        this.m_class.getClassFile().addInterface(IUNMARSHALLABLE_INTERFACE);
    }

    public BoundClass getBoundClass() {
        return this.m_class;
    }

    public IComponent getImplComponent() {
        return this.m_component;
    }

    public ClassFile getMarshaller() {
        return this.m_marshaller;
    }

    public ClassFile getUnmarshaller() {
        return this.m_unmarshaller;
    }

    public NameDefinition getName() {
        return this.m_name;
    }

    public int getIndex() {
        return this.m_indexNumber;
    }

    public void addNamespace(NamespaceDefinition ns) throws JiBXException {
        this.m_defContext.addNamespace(ns);
    }

    public boolean isAbstract() {
        return this.m_isAbstract;
    }

    public void addExtension(MappingDefinition mdef) {
        if (!this.m_extensions.contains(mdef)) {
            this.m_extensions.add(mdef);
        }
    }

    public IComponent buildRef(IContainer parent, String type, PropertyDefinition prop) throws JiBXException {
        boolean abs = this.m_isAbstract && !prop.isThis();
        DirectObject dobj = new DirectObject(this.m_container, this.m_class.getClassFile(), abs, this.m_marshaller, this.m_unmarshaller, this.m_indexNumber);
        return new DirectProperty(prop, dobj);
    }

    public void generateCode() throws JiBXException {
        IMapping map;
        ContextMethodBuilder mb;
        this.m_defContext.generateCode();
        ClassFile target = this.m_class.getMungedFile();
        String pack = "";
        String tname = target.getName();
        int split = tname.lastIndexOf(46);
        if (split >= 0) {
            pack = tname.substring(0, split + 1);
            tname = tname.substring(split + 1);
        }
        BindingDefinition def = this.m_container.getBindingRoot();
        String name = pack + def.getPrefix() + tname + ADAPTERCLASS_SUFFIX;
        ClassFile base = ClassCache.getClassFile("java.lang.Object");
        String[] intfs = def.isInput() ? (def.isOutput() ? BOTH_INTERFACES : UNMARSHALLER_INTERFACES) : MARSHALLER_INTERFACES;
        ClassFile cf = new ClassFile(name, target.getRoot(), base, 1, intfs);
        cf.addDefaultConstructor();
        if (def.isInput()) {
            IMapping map2;
            int i;
            mb = new ContextMethodBuilder(ISPRESENT_METHODNAME, (Type)Type.BOOLEAN, ISPRESENT_METHOD_ARGS, cf, 17, -1, null, 1, UNMARSHALCONTEXT_INTERFACE);
            if (this.m_isAbstract) {
                mb.addException("org.jibx.runtime.JiBXException");
                BranchHandle[] iffounds = new BranchHandle[this.m_extensions.size()];
                int i2 = 0;
                while (i2 < iffounds.length) {
                    map = (IMapping)this.m_extensions.get(i2);
                    mb.loadContext();
                    mb.appendLoadConstant(map.getIndex());
                    mb.appendCallInterface(GETUNMARSHALLER_METHOD, GETUNMARSHALLER_SIGNATURE);
                    mb.loadContext();
                    mb.appendCallInterface(UNMARSHALLERPRESENT_METHOD, UNMARSHALLERPRESENT_SIGNATURE);
                    iffounds[i2] = mb.append((BranchInstruction)new IFNE(null));
                    ++i2;
                }
                mb.append(InstructionConstants.ICONST_0);
                mb.append((Instruction)InstructionConstants.IRETURN);
                InstructionHandle found = mb.append(InstructionConstants.ICONST_1);
                i = 0;
                while (i < iffounds.length) {
                    iffounds[i].setTarget(found);
                    ++i;
                }
            } else if (this.m_name == null) {
                mb.append(InstructionConstants.ICONST_1);
            } else {
                mb.addException("org.jibx.runtime.JiBXException");
                mb.loadContext();
                this.m_name.genPushUriPair(mb);
                mb.appendCallInterface(UNMARSHAL_ISATMETHOD, UNMARSHAL_ISATSIGNATURE);
            }
            mb.append((Instruction)InstructionConstants.IRETURN);
            mb.codeComplete(false);
            mb.addMethod();
            String type = this.m_class.getClassName();
            mb = new ContextMethodBuilder("unmarshal", (Type)Type.OBJECT, UNMARSHAL_METHOD_ARGS, cf, 17, 1, type, 2, UNMARSHALCONTEXT_INTERFACE);
            mb.addException("org.jibx.runtime.JiBXException");
            mb.loadObject();
            BranchHandle ifnnull = mb.append((BranchInstruction)new IFNONNULL(null));
            if (this.m_isAbstract) {
                BranchHandle[] iffounds = new BranchHandle[this.m_extensions.size()];
                i = 0;
                while (i < iffounds.length) {
                    map2 = (IMapping)this.m_extensions.get(i);
                    mb.loadContext();
                    mb.appendLoadConstant(map2.getIndex());
                    mb.appendCallInterface(GETUNMARSHALLER_METHOD, GETUNMARSHALLER_SIGNATURE);
                    mb.append((Instruction)InstructionConstants.DUP);
                    mb.loadContext();
                    mb.appendCallInterface(UNMARSHALLERPRESENT_METHOD, UNMARSHALLERPRESENT_SIGNATURE);
                    iffounds[i] = mb.append((BranchInstruction)new IFNE(null));
                    mb.append((Instruction)InstructionConstants.POP);
                    ++i;
                }
                mb.appendCreateNew("java.lang.StringBuffer");
                mb.append((Instruction)InstructionConstants.DUP);
                mb.appendLoadConstant("Element ");
                mb.appendCallInit("java.lang.StringBuffer", "(Ljava/lang/String;)V");
                mb.append((Instruction)InstructionConstants.DUP);
                mb.loadContext(UNMARSHALCONTEXT_CLASS);
                mb.appendCallVirtual(CURRENTELEMENT_METHOD, CURRENTELEMENT_SIGNATURE);
                mb.appendCallVirtual("java.lang.StringBuffer.append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
                mb.append((Instruction)InstructionConstants.DUP);
                mb.appendLoadConstant(" has no mapping that extends " + this.m_class.getClassName());
                mb.appendCallVirtual("java.lang.StringBuffer.append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
                mb.appendCallVirtual("java.lang.StringBuffer.toString", CURRENTELEMENT_SIGNATURE);
                mb.appendCreateNew("org.jibx.runtime.JiBXException");
                mb.append((Instruction)InstructionConstants.DUP_X1);
                mb.append((Instruction)InstructionConstants.SWAP);
                mb.appendCallInit("org.jibx.runtime.JiBXException", "(Ljava/lang/String;)V");
                mb.append(InstructionConstants.ATHROW);
                InstructionHandle found = mb.append(InstructionConstants.ACONST_NULL);
                int i3 = 0;
                while (i3 < iffounds.length) {
                    iffounds[i3].setTarget(found);
                    ++i3;
                }
                mb.loadContext();
                mb.appendCallInterface(UNMARSHALLERUNMARSHAL_METHOD, UNMARSHALLERUNMARSHAL_SIGNATURE);
                mb.append((Instruction)InstructionConstants.ARETURN);
            } else {
                this.genNewInstance(mb);
                mb.storeObject();
            }
            ArrayList maps = this.m_defContext.getMappings();
            if (maps != null && maps.size() > 0) {
                i = 0;
                while (i < maps.size()) {
                    mb.loadContext(UNMARSHALCONTEXT_CLASS);
                    map2 = (IMapping)maps.get(i);
                    mb.appendLoadConstant(map2.getIndex());
                    map2.getName().genPushUriPair(mb);
                    mb.appendLoadConstant(map2.getUnmarshaller().getName());
                    mb.appendCallVirtual(ADDUNMARSHALLER_METHOD, ADDUNMARSHALLER_SIGNATURE);
                    ++i;
                }
            }
            ifnnull.setTarget(mb.loadObject());
            mb.appendCreateCast(type);
            if (this.m_component.hasAttribute()) {
                mb.append((Instruction)InstructionConstants.DUP);
                this.m_component.genAttributeUnmarshal(mb);
            }
            if (this.m_component.hasContent()) {
                mb.append((Instruction)InstructionConstants.DUP);
                this.m_component.genContentUnmarshal(mb);
            }
            if (maps != null && maps.size() > 0) {
                i = 0;
                while (i < maps.size()) {
                    mb.loadContext(UNMARSHALCONTEXT_CLASS);
                    map2 = (IMapping)maps.get(i);
                    mb.appendLoadConstant(map2.getIndex());
                    mb.appendCallVirtual(REMOVEUNMARSHALLER_METHOD, "(I)V");
                    ++i;
                }
            }
            mb.append((Instruction)InstructionConstants.ARETURN);
            mb.codeComplete(false);
            mb.addMethod();
            if (this.m_name != null && !this.m_isAbstract && this.m_class.getClassFile() == this.m_class.getMungedFile()) {
                this.addIUnmarshallableMethod();
            }
        }
        if (def.isOutput()) {
            mb = new ContextMethodBuilder("marshal", (Type)Type.VOID, MARSHAL_METHOD_ARGS, cf, 17, 1, "java.lang.Object", 2, MARSHALCONTEXT_INTERFACE);
            mb.addException("org.jibx.runtime.JiBXException");
            ArrayList maps = this.m_defContext.getMappings();
            if (maps != null && maps.size() > 0) {
                int i = 0;
                while (i < maps.size()) {
                    mb.loadContext(MARSHALCONTEXT_CLASS);
                    map = (IMapping)maps.get(i);
                    mb.appendLoadConstant(map.getIndex());
                    mb.appendLoadConstant(map.getMarshaller().getName());
                    mb.appendCallVirtual(ADDMARSHALLER_METHOD, ADDMARSHALLER_SIGNATURE);
                    ++i;
                }
            }
            if (this.m_component.hasAttribute() || this.m_component.hasContent()) {
                mb.loadObject(target.getName());
                if (this.m_component.hasAttribute()) {
                    if (this.m_component.hasContent()) {
                        mb.append((Instruction)InstructionConstants.DUP);
                    }
                    this.m_component.genAttributeMarshal(mb);
                }
                if (this.m_component.hasContent()) {
                    this.m_component.genContentMarshal(mb);
                }
            }
            if (maps != null && maps.size() > 0) {
                int i = 0;
                while (i < maps.size()) {
                    mb.loadContext(MARSHALCONTEXT_CLASS);
                    map = (IMapping)maps.get(i);
                    mb.appendLoadConstant(map.getIndex());
                    mb.appendCallVirtual(REMOVEMARSHALLER_METHOD, "(I)V");
                    ++i;
                }
            }
            mb.append((Instruction)InstructionConstants.RETURN);
            mb.codeComplete(false);
            mb.addMethod();
            ExceptionMethodBuilder xb = new ExceptionMethodBuilder(CHECKEXTENDS_METHODNAME, CHECKEXTENDS_SIGNATURE, cf, 17);
            if (this.m_baseMapping == null) {
                xb.append(InstructionConstants.ICONST_0);
            } else {
                xb.append((Instruction)InstructionConstants.ILOAD_1);
                xb.appendLoadConstant(this.m_baseMapping.getIndex());
                xb.append((Instruction)InstructionConstants.ISUB);
                BranchHandle iftrue = xb.append((BranchInstruction)new IFEQ(null));
                xb.append(InstructionConstants.ICONST_0);
                xb.append((Instruction)InstructionConstants.IRETURN);
                iftrue.setTarget(xb.append(InstructionConstants.ICONST_1));
            }
            xb.append((Instruction)InstructionConstants.IRETURN);
            xb.codeComplete(false);
            xb.addMethod();
            if (this.m_name != null && !this.m_isAbstract && this.m_class.getClassFile() == this.m_class.getMungedFile()) {
                this.addIMarshallableMethod();
            }
            if (this.m_isAbstract) {
                mb = new ContextMethodBuilder(BASEMARSHAL_METHODNAME, (Type)Type.VOID, MARSHAL_METHOD_ARGS, cf, 17, 1, "java.lang.Object", 2, MARSHALCONTEXT_INTERFACE);
                mb.addException("org.jibx.runtime.JiBXException");
                mb.loadContext();
                mb.loadObject(IMARSHALLABLE_INTERFACE);
                mb.appendCallInterface(GETINDEX_METHOD, GETINDEX_SIGNATURE);
                mb.loadObject();
                mb.appendCallVirtual("java.lang.Object.getClass", "()Ljava/lang/Class;");
                mb.appendCallVirtual("java.lang.Class.getName", CURRENTELEMENT_SIGNATURE);
                mb.appendCallInterface(GETMARSHALLER_METHOD, GETMARSHALLER_SIGNATURE);
                mb.append((Instruction)InstructionConstants.DUP);
                mb.appendLoadConstant(this.m_indexNumber);
                mb.appendCallInterface(CHECKEXTENDS_METHOD, CHECKEXTENDS_SIGNATURE);
                BranchHandle ifvalid = mb.append((BranchInstruction)new IFNE(null));
                mb.appendCreateNew("java.lang.StringBuffer");
                mb.append((Instruction)InstructionConstants.DUP);
                mb.appendLoadConstant("Mapping for type ");
                mb.appendCallInit("java.lang.StringBuffer", "(Ljava/lang/String;)V");
                mb.append((Instruction)InstructionConstants.DUP);
                mb.loadObject();
                mb.appendCallVirtual("java.lang.Object.getClass", "()Ljava/lang/Class;");
                mb.appendCallVirtual("java.lang.Class.getName", CURRENTELEMENT_SIGNATURE);
                mb.appendCallVirtual("java.lang.StringBuffer.append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
                mb.append((Instruction)InstructionConstants.DUP);
                mb.appendLoadConstant(" must extend abstract mapping for type " + this.m_class.getClassName());
                mb.appendCallVirtual("java.lang.StringBuffer.append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
                mb.appendCallVirtual("java.lang.StringBuffer.toString", CURRENTELEMENT_SIGNATURE);
                mb.appendCreateNew("org.jibx.runtime.JiBXException");
                mb.append((Instruction)InstructionConstants.DUP_X1);
                mb.append((Instruction)InstructionConstants.SWAP);
                mb.appendCallInit("org.jibx.runtime.JiBXException", "(Ljava/lang/String;)V");
                mb.append(InstructionConstants.ATHROW);
                ifvalid.setTarget(mb.loadObject());
                mb.loadContext();
                mb.appendCallInterface(MARSHALLERMARSHAL_METHOD, MARSHALLERMARSHAL_SIGNATURE);
                mb.append((Instruction)InstructionConstants.RETURN);
                mb.codeComplete(false);
                mb.addMethod();
                cf.addInterface(ABSTRACTMARSHALLER_INTERFACE);
            }
        }
        this.m_marshaller = this.m_unmarshaller = MungedClass.getUniqueSupportClass(cf);
    }

    public void setLinkages() throws JiBXException {
        this.m_component.setLinkages();
        if (!this.m_isAbstract) {
            this.m_component.checkContentSequence(true);
        }
        this.m_defContext.setLinkages();
        if (this.m_baseType != null) {
            this.m_baseMapping = this.m_defContext.getClassMapping(this.m_baseType);
            this.m_baseMapping.addExtension(this);
        }
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.print("mapping class " + this.m_class.getClassFile().getName());
        if (this.m_name != null) {
            System.out.print(" to element " + this.m_name.toString());
        }
        System.out.println();
        this.m_component.print(depth + 1);
    }
}

