// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		MenuBean.java
//	DATE:		2003.8.1
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.util.gui;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.PropertyBundle;

class MenuBean implements MenuElementBean {
	private String mName;
	private java.util.ArrayList mItemList = new java.util.ArrayList();
	
	public MenuBean() {}
	
	public java.awt.MenuItem createMenuItem(MenuManager inManager) {
		String aI18NName = PropertyBundle.getInstance().getString(mName);
		if (aI18NName.length() == 0) aI18NName = mName;
		
		java.awt.Menu aMenu = new java.awt.Menu(aI18NName);
		aMenu.setActionCommand(mName);
		
		for (int i = 0; i < mItemList.size(); ++i) {
			java.awt.MenuItem aItem
				 = ((MenuElementBean)mItemList.get(i)).createMenuItem(inManager);
			
			aMenu.add(aItem);
		}
		
		inManager.installMenuItem(mName, aMenu);

		return aMenu;
	}
	
	public void setName(String inName) {
		mName = inName;
	}
	
	public String getName() {
		return mName;
	}
	
	public String toString() {
		StringBuffer aBuf = new StringBuffer();
		
		aBuf.append("menu name = " + mName + ", item count = " + mItemList.size() + "\n");
		
		for (int i = 0; i < mItemList.size(); ++i) {
			aBuf.append("\t" + mItemList.get(i) + "\n");
		}
		
		aBuf.append("\n");
		
		return new String(aBuf);
	}
}