/*********************************************************************
 *
 *      Copyright (C) 2001-2002 Nathan Fiedler
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ********************************************************************/

package jp.gr.java_conf.ktz.puzzle.hashikake.util; 

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PropertyBundle extends ResourceBundle {
	private static PropertyBundle sBundle = new PropertyBundle();
	private static java.util.Set sLoaded = new java.util.HashSet();
	
	private java.util.Map mProperty = new java.util.Hashtable();

	public static void initialize(URL inProperty) {
		sBundle.loadProperty(inProperty);
	}

	private PropertyBundle() {
	}

	private void loadProperty(URL inProperty) {
		// Ƀ[hς݂̃\[Xł΍ă[h͍sȂ
		if (sLoaded.contains(inProperty)) return;
		
		java.io.BufferedReader aReader = null;
		try {
			aReader = new java.io.BufferedReader(
				 new java.io.InputStreamReader(inProperty.openStream(), "UTF-8")
			);
			
			String aLine;
			while (null != (aLine = aReader.readLine())) {
				final int aPos = aLine.indexOf("=");
				if (0 < aPos) {
					String aKey = aLine.substring(0, aPos).trim();
					String aValue = aLine.substring(aPos +1).trim();
					
					mProperty.put(aKey, aValue);
				}
			}
			
			sLoaded.add(inProperty);
      	}
      	catch (java.io.IOException e) {
      		System.out.println(
      			"The specified property file, "
      			+ inProperty.getFile()
      			+ "is no existance."
      		);
      		
      		e.printStackTrace(System.out);
      		System.exit(-1);
      	}
      	finally {
      		try {
	      		aReader.close();
	      	}
	      	catch (java.io.IOException e) {
	      		System.out.println("This stream could not be closed");
	      	}
      	}
	}
	
    public static ResourceBundle getInstance() {
    	if (null == sBundle) {
    		throw new IllegalStateException(
    			"ResourceBundle is not initialized.\n"
    			+ "Calling initialize method is to initialize it."
    		);
    	}
    	
    	return sBundle;
    }
    
    /**
     *	BundlȇSL[Ԃ
     */
    public java.util.Enumeration getKeys() {
		return java.util.Collections.enumeration(mProperty.keySet());
    }
    
    protected Object handleGetObject(String inKey) {
    	Object aValue = mProperty.get(inKey);
    	
    	return (null == aValue ? "" : aValue);
    }
}
