// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
//	NAME:		CellActivationModel.java
//	DATE:		2003.6.4
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.creator.model;

import java.awt.Point;

import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

import jp.gr.java_conf.ktz.puzzle.framework.model.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.model.ModelConstants;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.SelectionState;

/**
 *	IꂽZANeBuɂModel
 */
public class CellActivationModel extends AbstractDecoratedModel {
	/** Ȉʒu萔 */
	private static Point EMPTY_POS = ModelConstants.ILLEGAL_POS;
	
	/** ANeBuȈʒu */
	private Point mActivePos = EMPTY_POS;
	private Point mReleasePos = EMPTY_POS;
	
	/** ModelCꂽǂtO */
	private boolean mIsModified = false;
	
	/**
	 *	w肳ꂽStateEventCodẽfŏł邩ǂ`FbNB
	 *
	 *	@param	inCode`FbNStateEventCode
	 *	@return	̃fŏł̂ł΁AtrueԂ
	 */
	protected boolean isAcceptableEvent(StateEventCode inEvent) {
		return (inEvent == UtilityFuncs.getSelectionEventCode());
	}
	
	/**
	 *	w肳ꂽTCỸ{[h쐬B
	 *	œ̏s
	 *
	 *	@param	inWidth	̌
	 *	@param	inHeight	č
	 */
	protected void createBoardSelf(final int inWidth, final int inHeight) {
	}
	
	/**
	 *	w肵ʒuԂɖ߂
	 */
	protected void resetAtSelf(final int inX, final int inY) {
	}

	/**
	 *	w肵Ֆʂ̈ʒȕԂɑJڂB
	 *	inCodelɏ]ēJڂԂƂȂĂB
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@param	inCode ԂJڂ邽߂̃CxgR[h
	 */
	protected void nextStateAtSelf(final int inX, final int inY, StateEventCode inCode) {
		// ړʒuAՊOł΂ʂ
		if (! contains(mActivePos.x + inX, mActivePos.y + inY)) return;

		// ANeBuȈʒuړ
		mActivePos = new Point(mActivePos);
		mActivePos.translate(inX, inY);
		mIsModified = true;
	}

	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1i߂
	 *	̎́AMousëړɌĂ΂邱Ƃz肵Ă
	 *	ȊȌ󋵂ŌĂ΂ꂽƂ͕̋słB
	 * 
	 *	@param	inX	XWiBoardWnj
	 *	@param	inY	YWiBoardWnj
	 */
	public void nextStateAt(final int inX, final int inY) {
		// ʂModel̃\bhĂł
		super.nextStateAt(inX, inY);
		
		// w肵ʒuՊOł΁ȀŔ
		if (! contains(inX, inY)) return;
		
		Point aPos = new Point(inX, inY);
		
		// ʒułΕύXȂ
		if (aPos.equals(mActivePos)) return;
		
		mActivePos = aPos;
		mIsModified = true; 
	}

	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1߂
	 *	inCodelɏ]ēJڂԂƂȂĂB
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@param	inCode ԂJڂ邽߂̃CxgR[h
	 */
	protected void prevStateAtSelf(final int inX, final int inY, StateEventCode inCode) {
	}

	/**
	 *	w肳ꂽʒu̖ʂ̏ԂԂB
	 *	̎ł́Aw肵ʒuANeBuȈʒułꍇA
	 *	ʂ̃fԂꂽԂAANeBuȏԂŃbvB
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@return 
	 */
	public State getCurStateAt(final int inX, final int inY) {
		State aState = super.getCurStateAt(inX, inY);
		
		if (inX == mActivePos.x && inY == mActivePos.y) {
//			aState = new SelectionState(aState);
			aState = StateManager.getInstance().getNextState(
					aState, UtilityFuncs.getSelectionEventCode()
			);
		}
		
		return aState;
	}
	
	/** 
	 *	@return ŌɏCʂ̈ʒuԂ
	 */
	protected java.awt.Point[] lastModifiedSelf() {
		java.util.Set aSet = new java.util.HashSet();
		
		if (EMPTY_POS != mActivePos) aSet.add(mActivePos);
		if (EMPTY_POS != mReleasePos) aSet.add(mReleasePos);
		
		return (java.awt.Point[])aSet.toArray(new java.awt.Point[aSet.size()]);
	}
	
	/**
	 *	ModelύXꂽǂ𒲂ׂB
	 *
	 *	@return	ύXĂtrueԂB
	 */
	protected boolean isModifiedSelf() {
		return mIsModified;
	}

	/**
	 *	Model̕ύXNA
	 */
	protected void flushSelf() {
		mReleasePos = mActivePos;
		mIsModified = false;
	}
}