// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
//	NAME:		BoardModelTest.java
//	DATE:		2003.5.25
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.creator.model;

import junit.framework.TestSuite;

import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;

import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.SpaceState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NumberState;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;

/**
 *	BoardModelɑ΂Unt Test
 */
public class BoardModelTest extends junit.framework.TestCase {
	public static junit.framework.Test suite() {
		TestSuite aSuite = new TestSuite("test name : BoardModelTest");
		
		aSuite.addTest(new TestSuite(BoardModelTest.class));
		
		return aSuite;
	}
	
	private BoardModel mModel;
	
	protected void setUp() throws Exception {
		super.setUp();
		
		// StateManagerB
		StateManager.initialize(new HashiCreStateManagerImpl());
		
		// Board쐬
		mModel = new CreatorBoardModel();
		mModel.createBoard(7, 7);
	}
	
	/**
	 *	{[hꂽǂ`FbN
	 */
	public void testCreateBoard() {
		// BoardԂɖ߂
		mModel.reset();
		mModel.flush();
	
		// ꂽmF
		assertEquals(7, mModel.getWidth());
		assertEquals(7, mModel.getHeight());
		
		// (0, 0)݂͑͂
		assertEquals(true, mModel.contains(0, 0));
	}
	
	/**
	 *	󔒂琔ւ̑Jڂ̃`FbN
	 */
	public void testSpaceToNumber() {
		// BoardԂɖ߂
		mModel.reset();
		mModel.flush();
	
		// ߂͋󔒂̂͂
		assertEquals(true, mModel.isSpaceAt(0, 0));
		
		// (0, 0)'1'ɐݒ肷
		mModel.nextStateAt(0, 0, HashikakeStateEventCode.valueOf("1"));
		NumberState aState = (NumberState)mModel.getCurStateAt(0, 0);
		assertEquals(1, aState.getValue());
		assertEquals(true, mModel.isNumberAt(0, 0));
		
		// Model͕ύXĂ͂
		assertEquals(true, mModel.isModified());
	}
	
	/**
	 *	אڂăZbgB
	 *	́A˂邱ƂłȂ̂ŁAdl㋖Ȃ
	 */
	public void testNeiborNumber() {
		// BoardԂɖ߂
		mModel.reset();
		mModel.flush();
		
		// ߂͋󔒂̂͂
		assertEquals(true, mModel.isSpaceAt(0, 0));

		// (0, 0)'1'ɐݒ肷
		mModel.nextStateAt(0, 0, HashikakeStateEventCode.valueOf("1"));
		
		// (0, 1)'1'ɐݒ肷
		// אڃZɐݒ肳Ă邽߁A󔒂̂܂܂̂͂
		mModel.nextStateAt(0, 1, HashikakeStateEventCode.valueOf("1"));
		assertEquals(true, mModel.isSpaceAt(0, 1));
		
		// mFĂ݂AJڂłȂƂ
		assertEquals(false, mModel.isTransitAt(0, 1, HashikakeStateEventCode.valueOf("1")));
		
		// ׂ̗(0, 2)͑Jڂł͂
		assertEquals(true, mModel.isTransitAt(0, 2, HashikakeStateEventCode.valueOf("1")));
		 
	}
	
	/**
	 *	琔ւ̑Jڂ̃`FbN
	 */
	public void testNumberToNumber() {
		// BoardԂɖ߂
		mModel.reset();
		mModel.flush();
		
		// ߂͋󔒂̂͂
		assertEquals(true, mModel.isSpaceAt(0, 0));

		// (0, 0)'1'ɐݒ肷
		mModel.nextStateAt(0, 0, HashikakeStateEventCode.valueOf("1"));
		assertEquals(true, mModel.isNumberAt(0, 0));
		
		// ŁA(0, 0)'4'ɐݒ肷
		mModel.nextStateAt(0, 0, HashikakeStateEventCode.valueOf("4"));
		NumberState aState = (NumberState)mModel.getCurStateAt(0, 0);
		assertEquals(4, aState.getValue());
		assertEquals(true, mModel.isNumberAt(0, 0));
	}

}


