//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		ProgressDialogColleague.java
//	DATE:		2003.9.30
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.bench.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import java.awt.Component;

import javax.swing.JDialog;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.hashikake.bench.BenchmarkMediator;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.Colleague;

public class ProgressDialogColleague extends AbstractFrameColleague {
	static final String[] DETAIL_BUTON_LABEL = new String[] {
		"show", "hide", 
	};
	
	static final String CANCEL_BUTON_LABEL = "Cancel";
	
	private BenchmarkMediator mMediator;
	private ProgressDialog mProgress;
	private JDialog mDialog;
	
	private final Colleague mDetailButtonColleague = new DetailButtonColleague(this);
	private final Colleague mCancelButtonColleague = new CancelButtonColleague();
	
	private int mOffsetCount;
	
	public ProgressDialogColleague(BenchmarkMediator inMediator, Component inOwner, final int inProblemNum) {
		mProgress = new ProgressDialog(inOwner, "file : ", 0, inProblemNum);
		mMediator = inMediator;
		mDialog = mProgress.createDialog(inOwner, "Now measuring");
		
		mDialog.addWindowListener(getDefaultWindowListener());
		
		mProgress.addPropertyChangeListener(new PropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent inEvent) {
				if (mDialog.isVisible() && inEvent.getSource() instanceof ProgressDialog
					&& inEvent.getPropertyName().equals(javax.swing.JOptionPane.VALUE_PROPERTY) 
					&& inEvent.getNewValue() != null)
				{
					Colleague aColleague = getColleagueForOption(inEvent.getNewValue());
					mMediator.colleagueChanged(aColleague);
				}
			}
		});
	}
	
	protected void colleagueCloseOperation() {
		mMediator.colleagueChanged(mCancelButtonColleague);
	}
	
	public Colleague getDetailButtonColleague() {
		return mDetailButtonColleague;
	}
	
	public Colleague getCancelButtonColleague() {
		return mCancelButtonColleague;
	}
	
	public void setUp() {
		final int aCount = mMediator.getProblemCount();
		if (0 < aCount) {
			if (1 < aCount) {
				mProgress.addMaxValue(aCount-1);
			}
			
			mOffsetCount = mProgress.getCurrentValue();
			
			ProblemInfo aProblem = mMediator.getProblemAt(0);
			String aMessage = "file : " + aProblem.getProblemName();
			mProgress.setMessage(aMessage);
		}
		
		mDialog.setVisible(true);
	}
	
	public void update() {
		mProgress.increse();
		
		String aMessage = "file : ";
		
		final int aNextIndex = mProgress.getCurrentValue() - mOffsetCount + 1;
		if (aNextIndex < mMediator.getProblemCount()) {
			ProblemInfo aProblem = mMediator.getProblemAt(aNextIndex);
			aMessage += aProblem.getProblemName();
		}

		mProgress.setMessage(aMessage);
	}
	
	public void cleanUp() {
		mDialog.setVisible(false);
		mDialog.dispose();
	}

	public void changeDetailButtonLabel() {
		mProgress.changeDetailButtonLabel();
	}

	public Colleague getColleagueForOption(Object inValue) {
		Object[] aLabel = mProgress.getOptions();
		
		if (DETAIL_BUTON_LABEL[0].equals(inValue) 
			|| DETAIL_BUTON_LABEL[1].equals(inValue))
		{
			return mDetailButtonColleague;
		}
		else if (CANCEL_BUTON_LABEL.equals(inValue)) {
			return mCancelButtonColleague;
		}
		
		return mCancelButtonColleague;
	}
}

class DetailButtonColleague implements Colleague {
	ProgressDialogColleague mOwner;
	
	public DetailButtonColleague(ProgressDialogColleague inOwnerColleague) {
		mOwner = inOwnerColleague;
	}
	
	public void setUp() {
	}
	
	public void update() {
		mOwner.changeDetailButtonLabel();
	}
	
	public void cleanUp() {
	}
}
	
class CancelButtonColleague implements Colleague {
	public void setUp() {
	}
	
	public void update() {
		
	}
	
	public void cleanUp() {
	}
}	
	
class ProgressDialog extends javax.swing.JOptionPane {
	
	private javax.swing.JProgressBar mProgress = new javax.swing.JProgressBar();
	private javax.swing.JLabel mMessageLabel;
	private Component mOwner;
	private String mCurDetailButtonLabel = ProgressDialogColleague.DETAIL_BUTON_LABEL[0];
	private String mOldDetailButtonLabel = ProgressDialogColleague.DETAIL_BUTON_LABEL[1];
	private String mCancelButtonLabel = ProgressDialogColleague.CANCEL_BUTON_LABEL;
	
	public ProgressDialog(Component inOwner, String inMessage, final int inMinVal, final int inMaxVal) 
	{
		super(
			null, javax.swing.JOptionPane.INFORMATION_MESSAGE, 
			javax.swing.JOptionPane.OK_CANCEL_OPTION, null, null			
		);
		
		mMessageLabel = new javax.swing.JLabel(inMessage);
		setMessage(new Object[]{mMessageLabel, mProgress});
		setOptions(new String[]{mCurDetailButtonLabel, mCancelButtonLabel});
		
		mOwner = inOwner;
		javax.swing.BoundedRangeModel aModel = mProgress.getModel();
		aModel.setRangeProperties(aModel.getValue(), aModel.getExtent(), inMinVal, inMaxVal, aModel.getValueIsAdjusting());
	}
	
	public JDialog createDialog(Component inOwner, String inTitle) {
		java.awt.Frame aFrame = getFrameForComponent(inOwner);
		final JDialog aDialog = new JDialog(aFrame, inTitle, false);

		java.awt.Container aContent = aDialog.getContentPane();

		aContent.setLayout(new java.awt.BorderLayout());
		aContent.add(this, java.awt.BorderLayout.CENTER);
		aDialog.pack();
		aDialog.setLocationRelativeTo(inOwner);
		
		return aDialog;
    }
	
	public int getCurrentValue() {
		return mProgress.getValue();
	}
	
	public void increse() {
		mProgress.setValue(mProgress.getValue()+1);
	}
	
	public void addMaxValue(final int inCount) {
		javax.swing.BoundedRangeModel aModel = mProgress.getModel();
		
		int aMaxVal = aModel.getMaximum()+inCount;
		final int aPercent = (int)(mProgress.getPercentComplete() * 100);
		final int aCurVal = aModel.getValue();
		int aOffset = (int)Math.ceil((aMaxVal * aPercent - aCurVal * 100)/(double)(100 - aPercent));
		
		aModel.setRangeProperties(
			aCurVal+aOffset, aModel.getExtent(), aModel.getMinimum(), aMaxVal+aOffset, aModel.getValueIsAdjusting()
		);
	}
	
	public void setMessage(String inMessage) {
		mMessageLabel.setText(inMessage);
	}
	
	public void changeDetailButtonLabel() {
		String aOldLabel = mCurDetailButtonLabel;
		mCurDetailButtonLabel = mOldDetailButtonLabel;
		mOldDetailButtonLabel = aOldLabel;
		
		Object[] aLabels = getOptions();
		aLabels[0] = mCurDetailButtonLabel;
		setOptions(aLabels);
		
		value = mOldDetailButtonLabel;
	}
	

}
