//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		DirectoryChooser.java
//	DATE:		2003.10.1
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.bench.view; 

import javax.swing.filechooser.FileSystemView;
import java.io.File;

import java.awt.BorderLayout;

import javax.swing.JDialog;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.JOptionPane;

import javax.swing.event.EventListenerList;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeModelEvent;

import jp.gr.java_conf.ktz.puzzle.hashikake.bench.model.FileNode;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.model.FileViewTreeModel;

/**
 *	tH_I邽߂̃R|[lg
 */
public class DirectoryChooser {
	private static final java.io.FileFilter DEFAULT_FILTER = new java.io.FileFilter() {
		public boolean accept(File inFile) {
			return inFile.isDirectory();
		}
	};
	
	private static class Holder {
		static final DirectoryChooser CHOOSER = new DirectoryChooser();
	}
	
	private javax.swing.JLabel mDescription;
	private JTree mTree;
	private JComponent mScroller;
	
	private static DirectoryChooser getInstance() {
		return Holder.CHOOSER;
	}
	
	private DirectoryChooser() {
		javax.swing.border.Border aBorder = new javax.swing.border.EmptyBorder(12, 0, 12, 0);
		
		{
			mDescription = new javax.swing.JLabel("select the folder performing solver program.");
			mDescription.setBorder(aBorder);
		}
		{
			File[] aRoots = FileSystemView.getFileSystemView().getRoots();
			FileNode aRootNode = new FileNode(aRoots[0], DEFAULT_FILTER);
			mTree = new JTree();
			TreeModel aModel = new FileViewTreeModel(aRootNode);
			mTree.setModel(aModel);
			
			mScroller = new javax.swing.JScrollPane(mTree);
			mScroller.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
		}
	}
	
	public static File chooseDirectory(java.awt.Component inOwner, File inDirectory) {
		return getInstance().chooseDirectorySub(inOwner, inDirectory);
	}
	
	public File chooseDirectorySub(java.awt.Component inOwner, File inDirectory) {
		if (inDirectory.isDirectory()) {
			expandAndSelect(mTree, inDirectory);
		}
		else {
			mTree.setSelectionRow(0);
		}

		final int aSIgnal = JOptionPane.showConfirmDialog(
			inOwner, new Object[] {mDescription, mScroller}, 
			"Reference the folder", JOptionPane.OK_CANCEL_OPTION, JOptionPane.PLAIN_MESSAGE
		);
		
		File aRetPath = inDirectory;
		
		if (aSIgnal == JOptionPane.YES_OPTION) {
			FileNode aNode = (FileNode)mTree.getSelectionPath().getLastPathComponent();
			aRetPath = new File(aNode.getAbsolutePath());
		}

		return aRetPath;
	}
	
	public static void main(String[] inArgs) {
		File file = new File("class").getAbsoluteFile();
		
		javax.swing.JFrame f = new javax.swing.JFrame();
		chooseDirectory(f, file);
		
		System.exit(0);
	}

	private void expand(final JTree inTree, TreePath inPath) {
	
		TreePath aParent = inPath.getParentPath();
		if (null != aParent) {
			if (! inTree.isExpanded(aParent)) {
				expand(inTree, aParent);
			}
		}
		
		inTree.expandPath(inPath);
	}
	
	private TreePath toTreePath(java.io.File inFile) {
		return new TreePath(toTreePathSub(inFile, 1));
	}
	
	private FileNode[] toTreePathSub(java.io.File inFile, final int inDepth) {
		java.io.File aParent = FileSystemView.getFileSystemView().getParentDirectory(inFile);
		FileNode[] aRet = null;
		
		if (null == aParent) {
			aRet = new FileNode[inDepth];
		}
		else {
			aRet = toTreePathSub(aParent, inDepth+1);
		}
		
		aRet[aRet.length-inDepth] = new FileNode(inFile, DEFAULT_FILTER);
		
		return aRet;
	}
	
	private void expandAndSelect(final JTree inTree, final java.io.File inFile) {
		TreePath aPath = toTreePath(inFile);
		
		expand(inTree, aPath);
		inTree.setSelectionPath(aPath);
	}
}

