//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		HashikakeBenchResultSorter.java
//	DATE:		2003.10.2
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.bench.model;

import javax.swing.table.TableModel;

import jp.gr.java_conf.ktz.puzzle.hashikake.bench.TableSortHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.SortStrategy;

public class HashikakeBenchResultSorter implements TableSortHandler {
	private TableModel mModel;
	
	private int[] mSortedIndex = new int[0];
	private SortStrategy mStrategy = new DefaultSortStrategy();
	
	private boolean mDescentOrdered = true;
	private int mCurColIndex = Integer.MIN_VALUE;
	
	public HashikakeBenchResultSorter() {}
	
	public void sort() {
		if (mCurColIndex == Integer.MIN_VALUE) {
			// \[g̏ꍇ
			sort(0, false);
		}
		else {
			if (mSortedIndex.length != mModel.getRowCount()) {
				sort(mCurColIndex, mDescentOrdered);
			}
		}
	}
	
	public void sort(final int inColumnIndex) {
		if (mCurColIndex == inColumnIndex) {
			mDescentOrdered = ! mDescentOrdered;
		}
		else {
			sort(inColumnIndex, true);
		}
	}
	
	private void sort(final int inColumnIndex, final boolean inDescentOrdered) {
		if (mModel != null) {
			initIndexedArray();
			
			mDescentOrdered = true;
			mStrategy.sort(inColumnIndex, mModel, mSortedIndex);
			
			mDescentOrdered = inDescentOrdered;
			mCurColIndex = inColumnIndex;
		}
	}
	
	public void setSortStrategy(SortStrategy inStrategy) {
		mStrategy = inStrategy;
	}
	
	public void setModel(TableModel inModel) {
		mModel = inModel;
	}
	
	public int resolveRowIndex(final int inIndex) {
		initIndexedArray();
		
		if (mDescentOrdered) {
			return mSortedIndex[inIndex];
		}
		
		return mSortedIndex[mSortedIndex.length - inIndex - 1];
	}
	
	private void initIndexedArray() {
		final int aSize = mModel.getRowCount();
		if (mSortedIndex.length != aSize) {
			mSortedIndex = new int[aSize];
			
			CollectionUtility.iota(mSortedIndex);
		}		
	}
}

/**
 *	}\[gs
 */
class DefaultSortStrategy implements SortStrategy {
	public void sort(final int inColumnIndex, TableModel inModel, int[] outArray) {
		if (null == outArray || null == inModel) return;
		
		if (inColumnIndex < 0 || inColumnIndex >= inModel.getRowCount()) {
			return;
		}
		
		final int aStopIndex
			 = outArray.length > inModel.getRowCount() ? inModel.getRowCount() : outArray.length;
		
		int[] aCopy = new int[outArray.length];
		System.arraycopy(outArray, 0, aCopy, 0, outArray.length);
		
		Object[] aNullArray = new Object[outArray.length];
		Object[] aTemp = new Object[outArray.length];
		
		for (int i = aStopIndex -2; i >= 0; --i) {
			Object aLeftObj = aTemp[i];
			if (null == aLeftObj) {
				aLeftObj = inModel.getValueAt(i, inColumnIndex);
				aTemp[i] = aLeftObj;
			}
			int aLeftValue = aCopy[i];
			
			Comparable aLHS = (aLeftObj instanceof Comparable ? 
						(Comparable)aLeftObj : aLeftObj.toString());

			int j = i +1;
			for (; j < aStopIndex; ++j) {
				Object aRightObj = aTemp[j];
				if (null == aRightObj) {
					aRightObj = inModel.getValueAt(j, inColumnIndex);
					aTemp[j] = aRightObj;
				}
				
				Comparable aRHS = (aRightObj instanceof Comparable ? 
						(Comparable)aRightObj : aRightObj.toString());
				
				final int aComp = aLHS.compareTo(aRHS);
				if (aComp >= 0) break;
				else {
					aCopy[j-1] = aCopy[j];
					aTemp[j-1] = aRightObj;
				}
			}
			
			aCopy[j-1] = aLeftValue;
			aTemp[j-1] = aLeftObj;
		}
		
		System.arraycopy(aNullArray, 0, aTemp, 0, aTemp.length);
		System.arraycopy(aCopy, 0, outArray, 0, aCopy.length);
	}
}