// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		SolutionCheckModel.java
//	DATE:		2003.5.9
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import java.awt.Point;

import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;

import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.model.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.model.ModelConstants;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

/**
 *	̉𓚂`FbN邽߂Model
 */
public class SolutionCheckModel extends AbstractDecoratedModel {
	/** size = 0̔z */
	private static final Point[] NO_MODIFIED = ModelConstants.EMPTIES;
	
	/** ̏W */
	private static final Direction[] DIRECTIONS = {
		Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, 
	};

	/** ̘A`FbN邽߂̔z */
	private int[] mCheckArray;
	
	/** mCheckArrayĂ邩ǂ𒲂ׂ邽߂̃tO */
	private boolean mArrayCreated = false;
	
	/**
	 *	RXgN^
	 *	w肵ModelbvModelƂďLB
	 *
	 *	@param	inModel	bvModel
	 */
	public SolutionCheckModel(Model inModel) {
		super(inModel);
	}
	
	/**
	 *	݂̏Ԃǂ`FbN
	 *
	 *	@return ȂtrueԂ
	 */
	public boolean check() {
		StateManager aManager = StateManager.getInstance();
		
		// ̏W
		if (! mArrayCreated) {
			mCheckArray = initCheckArray();
		}
		
		return new CheckWorker().start(mCheckArray);
	}
	
	/**
	 *	ݎw肳Ă̓̏ɏs
	 *	̃\bh́A肪ύXĂAŏcheck\bh
	 *	Ă΂ꂽƂɌĂ΂
	 *
	 *	@return	𓚂`FbN邽߂̔zԂ
	 *
	 *	@throws	IllegalStateException ̃Z̏ԂNumberStatełȂƂ
	 */
	private int[] initCheckArray() {
		StateManager aManager = StateManager.getInstance();
		int[] aArray = new int[getWidth() * getHeight()];
		
		for (int y = 0, i = 0; y < getHeight(); ++y) {
			for (int x = 0;x < getWidth(); ++x, ++i) {
				if (isNumberAt(x, y)) {
					try {
						final int aNum = Integer.parseInt(
							aManager.findIdentityOf(getCurStateAt(x, y))
						);
						
						aArray[i] = aNum;
					}
					catch (NumberFormatException e) {
						throw new IllegalStateException(
							"The simbol of Number State cannot be parsed as integer."
						);
					}
				}
			}
		}
		
		mArrayCreated = true;	
		
		return aArray;
	}

	/**
	 *	w肳ꂽTCỸ{[h쐬B
	 *	œ̏s
	 *
	 *	@param	inWidth		̌
	 *	@param	inHeight	č
	 */
	protected void createBoardSelf(final int inWidth, final int inHeight) {
		mArrayCreated = false;
		mCheckArray = null;
	}
	
	/**
	 *	w肵ʒuԂɖ߂
	 */
	protected void resetAtSelf(final int inX, final int inY) {
	}

	/**
	 *	ύXꂽՖʂ̈ʒuԂB
	 *	̎ł́Adh悤ɂĂB
	 *
	 *	@return	ύXꂽՖʂ̈ʒȕWB
	 */
	protected Point[] lastModifiedSelf() {
		return NO_MODIFIED;
	}

	/**
	 *	ModelύXꂽǂ𒲂ׂB
	 *
	 *	@return	ύXĂtrueԂB
	 */
	protected boolean isModifiedSelf() {
		return false;
	}
	
	/**
	 *	w肳ꂽStateEventCodẽfŏł邩ǂ`FbNB
	 *
	 *	@param	inCode`FbNStateEventCode
	 *	@return	̃fŏł̂ł΁AtrueԂ
	 */
	public boolean isAcceptableEvent(StateEventCode inCode) {
		return true;
	}

	/**
	 *	w肵Ֆʂ̈ʒȕԂɑJڂB
	 *	inCodelɏ]ēJڂԂƂȂĂB
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@param	inCode ԂJڂ邽߂̃CxgR[h
	 */
	protected void nextStateAtSelf(final int inX, final int inY, StateEventCode inCode) {
	}

	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1߂
	 *	inCodelɏ]ēJڂԂƂȂĂB
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@param	inCode ԂJڂ邽߂̃CxgR[h
	 */
	protected void prevStateAtSelf(final int inX, final int inY, StateEventCode inCode) {
	}

	/**
	 *	Model̕ύXNA
	 */
	protected void flushSelf() {
	}
	
	/**
	 *	ۂɃ`FbNƂsIuWFNg
	 */
	private class CheckWorker {
		/** `FbN҂̓̈ʒũL[ */
		private java.util.List mQueue;
		
		/** d`FbN邽߂̔z */
		private boolean[] mDoubleCkecked;
		
		/** c̋̐Ǘ邽߂̔z */
		private int[] mCheckArray;
		
		/** 
		 *	`FbNƂJn
		 *	̃\bh́AĂяoтɏs߁A
		 *	GggłB
		 *
		 *	@param inCheckArray	eZ̓̐L^zB
		 *
		 *	@throws	IllegalArgumentException	inCheckArraynull̂ƂA
		 *		܂́AinCheckArraỹTCY0̂Ƃ
		 */
		public boolean start(int[] inCheckArray) {
			if (null == inCheckArray || inCheckArray.length == 0) {
				throw new IllegalArgumentException("check array isnot correctly initialized.");
			}

			initialize(inCheckArray);
			
			try {
				while (! mQueue.isEmpty()) {
					final int aIndex = ((Integer)mQueue.remove(0)).intValue();
					
					if (0 < mCheckArray[aIndex]) {
						checkSolution(aIndex);
					}
					
					if (0 > mCheckArray[aIndex]) {
						// }CiXłꍇA
						// ˂Ă鎖Ă邽߁AfalseԂ
						return false;
					}
				}

				// ׂĂ̓ɓK؂ɋ˂ǂׂ
				// ׂĂ̗vf0łꍇOKƂ݂Ȃ
				for ( int i = 0; i < mCheckArray.length; ++i) {
					if (0 != mCheckArray[i]) return false;
				}
			}
			finally {
				mCheckArray = null;
				mDoubleCkecked = null;
				mQueue = null;
			}
			
			return true;
		}
		
		/**
		 *	w肵ʒũZ牄т鋴`FbN
		 *
		 *	@param	inIndex	ʒuɑΉCfbNX
		 */
		private void checkSolution(final int inIndex) {
			final int aX = inIndex % getWidth();
			final int aY = inIndex / getWidth();
			
			Point aPos = new Point(aX, aY);
			
			for (int i = 0; i < DIRECTIONS.length; ++i) {
				// אڂZɋ˂ĂꍇAΉ铇T
				Point aDiff = DIRECTIONS[i].getDifference();
				aPos.translate(aDiff.x, aDiff.y);
				
				// ՊO܂͋󔒂łΎ̕T
				if (contains(aPos.x, aPos.y) && ! isSpaceAt(aPos.x, aPos.y)) {
					StateEventCode aCode = UtilityFuncs.getDetermineDirectionEventCode(DIRECTIONS[i]);
					if (isTransitAt(aPos.x, aPos.y, aCode)) {
						final int aCount = 
							HashikakeStateManagerImpl.countBridge(getCurStateAt(aPos.x, aPos.y));
						
						if (0 == aCount) {
							throw new IllegalStateException(
								"Both islands donot neighbor each other.\n"
								+ "\tOne side : " + new Point(aX, aY) + "\n"
								+ "\tOpposite side : " + aPos
							);
						}
						
						// Ί݂T
						final int aOpposite = findIndexOfOppositeSide(aPos, aDiff);
										
						// Ƀ`FbNꂽǂmFŁA݂̖̋{炷
						if (! mDoubleCkecked[aOpposite]) {
							mCheckArray[aOpposite] -= aCount;
							mCheckArray[inIndex] -= aCount;
							
							// `FbNς݂̃}[N
							mDoubleCkecked[inIndex] = true;
							
							// Ί݂L[ɓ
							mQueue.add(new Integer(aOpposite));
						}
					}
				}
				
				aPos.translate(-aDiff.x, -aDiff.y);
			}
		}
		
		/**
		 *	Ί݂̓̈ʒuɑΉCfbNXvZ
		 *
		 *	@param	inPos	瑤ɓ̈ʒu
		 *	@param	inDiff	iޕ̍
		 *	@return	Ί݂̓̈ʒuɑΉCfbNXԂ
		 *
		 *	@throws	IllegalStateException	i߂ɑΊ݂Ȃꍇ
		 */
		private int findIndexOfOppositeSide(Point inPos, Point inDiff) {
			Point aPos = new Point(inPos);
			aPos.translate(inDiff.x, inDiff.y);
			
			do {
				if (isNumberAt(aPos.x, aPos.y)) {
					return toIndex(aPos.x, aPos.y);
				}
				
				aPos.translate(inDiff.x, inDiff.y);
			}
			while (contains(aPos.x, aPos.y));
			
			throw new IllegalStateException("The opposite side is no existance."); 
		}
		
		/**
		 *	w肵ʒuCfbNXɕϊ
		 *
		 *	@param	inX	XWiBoardWnj
		 *	@param	inY	YWiBoardWnj
		 *	@return	CfbNXԂ
		 */
		private int toIndex(final int inX, final int inY) {
			return inY * getWidth()  + inX;
		}
		
		/**
		 *	Ɨ̈
		 *
		 *	@param	inCheckArray	̐Ǘz
		 */
		private void initialize(int[] inCheckArray) {
			mDoubleCkecked = new boolean[inCheckArray.length];
			
			mCheckArray = new int[inCheckArray.length];
			System.arraycopy(inCheckArray, 0, mCheckArray, 0, inCheckArray.length);
			
			mQueue = new java.util.LinkedList();
			
			// TJnn_T
			for (int i = 0; i < mCheckArray.length; ++i) {
				if (0 < mCheckArray[i]) {
					mQueue.add(new Integer(i));
					break;
				}			
			}	
		}
	}
}