// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		HashikakeStateManagerImpl.java
//	DATE:		2003.5.12
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import jp.gr.java_conf.ktz.puzzle.framework.StateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.framework.DecoratedStateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;

import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.*;

/**
 *	ԑJڃ}l[W̎
 */
public class HashikakeStateManagerImpl extends DecoratedStateManagerImpl {
	// ԑJڕ\ɓo^邽߂̃R[h
	private static class TransitRecord {
		final State mPrev;
		final State mNext;
		final StateEventCode[] mEvent;
		
		TransitRecord(final State inPrev, final State inNext, StateEventCode[] inEvent) 
		{
			mPrev = inPrev;
			mNext = inNext;
			mEvent = inEvent;
		}
	};	
	
	public final static String SPACE_ID = HashikakeStateEventCode.SPACE_ID;
	public final static String NS_BRIDGE_ID = HashikakeStateEventCode.NS_BRIDGE_ID;
	public final static String BIG_NS_BRIDGE_ID = HashikakeStateEventCode.BIG_NS_BRIDGE_ID;
	public final static String WE_BRIDGE_ID = HashikakeStateEventCode.WE_BRIDGE_ID;
	public final static String BIG_WE_BRIDGE_ID = HashikakeStateEventCode.BIG_WE_BRIDGE_ID;
	public final static String NULL_ID = HashikakeStateEventCode.NULL_ID;
	
	/** 
	 *	IDƏԂgƂe[u
	 *	IDԂ擾ƂɎQƂ
	 */
	private java.util.Map mStateMap = new java.util.HashMap(); // Map<String, State>
	
	/** 
	 *	IDƏԂgƂe[u
	 *	ԂID擾ƂɎQƂ
	 */
	private java.util.Map mStateToIDMap = new java.util.HashMap(); // Map<State, StateRecord>
	
	/** ԑJڃe[u */	
	private java.util.Map mTransitMap = new java.util.HashMap(); // Map<State, TransitRecord>
	
	/**
	 *	RXgN^
	 *	ԑJڕ\쐬Ă
	 */
	public HashikakeStateManagerImpl() {
		this(null);
	}
	
	/**
	 *	RXgN^
	 *	ԑJڕ\쐬Ă
	 */
	public HashikakeStateManagerImpl(StateManagerImpl inManager) {
		super(inManager);
		
		State aSpace = SpaceState.getInstance();
		State aNSBridge = new NSBridgeState();
		State aBigNSBridge = new BigNSBridgeState();
		State aWEBridge = new WEBridgeState();
		State aBigWEBridge = new BigWEBridgeState();
		
		// ̑J
		final StateEventCode aWest = UtilityFuncs.getDetermineDirectionEventCode(Direction.WEST);
		// ̑J
		final StateEventCode aEast = UtilityFuncs.getDetermineDirectionEventCode(Direction.EAST);
		// k̑J
		final StateEventCode aNorth = UtilityFuncs.getDetermineDirectionEventCode(Direction.NORTH);
		// ̑J
		final StateEventCode aSouth = UtilityFuncs.getDetermineDirectionEventCode(Direction.SOUTH);
		
		// Ԃ̓o^
		installStateMap(SPACE_ID, aSpace);
		installStateMap(NS_BRIDGE_ID, aNSBridge);
		installStateMap(BIG_NS_BRIDGE_ID, aBigNSBridge);
		installStateMap(WE_BRIDGE_ID, aWEBridge);
		installStateMap(BIG_WE_BRIDGE_ID, aBigWEBridge);

		// ԑJڂ̓o^
		installTransitMap(aNSBridge, aSpace, aBigNSBridge, new StateEventCode[]{aNorth, aSouth});
		installTransitMap(aBigNSBridge, aNSBridge, aSpace, new StateEventCode[]{aNorth, aSouth});
		installTransitMap(aWEBridge, aSpace, aBigWEBridge, new StateEventCode[]{aWest, aEast});
		installTransitMap(aBigWEBridge, aWEBridge, aSpace, new StateEventCode[]{aWest, aEast});
		installTransitMap(aSpace, aSpace, 
			new BranchState.TransitHint[]{
				new BranchState.TransitHint(aNSBridge, new StateEventCode[]{aNorth, aSouth}), 
				new BranchState.TransitHint(aWEBridge, new StateEventCode[]{aWest, aEast}), 
			}, 
			new StateEventCode[] {aNorth, aSouth, aWest, aEast}
		);
	}
	
	/**
	 *	ԑJڂ̃Gg[o^
	 *
	 *	@param	inCur	݂̏
	 *	@param	inPrev	1Ȍ
	 *	@param	inNext	̏
	 *	@param	inEvent	JڂɊւCxgR[h
	 */
	private void installTransitMap(State inCur, State inPrev, State inNext, StateEventCode[] inEvent) 
	{
		mTransitMap.put(inCur, new TransitRecord(inPrev, inNext, inEvent));
	}
	
	/**
	 *	ԑJڂ̃Gg[o^
	 *
	 *	@param	inCur	݂̏
	 *	@param	inPrev	1Ȍ
	 *	@param	inNext	̏
	 *	@param	inEvent	JڂɊւCxgR[h
	 */
	private void installTransitMap(
						State inCur, State inPrev, BranchState.TransitHint[] inNext, 
						StateEventCode[] inEvent) 
	{
		installTransitMap(inCur, inPrev, new BranchState(inNext), inEvent);
	}
	
	/**
	 *	IDԂɕϊGg[o^
	 *
	 *	@param	inID	ԂɑΉID
	 *	@param	inState	ϊ
	 */
	private void installStateMap(String inID, State inState) {
		// Ԃ̓o^
		mStateMap.put(inID, inState);
		
		// Ԃ̋tϊe[uւ̓o^
		mStateToIDMap.put(inState, inID);
	}
	
	/**
	 *	inStateIDlɑԂ쐬B
	 *
	 *	@param inStateID ԂɑΉID
	 *	@return inStateIDlɑԁB
	 *
	 *	@throws IllegalArgumentException	w肳ꂽԂo^ĂȂꍇ
	 */
	protected State createStateOfSelf(String inStateID) {
		String aID = inStateID.trim().toLowerCase();
		
		if (mStateMap.containsKey(aID)) {
			return (State)mStateMap.get(aID);
		}
		
		// ID̂łꍇ
		// HashikakeNumberStateԂB
		try {
			final int aNum = Integer.parseInt(aID);
			State aState = new NumberState(aNum);
			installStateMap(aID, aState);
					
			return aState;
		} 
		catch (NumberFormatException e) {
		}
		
		// łȂꍇ͗O𔭍sB
		throw new IllegalArgumentException("Illegal State ID : " + inStateID);
	}
	
	/**
	 *	ftHg̏Ԃ쐬B
	 *	
	 * @return ftHg
	 */
	protected State createDefaultStateSelf() {
		return createStateOf(SPACE_ID);
	}
	
	/**
	 *	w肳ꂽԂIDl̕ϊ
	 *
	 *	@param	ϊΏۂƂȂ
	 *	@return	ϊꂽIDl
	 *
	 *	@throws	IllegalArgumentException	w肳ꂽԂo^ĂȂꍇ
	 */
	protected String findIdentityOfSelf(State inState) {
		if (isNumberState(inState)) {
			return findIdentityOf(((HashikakeNumberState)inState).getNumberState());
		}
		
		if (! mStateToIDMap.containsKey(inState)) {
			throw new IllegalArgumentException(
				"The ID corresponding to the state is no existance."
			);
		}
		
		return (String)mStateToIDMap.get(inState);
	}

	/**
	 *	Ԃ1i߂B
	 *	̎ł́AO𑗏ô
	 *
	 *	@param inState ݂̏
	 *	@return ̏
	 *
	 *	@throws	UnsupportedOperationException	̃\bhĂяoƂ
	 */
	protected State getNextStateSelf(State inState) {
		throw new UnsupportedOperationException("The method getNextState(State) is not supported");
	}
	
	/**
	 *	inEventlɏ]āAԂ1i߂B
	 *
	 *	@param inState ݂̏
	 *	@param Jڂ̊ւCxglB
	 *	@return ̏
	 *
	 *	@throws	IllegalArgumentException	w肳ꂽԂo^ĂȂꍇ
	 */
	protected State getNextStateSelf(State inState, StateEventCode inEvent) {
		if (isNumberState(inState)) {
			return getNextNumberState(inState, inEvent);
		}
		
		if (! mTransitMap.containsKey(inState)) {
			throw new IllegalArgumentException("The next State is no existence."); 
		}
		
		TransitRecord aRec = (TransitRecord)mTransitMap.get(inState);
		
		return aRec.mNext.onEnter(inEvent);
	}
	
	private State getNextNumberState(State inState, StateEventCode inEvent) {
		HashikakeNumberState aNumState = (HashikakeNumberState)inState;
		
		Direction aDirection = UtilityFuncs.resolveDirectionOf(inEvent);
		HashikakeNumberState.AdjacentState aAdjacent = aNumState.findAdjacentOf(aDirection);
		
		if (null != aAdjacent) {
			State aState = getNextState(aAdjacent.getState(), inEvent);
			aAdjacent.setState(aState);
		}
		
		return inState;
	}

	/**
	 *	Ԃ1߂B
	 *	̎ł́AO𑗏ô
	 *
	 *	@param inState ݂̏
	 *	@return ̏
	 *
	 *	@throws	UnsupportedOperationException	̃\bhĂяoƂ
	 */
	protected State getPrevStateSelf(State inState) {
		throw new UnsupportedOperationException("The method getPrevState(State) is not supported");
	}
	
	/**
	 *	inEventlɏ]āAԂ1߂B
	 *
	 *	@param inState ݂̏
	 *	@param Jڂ̊ւCxglB
	 *	@return ̏
	 *
	 *	@throws	IllegalArgumentException	w肳ꂽԂo^ĂȂꍇ
	 */
	protected State getPrevStateSelf(State inState, StateEventCode inEvent) {
		if (isNumberState(inState)) {
			return getPrevNumberState(inState, inEvent);
		}
		
		if (! mTransitMap.containsKey(inState)) {
			throw new IllegalArgumentException("The next State is no existence."); 
		}
		
		TransitRecord aRec = (TransitRecord)mTransitMap.get(inState);
		
		return aRec.mPrev.onEnter(inEvent);
	}
	
	private State getPrevNumberState(State inState, StateEventCode inEvent) {
		HashikakeNumberState aNumState = (HashikakeNumberState)inState;
		
		Direction aDirection = UtilityFuncs.resolveDirectionOf(inEvent);
		HashikakeNumberState.AdjacentState aAdjacent = aNumState.findAdjacentOf(aDirection);
		
		if (null != aAdjacent) {
			State aState = getPrevState(aAdjacent.getState(), inEvent);
			aAdjacent.setState(aState);
		}
		
		return inState;
	}

	/**
	 *	w肳ꂽԂł邩ǂ`FbNB
	 *
	 *	@param	inState `FbNState object
	 *	@return ԂłtrueԂB
	 */
	protected boolean isNumberStateSelf(State inState) {
		return (inState instanceof HashikakeNumberState);
	}
	
	/**
	 *	w肳ꂽԂ󔒂ł邩ǂ`FbNB
	 *
	 *	@param	inState `FbNState object
	 *	@return Ԃ󔒂łtrueԂB
	 */
	protected boolean isSpaceStateSelf(State inState) {
		return (inState instanceof SpaceState);
	}
	
	/**
	 *	w肳ꂽԂAinEventlɏ]đJڂł邩ǂ`FbNB
	 *
	 *	@param inState `FbNState object
	 *	@param inEvent CxglB
	 *	@return Jڂł̂ł΁AtrueԂB
	 */
	protected boolean isTransitSelf(State inState, StateEventCode inEvent) {
		if (isNumberState(inState)) return true;
		
		if (! mTransitMap.containsKey(inState)) return false;
		
		TransitRecord aRec = (TransitRecord)mTransitMap.get(inState);
		
		for (int i = 0; i < aRec.mEvent.length; ++i) {
			if (aRec.mEvent[i] == inEvent) return true;
		}
		
		return false;
	}
	
	/**
	 *	w肳ꂽԂAJڂł邩ǂ`FbNB
	 *
	 *	@param inState `FbNState object
	 *	@param inEvent CxglB
	 *	@return Jڂł̂ł΁AtrueԂB
	 */
	protected boolean isTransitSelf(State inState) {
		throw new UnsupportedOperationException("The method isTransit(State) is not supported");
	}
	
	/**
	 *	w肵StateEventCodeStateManagerŏł邩ǂ`FbN
	 *
	 *	@param	inEvent	Cxg̎
	 *	@return	łꍇAtrueԂ
	 *
	 *	@see #isTransit(State, StateEventCode)
	 *	@see #getNextState(State, StateEventCode)
	 *	@see #getPrevState(State, StateEventCode)
	 */
	 
	protected boolean acceptableEventCode(StateEventCode inEvent) {
		return (
			UtilityFuncs.isSelectionType(inEvent)
			|| UtilityFuncs.isDeterminationType(inEvent)
		);
	}
	
	/**
	 *	w肳ꂽԂłꍇA̖{𐔂
	 *	łȂꍇ́A0Ԃ
	 *
	 *	@return ̖{
	 */
	public static int countBridge(State inState) {
		if (NSBridgeState.class.equals(inState.getClass())
				 || WEBridgeState.class.equals(inState.getClass())) 
		{
			return 1;
		}
		if (BigNSBridgeState.class.equals(inState.getClass())
				 || BigWEBridgeState.class.equals(inState.getClass())) 
		{
			return 2;
		}
		
		return 0;
	}	
}