// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		BridgableCheckModel.java
//	DATE:		2003.5.9
//	MODIFIED	2003.8.13	mSelectedPosɗ݂̈ʒu悤ɕύX
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import java.awt.Point;

import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.model.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.model.ModelConstants;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;

import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.SelectionState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NumberActiveState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.HashikakeNumberState;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

/**
 *	Ֆʂ̑IԂǗModel
 */
public class BridgibleCheckModel extends AbstractDecoratedModel {
	/** ՊÔł߂Ȉʒu萔 */
	private static final Point EMPTY_POS = ModelConstants.ILLEGAL_POS;
	
	/** ύXȂ萔 */
	private static final Point[] NO_MODIFIED = ModelConstants.EMPTIES;
	
	/** Iꂽ̈ʒu */
	private Point mPressedPos = EMPTY_POS;
	
	/**	Ί݂̐̈ʒu */
	private Point mOppositePos = EMPTY_POS;
	
	/** IꂽʒȕW */
	private Point[] mSelectedPos = NO_MODIFIED;
	
	/** IɂꂽʒȕW */
	private Point[] mDeactivatedPos = NO_MODIFIED;
	
	/** Model̏CtO */
	private boolean mIsModified = false;
	
	/** Iꂽ */
	private Direction mDirection = Direction.NO;
	
	/**
	 *	RXgN^
	 *	w肵ModelbvModelƂďLB
	 *
	 *	@param	inModel	bvModel
	 */
	public BridgibleCheckModel(Model inModel) {
		super(inModel);
	}
	
	/**
	 *	w肳ꂽʒu̖ʂ̏ԂԂ 
	 *
	 *	@param inX	XW
	 *	@param	inY	YW
	 *	@return 
	 */
	public State getCurStateAt(final int inX, final int inY) {
		final Point aPos = new Point(inX, inY);
		
		State aState = super.getCurStateAt(inX, inY);
		
		if (aPos.equals(mPressedPos)) {
			return new NumberActiveState(aState, mDirection);
		}
		
		if (aPos.equals(mOppositePos)) {
			Direction aInverse = UtilityFuncs.inverseDirection(mDirection);
			return new NumberActiveState(aState, aInverse);
		}
		
		Point[] aModifiedPos = mSelectedPos;
		for (int i = 0; i < aModifiedPos.length; ++i) {
			if (aPos.equals(aModifiedPos[i])) {
				return new SelectionState(aState);
			}
		}
		
		return aState;
	}
		
	/**
	 *	w肳ꂽTCỸ{[h쐬B
	 *	œ̏s
	 *
	 *	@param	inWidth	̌
	 *	@param	inHeight	č
	 */
	protected void createBoardSelf(final int inWidth, final int inHeight) {
	}
	
	/**
	 *	w肵ʒuԂɖ߂
	 */
	protected void resetAtSelf(final int inX, final int inY) {
	}

	/**
	 *	ύXꂽՖʂ̈ʒuԂB
	 *	̎ł́Adh悤ɂĂB
	 *
	 *	@return	ύXꂽՖʂ̈ʒȕWB
	 */
	protected Point[] lastModifiedSelf() {
		java.util.Set aSet = new java.util.HashSet();
		
		if (mDeactivatedPos != NO_MODIFIED) {
			aSet.addAll(java.util.Arrays.asList(mDeactivatedPos));
		}
		
		if (mSelectedPos != NO_MODIFIED) {
			aSet.addAll(java.util.Arrays.asList(mSelectedPos));
		}
		
		return (Point[])aSet.toArray(new Point[aSet.size()]);
	}
	
	/**
	 *	ModelύXꂽǂ𒲂ׂB
	 *
	 *	@return	ύXĂtrueԂB
	 */
	protected boolean isModifiedSelf() {
		return mIsModified;
	}
	
	/**
	 *	w肳ꂽStateEventCodẽfŏł邩ǂ`FbNB
	 *
	 *	@param	inCode`FbNStateEventCode
	 *	@return	̃fŏł̂ł΁AtrueԂ
	 */
	protected boolean isAcceptableEvent(StateEventCode inCode) {
		return UtilityFuncs.isSelectionType(inCode)
			|| UtilityFuncs.isDeterminationType(inCode);
	}

	/**
	 *	w肵Ֆʂ̈ʒȕԂɑJڂB
	 *	inCodelɏ]ēJڂԂƂȂĂB
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@param	inCode ԂJڂ邽߂̃CxgR[h
	 */
	protected void nextStateAtSelf(final int inX, final int inY, StateEventCode inEvent) {}
	
	public void nextStateAt(final int inX, final int inY, StateEventCode inEvent) {
		if (isAcceptableEvent(inEvent)) {
			if (UtilityFuncs.isSelectionType(inEvent)) {
				changeSelection(inX, inY, inEvent);
			}
			else if (UtilityFuncs.isDeterminationType(inEvent)) {
				determine();
				
				if (mOppositePos != EMPTY_POS && new Point(inX, inY).equals(mOppositePos)) {
					Direction aInverse = UtilityFuncs.inverseDirection(UtilityFuncs.resolveDirectionOf(inEvent));
					StateEventCode aEvent = UtilityFuncs.getDetermineDirectionEventCode(aInverse);
					
					getDecorated().nextStateAt(mOppositePos.x, mOppositePos.y, aEvent);
					
					mOppositePos = EMPTY_POS;
					return;
				}
			}
		}
		
		getDecorated().nextStateAt(inX, inY, inEvent);
	}
	
	private void changeSelection(final int inX, final int inY, StateEventCode inCode) {
		Direction aDirection = UtilityFuncs.resolveDirectionOf(inCode);
		
		if (aDirection == Direction.NO) {
			mPressedPos = new Point(inX, inY);
			mOppositePos = EMPTY_POS;
			mDeactivatedPos = mSelectedPos;
			mSelectedPos = new Point[] {mPressedPos};
			mDirection = aDirection;
			mIsModified = true;
			
			return;
		}
		
		// IɕύXȂΔ
		if (aDirection == mDirection) return;
		
		mDirection = aDirection;
		
		activate(aDirection);
	}
	
	private void determine() {
		if (! mIsModified) {
			mDeactivatedPos = mSelectedPos;
			mSelectedPos = NO_MODIFIED;
			mPressedPos = EMPTY_POS;
			mDirection = Direction.NO;
			
			mIsModified = true;
		}
	}	
	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1߂
	 *	inCodelɏ]ēJڂԂƂȂĂB
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@param	inCode ԂJڂ邽߂̃CxgR[h
	 */
	protected void prevStateAtSelf(final int inX, final int inY, StateEventCode inEvent) {}
	
	public void prevStateAt(final int inX, final int inY, StateEventCode inEvent) {
		if (isAcceptableEvent(inEvent)) {
			if (UtilityFuncs.isSelectionType(inEvent)) {
				changeSelection(inX, inY, inEvent);
			}
			else if (UtilityFuncs.isDeterminationType(inEvent)) {
				determine();
				
				if (mOppositePos != EMPTY_POS && new Point(inX, inY).equals(mOppositePos)) {
					Direction aInverse = UtilityFuncs.inverseDirection(UtilityFuncs.resolveDirectionOf(inEvent));
					StateEventCode aEvent = UtilityFuncs.getDetermineDirectionEventCode(aInverse);
					
					getDecorated().prevStateAt(mOppositePos.x, mOppositePos.y, aEvent);
					
					mOppositePos = EMPTY_POS;
					return;
				}
			}
		}
		
		getDecorated().prevStateAt(inX, inY, inEvent);
	}
	
	/**
	 *	w肳ꂽIԂɂ
	 *
	 *	@param	inDirection	IԂɂ
	 */
	private void activate(Direction inDirection) {
		// OɑIꂽʒuIɂB
		mDeactivatedPos = mSelectedPos;
		
		// ˂邱ƂłȂȂAB
		if (! isBuildBridge(inDirection)) {
			mSelectedPos = NO_MODIFIED;
			
			return;
		}
		
		Point aDiff = inDirection.getDifference();
		Point aPos = new Point(mPressedPos);
		java.util.Set aSet = new java.util.HashSet();
		
		// pressʒu
		aSet.add(new Point(aPos));
		
		aPos.translate(aDiff.x, aDiff.y);
		do {
			aSet.add(new Point(aPos));
			aPos.translate(aDiff.x, aDiff.y);
		} 
		while(! isNumberAt(aPos.x, aPos.y));
		
		// Ί݂̈ʒu
		mOppositePos = new Point(aPos);
		aSet.add(mOppositePos);
		
		mSelectedPos = (Point[])aSet.toArray(new Point[aSet.size()]);
		
		mIsModified = true;
	}
	
	/**
	 *	w肳ꂽɋ˂邱Ƃł邩ǂ`FbN
	 *
	 *	@param	inDirection	`FbN
	 */
	private boolean isBuildBridge(Direction inDirection) {
		Point aDiff = inDirection.getDifference();
		Point aPos = new Point(mPressedPos);
		
		final StateEventCode aCode = UtilityFuncs.getDetermineDirectionEventCode(inDirection);
		
		// אڂĂ̂ł΁AfalseԂ
		aPos.translate(aDiff.x, aDiff.y);
		if (! isTransitAt(aPos.x, aPos.y, aCode)) return false;
		
		// ̐ɏo܂ŁAw肳ꂽTB
		// rA󔒈ȊȌԂ邱ƂȂ̐ɏoAfalseԂB
		do {
			aPos.translate(aDiff.x, aDiff.y);
			if (isNumberAt(aPos.x, aPos.y)) return true;
		} while(contains(aPos.x, aPos.y) && isTransitAt(aPos.x, aPos.y, aCode));
		
		// rA󔒈ȊȌԂꂽB
		return false;
	}
	
	/**
	 *	Model̕ύXNA
	 */
	protected void flushSelf() {
		if (mIsModified) {
			mDeactivatedPos = NO_MODIFIED;
			mIsModified = false;
		}
	}
}
