/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.mxp1;

import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParserException;

public class MXParserCachingStrings
extends MXParser {
    private static final boolean CACHE_STATISTICS = false;
    private static final boolean TRACE_SIZING = false;
    private int cacheStatCalls;
    private int cacheStatWalks;
    private int cacheStatResets;
    private int cacheStatRehash;
    private static final int CACHE_LOAD = 77;
    private int cacheEntriesCount;
    private int cacheEntriesThreshold;
    private char[][] keys;
    private String[] values;
    private boolean global;
    private static int globalCacheEntriesCount;
    private static int globalCacheEntriesThreshold;
    private static char[][] globalKeys;
    private static String[] globalValues;

    public MXParserCachingStrings() {
        this.allStringsInterned = true;
    }

    public void setFeature(String name, boolean state) throws XmlPullParserException {
        if ("http://xmlpull.org/v1/doc/features.html#names-interned".equals(name)) {
            if (this.eventType != 0) {
                throw new XmlPullParserException("interning names feature can only be changed before parsing", this, null);
            }
            this.allStringsInterned = state;
            if (!state && this.keys != null) {
                this.resetStringCache();
            }
        } else {
            super.setFeature(name, state);
        }
    }

    public boolean getFeature(String name) {
        if ("http://xmlpull.org/v1/doc/features.html#names-interned".equals(name)) {
            return this.allStringsInterned;
        }
        return super.getFeature(name);
    }

    public void finalize() {
    }

    protected String newString(char[] cbuf, int off, int len) {
        if (this.allStringsInterned) {
            return this.newStringIntern(cbuf, off, len);
        }
        return super.newString(cbuf, off, len);
    }

    protected String newStringIntern(char[] cbuf, int off, int len) {
        if (this.cacheEntriesCount >= this.cacheEntriesThreshold) {
            this.rehash();
        }
        int offset = MXParser.fastHash(cbuf, off, len) % this.keys.length;
        char[] k = null;
        while ((k = this.keys[offset]) != null && !MXParserCachingStrings.keysAreEqual(k, 0, k.length, cbuf, off, len)) {
            offset = (offset + 1) % this.keys.length;
        }
        if (k != null) {
            return this.values[offset];
        }
        k = new char[len];
        System.arraycopy(cbuf, off, k, 0, len);
        String v = new String(k).intern();
        this.keys[offset] = k;
        this.values[offset] = v;
        ++this.cacheEntriesCount;
        return v;
    }

    protected void initStringCache() {
        if (this.keys == null) {
            int initialCapacity = 13;
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
            }
            this.cacheEntriesThreshold = initialCapacity * 77 / 100;
            if (this.cacheEntriesThreshold >= initialCapacity) {
                throw new RuntimeException("internal error: threshold must be less than capacity: " + initialCapacity);
            }
            this.keys = new char[initialCapacity][];
            this.values = new String[initialCapacity];
            this.cacheEntriesCount = 0;
        }
    }

    protected void resetStringCache() {
        this.initStringCache();
    }

    private void rehash() {
        int newSize = 2 * this.keys.length + 1;
        this.cacheEntriesThreshold = newSize * 77 / 100;
        if (this.cacheEntriesThreshold >= newSize) {
            throw new RuntimeException("internal error: threshold must be less than capacity: " + newSize);
        }
        char[][] newKeys = new char[newSize][];
        String[] newValues = new String[newSize];
        int i = 0;
        while (i < this.keys.length) {
            char[] k = this.keys[i];
            this.keys[i] = null;
            String v = this.values[i];
            this.values[i] = null;
            if (k != null) {
                int newOffset = MXParser.fastHash(k, 0, k.length) % newSize;
                char[] newk = null;
                while ((newk = newKeys[newOffset]) != null) {
                    if (MXParserCachingStrings.keysAreEqual(newk, 0, newk.length, k, 0, k.length)) {
                        throw new RuntimeException("internal cache error: duplicated keys: " + new String(newk) + " and " + new String(k));
                    }
                    newOffset = (newOffset + 1) % newSize;
                }
                newKeys[newOffset] = k;
                newValues[newOffset] = v;
            }
            ++i;
        }
        this.keys = newKeys;
        this.values = newValues;
    }

    private static final boolean keysAreEqual(char[] a, int astart, int alength, char[] b, int bstart, int blength) {
        if (alength != blength) {
            return false;
        }
        int i = 0;
        while (i < alength) {
            if (a[astart + i] != b[bstart + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

