/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshaller;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.JiBXException;

public class MarshallingContext
implements IMarshallingContext {
    protected static final int INITIAL_STACK_SIZE = 20;
    private Writer m_writer;
    private boolean m_indent;
    private boolean m_textSeen;
    private int m_indentSpaces;
    private int m_nestingDepth;
    private char[] m_spaces;
    protected String[] m_classes;
    protected int m_globalCount;
    protected String[] m_marshallerClasses;
    protected IMarshaller[] m_marshallers;
    protected Stack m_namespaceStack;
    protected int m_namespaceDepth;
    protected String[] m_uris;
    protected String[] m_prefixes;
    protected int m_stackDepth;
    protected Object[] m_objectStack;

    public MarshallingContext(String[] classes, String[] mcs, String[] uris) {
        this.m_classes = classes;
        this.m_globalCount = mcs.length;
        this.m_marshallers = new IMarshaller[classes.length];
        this.m_marshallerClasses = new String[classes.length];
        System.arraycopy(mcs, 0, this.m_marshallerClasses, 0, mcs.length);
        this.m_uris = uris;
        this.m_prefixes = new String[uris.length];
        this.m_prefixes[0] = "";
        this.m_prefixes[1] = "xml:";
        this.m_namespaceStack = new Stack();
        this.m_namespaceDepth = -1;
        this.m_objectStack = new Object[20];
    }

    public void setOutput(OutputStream outs, String enc) throws JiBXException {
        try {
            this.m_writer = enc == null ? new BufferedWriter(new OutputStreamWriter(outs)) : new BufferedWriter(new OutputStreamWriter(outs, enc));
            this.reset();
        }
        catch (IOException ex) {
            throw new JiBXException("Error setting output", ex);
        }
    }

    public void setOutput(Writer outw) {
        this.m_writer = outw;
        this.reset();
    }

    public void setIndent(int indent) {
        if (indent >= 0) {
            this.m_indent = true;
            this.m_indentSpaces = indent;
            this.m_spaces = "\n                              ".toCharArray();
        } else {
            this.m_indent = false;
        }
    }

    public void reset() {
        this.m_textSeen = false;
        this.m_nestingDepth = 0;
        int i = this.m_globalCount;
        while (i < this.m_marshallers.length) {
            this.m_marshallers[i] = null;
            this.m_marshallerClasses[i] = null;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_objectStack.length) {
            this.m_objectStack[i2] = null;
            ++i2;
        }
    }

    private void indent() throws IOException {
        if (this.m_indent) {
            int length = 1 + this.m_nestingDepth * this.m_indentSpaces;
            if (length > this.m_spaces.length) {
                int use = Math.max(length, this.m_spaces.length * 2 + 1);
                this.m_spaces = new char[use];
                this.m_spaces[0] = 10;
                int i = 1;
                while (i < use) {
                    this.m_spaces[i] = 32;
                    ++i;
                }
            }
            this.m_writer.write(this.m_spaces, 0, length);
        }
    }

    private void writeAttribute(String text) throws IOException {
        if (text.indexOf(34) < 0 && text.indexOf(38) < 0 && text.indexOf(60) < 0 && text.indexOf(62) < 0) {
            this.m_writer.write(text);
        } else {
            int mark = 0;
            int i = 0;
            while (i < text.length()) {
                char chr = text.charAt(i);
                if (chr == '\"') {
                    this.m_writer.write(text, mark, i - mark);
                    mark = i + 1;
                    this.m_writer.write("&quot;");
                } else if (chr == '&') {
                    this.m_writer.write(text, mark, i - mark);
                    mark = i + 1;
                    this.m_writer.write("&amp;");
                } else if (chr == '<') {
                    this.m_writer.write(text, mark, i - mark);
                    mark = i + 1;
                    this.m_writer.write("&lt;");
                } else if (chr == '>' && i > 2 && text.charAt(i - 1) == ']' && text.charAt(i - 2) == ']') {
                    this.m_writer.write(text, mark, i - mark - 2);
                    mark = i + 1;
                    this.m_writer.write("]]&gt;");
                }
                ++i;
            }
            this.m_writer.write(text, mark, text.length() - mark);
        }
    }

    public MarshallingContext writeRaw(String text) throws IOException {
        this.m_writer.write(text);
        return this;
    }

    public MarshallingContext writeCData(String text) throws IOException {
        this.m_writer.write("<![CDATA[");
        this.m_writer.write(text);
        this.m_writer.write("]]>");
        return this;
    }

    public MarshallingContext writeContent(String text) throws IOException {
        if (text.indexOf(38) < 0 && text.indexOf(60) < 0 && text.indexOf(62) < 0) {
            this.m_writer.write(text);
        } else {
            int mark = 0;
            int i = 0;
            while (i < text.length()) {
                char chr = text.charAt(i);
                if (chr == '&') {
                    this.m_writer.write(text, mark, i - mark);
                    mark = i + 1;
                    this.m_writer.write("&amp;");
                } else if (chr == '<') {
                    this.m_writer.write(text, mark, i - mark);
                    mark = i + 1;
                    this.m_writer.write("&lt;");
                } else if (chr == '>' && i > 2 && text.charAt(i - 1) == ']' && text.charAt(i - 2) == ']') {
                    this.m_writer.write(text, mark, i - mark - 2);
                    mark = i + 1;
                    this.m_writer.write("]]&gt;");
                }
                ++i;
            }
            this.m_writer.write(text, mark, text.length() - mark);
        }
        return this;
    }

    public void startDocument(String enc, Boolean alone) throws JiBXException {
        try {
            this.m_writer.write("<?xml version=\"1.0\"");
            if (enc != null) {
                this.m_writer.write(" encoding=\"" + enc + '\"');
            }
            if (alone != null) {
                this.m_writer.write(" standalone=\"" + (alone != false ? "yes" : "no") + '\"');
            }
            this.m_writer.write("?>");
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public void startDocument(String enc, Boolean alone, OutputStream outs) throws JiBXException {
        this.setOutput(outs, enc);
        this.startDocument(enc, alone);
    }

    public void startDocument(String enc, Boolean alone, Writer outw) throws JiBXException {
        this.setOutput(outw);
        this.startDocument(enc, alone);
    }

    public void endDocument() throws JiBXException {
        try {
            this.m_writer.flush();
            this.m_writer.close();
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    private String prefixText(int index) throws JiBXException {
        try {
            return this.m_prefixes[index].toString();
        }
        catch (NullPointerException ex) {
            throw new JiBXException("Namespace URI has not been declared.");
        }
    }

    public MarshallingContext startTag(int index, String name) throws JiBXException {
        try {
            this.indent();
            this.m_writer.write("<" + this.prefixText(index) + name + '>');
            ++this.m_nestingDepth;
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public MarshallingContext startTagAttributes(int index, String name) throws JiBXException {
        try {
            this.indent();
            this.m_writer.write("<" + this.prefixText(index) + name);
            ++this.m_nestingDepth;
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public MarshallingContext attribute(int index, String name, String value) throws JiBXException {
        try {
            this.m_writer.write(" " + this.prefixText(index) + name + "=\"");
            this.writeAttribute(value);
            this.m_writer.write(34);
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public MarshallingContext attribute(int index, String name, int value) throws JiBXException {
        try {
            this.m_writer.write(" " + this.prefixText(index) + name + "=\"" + value + '\"');
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public MarshallingContext attribute(int index, String name, int value, String[] table) throws JiBXException {
        try {
            this.m_writer.write(" " + this.prefixText(index) + name + "=\"" + table[value] + '\"');
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new JiBXException("Enumeration value of " + value + " is outside to allowed range of 0 to " + table.length);
        }
    }

    public MarshallingContext closeStartContent() throws JiBXException {
        try {
            this.m_writer.write(62);
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public MarshallingContext closeStartEmpty() throws JiBXException {
        try {
            this.m_writer.write("/>");
            if (--this.m_nestingDepth == this.m_namespaceDepth) {
                this.closeNamespaces();
            }
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public MarshallingContext content(String value) throws JiBXException {
        try {
            this.writeContent(value);
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public MarshallingContext content(int value) throws JiBXException {
        try {
            this.m_writer.write(Integer.toString(value));
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public MarshallingContext content(int value, String[] table) throws JiBXException {
        try {
            this.m_writer.write(table[value]);
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new JiBXException("Enumeration value of " + value + " is outside to allowed range of 0 to " + table.length);
        }
    }

    public MarshallingContext endTag(int index, String name) throws JiBXException {
        try {
            --this.m_nestingDepth;
            if (!this.m_textSeen) {
                this.indent();
            }
            this.m_writer.write("</" + this.prefixText(index) + name + '>');
            if (this.m_nestingDepth == this.m_namespaceDepth) {
                this.closeNamespaces();
            }
            this.m_textSeen = false;
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public MarshallingContext element(int index, String name, String value) throws JiBXException {
        try {
            this.indent();
            this.m_writer.write("<" + this.prefixText(index) + name + '>');
            this.writeContent(value);
            this.m_writer.write("</" + this.prefixText(index) + name + '>');
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public MarshallingContext element(int index, String name, int value) throws JiBXException {
        try {
            this.indent();
            this.m_writer.write("<" + this.prefixText(index) + name + '>' + value + "</" + this.prefixText(index) + name + '>');
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public MarshallingContext element(int index, String name, int value, String[] table) throws JiBXException {
        try {
            this.indent();
            this.m_writer.write("<" + this.prefixText(index) + name + '>' + table[value] + "</" + this.prefixText(index) + name + '>');
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new JiBXException("Enumeration value of " + value + " is outside to allowed range of 0 to " + table.length);
        }
    }

    public MarshallingContext marshalCollection(Collection col) throws JiBXException {
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof IMarshallable) {
                ((IMarshallable)obj).marshal(this);
                continue;
            }
            throw new JiBXException("Unmarshallable object of class " + obj.getClass() + " found in marshalling");
        }
        return this;
    }

    public MarshallingContext marshalCollection(ArrayList col) throws JiBXException {
        int i = 0;
        while (i < col.size()) {
            Object obj = col.get(i);
            if (!(obj instanceof IMarshallable)) {
                throw new JiBXException("Unmarshallable object of class " + obj.getClass().getName() + " found in marshalling");
            }
            ((IMarshallable)obj).marshal(this);
            ++i;
        }
        return this;
    }

    public MarshallingContext marshalCollection(Vector col) throws JiBXException {
        int i = 0;
        while (i < col.size()) {
            Object obj = col.elementAt(i);
            if (!(obj instanceof IMarshallable)) {
                throw new JiBXException("Unmarshallable object of class " + obj.getClass().getName() + " found in marshalling");
            }
            ((IMarshallable)obj).marshal(this);
            ++i;
        }
        return this;
    }

    public void addMarshalling(int index, String name) {
        this.m_marshallerClasses[index] = name;
    }

    public void removeMarshalling(int index) {
        this.m_marshallers[index] = null;
        this.m_marshallerClasses[index] = null;
    }

    protected void closeNamespaces() {
        DeclarationInfo info = (DeclarationInfo)this.m_namespaceStack.pop();
        int[] deltas = info.m_deltas;
        String[] priors = info.m_priors;
        int i = 0;
        while (i < deltas.length) {
            this.m_prefixes[deltas[i]] = priors[i];
            ++i;
        }
        this.m_namespaceDepth = this.m_namespaceStack.empty() ? -1 : ((DeclarationInfo)this.m_namespaceStack.peek()).m_depth;
    }

    public MarshallingContext startTagNamespaces(int index, String name, int[] nums, String[] prefs) throws JiBXException {
        int count = 0;
        int i = 0;
        while (i < nums.length) {
            if (!prefs[i].equals(this.m_prefixes[nums[i]])) {
                ++count;
            }
            ++i;
        }
        int[] deltas = null;
        if (count > 0) {
            String[] priors = new String[count];
            if (count == nums.length) {
                deltas = nums;
                int i2 = 0;
                while (i2 < count) {
                    int slot = deltas[i2];
                    priors[i2] = this.m_prefixes[slot];
                    this.m_prefixes[slot] = prefs[i2];
                    ++i2;
                }
            } else {
                int fill = 0;
                deltas = new int[count];
                int i3 = 0;
                while (i3 < nums.length) {
                    int slot = nums[i3];
                    if (!prefs[i3].equals(this.m_prefixes[slot])) {
                        deltas[fill] = slot;
                        priors[fill++] = this.m_prefixes[slot];
                        this.m_prefixes[slot] = prefs[i3];
                    }
                    ++i3;
                }
            }
            this.m_namespaceStack.push(new DeclarationInfo(this.m_nestingDepth, deltas, priors));
            this.m_namespaceDepth = this.m_nestingDepth;
        }
        this.startTagAttributes(index, name);
        try {
            int i4 = 0;
            while (i4 < count) {
                int slot = deltas[i4];
                String prefix = this.m_prefixes[slot];
                int length = prefix.length();
                if (length > 0) {
                    this.m_writer.write(" xmlns:" + prefix.substring(0, length - 1) + "=\"");
                } else {
                    this.m_writer.write(" xmlns=\"");
                }
                this.writeAttribute(this.m_uris[slot]);
                this.m_writer.write(34);
                ++i4;
            }
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMarshaller getMarshaller(int index, String name) throws JiBXException {
        block11: {
            if (index >= this.m_classes.length || !name.equals(this.m_classes[index])) {
                throw new JiBXException("Marshalling not defined for class " + name);
            }
            if (this.m_marshallers[index] == null) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                ReflectiveOperationException ex = null;
                try {
                    IMarshaller m;
                    Class<?> clas = loader.loadClass(this.m_marshallerClasses[index]);
                    this.m_marshallers[index] = m = (IMarshaller)clas.newInstance();
                }
                catch (ClassNotFoundException e) {
                    ex = e;
                    return ex;
                }
                catch (InstantiationException e) {
                    ex = e;
                    return ex;
                }
                catch (IllegalAccessException e) {
                    ex = e;
                    return ex;
                }
                finally {
                    if (ex == null) break block11;
                    throw new JiBXException("Unable to create marshaller of class " + this.m_marshallerClasses[index]);
                }
            }
        }
        return this.m_marshallers[index];
    }

    protected void marshalRoot(Object root) throws JiBXException {
        if (!(root instanceof IMarshallable)) {
            throw new JiBXException("Supplied root object of class " + root.getClass().getName() + " cannot be marshalled without top-level mapping");
        }
        ((IMarshallable)root).marshal(this);
    }

    public void marshalDocument(Object root, String enc, Boolean alone) throws JiBXException {
        this.startDocument(enc, alone);
        this.marshalRoot(root);
        this.endDocument();
    }

    public void marshalDocument(Object root, String enc, Boolean alone, OutputStream outs) throws JiBXException {
        this.startDocument(enc, alone, outs);
        this.marshalRoot(root);
        this.endDocument();
    }

    public void marshalDocument(Object root, String enc, Boolean alone, Writer outw) throws JiBXException {
        this.startDocument(enc, alone, outw);
        this.marshalRoot(root);
        this.endDocument();
    }

    public void pushObject(Object obj) {
        int depth = this.m_stackDepth;
        if (depth >= this.m_objectStack.length) {
            Object[] stack = new Object[depth * 2];
            System.arraycopy(this.m_objectStack, 0, stack, 0, depth);
            this.m_objectStack = stack;
        }
        this.m_objectStack[depth] = obj;
        ++this.m_stackDepth;
    }

    public void popObject() throws JiBXException {
        if (this.m_stackDepth > 0) {
            --this.m_stackDepth;
        } else {
            throw new JiBXException("No object on stack");
        }
    }

    public int getStackDepth() {
        return this.m_stackDepth;
    }

    public Object getStackObject(int depth) {
        return this.m_objectStack[this.m_stackDepth - depth - 1];
    }

    public Object getStackTop() {
        if (this.m_stackDepth > 0) {
            return this.m_objectStack[this.m_stackDepth - 1];
        }
        return null;
    }

    private static class DeclarationInfo {
        public final int m_depth;
        public final int[] m_deltas;
        public final String[] m_priors;

        public DeclarationInfo(int depth, int[] deltas, String[] priors) {
            this.m_depth = depth;
            this.m_deltas = deltas;
            this.m_priors = priors;
        }
    }
}

