// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		MenuItemBean.java
//	DATE:		2003.8.1
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.util.gui;

import java.awt.event.ActionListener;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.PropertyBundle;

class MenuItemBean implements MenuElementBean {
	private String mName;
	
	private String mShortcut = "";
	private String mShortCutModifier = "";
	
	private String mClassName = "";
	
	public MenuItemBean() {
	}
	
	public java.awt.MenuItem createMenuItem(MenuManager inManager) {
		String aI18NName = PropertyBundle.getInstance().getString(mName);
		if (aI18NName.length() == 0) aI18NName = mName;
			
		java.awt.MenuItem aItem = new java.awt.MenuItem(aI18NName);
		aItem.setActionCommand(mName);
		
		if (0 != mShortcut.length()) {
			byte[] akey = mShortcut.getBytes();
			
			java.awt.MenuShortcut aShortcut = new java.awt.MenuShortcut(akey[0]);
			aItem.setShortcut(aShortcut);
		}
		
		aItem.addActionListener(inManager.getActionDispatcher());
		
		inManager.installMenuItem(mName, aItem);
		inManager.installDelegateAction(mName, mClassName);
		
		return aItem;
	}
	
	public void setName(String inName) {
		mName = inName;
	}
	
	public String getName() {
		return mName;
	}
	
	public void setShortCut(String inShortcut) {
		mShortcut = inShortcut;
	}
	
	public String getShortCut() {
		return mShortcut;
	}
	
	public void setShortCutModifier(String inModifier) {
		mShortCutModifier = inModifier;
	}
	
	public String getShortCutModifier() {
		return mShortCutModifier;
	}

	public String toString() {
		String aShortcut = "";
		
		if (mShortcut.length() != 0) {
			aShortcut = ", shortcut : CTRL + ";
			if (mShortCutModifier.length() != 0) {
				aShortcut += mShortCutModifier + " + ";
			}
			aShortcut += mShortcut;
		}
		
		return "item name : " + mName + 
				aShortcut + 
				", action class : " + mClassName;
	}
}
	
