// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		Board.java
//	DATE:		2003.7.11
//	CREATOR:	Kazuhiko TAMURA
// ***************************************************************************************


package jp.gr.java_conf.ktz.puzzle.hashikake.solver.view;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Point;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.NullModel;

import jp.gr.java_conf.ktz.puzzle.framework.Renderer;
import jp.gr.java_conf.ktz.puzzle.framework.DefaultRenderer;
import jp.gr.java_conf.ktz.puzzle.framework.RenderListener;
import jp.gr.java_conf.ktz.puzzle.framework.RenderEvent;
import jp.gr.java_conf.ktz.puzzle.framework.Model;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.AppColors;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.ProblemUnmarshalable;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.Command;

import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.HashikakeSolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolveDiscompleteException;

import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.*;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.view.RendererFactory;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.BoardModel;

import jp.gr.java_conf.ktz.puzzle.hashikake.command.ResetCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.BoardSizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.PieceSizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.LoadCommand;

import jp.gr.java_conf.ktz.puzzle.hashikake.solver.view.command.NextCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.view.command.NextAllCommand;

import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AbstractBottomUpCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AWTDispatchCommandQueue;


/**
 *	ՖʂViewKw
 */
public class Board extends java.awt.Canvas implements BoardView {
	/** Ֆʂ̃ftHg̕ */
	private static final int DEFAULT_BOARD_WIDTH = 9;

	/** Ֆʂ̃ftHg̍ */
	private static final int DEFAULT_BOARD_HEIGHT = 9;
	
	/** NbNĂȂƂ萔 */
	private static final Point NO_CLICKED = ModelConstants.ILLEGAL_POS;
	
	/** gbvxModelւ̎Q */
	private Model mModel = NullModel.getInstance();
	
	/** SolverHandler̎ */
	private SolverHandler mHandler;
	
	/** Ֆʂ̕`s_ */
	private DefaultRenderer mRenderer;
	
	/** View̐e */
	private BoardView mParent;
	
	/**
	 *	ftHgRXgN^
	 */
	public Board() {
	}
	
	/**
	 *	ViewKw
	 */
	public void initialize() {
		System.out.println("init");	
		
		// Model̏
		mModel = NullModel.getInstance();
		
		// Rendereȑ
		mRenderer = RendererFactory.create(DEFAULT_BOARD_WIDTH, DEFAULT_BOARD_HEIGHT);
		
		// Canvas̏
		setBackground(AppColors.BACK_COLOR);
		createBoard(DEFAULT_BOARD_WIDTH, DEFAULT_BOARD_HEIGHT);		

		// Piece size]
		PieceSizeCommand aCommand = new PieceSizeCommand(this, getPieceSize());
		AWTDispatchCommandQueue.postCommand(aCommand);
	}
		
	/** 
	 *	Command̏s
	 *	̎ł́ÃvZXŏłȂƂA
	 *	ʂCommandContainerŎw肵CommandƂA
	 *	Command]
	 *
	 *	@param	inCommand	Command
	 */	
	public void processCommand(Command inCommand) {
		// w肵Command̏܂ĂȂ
		// ACommandContainerŏłꍇ
		if (! inCommand.isConsumed()) {
			processCommandImpl(inCommand);
		}
		
		// ̃vZXŏłȂƂA
		// ܂́AʂCommandContainerŎw肵CommandƂ
		if (! inCommand.isConsumed()) {
			if (inCommand instanceof AbstractBottomUpCommand) {
				mParent.processCommand(inCommand);
			}
		}
	}
	
	/**
	 *	Command̎
	 */
	protected void processCommandImpl(Command inCommand) {
		final Class aClass = inCommand.getClass();
		
		if (aClass == ResetCommand.class) {
			clear();
			inCommand.consume();
		}
		else if (aClass == BoardSizeCommand.class) {
			final int aWidth = ((BoardSizeCommand)inCommand).getComponentWidth();
			final int aHeight = ((BoardSizeCommand)inCommand).getComponentHeight();
			
			setComponentSize(aWidth, aHeight);
		}
		else if (aClass == NextCommand.class) {
			mHandler.nextSolute();
			inCommand.consume();
			
			if (mModel.isModified()) {
				Rectangle aBounds = getClipBounds();
				repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
			}
		}
		else if (aClass == NextAllCommand.class) {
			try {
				mHandler.nextSoluteAll();
				inCommand.consume();
			}
			catch (SolveDiscompleteException e) {
				System.out.println(e);
			}
			
			if (mModel.isModified()) {
				Rectangle aBounds = getClipBounds();
				repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
			}
		}
		else if (aClass == LoadCommand.class) {
			ProblemInfo aInfo = ((LoadCommand)inCommand).getProblem();
			load(aInfo);
			inCommand.consume();
		}
	}
	
	/**
	 *	ViewKw̐eݒ肷
	 *
	 *	@param	inBoard	eView
	 */
	public void setParent(BoardView inBoard) {
		mParent = inBoard;
	}
	
	/**
	 *	w肵[h
	 *
	 *	@param	inInfo	蕶
	 *
	 *	@throws	IllegalArgumentException inInfonullnꂽƂ
	 */
	private void load(ProblemInfo inInfo) {
		System.out.println("set problem");	
		
		if (null == inInfo) throw new IllegalArgumentException("pass null object to inInfo");
		
		if (mModel instanceof NullModel) {
			mModel = new  BoardModel(mModel);
			mHandler = new HashikakeSolverHandler(mModel);	
		}
			
		createBoard(inInfo.getWidth(), inInfo.getHeight());
		mModel.setProblem(inInfo);
		mHandler.reset();
			
		if (mModel.isModified()) {
			Rectangle aBounds = getClipBounds();
			repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
		}
	}
	
	/**
	 *	w肵TCY̔Ֆʂ쐬
	 *
	 *	@param	inWidth		Ֆʂ̕iBoardWnj
	 *	@param	inHeight	Ֆʂ̍iBoardWnj
	 */
	private void createBoard(final int inWidth, final int inHeight) {
		mRenderer.setSize(inWidth, inHeight);
		mModel.createBoard(inWidth, inHeight);
		
		java.awt.Dimension aSize = mRenderer.getBoardSize();

		BoardSizeCommand aCommand = new BoardSizeCommand(
								this, aSize.width, aSize.height
		);
		AWTDispatchCommandQueue.postCommand(aCommand);
	}
	
	/**
	 *	w肵t@Cɖۑ
	 *	̎ł́Aۑ̓T|[gĂȂ
	 *
	 *	@param	inFile	ۑ
	 *
	 *	@throws	
	 */
	public void save(java.io.File inFile) {
		throw new UnsupportedOperationException(
			"This view isnot supported save method."
		);
	}
	
	/**
	 *	͂𓚂ł邩`FbN
	 *
	 *	@return	łꍇAtrueԂ
	 */
	private boolean check() {
		return mModel.check();
	}
	
	/**
	 *	ՖʂύXĂ邩ǂmF
	 *	̎ł͏falseԂ
	 */
	public boolean isModified() {
		return false;
	}
	
	/**
	 *	ViewɊ֘AtꂽR|[lgԂ
	 *
	 *	@return ViewɊ֘AtꂽR|[lg
	 */
	public java.awt.Component getComponent() {
		return this;
	}
	
	/**
	 *	Z̃s[XTCY擾
	 *
	 *	@return	s[XTCY
	 */
	private int getPieceSize() {
		return mRenderer.getPieceSize().width;
	}
	
	/**
	 *	ՖʃTCYZbg
	 *
	 *	@param	inWidth	Ֆʂ̕iScreenWnj
	 *	@param	inWidth	Ֆʂ̍iScreenWnj
	 */
	private void setComponentSize(final int inWidth, final int inHeight) {
		setSize(inWidth, inHeight);
	}
	
	/**
	 *	̃t[Ɋ֘AtꂽViewɃtH[JX邩ǂ߂
	 *
	 *	@param	inFocused	tH[JXꍇAtruwn
	 */
	public void setFocus(boolean inFocused) {
		mParent.setFocus(inFocused);
	}
	
	/**
	 *	̃t[Ɋ֘AtꂽViewtH[JXǂ`FbN
	 *
	 *	@return	tH[JXꍇAtruwԂ
	 */
	public boolean isFocused() {
		return mParent.isFocused();
	}
	
	/**
	 *	ՖʂԂɖ߂
	 */
	private void clear() {
		mModel.reset();
		mHandler.reset();
		
		if (mModel.isModified()) {
			Rectangle aBounds = getClipBounds();
			repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
		}
	}
	
	/**
	 *	w肵ScreenWn̈ʒuBoardWn̈ʒuɕϊ
	 *
	 *	@param	inX	XWiScreenWnj
	 *	@param	inY	YWiScreenWnj
	 *
	 *	@return	ϊ̍WiBoardWnj
	 */
	private Point calcPortToBoardPos(final int inX, final int inY) {
		return mRenderer.calcPortToBoardPos(inX, inY);
	}
	
	/**
	 *	ĕ`悷
	 */
	public void update(Graphics inGra) {
		paint(inGra);
	}
	
	/**
	 *	`悷
	 */
	public void paint(Graphics inGra) {
		Rectangle aBounds = inGra.getClipBounds();

		if (mModel.isModified()) {
			aBounds = new Rectangle();
			
			Point[] aPos = mModel.lastModified();
			
			for (int i = 0; i < aPos.length; ++i) {
				mRenderer.render(aPos[i].x, aPos[i].y, mModel.getCurStateAt(aPos[i].x, aPos[i].y));
			}

			aBounds = getClipBounds();
		}
		
		inGra.drawImage(
				mRenderer.getImage(), 
				aBounds.x, aBounds.y, aBounds.x + aBounds.width, aBounds.y + aBounds.height, 
				aBounds.x, aBounds.y, aBounds.x + aBounds.width, aBounds.y + aBounds.height, 
				this
		);
		
		mModel.flush();
	}
	
	/**
	 *	clip̈vZ
	 *
	 *	@return	clip̈
	 */
	private Rectangle getClipBounds() {
		return mRenderer.getClipBounds(mModel.lastModified());
	}
}