//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		SolverRI_4.java
//	DATE:		2003.7.23
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental;

import java.awt.Point;

import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.HashikakeStateManagerImpl;

import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SearchListener;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolveDiscompleteException;

public class SolverRI_3 implements SolverHandler {
	static class OppositeRecord {
		int mCount; // ݉ˋĂ鋴̐
		State mState = sStartState;
	}
	
	static class SolverRecord {
		int mQueueRef;
		
		Point mPos;
		final int mMaxBuildCount;
		int mResidue;
		int mOppositeCount;
		OppositeRecord[] mOpposite = new OppositeRecord[DIRECTIONS.length];
		State mState = sStartState;
		
		int mPenalty = DIRECTIONS.length * NUM_PER_DIRECTION;
		
		boolean mAroundChecked = true;
		int mMustBuildIndex = Integer.MIN_VALUE;
		
		SolverRecord(final int inQueueRef, Point inPos, final int inCount) {
			mQueueRef = inQueueRef;
			mPos = inPos;
			mMaxBuildCount = mResidue = inCount;
		}
		
		public String toString() {
			return "count = " + mOppositeCount
				+ "residue = " + mResidue
				+ "pos" + mPos;
		}
	}
	
	private static final State sStartState = new StartState();
	private static final State sProcessingState = new ProcessState();
	private static final State sBuildDisableState = new DisableState();
	private static final State sFinishedState = new FinishState();

	// ɂ邱Ƃ̂ł鋴̍ő{
	private static final int NUM_PER_DIRECTION = 2;
	
	/** Map<Point, SolverRecord> */
	private java.util.Map mRecords;
	
	/** QueueIF<SolverRecord> */
	private QueueIF mQueue;
	
	/** Map<Integer, List<SolverRecord> > */
	private java.util.Map mChainMap;
	
	private Model mModel;
	
	private int mLap;
	
	private Point mCurPos;
	
	/** ̏W */
	private static final Direction[] DIRECTIONS = {
		Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, 
	};
	
	public SolverRI_3(Model inModel) {
		mModel = inModel;
	}
	
	public void reset() {
		initRecords();
//		mQueue.printQueue();
		mLap = 0;
	}
	
	private void initRecords() {
		mRecords = new java.util.HashMap(); 
		mChainMap = new java.util.HashMap();
		mQueue = new Queue_1();
		
		java.util.List aList = new java.util.ArrayList();
		
		for (int y = 0; y < mModel.getHeight(); ++y) {
			for (int x = 0; x < mModel.getWidth(); ++x) {				
				
				if (mModel.isNumberAt(x, y)) {					
					Point aPos = new Point(x, y);
					
					SolverRecord aRec = getSolverRecord(aPos);
					updateSolverRecord(aRec);
//					aList.add(aRec);
					mQueue.enqueue(aRec);
				}
			}
		}
		
//		mQueue.reset(aList);
	}
	
	public boolean isSolute() {
		return mQueue.isEmpty();
	}
	
	
	public void nextSolute() {
		if (isSolute()) return;
		
		if (nextSoluteSub()) {
			System.out.println("build OK. at " + mCurPos);
		}
	}
	
	private boolean nextSoluteSub() {
		
		if (mLap == 0) {
			mLap = mQueue.size();
//			mQueue.shift(null);
			System.out.println("queue sorted. (" + mLap + " leaves.)");
		}
		
		--mLap;

		SolverRecord aRec = null;
		do {
			if (mQueue.isEmpty()) return true;
			
			aRec = (SolverRecord)mQueue.dequeue();
		}
		while (isFinishedState(aRec.mState));
		
		mCurPos = aRec.mPos;
		
		return attemptBuild(aRec);
	}
	
	public void nextSoluteAll() throws SolveDiscompleteException {
		int aLoopCount = 0;
		
		long t1 = System.currentTimeMillis();

		try {
			
			// QueuȅꍇA𓚂ꂽƔf
			if (mQueue.isEmpty()) return;

			// ˋłȂ
			int aCount = 0;
			do {
				++aLoopCount;
				
				if (! nextSoluteSub()) {
					// ˋłȂQueueTCYɓB_
					// ȏ𓚂i߂邱ƂłȂƔf
					if (mQueue.size()*2 == ++aCount) {
						throw new SolveDiscompleteException(mQueue.size());
					}
				}
				else {
					aCount = 0;
				}
			} while (! isSolute());	
		}
		finally {
			long t2 = System.currentTimeMillis();
		
			System.out.println("loop count : " + aLoopCount + "(" + (t2-t1) + " msec elapsed)");
		}
	}
	
	static class SolverInfo {	
		SolverRecord mRec;
		int mAroundMax;
		Point[] mAroundPos;
		
		SolverInfo(SolverRecord inRec, final int inAroundMax, Point[] inAroundPos) {
			mRec = inRec;
			mAroundMax = inAroundMax;
			mAroundPos = inAroundPos;
		}
	}

	private boolean attemptBuild(SolverRecord inRec) {
		boolean aRet = false;
		
		do {
			updateSolverRecord(inRec);
			
			if (isFinishedState(inRec.mState)) {
				return true;
			}
			
			aRet = false;
			
			Point[] aAroundPos = new Point[DIRECTIONS.length];
			final int aSum = getAroundMax(inRec, aAroundPos);
			
			SolverInfo aInfo = new SolverInfo(inRec, aSum, aAroundPos);
		
			aRet |= build_1(aInfo);
			
			if (! aRet) aRet |= build_2(aInfo);
			
			if (! aRet) aRet |= build_3(aInfo);
			
			if (! aRet) aRet |= build_4(aInfo);
			
			// Ίp`FbN
			if (aRet) {
				Point[] aDiagonal = new Point[] {
					new Point(1, 1), new Point(-1, 1), new Point(1, -1), new Point(-1, -1), 
				};
				
				Point aDiaPos = new Point(inRec.mPos);
				for (int i = 0; i < aDiagonal.length; ++i) {
					aDiaPos.translate(aDiagonal[i].x, aDiagonal[i].y);
					if (mModel.isNumberAt(aDiaPos.x, aDiaPos.y)) {
						SolverRecord aDiaRec = getSolverRecord(aDiaPos);
						
						updateSolverRecord(aDiaRec);
						
					}
					aDiaPos.translate(-aDiagonal[i].x, -aDiagonal[i].y);
				}
			}
		}
		while (aRet);
		

		if (! isFinishedState(inRec.mState)) {
//			inRec.mPenalty *= 2;
			mQueue.enqueue(inRec);
		}
		
		return aRet;
	}
	
	private boolean build_1(SolverInfo inInfo) {
		final int aResidue = inInfo.mRec.mResidue;
		final int aOpposite = inInfo.mRec.mOppositeCount;
		final int aNumPerDir = NUM_PER_DIRECTION - (aOpposite * NUM_PER_DIRECTION - aResidue);
		
		boolean aRet = false;
		for (int i = 0; i < DIRECTIONS.length; ++i) {
			// w肵ɁAΊ݂Ȃꍇ
			if (null == inInfo.mRec.mOpposite[i]) continue;
			
			// P{ˋłȂꍇ
			if (0 >= aNumPerDir) continue;
			
			// Ɏw肵{ˋĂꍇ
			if (aNumPerDir <=  inInfo.mRec.mOpposite[i].mCount) continue;
			
			aRet |= buildBridge(inInfo.mRec, aNumPerDir, i);
		}
		
		return aRet;
	}
	
	private boolean build_2(SolverInfo inInfo) {
		boolean aRet = false;
		for (int i = 0; i < DIRECTIONS.length; ++i) {
			// w肵ɁAΊ݂Ȃꍇ
			if (null == inInfo.mRec.mOpposite[i]) continue;
			
			// Ɏw肵ɂP{ȏˋĂꍇ
			if (0 != inInfo.mRec.mOpposite[i].mCount) continue;
			
			SolverRecord aAgainstRec = getSolverRecord(inInfo.mAroundPos[i]);
			
			if ((inInfo.mAroundMax - aAgainstRec.mResidue < inInfo.mRec.mResidue)) {
				aRet |= buildBridge(inInfo.mRec, 1, i);
			}
		}
		
		return aRet;
	}
	
	private boolean build_3(SolverInfo inInfo) {
		Integer aRefID = new Integer(inInfo.mRec.mQueueRef);
		java.util.List aList = getChainList(aRefID, inInfo.mRec);
		
		boolean aRet = false;
		for (int i = 0; i < DIRECTIONS.length; ++i) {
			// w肵ɁAΊ݂ȂꍇA܂͂ȏˋłȂꍇ
			if (null == inInfo.mAroundPos[i]) continue;
			
			SolverRecord aAgainstRec = getSolverRecord(inInfo.mAroundPos[i]);
			
			if (inInfo.mAroundMax - aAgainstRec.mResidue == inInfo.mRec.mResidue) {
				aRet |= attemptBuildLater(i, aList, inInfo);
			}
		}
		
		return aRet;
	}
	
	private boolean attemptBuildLater(
						final int inIndex, java.util.List inChainList, 
						SolverInfo inInfo) 
	{
		int aSum = 0;
		int aSize = 1; // 炩ߎgJEgĂ
		
		for (int i = 0; i < DIRECTIONS.length; ++i) {
			if (null != inInfo.mAroundPos[i] && i != inIndex) {
				
				SolverRecord aAgainstRec = getSolverRecord(inInfo.mAroundPos[i]);
				
				Integer aAgainstRefID = new Integer(aAgainstRec.mQueueRef);
				java.util.List aAgainstList = getChainList(aAgainstRefID, aAgainstRec);
				
				if (inInfo.mRec.mQueueRef == aAgainstRec.mQueueRef
						 && inChainList.size() <= DIRECTIONS.length) 
				{
					// Ί݂ɘAĂꍇ
					++aSize;
					aSum += aAgainstRec.mResidue;
				}
				else if (aAgainstList.size() == 1) {
					aSum += aAgainstRec.mResidue;
				}
			}
		}
		
		if (inChainList.size() == aSize && aSum == inInfo.mRec.mResidue) {
			return buildBridge(inInfo.mRec, 1, inIndex);
		}	
		
		return false;
	}
	
	private boolean build_4(SolverInfo inInfo) {
		boolean aRet = false;
		
		int aSum = getEffectiveAroundMax(inInfo);
		int aResidue = inInfo.mRec.mResidue;
		
		for (int i = 0; i < DIRECTIONS.length; ++i) {
			if (null == inInfo.mAroundPos[i]) continue;
			
			SolverRecord aAgainstRec = getSolverRecord(inInfo.mAroundPos[i]);
			
			int aCount = aAgainstRec.mMaxBuildCount;
			
			for (int j = 0; j < DIRECTIONS.length; ++j) {
				if (null == aAgainstRec.mOpposite[j]) continue;
				 
				if (inInfo.mRec.mOpposite[i] != aAgainstRec.mOpposite[j]) {
					aCount -= aAgainstRec.mOpposite[j].mCount;
				}
			}
			
			// Pɓn鋴̖{ő NUM_PER_DIRECTION {ɐ
			if (aCount > NUM_PER_DIRECTION) aCount = NUM_PER_DIRECTION;
			
			if (aSum != aResidue) {
				if (aSum - aCount < aResidue) {
					aCount = 1;
				}
				else {
					continue;
				}
			}
			
			if (0 == inInfo.mRec.mOpposite[i].mCount) {
				aRet |= buildBridge(inInfo.mRec, aCount, i);
				aSum -= aCount;
				aResidue -= aCount;
			}
		}
		
		return aRet;
	}

	private int getEffectiveAroundMax(SolverInfo inInfo) {
		int aSum = 0;
		
		// ̓ۂɓnƂ̏o鋴̑Zo
		for (int i = 0; i < DIRECTIONS.length; ++i) {
			if (null == inInfo.mAroundPos[i]) continue;
			
			SolverRecord aAgainstRec = getSolverRecord(inInfo.mAroundPos[i]);
			
			int aCount = aAgainstRec.mMaxBuildCount;
			
			for (int j = 0; j < DIRECTIONS.length; ++j) {
				if (null != aAgainstRec.mOpposite[j] 
						&& inInfo.mRec.mOpposite[i] != aAgainstRec.mOpposite[j])
				{
					aCount -= aAgainstRec.mOpposite[j].mCount;
				}
			}
			// Pɓn鋴̖{ő NUM_PER_DIRECTION {ɐ
			if (aCount > NUM_PER_DIRECTION) aCount = NUM_PER_DIRECTION;
			
			aSum += aCount;
		}
		
		return aSum;
	}
	
	private SolverRecord getSolverRecord(Point inPos) {
		if (mRecords.containsKey(inPos)) {
			return (SolverRecord)mRecords.get(inPos);
		}
		else {
			if (mModel.isNumberAt(inPos.x, inPos.y)) {
				// mappingĂȂꍇArecord\zAmapperɓo^B
				// ŁA\zCX^XԂ
				int aCount = Integer.MIN_VALUE;
				Point aPos = new Point(inPos);
				
				try {
					aCount = Integer.parseInt(StateManager.getInstance().
								findIdentityOf(mModel.getCurStateAt(aPos.x, aPos.y)));
				}
				catch (NumberFormatException e) {
					throw new IllegalStateException(
						"The simbol of Number State cannot be parsed as integer."
					);
				}
					
				SolverRecord aRec = new SolverRecord(mRecords.size(), aPos, aCount);
				
				mRecords.put(aPos, aRec);
				
				return aRec;
			}
		}
		
		throw new IllegalArgumentException(
			"The state of specified position isnot NumberState"
			+ " (pos : x = " + inPos.x + ", y = " + inPos.y + ")"
		);
	}
	
	private boolean isBuild(Point inStart, Direction inDir, Point outOpposite) {
		Point aPos = new Point(inStart);
		
		Point aDiff = inDir.getDifference();
		aPos.translate(aDiff.x, aDiff.y);
		
		if (! mModel.contains(aPos.x, aPos.y)) return false;
		
		while (mModel.contains(aPos.x, aPos.y)) {
			if (mModel.isNumberAt(aPos.x, aPos.y)) {
				outOpposite.setLocation(aPos.x, aPos.y);
				
				return true;
			}
			
			StateEventCode aCode = HashikakeStateEventCode.createParallelCode(inDir);
			if (! mModel.isTransitAt(aPos.x, aPos.y, aCode)) {
				return false;
			}
			
			aPos.translate(aDiff.x, aDiff.y);
		}
		
		return false;
	}
	
	private boolean isStartState(State inState) {
		return inState == sStartState;
	}
	
	private boolean isFinishedState(State inState) {
		return inState == sFinishedState;
	}
	
	private boolean isDisableState(State inState) {
		return inState == sBuildDisableState;
	}
	
	private boolean isProcessState(State inState) {
		return inState == sProcessingState;
	}
	
	private boolean buildBridge(SolverRecord inRec, final int inCount, final int inIndex) {
		Point aPos = new Point(inRec.mPos);
		
		OppositeRecord aOppRec = inRec.mOpposite[inIndex];
		
		// ˋłȂꍇ
		if (null == aOppRec) return false;
		
		// ȏ㋴˂邱ƂoȂꍇ
		if (isFinishedState(aOppRec.mState)) return false;
		
		// ˋ{ɕωȂꍇ
		if (inCount == aOppRec.mCount) return false;
		
		Direction aDirection = DIRECTIONS[inIndex];
		
		StateEventCode aCode = HashikakeStateEventCode.createParallelCode(aDirection);
		
		Point aDiff = aDirection.getDifference();
		aPos.translate(aDiff.x, aDiff.y);
		
		while (! mModel.isNumberAt(aPos.x, aPos.y)) {
			for (int aCount = aOppRec.mCount; aCount < inCount; ++aCount) {
				mModel.nextStateAt(aPos.x, aPos.y, aCode);
			}
			
			aPos.translate(aDiff.x, aDiff.y);
		}
		
		// ˋ{̍XV
		aOppRec.mCount = inCount;
		
		// Ί݂̍XV
		SolverRecord aAgainstRec = getSolverRecord(aPos);
		addChainMap(inRec, aAgainstRec);
		updateSolverRecord(aAgainstRec);


		
		return true;
	}

	private void addChainMap(SolverRecord inRec, SolverRecord inAgainstRec) {
		if (inRec.mQueueRef == inAgainstRec.mQueueRef) return;
		
		Integer aRefID = new Integer(inRec.mQueueRef);
		java.util.List aList = getChainList(aRefID, inRec);
		
		Integer aAgainstRefID = new Integer(inAgainstRec.mQueueRef);
		java.util.List aAgainstList = getChainList(aAgainstRefID, inAgainstRec);
		
		if (inRec.mQueueRef < inAgainstRec.mQueueRef) {
			margeChainList(aList, aAgainstList, aRefID);
			mChainMap.remove(aAgainstRefID);
		}
		else {
			margeChainList(aAgainstList, aList, aAgainstRefID);
			mChainMap.remove(aRefID);
		}
	}
	
	private java.util.List getChainList(Integer inKey, SolverRecord inRec) {
		java.util.List aList = (java.util.List)mChainMap.get(inKey);
		if (null == aList) {
			aList = new java.util.LinkedList();
			aList.add(inRec);
			mChainMap.put(inKey, aList);
		}
		
		return aList;
	}
	
	private void margeChainList(java.util.List inList1, java.util.List inList2, Integer inKey) {
		final int aRefID = inKey.intValue();
		
		while (! inList2.isEmpty()) {
			SolverRecord aRec = (SolverRecord)inList2.remove(0);
			aRec.mQueueRef = aRefID;
			inList1.add(aRec);
		}
		
		mChainMap.put(inKey, inList1);
	}
	
	private void removeChainMap(SolverRecord inRec) {
		Integer aRefID = new Integer(inRec.mQueueRef);
		java.util.List aList = (java.util.List)mChainMap.get(aRefID);
		
		if (null == aList) return;
		
		aList.remove(inRec);
		
		if (mChainMap.size() > 1 && aList.isEmpty()) {
			throw new IllegalStateException(
				"The building bridge has separated."
			);
		}
	}
	
	private void updateSolverRecord(SolverRecord inRec) {
		if (isFinishedState(inRec.mState)) {
			return;
		}
		
		if (isStartState(inRec.mState)) {
			initSolverRecord(inRec);
		}
		
		int aSum =0;
		
		Point aOpposite = new Point();
		for (int i = 0; i < DIRECTIONS.length; ++i) {
			aOpposite.setLocation(Integer.MIN_VALUE, Integer.MIN_VALUE);
			
			OppositeRecord aOppRec = inRec.mOpposite[i];
			if (isBuild(inRec.mPos, DIRECTIONS[i], aOpposite)) {
				SolverRecord aAgainstRec = getSolverRecord(aOpposite);
				
				if (null == aOppRec) {
					if (! isFinishedState(aAgainstRec.mState)) {
						initOppositeRecord(inRec, aAgainstRec, i);
					}
				}
				else {
					if (isDisableState(aOppRec.mState)) {
						if (isFinishedState(aAgainstRec.mState)) {							
							inRec.mOpposite[i] = aOppRec = null;
							--inRec.mOppositeCount;
//							inRec.mPenalty /= 2;
						}
						else {
							initOppositeRecord(inRec, aAgainstRec, i);
						}
					} 
					else if(isProcessState(aOppRec.mState)) {
						if (isFinishedState(aAgainstRec.mState)) {
							inRec.mResidue -= aOppRec.mCount;
							--inRec.mOppositeCount;
							
							aOppRec.mState = sFinishedState;
//							inRec.mPenalty /= 2;
						}
					}
				}
			}
			else {
				if (null != aOppRec) {
					inRec.mOpposite[i] = aOppRec = null; 
					--inRec.mOppositeCount; 
				}
				
				continue;
			}
			
			SolverRecord aAgainstRec = getSolverRecord(aOpposite);
			
			if (null == aOppRec || isDisableState(aOppRec.mState)) continue;
			if (isFinishedState(aOppRec.mState)) continue;
			
			updateOppositeRecord(inRec, aAgainstRec, aOppRec);
			
			if (! isFinishedState(aOppRec.mState)) {
				aSum += aOppRec.mCount;
			}
		}
		
		if (aSum == inRec.mResidue
				|| 0 == inRec.mOppositeCount
				|| 0 == inRec.mResidue) 
		{
			finalizeOppositeRecordAll(inRec);
		}
	}
	
	private void finalizeOppositeRecordAll(SolverRecord inRec) {
		inRec.mResidue = 0;
		inRec.mState = sFinishedState;
				
		for (int i = 0; i < DIRECTIONS.length; ++i) {
			finalizeOppositeRecord(inRec, i);
		}
		
		removeChainMap(inRec);
//		mQueue.remove(inRec);
	}
	
	private void finalizeOppositeRecord(SolverRecord inRec, final int inIndex) {
		if (null != inRec.mOpposite[inIndex]) {
			if (isStartState(inRec.mOpposite[inIndex].mState)) {
				// OppositeRecordˋsԂɑJڂ
				inRec.mOpposite[inIndex].mState = sBuildDisableState;
				
				inRec.mOpposite[inIndex] = null;
			}
			else if (isFinishedState(inRec.mOpposite[inIndex].mState)) {
				return;
			}
			
			--inRec.mOppositeCount;
		}
	}
	
	private void updateOppositeRecord(
						SolverRecord inRec, SolverRecord inAgainst, 
						OppositeRecord inOppRec) 
	{
		if (isFinishedState(inOppRec.mState)) return;
		
		if (NUM_PER_DIRECTION == inOppRec.mCount) {
			inOppRec.mState = sFinishedState;
			
			{
				inRec.mResidue -= inOppRec.mCount;
				--inRec.mOppositeCount;
				
//				inAgainst.mPenalty /= 2;
			}
			
			{
				inAgainst.mResidue -= inOppRec.mCount;
				--inAgainst.mOppositeCount;
				
//				inAgainst.mPenalty /= 2;
			}
		}
		else if (0 < inOppRec.mCount) {
			inOppRec.mState = sProcessingState;
		}
	}
	
	private void initSolverRecord(SolverRecord inRec) {
		Point aOpposite = new Point();
		
		for (int i = 0; i < DIRECTIONS.length; ++i) {
			if (null != inRec.mOpposite[i]) continue;
			
			if (isBuild(inRec.mPos, DIRECTIONS[i], aOpposite)) {
				SolverRecord aAgainstRec = getSolverRecord(aOpposite);
				initOppositeRecord(inRec, aAgainstRec, i);
			}
		}
		
		inRec.mState = sProcessingState;
	}
	
	private void initOppositeRecord(
					SolverRecord inRec, SolverRecord inAgainst, 
					final int inIndex) 
	{
		Direction aInverse
			 = UtilityFuncs.inverseDirection(DIRECTIONS[inIndex]);
		final int aIndex = getDirectionToIndex(aInverse);
		
		OppositeRecord aOppRec = inAgainst.mOpposite[aIndex];
		
		if (null == aOppRec) {
			aOppRec = new OppositeRecord();
			
			inAgainst.mOpposite[aIndex] = aOppRec;
			++inAgainst.mOppositeCount;	
		}
		
		inRec.mOpposite[inIndex] = aOppRec;
		++inRec.mOppositeCount;	
	}
	
	private int getDirectionToIndex(Direction inDirection) {
		for (int i = 0; i < DIRECTIONS.length; ++i) {
			if (DIRECTIONS[i] == inDirection) return i;
		}
		
		throw new IllegalArgumentException(
			"Direction, " + inDirection + "is illegal."
		);
	}
	
	private int getAroundMax(SolverRecord inRec, Point[] outAgainstPos) {
		int aSum = 0;
		
		for (int i = 0; i < DIRECTIONS.length; ++i) {
			if (null == inRec.mOpposite[i]
					 || isFinishedState(inRec.mOpposite[i].mState))
			{
				continue;
			}
			
			Point aOpposite = new Point();
			if (isBuild(inRec.mPos, DIRECTIONS[i], aOpposite)) {
				SolverRecord aAgainstRec = getSolverRecord(aOpposite);
				
				aSum += aAgainstRec.mResidue;
				
				outAgainstPos[i] = aOpposite;
			}
		}
		
		return aSum;
	}
	
	/**
	 *	΂ɉˋȂ̃CfbNXԂ
	 *	ȂꍇAInteger.MIN_VALUEԂ
	 */
	private int getMustConnectDirectionIndex(SolverRecord inRec) {
		Point[] aOpposites = new Point[DIRECTIONS.length];
		
		final int aSum = getAroundMax(inRec, aOpposites);
		
		for (int i = 0; i < DIRECTIONS.length; ++i) {
			if (null == aOpposites[i]) continue;
			
			SolverRecord aAgainstRec = getSolverRecord(aOpposites[i]);
			
			if (aSum - aAgainstRec.mResidue <= inRec.mResidue) {
				if (0 == inRec.mOpposite[i].mCount) {
					return i;
				}
			}
		}
		
		return Integer.MIN_VALUE;
	}
	
	private static class ProcessState implements State {
		public State onEnter(StateEventCode inEvent) {
			return this;
		}
	}
	
	private static class StartState implements State {
		public State onEnter(StateEventCode inEvent) {
			return this;
		}
	}
	
	private static class DisableState implements State {
		public State onEnter(StateEventCode inEvent) {
			return this;
		}
	}
	
	private static class FinishState implements State {
		public State onEnter(StateEventCode inEvent) {
			return this;
		}
	}
}