//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		SolverRI_2.java
//	DATE:		2003.7.10
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental;

import java.awt.Point;

import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.HashikakeStateManagerImpl;

import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SearchListener;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolveDiscompleteException;

public class SolverRI_2 implements SolverHandler {
	class OppositeRecord {
		int mCount; // ݉ˋĂ鋴̐
		Point mPos;
		Direction mDir;
		State mState = sStartState;
		
		OppositeRecord(Point inPos, Direction inDir) {
			mPos = inPos;
			mDir = inDir;
		}
	}
	
	class SolverRecord {
		Point mPos;
		final int mMaxBuildCount;
		int mResidue;
		int mMaxOppositeCount;
		int mOppositeCount;
		OppositeRecord[] mOpposite = new OppositeRecord[DIRECTIONS.length];
		State mState = sStartState;
		
		SolverRecord(Point inPos, final int inCount) {
			mPos = inPos;
			mMaxBuildCount = mResidue = inCount;
		}
	}

/*	
	private static final State sStartState = new ProcessState();
	private static final State sProcessingState = new ProcessState();
	private static final State sBuildDisable = new ProcessState();
	private static final State sFinishedState = new ProcessState();
*/

	private static final State sStartState = new StartState();
	private static final State sProcessingState = new ProcessState();
	private static final State sBuildDisable = new DisableState();
	private static final State sFinishedState = new FinishState();

	// ɂ邱Ƃ̂ł鋴̍ő{
	private static final int NUM_PER_DIRECTION = 2;

	private java.util.Map mRecords;
	private java.util.List mQueue;
	
	private Model mModel;
	
	/** ̏W */
	private static final Direction[] DIRECTIONS = {
		Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, 
	};
	
	public SolverRI_2(Model inModel) {
		mModel = inModel;
	}
	
	public void reset() {
		mQueue = new java.util.LinkedList();
		mRecords = new java.util.HashMap(); 
		
		for (int y = 0; y < mModel.getHeight(); ++y) {
			for (int x = 0; x < mModel.getWidth(); ++x) {				
				Point aPos = new Point(x, y);
				
				if (mModel.isNumberAt(x, y)) {
					mQueue.add(aPos);
					
					int aCount = 0;
					try {
						aCount = Integer.parseInt(StateManager.getInstance().
									findIdentityOf(mModel.getCurStateAt(aPos.x, aPos.y)));
						
						SolverRecord aRec = new SolverRecord(aPos, aCount);
						initSolverRecord(aRec);
						
						mRecords.put(aPos, aRec);
					}
					catch (NumberFormatException e) {
						throw new IllegalStateException(
							"The simbol of Number State cannot be parsed as integer."
						);
					}
	
				}
			}
		}
	}
	
	public boolean isSolute() {
		return mQueue.isEmpty();
	}
	
	public void nextSolute() {
		if (isSolute()) return;
		
		Point aPos = (Point)mQueue.remove(0);
		attemptBuild(aPos.x, aPos.y);
	}
	
	public void nextSoluteAll() throws SolveDiscompleteException {
			// QueuȅꍇA𓚂ꂽƔf
			if (mQueue.isEmpty()) return;
			
			// ˋłȂ
			int aCount = 0;
			do {
				Point aPos = (Point)mQueue.remove(0);
				
				if (! attemptBuild(aPos.x, aPos.y)) {
					// ˋłȂQueueTCYɓB_
					// ȏ𓚂i߂邱ƂłȂƔf
					if (mQueue.size() == ++aCount) {
						throw new SolveDiscompleteException(mQueue.size());
					}
				}
				else {
					aCount = 0;
				}
			} while (! isSolute());	
	}
	private boolean attemptBuild(final int inX, final int inY) {
		Point aPos = new Point(inX, inY);
		
		SolverRecord aRec = getSolverRecord(aPos);
		
		boolean aRet = false;
		do {
			updateSolverRecord(aRec);
			
			if (isFinishedState(aRec.mState)) return true;
			
			aRet = false;

			if (available_1(aRec)) {
				// ɂ{
	//			final int aNumPerDir = NUM_PER_DIRECTION - aNum % (aOppositeCount *2);
				int aNumPerDir = NUM_PER_DIRECTION - (aRec.mOppositeCount * NUM_PER_DIRECTION - aRec.mResidue);
					
				for (int i = 0; i < aRec.mMaxOppositeCount; ++i) {
					aRet |= buildBridge(aRec, aNumPerDir, i);
				}
			}
			else if (available_2(aRec)) {
				final int aSum = accumulateAroundMax(aRec);
				
				for (int i = 0; i < aRec.mMaxOppositeCount; ++i) {
					if (isFinishedState(aRec.mOpposite[i].mState)) continue;
					
					SolverRecord aAgainstRec = getSolverRecord(aRec.mOpposite[i].mPos);
					final int aCount = aAgainstRec.mMaxBuildCount;
					
					if (aSum - aCount <= aRec.mResidue) {
						aRet |= buildBridge(aRec, 1, i);
					}
				}
				
			}
		}
		while (aRet);
		
		if (! isFinishedState(aRec.mState)) {
			mQueue.add(aPos);
		}
		
		return aRet;
	}

	private SolverRecord getSolverRecord(Point inPos) {
		SolverRecord aSolverRec = getSolverRecordSub(inPos);
		
		initSolverRecord(aSolverRec);
		
		return aSolverRec;
	}
	
	private void initSolverRecord(SolverRecord ioRec) {
		// \zꂽ΂̏Ԃ̏ꍇ
		// Ŏ͂̏󋵂W
		if (isStartState(ioRec.mState)) {
			for (int i = 0; i < DIRECTIONS.length; ++i) {
				Point aOpposite = new Point();
				
				if (isBuild(ioRec.mPos, DIRECTIONS[i], aOpposite)) {
					OppositeRecord aOppRec = new OppositeRecord(aOpposite, DIRECTIONS[i]);
					ioRec.mOpposite[ioRec.mMaxOppositeCount] = aOppRec;
					++ioRec.mMaxOppositeCount;
				}
			}
			
			ioRec.mOppositeCount = ioRec.mMaxOppositeCount;
			ioRec.mState = sProcessingState;
		}
	}
	
	private SolverRecord getSolverRecordSub(Point inPos) {
		if (! mRecords.containsKey(inPos)) {
			throw new IllegalArgumentException(
				"The state of specified position isnot NumberState"
				+ " (pos : x = " + inPos.x + ", y = " + inPos.y + ")"
			);
		}
		
		return (SolverRecord)mRecords.get(inPos);
	}
	
	private boolean available_1(SolverRecord inRec) {
		final int aResidue = inRec.mResidue;
		final int aOpposite = inRec.mOppositeCount;
		
		return (NUM_PER_DIRECTION > (aOpposite * NUM_PER_DIRECTION) - aResidue);
	}
	
	private boolean available_2(SolverRecord inRec) {
		// ˋ2ȏ゠ꍇ́Ȁł͉ˋȂ
		return (2 < inRec.mOppositeCount) ? false : true;
	}
	
	private boolean isBuild(Point inStart, Direction inDir, Point outOpposite) {
		Point aPos = new Point(inStart);
		
		Point aDiff = inDir.getDifference();
		aPos.translate(aDiff.x, aDiff.y);
		
		if (! mModel.contains(aPos.x, aPos.y)) return false;
		
		while (mModel.contains(aPos.x, aPos.y)) {
			if (mModel.isNumberAt(aPos.x, aPos.y)) {
				outOpposite.setLocation(aPos.x, aPos.y);
				
				return true;
			}
			
			StateEventCode aCode = HashikakeStateEventCode.createParallelCode(inDir);
			if (! mModel.isTransitAt(aPos.x, aPos.y, aCode)) {
				return false;
			}
			
			aPos.translate(aDiff.x, aDiff.y);
		}
		
		return false;
	}
	
	private boolean isStartState(State inState) {
		return inState == sStartState;
	}
	
	private boolean isFinishedState(State inState) {
		return inState == sFinishedState;
	}
	
	private boolean isDisableState(State inState) {
		return inState == sBuildDisable;
	}
	
	private boolean buildBridge(SolverRecord inRec, final int inCount, final int inIndex) {
		Point aPos = new Point(inRec.mPos);
		
		Direction aDir = inRec.mOpposite[inIndex].mDir;
		Point aDiff = aDir.getDifference();
		aPos.translate(aDiff.x, aDiff.y);
		
		OppositeRecord aOppRec = getOppositeRecord(inRec, aDir);
		
		// ȏ㋴˂邱ƂoȂꍇ
		if (isFinishedState(aOppRec.mState)) return false;
		if (isDisableState(aOppRec.mState)) return false;
		
		// ˋ{ɕωȂꍇ
		if (inCount == aOppRec.mCount) return false;
		
		StateEventCode aCode = HashikakeStateEventCode.createParallelCode(aDir);
		
		while (! aPos.equals(aOppRec.mPos)) {
			for (int aCount = aOppRec.mCount; aCount < inCount; ++aCount) {
				mModel.nextStateAt(aPos.x, aPos.y, aCode);
			}
			
			aPos.translate(aDiff.x, aDiff.y);
		}
		
		// ˋ{̍XV
		aOppRec.mCount = inCount;
		
		SolverRecord aAgainstRec = getSolverRecord(aOppRec.mPos);
		
		// Ί݂̍XV
		updateSolverRecord(aAgainstRec);
		
		// K{̋˂ꂽꍇAԂJڂ
		if (NUM_PER_DIRECTION == inCount 
			|| 0 == aAgainstRec.mResidue
			|| inCount == inRec.mResidue) 
		{
			aOppRec.mState = sFinishedState;
			
			inRec.mResidue -= inCount;
			--inRec.mOppositeCount;
			if (inRec.mResidue == 0) {
				inRec.mState = sFinishedState;
			}
		}
		
		return true;
	}
	
	private void updateSolverRecord(SolverRecord inRecord) {
		Point aDummy = new Point();
		int aSum = 0; // IԂłȂ̗݌v
		
		for (int i = 0; i < inRecord.mMaxOppositeCount; ++i) {
			OppositeRecord aOppRec = inRecord.mOpposite[i];
			
			// Ί݂IԂłꍇAȗ
			if (isFinishedState(aOppRec.mState)) continue;
			if (isDisableState(aOppRec.mState)) continue;
			
			// Ί݂ɋ˂邱ƂoȂꍇ
			// ̕IԂɂ
			if (! isBuild(inRecord.mPos, aOppRec.mDir, aDummy)) {
				aOppRec.mState = sBuildDisable;
				--inRecord.mOppositeCount;
				continue;
			}
			
			SolverRecord aAgainstRec = getSolverRecord(aOppRec.mPos);
			
			if (isDisableState(aAgainstRec.mState)) continue;
			
			if (! isStartState(aAgainstRec.mState)) {
				// Ί݂ˋĂꍇAˋ\{炷
				Direction aInverse
						 = UtilityFuncs.inverseDirection(aOppRec.mDir);
				OppositeRecord aAgainstOppRec = getOppositeRecord(aAgainstRec, aInverse);
			
				if (isFinishedState(aAgainstOppRec.mState))
				{
					// Ί݂̏󋵂XV
					aOppRec.mState = sFinishedState;
					aOppRec.mCount = aAgainstOppRec.mCount;
					
					// SolverRecordXV
					inRecord.mResidue -= aOppRec.mCount;
					--inRecord.mOppositeCount;
			
					if (0 == inRecord.mResidue) {
						inRecord.mState = sFinishedState;
					}
				}
				else if (isFinishedState(aAgainstRec.mState))
				{
					// Ί݂IԂłƂ
					aOppRec.mState = sFinishedState;
					--inRecord.mOppositeCount;
					inRecord.mResidue -= aOppRec.mCount;
				}
				else {
					aOppRec.mCount = aAgainstOppRec.mCount;
					
					if (isFinishedState(inRecord.mState)) {
						aOppRec.mState = sBuildDisable;
					}
					else {
						aOppRec.mState = sProcessingState;
					}
					
					aSum += aOppRec.mCount;
				}
			}
		}
	}	

	private OppositeRecord getOppositeRecord(SolverRecord inRec, Direction inDir) {
		for (int i = 0; i < inRec.mMaxOppositeCount; ++i) {
			if (inRec.mOpposite[i].mDir == inDir) {
				return inRec.mOpposite[i];
			}
		}
		
		return null;
	}

	private int accumulateAroundMax(SolverRecord inRec) {
		int aSum = 0;
		for (int i = 0; i < inRec.mMaxOppositeCount; ++i) {
			if (! (isFinishedState(inRec.mOpposite[i].mState)
				|| isDisableState(inRec.mOpposite[i].mState)))
			{
				SolverRecord aAgainstRec
						= getSolverRecord(inRec.mOpposite[i].mPos);
				updateSolverRecord(aAgainstRec);
				
				aSum += aAgainstRec.mMaxBuildCount;
			}
		}
		
		return aSum;	
	}
	
	private static class ProcessState implements State {
		public State onEnter(StateEventCode inEvent) {
			return this;
		}
	}
	
	private static class StartState implements State {
		public State onEnter(StateEventCode inEvent) {
			return this;
		}
	}
	
	private static class DisableState implements State {
		public State onEnter(StateEventCode inEvent) {
			return this;
		}
	}
	
	private static class FinishState implements State {
		public State onEnter(StateEventCode inEvent) {
			return this;
		}
	}
}