//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		SolverRI_1.java
//	DATE:		2003.7.10
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental;

import java.awt.Point;

import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.HashikakeStateManagerImpl;

import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SearchListener;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolveDiscompleteException;

public class SolverRI_1 implements SolverHandler {
	// ɂ邱Ƃ̂ł鋴̍ő{
	private static final int NUM_PER_DIRECTION = 2;
	
	private static class CheckRecord {
		State mState = sStartState;
		int mResidueBridgeCount;
		int mCurBridgeCount;
		final int mMaxBridgeCount;
		Point mPos;
		int[] mEachCount;
		
		private CheckRecord(final int inCount, Point inPos) {
			mMaxBridgeCount = inCount;
			mResidueBridgeCount = inCount;
			mPos = inPos;
		}
		
		static CheckRecord createIslandRecord(final int inCount, Point inPos) {
			CheckRecord aRec =  new CheckRecord(inCount, inPos);
			aRec.mEachCount = new int[DIRECTIONS.length];
			
			return aRec;
		}
		
		static CheckRecord createBridgeRecord(Point inPos) {
			return new CheckRecord(NUM_PER_DIRECTION, inPos);
		}
	}
	
	private Model mModel;
	
	private java.util.Map mCheckedMap = new java.util.HashMap();
	
	/** List<Point> */
	private java.util.List mQueue;
	
	private static State sStartState = new StartState();
	private static State sProcessingState = new ProcessState();
	private static State sFinishState = new FinishState();
	
	/** ̏W */
	private static final Direction[] DIRECTIONS = {
		Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, 
	};

	public SolverRI_1(Model inModel) {
		mModel = inModel;
	}
	
	private int toIndex(final int inX, final int inY) {
		return inY * mModel.getWidth() + inX;
	}
	
	public void reset() {
		mQueue = new java.util.LinkedList();
		
		for (int y = 0; y < mModel.getWidth(); ++y) {
			for (int x = 0; x < mModel.getHeight(); ++x) {				
				Point aPos = new Point(x, y);
				
				if (mModel.isNumberAt(x, y)) {
					mQueue.add(aPos);
					
					int aCount = 0;
					try {
						aCount = Integer.parseInt(StateManager.getInstance().
									findIdentityOf(mModel.getCurStateAt(aPos.x, aPos.y)));
					}
					catch (NumberFormatException e) {
						throw new IllegalStateException(
							"The simbol of Number State cannot be parsed as integer."
						);
					}
	
					mCheckedMap.put(aPos, CheckRecord.createIslandRecord(aCount, aPos));
				}
				else if (mModel.isSpaceAt(x, y)) {
					mCheckedMap.put(aPos, CheckRecord.createBridgeRecord(aPos));
				}
			}
		}
	}

	public void nextSolute() {
		if (isSolute()) return;
		
		Point aPos = (Point)mQueue.remove(0);
		attemptBuild(aPos.x, aPos.y);
	}
	
	private boolean isFinished(Point inPos) {
		CheckRecord aRec = (CheckRecord)mCheckedMap.get(inPos);
		
		return isFinishedState(aRec.mState);
	}
	
	private boolean isProcessingState(State inState) {		
		return (inState instanceof ProcessState);
	}
	
	private boolean isFinishedState(State inState) {
		return (inState instanceof FinishState);
	}
	
	private boolean isStartState(State inState) {
		return (inState instanceof StartState);
	}
	
	private boolean attemptBuild(final int inX, final int inY) {
		
		Point aPos = new Point(inX, inY);
		
		int aOppositeCount = 0;
		int[] aIndicies = new int[DIRECTIONS.length];
		
		// Ί݂T
		
		for (int i = 0; i < DIRECTIONS.length; ++i) {
			if (isBuild(aPos, DIRECTIONS[i], i)) {
				aIndicies[aOppositeCount++] = i;
			}
		}
		
		// ˋ\ȋ̎c擾
		CheckRecord aRec = (CheckRecord)mCheckedMap.get(aPos);
//		int aMaxNum = aRec.mMaxBridgeCount;
		int aResNum = aRec.mResidueBridgeCount;
		
		
		boolean aRet = false;
		
		if (NUM_PER_DIRECTION > (aOppositeCount * NUM_PER_DIRECTION) - aResNum) 
		{
			// ɂ{
//			final int aNumPerDir = NUM_PER_DIRECTION - aNum % (aOppositeCount *2);
			int aNumPerDir = NUM_PER_DIRECTION - (aOppositeCount * NUM_PER_DIRECTION - aResNum);
				
			boolean aFilled = (aResNum == aOppositeCount * aNumPerDir);
			
			for (int i = 0; i < aOppositeCount; ++i) {
				final int aIndex = aIndicies[i];
				buildBridge(aPos, DIRECTIONS[aIndex], aIndex, aNumPerDir, aFilled);
			}
			
			
			aRet = true;
		}
		
		if (! isFinished(aPos)) {
			// ˂肫ĂȂꍇ́ÄʒuQueueɖ߂
			mQueue.add(aPos);
		}

		return aRet;
	}
	
	private boolean isBuild(Point inPos, Direction inDir, final int inIndex) {
		Point aPos = new Point(inPos);
		
		Point aDiff = inDir.getDifference();
		aPos.translate(aDiff.x, aDiff.y);
		
		if (! mModel.contains(aPos.x, aPos.y)) return false;
		
		// Ɏw肵ɍő{̋Ăꍇ́AsƂ
		State aState = mModel.getCurStateAt(aPos.x, aPos.y);
		int aCount = HashikakeStateManagerImpl.countBridge(aState);

/*
		if (aCount == NUM_PER_DIRECTION) {
			return false;
		}
*/
			
		while (mModel.contains(aPos.x, aPos.y)) {
			if (mModel.isNumberAt(aPos.x, aPos.y)) {
				boolean aRet = isFinished(aPos);
				
				// XVfĂȂꍇAōXV
				CheckRecord aRec = (CheckRecord)mCheckedMap.get(aPos);
				if (aRet && isFinishedState(aRec.mState) && 0 < aCount) {
					updateRecordLatter(inPos, aCount, inIndex);
				}
				
				return !aRet;
			}
			
			StateEventCode aCode = HashikakeStateEventCode.createParallelCode(inDir);
			if (! mModel.isTransitAt(aPos.x, aPos.y, aCode)) {
				return false;
			}
			
			aPos.translate(aDiff.x, aDiff.y);
		}
		
		return false;
	}
	
	private void buildBridge(Point inPos, Direction inDir, final int inDirIndex, final int inCount, final boolean inFilled) {
		Point aPos = new Point(inPos);
		Point aDiff = inDir.getDifference();
		aPos.translate(aDiff.x, aDiff.y);
		
		CheckRecord aRec = (CheckRecord)mCheckedMap.get(aPos);
		
		// Kv{
		final int aCount = inCount - (aRec.mMaxBridgeCount - aRec.mResidueBridgeCount);
		
		// ύXȂꍇ́ȀŔ
		if (0 == aCount) return;
		
		StateEventCode aCode = HashikakeStateEventCode.createParallelCode(inDir);

		while (mModel.contains(aPos.x, aPos.y) && ! mModel.isNumberAt(aPos.x, aPos.y)) {
			for (int i = aCount; i > 0; --i) {
				mModel.nextStateAt(aPos.x, aPos.y, aCode);
			}
			
			updateBridgeRecord(aPos, aCount);
			
			aPos.translate(aDiff.x, aDiff.y);
		}
		
		// ݂̏ԂXV
		
		updateOppositeRecord(aPos, inCount, aCount, inDirIndex, inFilled);
		
		updateRecord(inPos, inCount, aCount, inDirIndex, inFilled);
	}
	
	private boolean updateRecordSub(
				CheckRecord inRec, final int inCount, final int inDiffCount, 
				final boolean inFilled, final boolean inUpdateLatter) 
	{
		boolean aRet = inFilled;
		
		CheckRecord aRec = inRec;
		
		
		if (! inUpdateLatter) {
			// ۂɉˋꂽ{XV
			aRec.mCurBridgeCount += inDiffCount;
		}
		
		if (aRec.mCurBridgeCount != aRec.mMaxBridgeCount) 
		{
			aRec.mState = sProcessingState;
		}
		else {
			// ׂ̓̋ĉ˂ꍇ
			aRec.mState = sFinishState;
			
			// ܂AQueueɎcĂꍇAQueue甲B
			final int aIndex = mQueue.indexOf(aRec.mPos);
			if (0 <= aIndex) {
				mQueue.remove(aIndex);
			}
		}
		
		return aRet;
	}
	
	private boolean updateRecord(
				Point inPos, final int inCount, final int inDiffCount, 
				final int inDirIndex, final boolean inFilled) 
	{
		CheckRecord aRec = (CheckRecord)mCheckedMap.get(inPos);
		
		if (inFilled) {
				final int aOldCount = aRec.mEachCount[inDirIndex];
				if (aOldCount != inCount) {
					aRec.mEachCount[inDirIndex] = inCount;
				aRec.mResidueBridgeCount -= inCount;
				}
				
			if (0 > aRec.mResidueBridgeCount) {
				throw new IllegalStateException("negative error at : " + inPos);
			}
		}
		
		return updateRecordSub(aRec, inCount, inDiffCount, inFilled, false);
	}
	
	private boolean updateBridgeRecord(Point inPos, final int inDiffCount) {
		CheckRecord aRec = (CheckRecord)mCheckedMap.get(inPos);
		
		aRec.mResidueBridgeCount -= inDiffCount;
			if (0 > aRec.mResidueBridgeCount) {
				throw new IllegalStateException("negative error at : " + inPos);
			}

		return updateRecordSub(aRec, inDiffCount, inDiffCount, true, false);
	}
	
	private boolean updateRecordLatter(Point inPos, final int inCount, final int inDirIndex) {
		CheckRecord aRec = (CheckRecord)mCheckedMap.get(inPos);

/*		
		// ̏ł͗}Ȃ
		// {IȌKv
		if (aRec.mMaxBridgeCount != aRec.mResidueBridgeCount + aRec.mCurBridgeCount) {
*/		
			final int aOldCount = aRec.mEachCount[inDirIndex];
			if (aOldCount != inCount) {
				aRec.mEachCount[inDirIndex] = inCount;
				aRec.mResidueBridgeCount -= inCount;
			}
			if (0 > aRec.mResidueBridgeCount) {
				throw new IllegalStateException("negative error at : " + inPos);
			}
/*			
		}
*/
		
		return updateRecordSub(aRec, inCount, inCount, true, true);
	}
	
	private boolean updateOppositeRecord(
			Point inPos, final int inCount, final int inDiffCount, 
			final int inDirIndex, final boolean inFilled) 
	{
		CheckRecord aRec = (CheckRecord)mCheckedMap.get(inPos);
		
		boolean aFilled = inFilled;
		
		if (! inFilled) {
			if (inCount == aRec.mCurBridgeCount - aRec.mMaxBridgeCount) {
				aRec.mResidueBridgeCount -= inCount;
				if (0 > aRec.mResidueBridgeCount) {
					throw new IllegalStateException("negative error at : " + inPos);
				}
				aFilled = true;
			}
		}

		return updateRecordSub(aRec, inCount, inDiffCount, aFilled, false);
	}
	
	public void nextSoluteAll() throws SolveDiscompleteException {
			// QueuȅꍇA𓚂ꂽƔf
			if (mQueue.isEmpty()) return;
			
			// ˋłȂ
			int aCount = 0;
			do {
				Point aPos = (Point)mQueue.remove(0);
				
				if (! attemptBuild(aPos.x, aPos.y)) {
					// ˋłȂQueueTCYɓB_
					// ȏ𓚂i߂邱ƂłȂƔf
					if (mQueue.size() == ++aCount) {
						throw new SolveDiscompleteException(mQueue.size());
					}
				}
				else {
					aCount = 0;
				}
			} while (! isSolute());
	}
	
	public boolean isSolute() {
		return mQueue.isEmpty();
	}
	
	public void addSearchListener(SearchListener inListener) {
	}
	
	private static class StartState implements State {
		public State onEnter(StateEventCode inEvent) {
			return this;
		}
	}
	
	private static class ProcessState implements State {
		public State onEnter(StateEventCode inEvent) {
			return this;
		}
	}
	
	private static class FinishState implements State {
		public State onEnter(StateEventCode inEvent) {
			return this;
		}
	}
}