//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		Queue_2.java
//	DATE:		2003.7.22
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental;

/**
 *	q[vASYɂpriority queue
 */
class Queue_2 implements QueueIF {
	private java.util.List mContainer;
	private java.util.Comparator mComp;
	
	private int mInitialSize;
	
	public Queue_2(java.util.Comparator inComp) {
		mContainer = new java.util.ArrayList();
		mComp = inComp;
	}
	
	public void enqueue(Object inRec) {
		mContainer.add(inRec);
//		pushHeap(0, size(), mComp);
	}
	
	public Object dequeue() {
//		popHeap(0, size(), mComp);
		return mContainer.remove(0);
	}
	
	public void reset(java.util.Collection inContainer) {
		mContainer = new java.util.ArrayList();
		mContainer.addAll(inContainer);
		makeHeap();
		heapSort();
	}
	
	public boolean remove(Object inRec) {
		boolean aRemoved = mContainer.remove(inRec);
		if (aRemoved && ! isEmpty()) popHeap(0, size(), mComp);
		
		return aRemoved;
	}
	
	public void shift(Object inRec) {
//		java.util.Collections.sort(mContainer, new Not(mComp));
		if (mInitialSize < size()) {
			mInitialSize = size();
		}

		if (mInitialSize / size() < 4) {
		makeHeap();
		heapSort();
		}
	}

	
	public boolean isEmpty() {
		return mContainer.isEmpty();
	}
	
	public int size() {
		return mContainer.size();
	}
	
	private void pushHeap(
			final int inBegin, final int inEnd, 
			java.util.Comparator inComp) 
	{
		int aIndex = inEnd - inBegin -1;
		int aPredecessor = (aIndex-1)/2;
		
		// Ō̗vfۑ
		Object aTemp = mContainer.get(aIndex);
		
		while (aPredecessor != aIndex 
				&& 0 < inComp.compare(mContainer.get(aPredecessor), aTemp)) 
		{
			// vf𒾂܂
			mContainer.set(aIndex, mContainer.get(aPredecessor));
			
			aIndex = aPredecessor;
			aPredecessor = (aIndex-1)/2;
		}
		
		mContainer.set(aIndex, aTemp);
	}
	
	private void popHeap(
			final int inBegin, final int inEnd, 
			java.util.Comparator inComp) 
	{
		int aIndex = 0;
		int aSuccessor = 1;
		int aLastPos = inEnd - inBegin -1;
		
		// Ō̗vfۑ
		Object aTemp = mContainer.get(aLastPos);
		
		// 擪vf𖖔ɃRs[
		mContainer.set(aLastPos, mContainer.get(0));
					
		while (aSuccessor < aLastPos) {
			if (aSuccessor < aLastPos -1
				&& 0 < inComp.compare(mContainer.get(aSuccessor), mContainer.get(aSuccessor +1))) 
			{
				++aSuccessor;
			}
			
			if (0 < inComp.compare(aTemp, mContainer.get(aSuccessor))) {
				// vf𕂂
				mContainer.set(aIndex, mContainer.get(aSuccessor));			
			
				aIndex = aSuccessor;
				aSuccessor = (aIndex+1)*2 -1;
			}
			else {
				break;
			}
		}
		
		mContainer.set(aIndex, aTemp);
	}
	
	private void makeHeap() {
		for (int i = 1; i < size(); ++i) {
			pushHeap(0, i, mComp);
		}
	}
	
	private void heapSort() {
		int aSize = size();
		while (aSize > 1) {
			popHeap(0, aSize--, mComp);
		}
	}
	
	public void printQueue() {
		System.out.println("print queue entry.");
		for (int i = 0; i < size(); ++i) {
			System.out.println(mContainer.get(i));
		}
		System.out.println();
	}
}

class Not implements java.util.Comparator {
	java.util.Comparator mDecorated;
	
	public Not(java.util.Comparator inDecorated) {
		mDecorated = inDecorated;
	}
	
	public int compare(Object inLHS, Object inRHS) {
		return -(mDecorated.compare(inLHS, inRHS));
	}
}