//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		HashikakeSolverHandler.java
//	DATE:		2003.7.10
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.solver.model;

import java.awt.Point;

import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.HashikakeStateManagerImpl;

import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.*;

public class HashikakeSolverHandler implements SolverHandler {
	private SolverHandler mHandler;
	
	public HashikakeSolverHandler(Model inModel) {
//		mHandler = new SolverRI_1(inModel);
//		mHandler = new SolverRI_2(inModel);
//		mHandler = new SolverRI_3(inModel);
		mHandler = new SolverRI_4(inModel);
	}
	
	public void reset() {
		mHandler.reset();
	}

	public void nextSolute() {
		mHandler.nextSolute();
	}

	public void nextSoluteAll() throws SolveDiscompleteException {
		mHandler.nextSoluteAll();
	}
	
	public boolean isSolute() {
		return mHandler.isSolute();
	}
}