// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
//	NAME:		XMLProblemReader.java
//	DATE:		2003.6.2	initial version
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.io;

import java.io.FileInputStream;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.ProblemCollection;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.ProblemInfoBean;

import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;


/**
 *	XMLō쐬ꂽt@Cǂݍ
 *
 *	@see	ProblemReader
 */
public class XMLProblemReader implements ProblemReader {
	private ProblemInfo[] mProblemList;
	
	/**
	 *	w肵File蕶ǂݍ
	 *
	 *	@param	inFile	Ǎ
	 *
	 *	@throws	FileNotFoundException -- w肵t@C݂Ȃꍇ
	 *	@throws	IOException	-- t@CANZXɊւāA肪ꍇ
	 */
	public void load(java.io.File inFile) 
					throws java.io.FileNotFoundException, java.io.IOException
	{
		try {
			// CollectionƂĖǂݍ
			ProblemCollection aCollection = loadCollection(inFile);
			mProblemList = new ProblemInfo[aCollection.size()];
			
			for (int i = 0; i < mProblemList.length; ++i) {
				ProblemInfoBean aInfo = aCollection.getProblemAt(i);
				mProblemList[i] = new ProblemInfo(
					aInfo.getWidth(), aInfo.getHeight(), aInfo.getProblem().split(",")
				);
			}
		}
		catch (JiBXException e) {
//			System.out.println(e);
			throw new java.io.IOException("Unexpectied file is passed");
		}
	}
	
	/**
	 *	w肵CfbNXԖڂ̖ǂݍ
	 *
	 *	@param	inIndex	CfbNX
	 *	@retun	
	 */
	public ProblemInfo getProblemAt(final int inIndex) {
		return mProblemList[inIndex];
	}
	
	/**
	 *	w肵CfbNXԖڂ̖ǂݍ
	 *
	 *	@param	inIndex	CfbNX
	 *	@retun	
	 */
	public ProblemInfo[] getAllProblems() {
		return mProblemList;
	}
	
	/**
	 *	ǂݍ񂾖̐Ԃ
	 *
	 *	@return	ǂݍ񂾖̐
	 */
	public int size() {
		return mProblemList.length;
	}
	
	private ProblemCollection loadCollection(java.io.File inFile) 
						throws JiBXException, java.io.FileNotFoundException
	{
		IBindingFactory aFactory = 
			BindingDirectory.getFactory(ProblemCollection.class);
		
		IUnmarshallingContext aContext = 
			aFactory.createUnmarshallingContext();
		
		return (ProblemCollection)aContext.unmarshalDocument(new FileInputStream(inFile), null);
	}
	

}