// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
//	NAME:		HashiCreStateManagerImpl.java
//	DATE:		2003.7.1
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.creator.model;

import jp.gr.java_conf.ktz.puzzle.framework.StateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.framework.DecoratedStateManagerImpl;

import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.SpaceState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NumberState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.BranchState;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;

public class HashiCreStateManagerImpl extends DecoratedStateManagerImpl {
	/** 󔒂IDl */
	public final static String SPACE_ID = HashikakeStateEventCode.SPACE_ID;
	
	/** IDlƏԂ̑g}bvĂ */
	private java.util.Map mStateMap = new java.util.HashMap();
	
	/** Jڌ̏ */
	private State mTransit;
	
	/**
	 *	RXgN^
	 */
	public HashiCreStateManagerImpl() {
		this(null);
	}
	
	public HashiCreStateManagerImpl(StateManagerImpl inManager) {
		super(inManager);
		
		initTable();
		
	}
	
	private void initTable() {
		State[] aStates = {
			new SpaceState(), 
			new NumberState(1), new NumberState(2), 
			new NumberState(3), new NumberState(4), 
			new NumberState(5), new NumberState(6), 
			new NumberState(7), new NumberState(8), 
		};
		
		BranchState.TransitHint[] aHint = new BranchState.TransitHint[aStates.length];
		
		mStateMap.put(SPACE_ID, aStates[0]);
		aHint[0] = new BranchState.TransitHint(aStates[0], HashikakeStateEventCode.createSpaceCode());
		
		for (int i = 1; i < aStates.length; ++i) {
			String aStr = String.valueOf(i);
			
			mStateMap.put(aStr, aStates[i]);
			aHint[i] = new BranchState.TransitHint(aStates[i], HashikakeStateEventCode.valueOf(aStr));
		}
		
		mTransit = new BranchState(aHint);
	}
	
	/**
	 *	inStateIDlɑԂ쐬B
	 *
	 *	@param inStateID ԂɑΉID
	 *	@return inStateIDlɑԁB
	 */
	protected State createStateOfSelf(String inStateID) {
		// }bvɓo^ĂȂꍇ́AIDł邽ߗO𑗏o
		if (! mStateMap.containsKey(inStateID)) {
			throw new IllegalArgumentException("The inStateID : " + inStateID + " is illegal.");
		}
		
		return (State)mStateMap.get(inStateID);
	}
	
	
	/**
	 *	ftHg̏Ԃ쐬B
	 *	̎ł͋󔒏ԂԂB
	 *	
	 * @return ftHg
	 */
	protected State createDefaultStateSelf() {
		return createStateOfSelf(SPACE_ID);
	}
	
	/**
	 *	w肵ԂɑΉAIDԂB
	 *	́AcreateStateOf̋t̑łB
	 *
	 *	@param	inState ϊ
	 *	@return	ԂɑΉAID
	 */
	protected String findIdentityOfSelf(State inState) {
		java.util.Iterator aIt = mStateMap.entrySet().iterator();
		
		while (aIt.hasNext()) {
			java.util.Map.Entry aEntry = (java.util.Map.Entry)aIt.next();
			if (aEntry.getValue().equals(inState)) {
				return (String)aEntry.getKey();
			}
		}
		
		return HashikakeStateEventCode.SPACE_ID;
	}

	/**
	 *	w肵ԂKwĂꍇA
	 *	ȌԂ𔍂B
	 *	AAȌԂAManagerƊ֘AtĂȂꍇ͉A
	 *	̂܂ܕԂ
	 *
	 *	̃\bh́AfindIdentityOfŌĂ΂B
	 *
	 *	@param	inState	Ώۂ̏
	 *
	 *	@return	̏
	 */
	protected State dewrapState(State inState) {
		return inState;
	}
	
	/**
	 *	Ԃ1i߂B
	 *	̎ł́AJڂ͍sȂ
	 *
	 *	@param inState ݂̏
	 *	@return ̏
	 */
	protected State getNextStateSelf(State inState) {
		return getNextStateSelf(inState, HashikakeStateEventCode.createNoTransitCode());
	}

	/**
	 *	Ԃ1i߂B
	 *	ŁAinEventlɏ]ēJڂs
	 *
	 *	@param inState ݂̏
	 *	@param inEvent JڂɊւCxgl
	 *	@return ̏
	 */
	protected State getNextStateSelf(State inState, StateEventCode inEvent) {
		return mTransit.onEnter(inEvent);
	}

	/**
	 *	Ԃ1߂B
	 *	̎ł́AJڂ͍sȂ
	 *
	 *	@param inState ݂̏
	 *	@return ̏
	 */
	protected State getPrevStateSelf(State inState) {
		return getPrevStateSelf(inState, HashikakeStateEventCode.createNoTransitCode());
	}
	
	/**
	 *	Ԃ1߂B
	 *	ŁAinEventlɏ]ēJڂs
	 *
	 *	@param inState ݂̏
	 *	@param inEvent JڂɊւCxgl
	 *	@return ̏
	 */
	protected State getPrevStateSelf(State inState, StateEventCode inEvent) {
		return mTransit.onEnter(inEvent);
	}

	/**
	 *	w肳ꂽԂł邩ǂ`FbNB
	 *
	 *	@param	inState `FbNState object
	 *	@return ԂłtrueԂB
	 */
	protected boolean isNumberStateSelf(State inState) {
		return (inState instanceof NumberState);
	}
	
	/**
	 *	w肳ꂽԂ󔒂ł邩ǂ`FbNB
	 *
	 *	@param	inState `FbNState object
	 *	@return Ԃ󔒂łtrueԂB
	 */
	protected boolean isSpaceStateSelf(State inState) {
		return (inState instanceof SpaceState);
	}
	
	/**
	 *	w肳ꂽԂAJڂł邩ǂ`FbNB
	 *	̎ł́AJڂ܂ł̃`FbN͍sȂB
	 *
	 *	@param inState `FbNState object
	 *	@return Jڂł̂ł΁AtrueԂB
	 */
	protected boolean isTransitSelf(State inState) {
		return isTransitSelf(inState, HashikakeStateEventCode.createNoTransitCode());
	}
	
	/**
	 *	w肳ꂽԂAJڂł邩ǂ`FbNB
	 *	̎ł́A֌WȂevent codenĂꍇA
	 *	܂݂͌̏ԂƑJڌ̏ԂꍇAfalseԂB
	 *
	 *	@param inState `FbNState object
	 *	@param inEvent ɓJڂ҂̂łΎw肷B
	 *	@return Jڂł̂ł΁AtrueԂB
	 */
	protected boolean isTransitSelf(State inState, StateEventCode inEvent) {
		State aState = null;
		
		try {
			aState = mTransit.onEnter(inEvent);
		}
		catch (IllegalArgumentException e) {
			return false;
		}
		
		return (aState == inState ? false : true);
	}
	
	/**
	 *	w肵StateEventCodeStateManagerŏł邩ǂ`FbN
	 *
	 *	@param	inEvent	Cxg̎
	 *	@return	łꍇAtrueԂ
	 */
	protected boolean acceptableEventCode(StateEventCode inEvent) {
		return true;
	}
}