// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		RendererFactory.java
//	DATE:		2003.5.31
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************


package jp.gr.java_conf.ktz.puzzle.hashikake.app.view;

import java.awt.Rectangle;
import java.awt.Graphics;

import jp.gr.java_conf.ktz.puzzle.framework.DefaultRenderer;
import jp.gr.java_conf.ktz.puzzle.framework.Renderer;
import jp.gr.java_conf.ktz.puzzle.framework.RenderListener;
import jp.gr.java_conf.ktz.puzzle.framework.RenderEvent;
import jp.gr.java_conf.ktz.puzzle.framework.State;

import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.*;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.AppColors;

/**
 *	RenderListenero^邽߂̃t@Ng[\bhNX
 */
public class RendererFactory {
	public static DefaultRenderer create(final int inWidth, final int inHeight) {
		DefaultRenderer aRenderer
			 = new DefaultRenderer(inWidth, inHeight, AppColors.BACK_COLOR);

		aRenderer.addRenderListener(NumberState.class, new RenderListener() {
			public void render(RenderEvent inEvent) {
				Graphics aGra = inEvent.getGraphics();
				Rectangle aBounds = inEvent.getBounds();
				State aState = inEvent.getState();
				
				aGra.setColor(AppColors.ISLAND);
				aGra.fillRect(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
				
				final int aNum = ((NumberState)aState).getValue();
				aGra.setColor(AppColors.ISLAND_NUMBER);
				String aStr = String.valueOf(aNum);
				java.awt.geom.Rectangle2D aStrBounds = aGra.getFontMetrics().getStringBounds(aStr, aGra);

				final int aX = (int)(aBounds.x + (aBounds.width-aStrBounds.getWidth())/2);
				final int aY = (int)(aBounds.y - aStrBounds.getY() + (aBounds.width-aStrBounds.getHeight())/2);
				aGra.drawString(aStr, aX, aY);
			}
		});
		
		aRenderer.addRenderListener(NumberActiveState.class, new RenderListener() {
			public void render(RenderEvent ioEvent) {
				Renderer aRenderer = ioEvent.getSource();
				Graphics aGra = ioEvent.getGraphics();
				Rectangle aBounds = ioEvent.getBounds();
				State aState = ioEvent.getState();
				
				// ɐ`悷B
				ioEvent.reset(aRenderer, aGra, aBounds, ((NumberActiveState)aState).getDecorated());
				RenderListener aListener = ((DefaultRenderer)aRenderer).lookup(ioEvent.getState());
				aListener.render(ioEvent);
				
				// ANeBuԂ`悷B
				aGra.setColor(AppColors.ACTIVE_ISLAND);
				aGra.drawOval(aBounds.x+1, aBounds.y+1, aBounds.width-2, aBounds.height-2);
			}
		});
		
		aRenderer.addRenderListener(SelectionState.class, new RenderListener() {
			public void render(RenderEvent ioEvent) {
				Renderer aRenderer = ioEvent.getSource();
				Graphics aGra = ioEvent.getGraphics();
				Rectangle aBounds = ioEvent.getBounds();
				State aState = ioEvent.getState();
				
				// ɔՖʂ`悷B
				ioEvent.reset(aRenderer, aGra, aBounds, ((SelectionState)aState).getDecorated());
				RenderListener aListener = ((DefaultRenderer)aRenderer).lookup(ioEvent.getState());
				aListener.render(ioEvent);
				
				// IԂ`悷B
				aGra.setColor(AppColors.ACTIVE_COLOR);
				aGra.fillRect(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
			}
		});

		aRenderer.addRenderListener(NSBridgeState.class, new RenderListener() {
			public void render(RenderEvent inEvent) {
				Graphics aGra = inEvent.getGraphics();
				Rectangle aBounds = inEvent.getBounds();
				
				aGra.setColor(AppColors.BRIDGE);
				aGra.fillRect(aBounds.x + aBounds.width*2/5, aBounds.y, aBounds.width/5, aBounds.height);
			}
		});
		
		aRenderer.addRenderListener(BigNSBridgeState.class, new RenderListener() {
			public void render(RenderEvent inEvent) {
				Graphics aGra = inEvent.getGraphics();
				Rectangle aBounds = inEvent.getBounds();
				
				aGra.setColor(AppColors.BRIDGE);
				aGra.fillRect(aBounds.x + aBounds.width/5, aBounds.y, aBounds.width/5, aBounds.height);
				aGra.fillRect(aBounds.x + aBounds.width*3/5, aBounds.y, aBounds.width/5, aBounds.height);
			}
		});

		aRenderer.addRenderListener(WEBridgeState.class, new RenderListener() {
			public void render(RenderEvent inEvent) {
				Graphics aGra = inEvent.getGraphics();
				Rectangle aBounds = inEvent.getBounds();
				
				aGra.setColor(AppColors.BRIDGE);
				aGra.fillRect(aBounds.x, aBounds.y + aBounds.width*2/5, aBounds.width, aBounds.height/5);
			}
		});
		
		aRenderer.addRenderListener(BigWEBridgeState.class, new RenderListener() {
			public void render(RenderEvent inEvent) {
				Graphics aGra = inEvent.getGraphics();
				Rectangle aBounds = inEvent.getBounds();
				
				aGra.setColor(AppColors.BRIDGE);
				aGra.fillRect(aBounds.x, aBounds.y + aBounds.width/5, aBounds.width, aBounds.height/5);
				aGra.fillRect(aBounds.x, aBounds.y + aBounds.width*3/5, aBounds.width, aBounds.height/5);
			}
		});
		
		return aRenderer;
	}
}

