// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		BridgableCheckModelTest.java
//	DATE:		2003.5.13
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import junit.framework.TestSuite;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;

import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.*;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.HashikakeStateManagerImpl;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.ProblemInfoBean;

/**
 *	BridgibleCheckModelɑ΂Unit Test
 */
public class BridgibleCheckModelTest extends junit.framework.TestCase {
	public static junit.framework.Test suite() {
		TestSuite aSuite = new TestSuite("test name : BridgaebleCheckModelTest");
		
		aSuite.addTest(new TestSuite(BridgibleCheckModelTest.class));
		
		return aSuite;
	}
	
	private BridgibleCheckModel mModel;
	private ModelChangeDispatcher mDispatcher;
	
	public void setUp() {
		StateManager.initialize(new HashikakeStateManagerImpl());
		
		mModel = new BridgibleCheckModel(new BoardModel());
		mModel.createBoard(7, 7);
		mDispatcher = new HashikakeModelChangeHandler(mModel);	
	}
	
	public void testSelectState() {
		String aSolutionStr = 
			"3,-,1,s,s,s,s,"
			+"II,s,s,s,s,s,s,"
			+"II,s,s,s,s,s,s,"
			+"5,s,s,s,s,s,s,"
			+"s,s,s,s,s,s,s,"
			+"s,s,s,s,s,s,s,"
			+"s,s,s,s,s,s,s";

		mModel.setProblem(new ProblemInfo(7, 7, aSolutionStr.split(",")));
		
		// ʒu(0, 0)̃ZI
		ModelChangeEvent aEvent
			 = ModelChangeEvent.createSelectionEvent(0, 0, Direction.NO);

		assertEquals(NumberState.class, mModel.getCurStateAt(0, 0).getClass());
		mDispatcher.processModelChange(aEvent);
		assertEquals(NumberActiveState.class, mModel.getCurStateAt(0, 0).getClass());
		
		// ʒu(0, 0)̃Z𓌕ɑI
		aEvent
			 = ModelChangeEvent.createSelectionEvent(0, 0, Direction.EAST);

		mDispatcher.processModelChange(aEvent);
		assertEquals(NumberActiveState.class, mModel.getCurStateAt(0, 0).getClass());
		assertEquals(SelectionState.class, mModel.getCurStateAt(1, 0).getClass());
		
// -----

		// ʒu(0, 0)瓌̃Z肷B
		aEvent
			 = ModelChangeEvent.createDeterminationEvent(0, 0, Direction.EAST);
		
		mDispatcher.processModelChange(aEvent);
		assertEquals(false, SelectionState.class == mModel.getCurStateAt(1, 0).getClass());
		assertEquals(WEBridgeState.class, mModel.getCurStateAt(1, 0).getClass());
		assertEquals(NumberState.class, mModel.getCurStateAt(0, 0).getClass());

// -----

		// ʒu(0, 0)̃Z肷B
		aEvent = ModelChangeEvent.createSelectionEvent(0, 0, Direction.NO);
		mDispatcher.processModelChange(aEvent);
		aEvent = ModelChangeEvent.createSelectionEvent(0, 0, Direction.SOUTH);
		mDispatcher.processModelChange(aEvent);
		
		aEvent = ModelChangeEvent.createDeterminationEvent(0, 0, Direction.SOUTH);
		mDispatcher.processModelChange(aEvent);
		assertEquals(false, mModel.isSpaceAt(0, 1));
		assertEquals(NSBridgeState.class, mModel.getCurStateAt(0, 1).getClass());

// -----

		// ʒu(0, 0)̃Zx肷B
		aEvent = ModelChangeEvent.createSelectionEvent(0, 0, Direction.NO);
		mDispatcher.processModelChange(aEvent);
		aEvent = ModelChangeEvent.createSelectionEvent(0, 0, Direction.SOUTH);
		mDispatcher.processModelChange(aEvent);
		
		aEvent = ModelChangeEvent.createDeterminationEvent(0, 0, Direction.SOUTH);
		mDispatcher.processModelChange(aEvent);
		assertEquals(false, mModel.isSpaceAt(0, 1));
		assertEquals(BigNSBridgeState.class, mModel.getCurStateAt(0, 1).getClass());


// -----

		// ʒu(0, 0)̃Zɂx肷B
		aEvent = ModelChangeEvent.createSelectionEvent(0, 0, Direction.NO);
		mDispatcher.processModelChange(aEvent);
		aEvent = ModelChangeEvent.createSelectionEvent(0, 0, Direction.SOUTH);
		mDispatcher.processModelChange(aEvent);
		
		aEvent = ModelChangeEvent.createDeterminationEvent(0, 0, Direction.SOUTH);
		mDispatcher.processModelChange(aEvent);
		assertEquals(true, mModel.isSpaceAt(0, 1));

// -----

		// ʒu(2, 0)̃Z肷B
		// Ή铇Ȃ̂őIȂ͂
		aEvent = ModelChangeEvent.createSelectionEvent(2, 0, Direction.NO);
		mDispatcher.processModelChange(aEvent);
		aEvent = ModelChangeEvent.createSelectionEvent(2, 0, Direction.SOUTH);
		mDispatcher.processModelChange(aEvent);
		
		assertEquals(true, mModel.isSpaceAt(2, 1));
	}
}


