// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		BoardModelTest.java
//	DATE:		2003.5.8
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import junit.framework.TestSuite;

import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.HashikakeStateManagerImpl;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.ProblemInfoBean;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;

/**
 *	BoardModelɑ΂Unit Test
 */
public class BoardModelTest extends junit.framework.TestCase {
	public static junit.framework.Test suite() {
		TestSuite aSuite = new TestSuite("The test case name : BoardModelTest");
		
		aSuite.addTest(new TestSuite(BoardModelTest.class));
		
		return aSuite;
	}
	
	private BoardModel mModel;
	
	public void setUp() {
		StateManager.initialize(new HashikakeStateManagerImpl());
		mModel = new BoardModel();
		mModel.createBoard(7, 7);
		
		String aSolutionStr = 
			"3,-,1,s,s,s,s,"
			+"II,s,s,s,s,s,s,"
			+"II,s,s,s,s,s,s,"
			+"5,s,s,s,s,s,s,"
			+"s,s,s,s,s,s,s,"
			+"s,s,s,s,s,s,s,"
			+"s,s,s,s,s,s,s";
			
		mModel.setProblem(new ProblemInfo(7, 7, aSolutionStr.split(",")));
	}
	
	public void testShowProblem() throws Exception {
		String aSolutionStr = 
			"3,-,1,s,s,s,s,"
			+"II,s,s,s,s,s,s,"
			+"II,s,s,s,s,s,s,"
			+"5,s,s,s,s,s,s,"
			+"s,s,s,s,s,s,s,"
			+"s,s,s,s,s,s,s,"
			+"s,s,s,s,s,s,s";
		
		assertEquals(7, mModel.getWidth());
		assertEquals(7, mModel.getHeight());
		
		String[] aSolution = aSolutionStr.split(",");
		
		String[] aProblem = initProblem(aSolutionStr);
		
		assertEquals(49, aProblem.length);
		
		// Cell̏ԂƏĂ邩ǂ`FbN
		for (int y = 0, i = 0; y < mModel.getHeight(); ++y) {
			for (int x = 0; x < mModel.getWidth(); ++x) {
				assertEquals(toState(aProblem[i++]), mModel.getCurStateAt(x, y));
			}
		}
	}
	
	public void testTransit() {
		assertEquals(true, mModel.isSpaceAt(1, 0));
		
		mModel.reset();

		mModel.nextStateAt(1, 0, UtilityFuncs.resolveTransitCode(Direction.EAST));
		assertEquals(false, mModel.isSpaceAt(1, 0));

		mModel.nextStateAt(0, 1, UtilityFuncs.resolveTransitCode(Direction.NORTH));
		mModel.nextStateAt(0, 1, UtilityFuncs.resolveTransitCode(Direction.NORTH));
		mModel.nextStateAt(0, 1, UtilityFuncs.resolveTransitCode(Direction.NORTH));
		assertEquals(true, mModel.isSpaceAt(0, 1));

		// ͑JڂȂ͂
// System.out.println(mModel.getCurStateAt(0, 0));		
		assertEquals(true, mModel.isNumberAt(0, 0));
		mModel.nextStateAt(0, 0, UtilityFuncs.resolveTransitCode(Direction.NORTH));
		assertEquals(true, mModel.isNumberAt(0, 0));
		
	}
	
	private String[] initProblem(String inSolutionString) {
		// 𕔕󔒂ɂB
		String aProblem = inSolutionString.replaceAll("[I=-]", "s");

		// vfɕAԂB
		return aProblem.split(",");
		
	}
	
	private State toState(String inString) throws Exception {
		StateManager aManager = StateManager.getInstance();
		
		if (inString.indexOf('s') >= 0) return aManager.createDefaultState();
		
		return aManager.createStateOf(inString);
	}

}


