/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.JFileChooser;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.LoadCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.SaveCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.Command;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.ComponentUsher;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.GUIUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.TerminateManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.Usherable;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.ProblemMarshalable;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.ProblemUnmarshalable;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.SaveCanceledException;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AWTDispatchCommandQueue;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AbstractCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AbstractTopDownCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.CommandContainer;

public abstract class RootBoardContainer
implements BoardView,
Usherable,
ProblemUnmarshalable,
ProblemMarshalable {
    private static final int OFFSET_POS_PER_FRAME = 24;
    private static int sOffsetCount;
    private static String sInitialTitle;
    protected BoardView mDecorated;
    private Frame mComponent;
    private boolean mFocused;
    private boolean mMarshalAware = false;
    private boolean mIsCanceled = false;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$view$RootBoardContainer$DisposeLatterCommand;

    protected RootBoardContainer(Frame inComponent) {
        this.mComponent = inComponent;
    }

    public final void initialize() {
        this.initializeSelf();
        this.alignPos();
        this.throwIfUninitialized();
        this.mDecorated.initialize();
        this.mComponent.addWindowListener(new WindowHandler());
        this.mComponent.pack();
    }

    protected void alignPos() {
        int aPos = 24 * sOffsetCount;
        ++sOffsetCount;
        Dimension aScreenSize = GUIUtility.getEffectiveScreenSize();
        if (aScreenSize.width < aPos + this.getComponent().getWidth() || aScreenSize.height < aPos + this.getComponent().getHeight()) {
            sOffsetCount = 0;
            aPos = 0;
        }
        this.getComponent().setLocation(aPos, aPos);
    }

    protected abstract void initializeSelf();

    protected final void addBoard(BoardView inSubBoard) {
        this.mComponent.add(inSubBoard.getComponent());
        this.mDecorated = inSubBoard;
        inSubBoard.setParent(this);
    }

    public void setParent(BoardView inParent) {
        throw new UnsupportedOperationException("The Parent of root board is no existance.");
    }

    public final boolean isModified() {
        this.throwIfUninitialized();
        return this.mDecorated.isModified();
    }

    public final void saveProblem(File inFile) throws SaveCanceledException {
        this.mIsCanceled = false;
        if (0 <= inFile.getName().indexOf(sInitialTitle)) {
            this.saveProblemAs();
            this.repaint();
        } else {
            this.processCommand(new SaveCommand(this, inFile));
        }
    }

    public void save(File inFile) throws SaveCanceledException {
        this.saveProblem(inFile);
    }

    public final void saveProblemAs() throws SaveCanceledException {
        JFileChooser aChooser = GUIUtility.createFileChooser();
        int aSignal = aChooser.showSaveDialog(this.mComponent);
        if (aSignal == 1) {
            throw new SaveCanceledException("The save operation is canceled.");
        }
        if (aSignal == 0) {
            AWTDispatchCommandQueue.postCommand(new SaveCommand(this, aChooser.getSelectedFile()));
            this.setTitle(aChooser.getSelectedFile().getAbsolutePath());
        }
    }

    public final void load(ProblemInfo inInfo) {
        this.processCommand(new LoadCommand(this, inInfo));
        if (!this.mComponent.isVisible()) {
            this.show();
        }
    }

    public final void loadProblem(File inFile, ProblemInfo inInfo) {
        if (this != ComponentUsher.getInstance().getActiveComponent()) {
            ComponentUsher.getInstance().setActiveComponent(this);
        }
        this.setTitle(inFile.getAbsolutePath());
        this.load(inInfo);
    }

    public final void loadCanceled() {
        if (!this.mComponent.isVisible()) {
            WindowEvent aEvent = new WindowEvent(this.mComponent, 201);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(aEvent);
        }
    }

    public void setMarshalAware() {
        this.mMarshalAware = true;
    }

    public boolean isMarshalAware() {
        return this.mMarshalAware;
    }

    public final Component getComponent() {
        return this.mComponent;
    }

    public final void setTitle(String inTitle) {
        this.mComponent.setTitle(this.modifiyTitleString(inTitle));
    }

    protected abstract String modifiyTitleString(String var1);

    public final String getTitle() {
        return this.mComponent.getTitle();
    }

    public final void repaint() {
        this.throwIfUninitialized();
        this.mDecorated.repaint();
    }

    public final void setPieceSize(int inSize) {
    }

    public final void setComponentSize(int inWidth, int inHeight) {
        Dimension aScreenSize = GUIUtility.getEffectiveScreenSize();
        Dimension aPrefSize = this.mComponent.getPreferredSize();
        int aWidth = aPrefSize.width;
        int aHeight = aPrefSize.height;
        int aX = this.mComponent.getX();
        int aY = this.mComponent.getY();
        if (aX + aWidth > aScreenSize.width) {
            aWidth = aScreenSize.width - aX;
        }
        if (aY + aHeight > aScreenSize.height) {
            aHeight = aScreenSize.height - aY;
        }
        this.mComponent.setSize(aWidth, aHeight);
        this.mComponent.validate();
    }

    protected final void dispose() {
        this.mComponent.dispose();
    }

    public final boolean isFocused() {
        return this.mFocused;
    }

    public final void setFocus(boolean inFocused) {
        this.mFocused = inFocused;
    }

    protected final void saveCanceled() {
        TerminateManager aManager = TerminateManager.getInstance();
        if (aManager.isTerminateThread()) {
            aManager.cancel();
        }
        this.mIsCanceled = true;
    }

    private void throwIfUninitialized() {
        if (null == this.mDecorated) {
            throw new IllegalStateException("The subcompoment is initialized.To Call with addBoard() method lead to register it.");
        }
    }

    public void show() {
        this.mComponent.show();
    }

    public void processCommand(Command inCommand) {
        if (!this.availableDispose(inCommand)) {
            return;
        }
        if (!inCommand.isConsumed()) {
            this.processCommandImpl(inCommand);
        }
        if (!inCommand.isConsumed() && inCommand instanceof AbstractTopDownCommand) {
            this.mDecorated.processCommand(inCommand);
        }
    }

    protected abstract void processCommandImpl(Command var1);

    private boolean availableDispose(Command inCommand) {
        if (inCommand.getClass() != (class$jp$gr$java_conf$ktz$puzzle$hashikake$view$RootBoardContainer$DisposeLatterCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$view$RootBoardContainer$DisposeLatterCommand = RootBoardContainer.class$("jp.gr.java_conf.ktz.puzzle.hashikake.view.RootBoardContainer$DisposeLatterCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$view$RootBoardContainer$DisposeLatterCommand)) {
            return true;
        }
        return this.disposeLatter();
    }

    protected String parseTitleToFileName(String inTitle) {
        return inTitle;
    }

    private boolean disposeLatter() {
        if (this.isMarshalAware() && this.isModified() && !this.mIsCanceled) {
            AWTDispatchCommandQueue.postCommand(new DisposeLatterCommand(this));
            return false;
        }
        ComponentUsher.getInstance().uninstall(this);
        this.dispose();
        if (0 == ComponentUsher.getInstance().getComponentCount()) {
            System.out.println("all frame is closed");
            System.exit(0);
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        OFFSET_POS_PER_FRAME = 24;
        sOffsetCount = 0;
        sInitialTitle = "<untitled>";
    }

    private class WindowHandler
    implements WindowListener {
        private WindowHandler() {
        }

        public void windowClosing(WindowEvent inEvent) {
            if (RootBoardContainer.this.isMarshalAware() && RootBoardContainer.this.isModified()) {
                try {
                    String aFileName = RootBoardContainer.this.parseTitleToFileName(RootBoardContainer.this.getTitle());
                    int aSignal = GUIUtility.showBoardModifiedNotice(RootBoardContainer.this.getComponent(), aFileName, true);
                    if (0 == aSignal) {
                        RootBoardContainer.this.saveProblem(new File(aFileName));
                    } else {
                        if (2 == aSignal) {
                            throw new SaveCanceledException("frame closing process is canceled");
                        }
                        if (1 == aSignal) {
                            RootBoardContainer.this.mIsCanceled = true;
                        }
                    }
                }
                catch (SaveCanceledException e) {
                    RootBoardContainer.this.saveCanceled();
                    return;
                }
            }
            RootBoardContainer.this.disposeLatter();
        }

        public void windowActivated(WindowEvent inEvent) {
            ComponentUsher.getInstance().setActiveComponent(RootBoardContainer.this.getComponent());
        }

        public void windowDeactivated(WindowEvent inEvent) {
            ComponentUsher.getInstance().setActiveComponent();
        }

        public void windowOpened(WindowEvent inEvent) {
        }

        public void windowClosed(WindowEvent inEvent) {
        }

        public void windowIconified(WindowEvent inEvent) {
        }

        public void windowDeiconified(WindowEvent inEvent) {
        }
    }

    private static class DisposeLatterCommand
    extends AbstractCommand {
        public DisposeLatterCommand(CommandContainer inCommander) {
            super(inCommander);
        }
    }
}

