/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.util.gui;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.Usherable;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;

public final class ComponentUsher {
    private Usherable mActiveComponent = null;
    private Map mAllComponents = new HashMap();

    public static ComponentUsher getInstance() {
        return Holder.sInstance;
    }

    public synchronized Usherable getActiveComponent() {
        return this.mActiveComponent;
    }

    public synchronized void setActiveComponent(Component inComp) {
        this.lostFocus(this.mActiveComponent);
        this.gainFocus((Usherable)this.mAllComponents.get(inComp));
    }

    public synchronized void setActiveComponent(BoardView inComp) {
        this.lostFocus(this.mActiveComponent);
        this.gainFocus((Usherable)((Object)inComp));
    }

    public synchronized void setActiveComponent() {
        this.lostFocus(this.mActiveComponent);
        this.mActiveComponent = null;
    }

    private void lostFocus(Usherable inComp) {
        if (null != inComp) {
            inComp.setFocus(false);
        }
    }

    private void gainFocus(Usherable inComp) {
        if (null != inComp) {
            inComp.setFocus(true);
        }
        this.mActiveComponent = inComp;
    }

    public int getComponentCount() {
        return this.mAllComponents.size();
    }

    public Usherable[] getAllComponents() {
        Usherable[] aComp = new Usherable[this.mAllComponents.size()];
        this.mAllComponents.values().toArray(aComp);
        return aComp;
    }

    public void install(Usherable inComp) {
        if (inComp instanceof BoardView) {
            this.mAllComponents.put(((BoardView)((Object)inComp)).getComponent(), inComp);
            this.setActiveComponent((BoardView)((Object)inComp));
        } else if (inComp instanceof Component) {
            this.mAllComponents.put(inComp, inComp);
            this.setActiveComponent((Component)((Object)inComp));
        }
    }

    public void uninstall(Usherable inComp) {
        if (inComp instanceof BoardView) {
            this.mAllComponents.remove(((BoardView)((Object)inComp)).getComponent());
        } else if (inComp instanceof Component) {
            this.mAllComponents.remove(inComp);
        }
    }

    private ComponentUsher() {
    }

    private static class Holder {
        static ComponentUsher sInstance = new ComponentUsher();

        private Holder() {
        }
    }
}

