/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.util;

import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.DirectionStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.SelectionStateEventCode;

public class UtilityFuncs {
    public static StateEventCode resolveTransitCode(Direction inDirection) {
        if (Direction.NORTH == inDirection || Direction.SOUTH == inDirection) {
            return HashikakeStateEventCode.createVerticalCode();
        }
        if (Direction.EAST == inDirection || Direction.WEST == inDirection) {
            return HashikakeStateEventCode.createHorizontalCode();
        }
        return HashikakeStateEventCode.createNoTransitCode();
    }

    public static boolean isTransitCode(StateEventCode inEventCode) {
        return inEventCode instanceof HashikakeStateEventCode;
    }

    public static StateEventCode getDirectionEventCode(Direction inDirection) {
        return DirectionStateEventCode.createDirectionCode(inDirection);
    }

    public static boolean isDirectionStateEventCode(StateEventCode inEventCode) {
        return DirectionStateEventCode.isDirectionStateEventCode(inEventCode);
    }

    public static StateEventCode getSelectionEventCode() {
        return SelectionStateEventCode.getInstance();
    }

    public static Direction resolveDirectionOf(int inKeyCode) {
        if (inKeyCode == 37) {
            return Direction.WEST;
        }
        if (inKeyCode == 39) {
            return Direction.EAST;
        }
        if (inKeyCode == 38) {
            return Direction.NORTH;
        }
        if (inKeyCode == 40) {
            return Direction.SOUTH;
        }
        return Direction.NO;
    }

    public static Direction resolveDirectionOf(StateEventCode inEventCode) {
        if (inEventCode instanceof DirectionStateEventCode) {
            return ((DirectionStateEventCode)inEventCode).getDirection();
        }
        return Direction.NO;
    }

    public static Direction inverseDirection(Direction inDirection) {
        if (Direction.WEST == inDirection) {
            return Direction.EAST;
        }
        if (Direction.EAST == inDirection) {
            return Direction.WEST;
        }
        if (Direction.NORTH == inDirection) {
            return Direction.SOUTH;
        }
        if (Direction.SOUTH == inDirection) {
            return Direction.NORTH;
        }
        return Direction.NO;
    }
}

