/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolveDiscompleteException;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.QueueIF;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.Queue_2;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class SolverRI_4
implements SolverHandler {
    private static final State sStartState = new StartState();
    private static final State sProcessingState = new ProcessState();
    private static final State sBuildDisableState = new DisableState();
    private static final State sFinishedState = new FinishState();
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private static final int NUM_PER_DIRECTION = 2;
    private static final int PENALTY_WEIGHT;
    private Map mRecords;
    private QueueIF mQueue;
    private Map mChainMap;
    private Model mModel;
    private int mLap;
    private Point mCurPos;
    private SolverPattern[] mPatterns = new SolverPattern[]{new HashikakeSolverPattern1(), new HashikakeSolverPattern2(), new HashikakeSolverPattern3(), new HashikakeSolverPattern4()};

    public SolverRI_4(Model inModel) {
        this.mModel = inModel;
    }

    public void reset() {
        this.initRecords();
        this.mLap = 0;
    }

    private void initRecords() {
        this.mRecords = new HashMap();
        this.mChainMap = new HashMap();
        this.mQueue = new Queue_2(new SolverRecordComparator());
        ArrayList aList = new ArrayList();
        int y = 0;
        while (y < this.mModel.getHeight()) {
            int x = 0;
            while (x < this.mModel.getWidth()) {
                if (this.mModel.isNumberAt(x, y)) {
                    Point aPos = new Point(x, y);
                    SolverRecord aRec = this.getSolverRecord(aPos);
                    this.updateSolverRecord(aRec);
                    this.mQueue.enqueue(aRec);
                }
                ++x;
            }
            ++y;
        }
    }

    public boolean isSolute() {
        return this.mQueue.isEmpty();
    }

    public void nextSolute() {
        if (this.isSolute()) {
            return;
        }
        if (this.nextSoluteSub()) {
            System.out.println("build OK. at " + this.mCurPos);
        }
    }

    private boolean nextSoluteSub() {
        if (this.mLap == 0) {
            this.mLap = this.mQueue.size();
            this.mQueue.shift(null);
            System.out.println("queue sorted. (" + this.mLap + " leaves.)");
        }
        --this.mLap;
        SolverRecord aRec = null;
        do {
            if (this.mQueue.isEmpty()) {
                return true;
            }
            aRec = (SolverRecord)this.mQueue.dequeue();
        } while (this.isFinishedState(aRec.mState));
        this.mCurPos = aRec.mPos;
        return this.attemptBuild(aRec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void nextSoluteAll() throws SolveDiscompleteException {
        long t1;
        int aLoopCount;
        block6: {
            block5: {
                aLoopCount = 0;
                t1 = System.currentTimeMillis();
                try {
                    if (this.mQueue.isEmpty()) {
                        Object var6_3 = null;
                        break block5;
                    }
                    int aCount = 0;
                    do {
                        ++aLoopCount;
                        if (!this.nextSoluteSub()) {
                            if (this.mQueue.size() * 2 != ++aCount) continue;
                            throw new SolveDiscompleteException(this.mQueue.size());
                        }
                        aCount = 0;
                    } while (!this.isSolute());
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    long t2 = System.currentTimeMillis();
                    System.out.println("loop count : " + aLoopCount + "(" + (t2 - t1) + " msec elapsed)");
                    throw throwable;
                }
            }
            long t2 = System.currentTimeMillis();
            System.out.println("loop count : " + aLoopCount + "(" + (t2 - t1) + " msec elapsed)");
            return;
        }
        Object var6_4 = null;
        long t2 = System.currentTimeMillis();
        System.out.println("loop count : " + aLoopCount + "(" + (t2 - t1) + " msec elapsed)");
    }

    private boolean attemptBuild(SolverRecord inRec) {
        boolean aRet = false;
        do {
            this.updateSolverRecord(inRec);
            if (this.isFinishedState(inRec.mState)) {
                return true;
            }
            aRet = false;
            Point[] aAroundPos = new Point[DIRECTIONS.length];
            int aSum = this.getAroundMax(inRec, aAroundPos);
            SolverInfo aInfo = new SolverInfo(inRec, aSum, aAroundPos);
            int i = 0;
            while (i < this.mPatterns.length) {
                if (aRet |= this.mPatterns[i].build(aInfo)) break;
                ++i;
            }
            if (!aRet) continue;
            Point[] aDiagonal = new Point[]{new Point(1, 1), new Point(-1, 1), new Point(1, -1), new Point(-1, -1)};
            Point aDiaPos = new Point(inRec.mPos);
            int i2 = 0;
            while (i2 < aDiagonal.length) {
                aDiaPos.translate(aDiagonal[i2].x, aDiagonal[i2].y);
                if (this.mModel.isNumberAt(aDiaPos.x, aDiaPos.y)) {
                    SolverRecord aDiaRec = this.getSolverRecord(aDiaPos);
                    this.updateSolverRecord(aDiaRec);
                }
                aDiaPos.translate(-aDiagonal[i2].x, -aDiagonal[i2].y);
                ++i2;
            }
        } while (aRet);
        if (!this.isFinishedState(inRec.mState)) {
            inRec.mPenalty += PENALTY_WEIGHT;
            this.mQueue.enqueue(inRec);
        }
        return aRet;
    }

    private SolverRecord getSolverRecord(Point inPos) {
        if (this.mRecords.containsKey(inPos)) {
            return (SolverRecord)this.mRecords.get(inPos);
        }
        if (this.mModel.isNumberAt(inPos.x, inPos.y)) {
            int aCount = Integer.MIN_VALUE;
            Point aPos = new Point(inPos);
            try {
                aCount = Integer.parseInt(StateManager.getInstance().findIdentityOf(this.mModel.getCurStateAt(aPos.x, aPos.y)));
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("The simbol of Number State cannot be parsed as integer.");
            }
            SolverRecord aRec = new SolverRecord(this.mRecords.size(), aPos, aCount);
            this.mRecords.put(aPos, aRec);
            return aRec;
        }
        throw new IllegalArgumentException("The state of specified position isnot NumberState (pos : x = " + inPos.x + ", y = " + inPos.y + ")");
    }

    /*
     * Unable to fully structure code
     */
    private boolean isBuild(Point inStart, Direction inDir, Point outOpposite) {
        aPos = new Point(inStart);
        aDiff = inDir.getDifference();
        aPos.translate(aDiff.x, aDiff.y);
        if (this.mModel.contains(aPos.x, aPos.y)) ** GOTO lbl13
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.mModel.isNumberAt(aPos.x, aPos.y)) {
                outOpposite.setLocation(aPos.x, aPos.y);
                return true;
            }
            aCode = HashikakeStateEventCode.createParallelCode(inDir);
            if (!this.mModel.isTransitAt(aPos.x, aPos.y, aCode)) {
                return false;
            }
            aPos.translate(aDiff.x, aDiff.y);
lbl13:
            // 2 sources

            ** while (this.mModel.contains((int)aPos.x, (int)aPos.y))
        }
lbl14:
        // 1 sources

        return false;
    }

    private boolean isStartState(State inState) {
        return inState == sStartState;
    }

    private boolean isFinishedState(State inState) {
        return inState == sFinishedState;
    }

    private boolean isDisableState(State inState) {
        return inState == sBuildDisableState;
    }

    private boolean isProcessState(State inState) {
        return inState == sProcessingState;
    }

    private boolean buildBridge(SolverRecord inRec, int inCount, int inIndex) {
        Point aPos = new Point(inRec.mPos);
        OppositeRecord aOppRec = inRec.mOpposite[inIndex];
        if (null == aOppRec) {
            return false;
        }
        if (this.isFinishedState(aOppRec.mState)) {
            return false;
        }
        if (inCount == aOppRec.mCount) {
            return false;
        }
        Direction aDirection = DIRECTIONS[inIndex];
        StateEventCode aCode = HashikakeStateEventCode.createParallelCode(aDirection);
        Point aDiff = aDirection.getDifference();
        aPos.translate(aDiff.x, aDiff.y);
        while (!this.mModel.isNumberAt(aPos.x, aPos.y)) {
            int aCount = aOppRec.mCount;
            while (aCount < inCount) {
                this.mModel.nextStateAt(aPos.x, aPos.y, aCode);
                ++aCount;
            }
            aPos.translate(aDiff.x, aDiff.y);
        }
        aOppRec.mCount = inCount;
        SolverRecord aAgainstRec = this.getSolverRecord(aPos);
        this.addChainMap(inRec, aAgainstRec);
        this.updateSolverRecord(aAgainstRec);
        return true;
    }

    private void addChainMap(SolverRecord inRec, SolverRecord inAgainstRec) {
        Integer aRemoveRefID;
        if (inRec.mQueueRef == inAgainstRec.mQueueRef) {
            return;
        }
        List aList = this.getChainList(inRec);
        List aAgainstList = this.getChainList(inAgainstRec);
        if (inRec.mQueueRef < inAgainstRec.mQueueRef) {
            aRemoveRefID = new Integer(inAgainstRec.mQueueRef);
            this.mergeChainList(aList, aAgainstList, inRec.mQueueRef);
        } else {
            aRemoveRefID = new Integer(inRec.mQueueRef);
            this.mergeChainList(aAgainstList, aList, inAgainstRec.mQueueRef);
        }
        this.mChainMap.remove(aRemoveRefID);
    }

    private List getChainList(SolverRecord inRec) {
        Integer aKey = new Integer(inRec.mQueueRef);
        LinkedList<SolverRecord> aList = (LinkedList<SolverRecord>)this.mChainMap.get(aKey);
        if (null == aList) {
            aList = new LinkedList<SolverRecord>();
            aList.add(inRec);
            this.mChainMap.put(aKey, aList);
        }
        return aList;
    }

    private void mergeChainList(List inList1, List inList2, int inRefID) {
        while (!inList2.isEmpty()) {
            SolverRecord aRec = (SolverRecord)inList2.remove(0);
            aRec.mQueueRef = inRefID;
            inList1.add(aRec);
        }
        this.mChainMap.put(new Integer(inRefID), inList1);
    }

    private void removeChainMap(SolverRecord inRec) {
        Integer aRefID = new Integer(inRec.mQueueRef);
        List aList = (List)this.mChainMap.get(aRefID);
        if (null == aList) {
            return;
        }
        aList.remove(inRec);
        if (this.mChainMap.size() > 1 && aList.isEmpty()) {
            throw new IllegalStateException("The building bridge has separated.");
        }
    }

    private void updateSolverRecord(SolverRecord inRec) {
        if (this.isFinishedState(inRec.mState)) {
            return;
        }
        int aSum = 0;
        Point aOpposite = new Point();
        int i = 0;
        while (i < DIRECTIONS.length) {
            aOpposite.setLocation(Integer.MIN_VALUE, Integer.MIN_VALUE);
            OppositeRecord aOppRec = inRec.mOpposite[i];
            if (!this.isBuild(inRec.mPos, DIRECTIONS[i], aOpposite)) {
                if (null != aOppRec) {
                    aOppRec = null;
                    inRec.mOpposite[i] = null;
                    --inRec.mOppositeCount;
                }
            } else {
                SolverRecord aAgainstRec = this.getSolverRecord(aOpposite);
                if (null == aOppRec) {
                    if (!this.isFinishedState(aAgainstRec.mState)) {
                        this.initOppositeRecord(inRec, aAgainstRec, i);
                    }
                } else if (this.isDisableState(aOppRec.mState)) {
                    if (this.isFinishedState(aAgainstRec.mState)) {
                        aOppRec = null;
                        inRec.mOpposite[i] = null;
                        --inRec.mOppositeCount;
                    } else {
                        this.initOppositeRecord(inRec, aAgainstRec, i);
                    }
                } else if (this.isProcessState(aOppRec.mState) && this.isFinishedState(aAgainstRec.mState)) {
                    inRec.mResidue -= aOppRec.mCount;
                    --inRec.mOppositeCount;
                    aOppRec.mState = sFinishedState;
                }
                aAgainstRec = this.getSolverRecord(aOpposite);
                if (null != aOppRec && !this.isDisableState(aOppRec.mState) && !this.isFinishedState(aOppRec.mState)) {
                    this.updateOppositeRecord(inRec, aAgainstRec, aOppRec);
                    if (!this.isFinishedState(aOppRec.mState)) {
                        aSum += aOppRec.mCount;
                    }
                }
            }
            ++i;
        }
        if (aSum == inRec.mResidue || 0 == inRec.mOppositeCount || 0 == inRec.mResidue) {
            this.finalizeOppositeRecordAll(inRec);
        }
    }

    private void finalizeOppositeRecordAll(SolverRecord inRec) {
        inRec.mResidue = 0;
        inRec.mState = sFinishedState;
        int i = 0;
        while (i < DIRECTIONS.length) {
            this.finalizeOppositeRecord(inRec, i);
            ++i;
        }
        this.removeChainMap(inRec);
    }

    private void finalizeOppositeRecord(SolverRecord inRec, int inIndex) {
        if (null != inRec.mOpposite[inIndex]) {
            if (0 == inRec.mOpposite[inIndex].mCount) {
                inRec.mOpposite[inIndex].mState = sBuildDisableState;
                inRec.mOpposite[inIndex] = null;
            } else if (this.isFinishedState(inRec.mOpposite[inIndex].mState)) {
                return;
            }
            --inRec.mOppositeCount;
        }
    }

    private void updateOppositeRecord(SolverRecord inRec, SolverRecord inAgainst, OppositeRecord inOppRec) {
        if (this.isFinishedState(inOppRec.mState)) {
            return;
        }
        if (2 == inOppRec.mCount) {
            inOppRec.mState = sFinishedState;
            inRec.mResidue -= inOppRec.mCount;
            --inRec.mOppositeCount;
            if (0 < inRec.mPenalty) {
                inRec.mPenalty -= PENALTY_WEIGHT;
            }
            inAgainst.mResidue -= inOppRec.mCount;
            --inAgainst.mOppositeCount;
            if (0 < inRec.mPenalty) {
                inAgainst.mPenalty -= PENALTY_WEIGHT;
            }
        } else if (0 < inOppRec.mCount) {
            inOppRec.mState = sProcessingState;
        }
    }

    private void initOppositeRecord(SolverRecord inRec, SolverRecord inAgainst, int inIndex) {
        Direction aInverse = UtilityFuncs.inverseDirection(DIRECTIONS[inIndex]);
        int aIndex = this.getDirectionToIndex(aInverse);
        OppositeRecord aOppRec = inAgainst.mOpposite[aIndex];
        if (null == aOppRec) {
            inAgainst.mOpposite[aIndex] = aOppRec = new OppositeRecord();
            ++inAgainst.mOppositeCount;
        }
        inRec.mOpposite[inIndex] = aOppRec;
        ++inRec.mOppositeCount;
    }

    private int getDirectionToIndex(Direction inDirection) {
        int i = 0;
        while (i < DIRECTIONS.length) {
            if (DIRECTIONS[i] == inDirection) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Direction, " + inDirection + "is illegal.");
    }

    private int getAroundMax(SolverRecord inRec, Point[] outAgainstPos) {
        int aSum = 0;
        int i = 0;
        while (i < DIRECTIONS.length) {
            Point aOpposite;
            if (null != inRec.mOpposite[i] && !this.isFinishedState(inRec.mOpposite[i].mState) && this.isBuild(inRec.mPos, DIRECTIONS[i], aOpposite = new Point())) {
                SolverRecord aAgainstRec = this.getSolverRecord(aOpposite);
                aSum += aAgainstRec.mResidue;
                outAgainstPos[i] = aOpposite;
            }
            ++i;
        }
        return aSum;
    }

    static /* synthetic */ State access$000() {
        return sStartState;
    }

    static {
        NUM_PER_DIRECTION = 2;
        PENALTY_WEIGHT = DIRECTIONS.length * 2;
    }

    private static class SolverRecordComparator
    implements Comparator {
        private SolverRecordComparator() {
        }

        public int compare(Object inLHS, Object inRHS) {
            if (inLHS.equals(inRHS)) {
                return 0;
            }
            SolverRecord aLHS = (SolverRecord)inLHS;
            SolverRecord aRHS = (SolverRecord)inRHS;
            int aLScore = aLHS.mOppositeCount * 2 - aLHS.mResidue + aLHS.mPenalty;
            int aRScore = aRHS.mOppositeCount * 2 - aRHS.mResidue + aRHS.mPenalty;
            if (aLScore == aRScore) {
                return aLHS.mResidue < aRHS.mResidue ? -1 : 1;
            }
            return aLScore > aRScore ? -1 : 1;
        }
    }

    private class BuildChainMap {
        private Map mChainMap;

        private BuildChainMap() {
        }

        public List getChainList(SolverRecord inRec) {
            Integer aKey = new Integer(inRec.mQueueRef);
            LinkedList<SolverRecord> aList = (LinkedList<SolverRecord>)this.mChainMap.get(aKey);
            if (null == aList) {
                aList = new LinkedList<SolverRecord>();
                aList.add(inRec);
                this.mChainMap.put(aKey, aList);
            }
            return aList;
        }

        public void addSolverRecordPair(SolverRecord inRec, SolverRecord inAgainstRec) {
            Integer aRemoveRefID;
            if (inRec.mQueueRef == inAgainstRec.mQueueRef) {
                return;
            }
            List aList = this.getChainList(inRec);
            List aAgainstList = this.getChainList(inAgainstRec);
            if (inRec.mQueueRef < inAgainstRec.mQueueRef) {
                aRemoveRefID = new Integer(inAgainstRec.mQueueRef);
                this.mergeChainList(aList, aAgainstList, inRec.mQueueRef);
            } else {
                aRemoveRefID = new Integer(inRec.mQueueRef);
                this.mergeChainList(aAgainstList, aList, inAgainstRec.mQueueRef);
            }
            this.mChainMap.remove(aRemoveRefID);
        }

        private void mergeChainList(List inList1, List inList2, int inRefID) {
            while (!inList2.isEmpty()) {
                SolverRecord aRec = (SolverRecord)inList2.remove(0);
                aRec.mQueueRef = inRefID;
                inList1.add(aRec);
            }
            this.mChainMap.put(new Integer(inRefID), inList1);
        }

        public void removeSolverRecord(SolverRecord inRec) {
            Integer aRefID = new Integer(inRec.mQueueRef);
            List aList = (List)this.mChainMap.get(aRefID);
            if (null == aList) {
                return;
            }
            aList.remove(inRec);
            if (this.mChainMap.size() > 1 && aList.isEmpty()) {
                throw new IllegalStateException("The building bridge has separated.");
            }
        }
    }

    private class HashikakeSolverPattern4
    implements SolverPattern {
        private HashikakeSolverPattern4() {
        }

        public boolean build(SolverInfo inInfo) {
            boolean aRet = false;
            int aSum = this.getEffectiveAroundMax(inInfo);
            int aResidue = inInfo.mRec.mResidue;
            int i = 0;
            while (i < DIRECTIONS.length) {
                block8: {
                    int aCount;
                    block9: {
                        if (null == inInfo.mAroundPos[i]) break block8;
                        SolverRecord aAgainstRec = SolverRI_4.this.getSolverRecord(inInfo.mAroundPos[i]);
                        aCount = aAgainstRec.mMaxBuildCount;
                        int j = 0;
                        while (j < DIRECTIONS.length) {
                            if (null != aAgainstRec.mOpposite[j] && inInfo.mRec.mOpposite[i] != aAgainstRec.mOpposite[j]) {
                                aCount -= aAgainstRec.mOpposite[j].mCount;
                            }
                            ++j;
                        }
                        if (aCount > 2) {
                            aCount = 2;
                        }
                        if (aSum == aResidue) break block9;
                        if (aSum - aCount >= aResidue) break block8;
                        aCount = 1;
                    }
                    if (0 == inInfo.mRec.mOpposite[i].mCount) {
                        aRet |= SolverRI_4.this.buildBridge(inInfo.mRec, aCount, i);
                        aSum -= aCount;
                        aResidue -= aCount;
                    }
                }
                ++i;
            }
            return aRet;
        }

        private int getEffectiveAroundMax(SolverInfo inInfo) {
            int aSum = 0;
            int i = 0;
            while (i < DIRECTIONS.length) {
                if (null != inInfo.mAroundPos[i]) {
                    SolverRecord aAgainstRec = SolverRI_4.this.getSolverRecord(inInfo.mAroundPos[i]);
                    int aCount = aAgainstRec.mMaxBuildCount;
                    int j = 0;
                    while (j < DIRECTIONS.length) {
                        if (null != aAgainstRec.mOpposite[j] && inInfo.mRec.mOpposite[i] != aAgainstRec.mOpposite[j]) {
                            aCount -= aAgainstRec.mOpposite[j].mCount;
                        }
                        ++j;
                    }
                    if (aCount > 2) {
                        aCount = 2;
                    }
                    aSum += aCount;
                }
                ++i;
            }
            return aSum;
        }
    }

    private class HashikakeSolverPattern3
    implements SolverPattern {
        private HashikakeSolverPattern3() {
        }

        public boolean build(SolverInfo inInfo) {
            List aList = SolverRI_4.this.getChainList(inInfo.mRec);
            boolean aRet = false;
            int i = 0;
            while (i < DIRECTIONS.length) {
                if (null != inInfo.mAroundPos[i]) {
                    SolverRecord aAgainstRec = SolverRI_4.this.getSolverRecord(inInfo.mAroundPos[i]);
                    if (inInfo.mAroundMax - aAgainstRec.mResidue == inInfo.mRec.mResidue) {
                        aRet |= this.attemptBuildLater(i, aList, inInfo);
                    }
                }
                ++i;
            }
            return aRet;
        }

        private boolean attemptBuildLater(int inIndex, List inChainList, SolverInfo inInfo) {
            int aSum = 0;
            int aSize = 1;
            int i = 0;
            while (i < DIRECTIONS.length) {
                if (null != inInfo.mAroundPos[i] && i != inIndex) {
                    SolverRecord aAgainstRec = SolverRI_4.this.getSolverRecord(inInfo.mAroundPos[i]);
                    List aAgainstList = SolverRI_4.this.getChainList(aAgainstRec);
                    if (inInfo.mRec.mQueueRef == aAgainstRec.mQueueRef && inChainList.size() <= DIRECTIONS.length) {
                        ++aSize;
                        aSum += aAgainstRec.mResidue;
                    } else if (aAgainstList.size() == 1) {
                        aSum += aAgainstRec.mResidue;
                    }
                }
                ++i;
            }
            if (inChainList.size() == aSize && aSum == inInfo.mRec.mResidue) {
                return SolverRI_4.this.buildBridge(inInfo.mRec, 1, inIndex);
            }
            return false;
        }
    }

    private class HashikakeSolverPattern2
    implements SolverPattern {
        private HashikakeSolverPattern2() {
        }

        public boolean build(SolverInfo inInfo) {
            boolean aRet = false;
            int i = 0;
            while (i < DIRECTIONS.length) {
                if (null != inInfo.mRec.mOpposite[i] && 0 == inInfo.mRec.mOpposite[i].mCount) {
                    SolverRecord aAgainstRec = SolverRI_4.this.getSolverRecord(inInfo.mAroundPos[i]);
                    if (inInfo.mAroundMax - aAgainstRec.mResidue < inInfo.mRec.mResidue) {
                        aRet |= SolverRI_4.this.buildBridge(inInfo.mRec, 1, i);
                    }
                }
                ++i;
            }
            return aRet;
        }
    }

    private class HashikakeSolverPattern1
    implements SolverPattern {
        private HashikakeSolverPattern1() {
        }

        public boolean build(SolverInfo inInfo) {
            int aResidue = inInfo.mRec.mResidue;
            int aOpposite = inInfo.mRec.mOppositeCount;
            int aNumPerDir = 2 - (aOpposite * 2 - aResidue);
            boolean aRet = false;
            int i = 0;
            while (i < DIRECTIONS.length) {
                if (null != inInfo.mRec.mOpposite[i] && 0 < aNumPerDir && aNumPerDir > inInfo.mRec.mOpposite[i].mCount) {
                    aRet |= SolverRI_4.this.buildBridge(inInfo.mRec, aNumPerDir, i);
                }
                ++i;
            }
            return aRet;
        }
    }

    private static class FinishState
    implements State {
        private FinishState() {
        }

        public State onEnter(StateEventCode inEvent) {
            return this;
        }
    }

    private static class DisableState
    implements State {
        private DisableState() {
        }

        public State onEnter(StateEventCode inEvent) {
            return this;
        }
    }

    private static class StartState
    implements State {
        private StartState() {
        }

        public State onEnter(StateEventCode inEvent) {
            return this;
        }
    }

    private static class ProcessState
    implements State {
        private ProcessState() {
        }

        public State onEnter(StateEventCode inEvent) {
            return this;
        }
    }

    private static interface SolverPattern {
        public boolean build(SolverInfo var1);
    }

    private static class SolverInfo {
        SolverRecord mRec;
        int mAroundMax;
        Point[] mAroundPos;

        SolverInfo(SolverRecord inRec, int inAroundMax, Point[] inAroundPos) {
            this.mRec = inRec;
            this.mAroundMax = inAroundMax;
            this.mAroundPos = inAroundPos;
        }
    }

    static class SolverRecord {
        int mQueueRef;
        Point mPos;
        final int mMaxBuildCount;
        int mResidue;
        int mOppositeCount;
        OppositeRecord[] mOpposite = new OppositeRecord[SolverRI_4.access$100().length];
        State mState = SolverRI_4.access$000();
        int mPenalty = 0;

        SolverRecord(int inQueueRef, Point inPos, int inCount) {
            this.mQueueRef = inQueueRef;
            this.mPos = inPos;
            this.mMaxBuildCount = this.mResidue = inCount;
        }

        public String toString() {
            return "count = " + this.mOppositeCount + "residue = " + this.mResidue + "pos" + this.mPos;
        }
    }

    static class OppositeRecord {
        int mCount;
        State mState = SolverRI_4.access$000();

        OppositeRecord() {
        }
    }
}

