/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.QueueIF;

class Queue_2
implements QueueIF {
    private List mContainer = new ArrayList();
    private Comparator mComp;
    private int mInitialSize;

    public Queue_2(Comparator inComp) {
        this.mComp = inComp;
    }

    public void enqueue(Object inRec) {
        this.mContainer.add(inRec);
    }

    public Object dequeue() {
        return this.mContainer.remove(0);
    }

    public void reset(Collection inContainer) {
        this.mContainer = new ArrayList();
        this.mContainer.addAll(inContainer);
        this.makeHeap();
        this.heapSort();
    }

    public boolean remove(Object inRec) {
        boolean aRemoved = this.mContainer.remove(inRec);
        if (aRemoved && !this.isEmpty()) {
            this.popHeap(0, this.size(), this.mComp);
        }
        return aRemoved;
    }

    public void shift(Object inRec) {
        if (this.mInitialSize < this.size()) {
            this.mInitialSize = this.size();
        }
        if (this.mInitialSize / this.size() < 4) {
            this.makeHeap();
            this.heapSort();
        }
    }

    public boolean isEmpty() {
        return this.mContainer.isEmpty();
    }

    public int size() {
        return this.mContainer.size();
    }

    private void pushHeap(int inBegin, int inEnd, Comparator inComp) {
        int aIndex = inEnd - inBegin - 1;
        int aPredecessor = (aIndex - 1) / 2;
        Object aTemp = this.mContainer.get(aIndex);
        while (aPredecessor != aIndex && 0 < inComp.compare(this.mContainer.get(aPredecessor), aTemp)) {
            this.mContainer.set(aIndex, this.mContainer.get(aPredecessor));
            aIndex = aPredecessor;
            aPredecessor = (aIndex - 1) / 2;
        }
        this.mContainer.set(aIndex, aTemp);
    }

    private void popHeap(int inBegin, int inEnd, Comparator inComp) {
        int aIndex = 0;
        int aSuccessor = 1;
        int aLastPos = inEnd - inBegin - 1;
        Object aTemp = this.mContainer.get(aLastPos);
        this.mContainer.set(aLastPos, this.mContainer.get(0));
        while (aSuccessor < aLastPos) {
            if (aSuccessor < aLastPos - 1 && 0 < inComp.compare(this.mContainer.get(aSuccessor), this.mContainer.get(aSuccessor + 1))) {
                ++aSuccessor;
            }
            if (0 >= inComp.compare(aTemp, this.mContainer.get(aSuccessor))) break;
            this.mContainer.set(aIndex, this.mContainer.get(aSuccessor));
            aIndex = aSuccessor;
            aSuccessor = (aIndex + 1) * 2 - 1;
        }
        this.mContainer.set(aIndex, aTemp);
    }

    private void makeHeap() {
        int i = 1;
        while (i < this.size()) {
            this.pushHeap(0, i, this.mComp);
            ++i;
        }
    }

    private void heapSort() {
        int aSize = this.size();
        while (aSize > 1) {
            this.popHeap(0, aSize--, this.mComp);
        }
    }

    public void printQueue() {
        System.out.println("print queue entry.");
        int i = 0;
        while (i < this.size()) {
            System.out.println(this.mContainer.get(i));
            ++i;
        }
        System.out.println();
    }
}

