/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.creator.view;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import jp.gr.java_conf.ktz.puzzle.framework.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.DefaultRenderer;
import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.NullModel;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.BoardSizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.LoadCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.PieceSizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.SaveCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.AppColors;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.model.BoardModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.model.CellActivationModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.RendererFactory;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.KeyScrollCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.ResizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.ResizeResultCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.Command;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.MenuManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.ProblemCollection;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.ProblemInfoBean;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.SaveDiscompletedException;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AWTDispatchCommandQueue;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AbstractBottomUpCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.CommandContainer;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;

public class Board
extends Canvas
implements BoardView {
    private DefaultRenderer mRenderer;
    private Model mModel = NullModel.getInstance();
    private BoardView mParent;
    private boolean mIsModified = false;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$command$BoardSizeCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeResultCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$command$SaveCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$command$LoadCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$util$marshal$ProblemCollection;

    public void initialize() {
        this.mRenderer = RendererFactory.create();
        this.addModel((Model)new BoardModel());
        this.addModel((Model)new CellActivationModel());
        this.mModel.nextStateAt(0, 0);
        this.setBackground(AppColors.BACK_COLOR);
        FocusEvent aEvent = new FocusEvent(this, 1004);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(aEvent);
        MouseHandler aHandler = new MouseHandler(new Point(0, 0));
        this.addKeyListener(aHandler);
        this.addMouseListener(aHandler);
        PieceSizeCommand aCommand = new PieceSizeCommand(this, this.getPieceSize());
        AWTDispatchCommandQueue.postCommand(aCommand);
    }

    private void addModel(Model inModel) {
        if (inModel instanceof AbstractDecoratedModel) {
            ((AbstractDecoratedModel)inModel).addModel(this.mModel);
        }
        this.mModel = inModel;
    }

    public void processCommand(Command inCommand) {
        if (!inCommand.isConsumed()) {
            this.processCommandImpl(inCommand);
        }
        if (!inCommand.isConsumed() && inCommand instanceof AbstractBottomUpCommand) {
            this.mParent.processCommand(inCommand);
        }
    }

    protected void processCommandImpl(Command inCommand) {
        Class<?> aClass = inCommand.getClass();
        if (aClass == (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.command.ResetCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand)) {
            this.clear();
            inCommand.consume();
        } else if (aClass == (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$BoardSizeCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$BoardSizeCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.command.BoardSizeCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$command$BoardSizeCommand)) {
            int aWidth = ((BoardSizeCommand)inCommand).getComponentWidth();
            int aHeight = ((BoardSizeCommand)inCommand).getComponentHeight();
            this.setComponentSize(aWidth, aHeight);
        } else if (aClass == (class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.ResizeCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeCommand)) {
            CommandContainer aCommander = ((ResizeCommand)inCommand).getDestination();
            int aWidth = this.getBoardWidth();
            int aHeight = this.getBoardHeight();
            ResizeResultCommand aCommand = new ResizeResultCommand(aCommander, aWidth, aHeight);
            AWTDispatchCommandQueue.postCommand(aCommand);
        } else if (aClass == (class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeResultCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeResultCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.ResizeResultCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeResultCommand)) {
            int aWidth = ((ResizeResultCommand)inCommand).getWidth();
            int aHeight = ((ResizeResultCommand)inCommand).getHeight();
            this.createBoard(aWidth, aHeight);
        } else if (aClass == (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$SaveCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$SaveCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.command.SaveCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$command$SaveCommand)) {
            File aFile = ((SaveCommand)inCommand).getFile();
            this.save(aFile);
        } else if (aClass == (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$LoadCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$LoadCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.command.LoadCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$command$LoadCommand)) {
            ProblemInfo aInfo = ((LoadCommand)inCommand).getProblem();
            this.load(aInfo);
            inCommand.consume();
        }
    }

    private void createBoard(int inWidth, int inHeight) {
        if (inWidth == this.getBoardWidth() && inHeight == this.getBoardHeight()) {
            return;
        }
        this.mModel.createBoard(inWidth, inHeight);
        this.mRenderer.setSize(inWidth, inHeight);
        Dimension aSize = this.getComponentSize();
        BoardSizeCommand aCommand = new BoardSizeCommand(this, aSize.width, aSize.height);
        AWTDispatchCommandQueue.postCommand(aCommand);
        Point aInitialPos = new Point(0, 0);
        this.mModel.nextStateAt(aInitialPos.x, aInitialPos.y);
    }

    private int getBoardWidth() {
        return this.mModel.getWidth();
    }

    private int getBoardHeight() {
        return this.mModel.getHeight();
    }

    private Rectangle getClipBounds() {
        Insets aInsets = this.getInsets();
        Rectangle aBounds = this.mRenderer.getClipBounds(this.mModel.lastModified());
        aBounds.translate(aInsets.left, aInsets.top);
        return aBounds;
    }

    private Point calcPortToBoardPos(int inX, int inY) {
        Insets aInsets = this.getInsets();
        return this.mRenderer.calcPortToBoardPos(inX - aInsets.left, inY - aInsets.top);
    }

    public boolean isModified() {
        return this.mIsModified;
    }

    public void update(Graphics inGra) {
        this.paint(inGra);
    }

    public void paint(Graphics inGra) {
        Rectangle aBounds = new Rectangle();
        inGra.getClipBounds(aBounds);
        Insets aInsets = this.getInsets();
        aBounds.translate(-aInsets.left, -aInsets.top);
        inGra.translate(aInsets.left, aInsets.top);
        if (this.mModel.isModified()) {
            Point[] aPos = this.mModel.lastModified();
            int i = 0;
            while (i < aPos.length) {
                this.mRenderer.render(aPos[i].x, aPos[i].y, this.mModel.getCurStateAt(aPos[i].x, aPos[i].y));
                ++i;
            }
        }
        inGra.drawImage(this.mRenderer.getImage(), aBounds.x, aBounds.y, aBounds.x + aBounds.width, aBounds.y + aBounds.height, aBounds.x, aBounds.y, aBounds.x + aBounds.width, aBounds.y + aBounds.height, this);
        inGra.translate(-aInsets.left, -aInsets.top);
        this.mModel.flush();
    }

    private void save(File inOutFile) {
        File aOutFile = inOutFile;
        ProblemCollection aCollection = this.createProblemCollection();
        try {
            this.saveProblem(aOutFile, aCollection);
            this.mIsModified = false;
            System.out.println("save complete");
        }
        catch (SaveDiscompletedException e) {
            System.out.println(e);
        }
        MenuManager.currentMenuManager().setEnabledFor("Save", false);
    }

    private ProblemCollection createProblemCollection() {
        int aWidth = this.mModel.getWidth();
        int aHeight = this.mModel.getHeight();
        StateManager aManager = StateManager.getInstance();
        int aBufSize = aWidth * aHeight * 3;
        StringBuffer aBuf = new StringBuffer(aBufSize);
        int y = 0;
        while (y < aHeight) {
            int x = 0;
            while (x < aWidth) {
                String aStr = aManager.findIdentityOf(this.mModel.getCurStateAt(x, y));
                aBuf.append(aStr).append(',');
                ++x;
            }
            ++y;
        }
        String aProblem = aBuf.substring(0, aBuf.length() - 1);
        ProblemCollection aCollection = new ProblemCollection();
        aCollection.addProblem(new ProblemInfoBean(aWidth, aHeight, aProblem));
        return aCollection;
    }

    private void saveProblem(File inFile, ProblemCollection inCollection) throws SaveDiscompletedException {
        try {
            IBindingFactory aFactory = BindingDirectory.getFactory(class$jp$gr$java_conf$ktz$puzzle$hashikake$util$marshal$ProblemCollection == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$util$marshal$ProblemCollection = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.ProblemCollection")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$util$marshal$ProblemCollection);
            IMarshallingContext aContext = aFactory.createMarshallingContext();
            aContext.setIndent(4);
            aContext.marshalDocument((Object)inCollection, "utf-8", null, new FileOutputStream(inFile));
        }
        catch (Exception e) {
            throw new SaveDiscompletedException("save discomplete");
        }
    }

    private void load(ProblemInfo inInfo) {
        this.createBoard(inInfo.getWidth(), inInfo.getHeight());
        this.mModel.nextStateAt(0, 0);
        this.mModel.setProblem(inInfo);
        MenuManager.currentMenuManager().setEnabledFor("Save", false);
        this.mIsModified = false;
        if (this.mModel.isModified()) {
            Rectangle aBounds = this.getClipBounds();
            this.repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
        }
    }

    private void clear() {
        this.mModel.reset();
        if (this.mModel.isModified()) {
            MenuManager.currentMenuManager().setEnabledFor("Clear", false);
            if (!this.isModified()) {
                this.mIsModified = true;
                MenuManager.currentMenuManager().setEnabledFor("Save", true);
            }
            Rectangle aBounds = this.getClipBounds();
            this.repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
        }
    }

    public void setParent(BoardView inParentBoard) {
        this.mParent = inParentBoard;
    }

    private int getPieceSize() {
        return this.mRenderer.getPieceSize().height;
    }

    public Component getComponent() {
        return this;
    }

    public Insets getInsets() {
        int aPiece = this.getPieceSize();
        return new Insets(aPiece, aPiece, aPiece, aPiece);
    }

    private void setComponentSize(int inWidth, int inHeight) {
        Insets aInsets = this.getInsets();
        int aWidth = inWidth + aInsets.left + aInsets.right;
        int aHeight = inHeight + aInsets.top + aInsets.bottom;
        this.setSize(aWidth, aHeight);
    }

    private Dimension getComponentSize() {
        Dimension aSize = new Dimension(this.mRenderer.getBoardSize());
        Insets aInsets = this.getInsets();
        aSize.width += aInsets.left + aInsets.right;
        aSize.height += aInsets.top + aInsets.bottom;
        return aSize;
    }

    public void setFocus(boolean inFocused) {
        this.mParent.setFocus(inFocused);
    }

    public boolean isFocused() {
        return this.mParent.isFocused();
    }

    private void enableMenu(String inMenuID, boolean inEnabled) {
        if (this.mModel.isModified()) {
            MenuManager.currentMenuManager().setEnabledFor(inMenuID, inEnabled);
        }
        this.mIsModified = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MouseHandler
    implements KeyListener,
    MouseListener {
        private final Point ILLEGAL = ModelConstants.ILLEGAL_POS;
        private Point mActivePiece;

        MouseHandler(Point inInitPos) {
            this.mActivePiece = inInitPos;
        }

        public void keyPressed(KeyEvent inEvent) {
            if (0 < inEvent.getModifiers()) {
                return;
            }
            int aPressedCode = inEvent.getKeyCode();
            if (aPressedCode == 127 || aPressedCode == 8) {
                StateEventCode aCode = HashikakeStateEventCode.createSpaceCode();
                Board.this.mModel.nextStateAt(this.mActivePiece.x, this.mActivePiece.y, aCode);
                Board.this.enableMenu("Save", true);
                Board.this.enableMenu("Clear", true);
            } else if (aPressedCode == 37 || aPressedCode == 39 || aPressedCode == 38 || aPressedCode == 40) {
                Direction aDirection = UtilityFuncs.resolveDirectionOf(aPressedCode);
                Point aDif = aDirection.getDifference();
                StateEventCode aCode = UtilityFuncs.getSelectionEventCode();
                Board.this.mModel.nextStateAt(aDif.x, aDif.y, aCode);
                if (Board.this.mModel.isModified()) {
                    this.mActivePiece.translate(aDif.x, aDif.y);
                    int aPieceSize = Board.this.getPieceSize();
                    Insets aInsets = Board.this.getInsets();
                    Rectangle aBounds = new Rectangle(aInsets.left + this.mActivePiece.x * aPieceSize + Board.this.getX(), aInsets.top + this.mActivePiece.y * aPieceSize + Board.this.getY(), aPieceSize, aPieceSize);
                    KeyScrollCommand aEvent = new KeyScrollCommand(Board.this, aBounds);
                    AWTDispatchCommandQueue.postCommand(aEvent);
                }
            } else {
                try {
                    int aVal = Integer.parseInt(KeyEvent.getKeyText(aPressedCode));
                    if (aVal > 0 && aVal < 9) {
                        StateEventCode aCode = HashikakeStateEventCode.valueOf(String.valueOf(aVal));
                        Board.this.mModel.nextStateAt(this.mActivePiece.x, this.mActivePiece.y, aCode);
                        Board.this.enableMenu("Save", true);
                        Board.this.enableMenu("Clear", true);
                    }
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
            if (Board.this.mModel.isModified()) {
                Rectangle aBounds = Board.this.getClipBounds();
                Board.this.repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
            }
        }

        public void mousePressed(MouseEvent inEvent) {
            if (!Board.this.isFocused()) {
                return;
            }
            int aX = inEvent.getX();
            int aY = inEvent.getY();
            Point aPos = Board.this.calcPortToBoardPos(aX, aY);
            Board.this.mModel.nextStateAt(aPos.x, aPos.y);
            if (Board.this.mModel.isModified()) {
                this.mActivePiece = aPos;
                Rectangle aBounds = Board.this.getClipBounds();
                Board.this.repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
            }
        }

        public void keyReleased(KeyEvent inEvent) {
        }

        public void keyTyped(KeyEvent inEvent) {
        }

        public void mouseClicked(MouseEvent inEvent) {
        }

        public void mouseReleased(MouseEvent inEvent) {
        }

        public void mouseEntered(MouseEvent inEvent) {
        }

        public void mouseExited(MouseEvent inEvent) {
        }
    }
}

