/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import java.awt.Dimension;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import jp.gr.java_conf.ktz.puzzle.framework.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.NullModel;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;

public class BoardModel
extends AbstractDecoratedModel {
    private static final Point[] NO_MODIFIED = ModelConstants.EMPTIES;
    private Cell[] mCells;
    private int mWidth;
    private int mHeight;
    private Set mModifiedPos = new HashSet();

    public BoardModel() {
        this(NullModel.getInstance());
    }

    public BoardModel(Model inModel) {
        super(inModel);
    }

    public void createBoardSelf(int inWidth, int inHeight) {
        this.mWidth = inWidth;
        this.mHeight = inHeight;
        this.mCells = new Cell[inWidth * inHeight];
    }

    public void setProblem(ProblemInfo inInfo) {
        if (this.mWidth != inInfo.getWidth() || this.mHeight != inInfo.getHeight()) {
            this.createBoard(inInfo.getWidth(), inInfo.getHeight());
        }
        int y = 0;
        int i = 0;
        while (y < this.mHeight) {
            int x = 0;
            while (x < this.mWidth) {
                this.mCells[y * this.mWidth + x] = new Cell((String)inInfo.getRecordAt(i++));
                this.mModifiedPos.add(new Point(x, y));
                ++x;
            }
            ++y;
        }
    }

    public boolean check() {
        return false;
    }

    public void reset() {
        int y = 0;
        boolean i = false;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                Cell aCell = this.getCellAt(x, y);
                if (!aCell.isSpace() && !aCell.isNumber()) {
                    this.mModifiedPos.add(new Point(x, y));
                    aCell.reset();
                }
                ++x;
            }
            ++y;
        }
    }

    public Dimension getSize() {
        return new Dimension(this.mWidth, this.mHeight);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public State getCurStateAt(int inX, int inY) {
        Cell aCell = this.getCellAt(inX, inY);
        return this.getCellAt(inX, inY).getCurState();
    }

    public void nextStateAt(int inX, int inY) {
        throw new UnsupportedOperationException("Needs to pass a arg inEvent for the method nextStateAt.");
    }

    protected void nextStateAtSelf(int inX, int inY, StateEventCode inEvent) {
        if (this.isNumberAt(inX, inY)) {
            return;
        }
        if (!this.isTransitAt(inX, inY, inEvent)) {
            return;
        }
        State aState = this.getCurStateAt(inX, inY);
        aState = StateManager.getInstance().getNextState(aState, inEvent);
        this.setCurStateAt(inX, inY, aState);
        this.mModifiedPos.add(new Point(inX, inY));
    }

    public void prevStateAt(int inX, int inY) {
        throw new UnsupportedOperationException("Needs to pass a arg inEvent for the method prevStateAt.");
    }

    protected void prevStateAtSelf(int inX, int inY, StateEventCode inEvent) {
        if (this.isNumberAt(inX, inY)) {
            return;
        }
        if (!this.isTransitAt(inX, inY, inEvent)) {
            return;
        }
        State aState = this.getCurStateAt(inX, inY);
        aState = StateManager.getInstance().getPrevState(aState, inEvent);
        this.setCurStateAt(inX, inY, aState);
        this.mModifiedPos.add(new Point(inX, inY));
    }

    private void setCurStateAt(int inX, int inY, State inState) {
        Cell aCell = this.getCellAt(inX, inY);
        aCell.setCurState(inState);
    }

    protected Point[] lastModifiedSelf() {
        return this.mModifiedPos.toArray(new Point[this.mModifiedPos.size()]);
    }

    protected boolean isModifiedSelf() {
        return !this.mModifiedPos.isEmpty();
    }

    protected void flushSelf() {
        if (!this.mModifiedPos.isEmpty()) {
            this.mModifiedPos = new HashSet();
        }
    }

    public boolean isNumberAt(int inX, int inY) {
        if (!this.contains(inX, inY)) {
            return false;
        }
        return this.getCellAt(inX, inY).isNumber();
    }

    public boolean isSpaceAt(int inX, int inY) {
        if (!this.contains(inX, inY)) {
            return false;
        }
        return this.getCellAt(inX, inY).isSpace();
    }

    public boolean isTransitAt(int inX, int inY, StateEventCode inTransitCode) {
        if (!this.contains(inX, inY)) {
            return false;
        }
        return this.getCellAt(inX, inY).isTransit(inTransitCode);
    }

    public boolean isTransitAt(int inX, int inY) {
        throw new UnsupportedOperationException("the method isTransitAt(int, int) is unsupported");
    }

    protected boolean isAcceptableEvent(StateEventCode inCode) {
        return inCode == HashikakeStateEventCode.createVerticalCode() || inCode == HashikakeStateEventCode.createHorizontalCode();
    }

    public boolean contains(int inX, int inY) {
        return inX >= 0 && inX < this.mWidth && inY >= 0 && inY < this.mHeight;
    }

    public State getCorrectStateAt(int inX, int inY) {
        throw new UnsupportedOperationException("This model isnot supported getCorrectStateAt method.");
    }

    private Cell getCellAt(int inX, int inY) {
        if (inX < 0 || inY < 0 || inX >= this.mWidth || inY >= this.mHeight) {
            throw new IndexOutOfBoundsException("0 < x <= " + this.mWidth + ", 0 < y <= " + this.mHeight + " (inX : " + inX + ", inY : " + inY + ")");
        }
        return this.mCells[this.mWidth * inY + inX];
    }

    private static class Cell {
        private State mState;

        Cell(String inID) {
            StateManager amanager = StateManager.getInstance();
            try {
                Integer.parseInt(inID.trim());
                this.mState = amanager.createStateOf(inID);
            }
            catch (NumberFormatException e) {
                this.mState = amanager.createDefaultState();
            }
        }

        void reset() {
            if (!this.isNumber()) {
                this.mState = StateManager.getInstance().createDefaultState();
            }
        }

        boolean isNumber() {
            return StateManager.getInstance().isNumberState(this.mState);
        }

        boolean isSpace() {
            return StateManager.getInstance().isSpaceState(this.mState);
        }

        boolean isTransit(StateEventCode inEventCode) {
            return StateManager.getInstance().isTransit(this.mState, inEventCode);
        }

        State getCurState() {
            return this.mState;
        }

        void setCurState(State inState) {
            this.mState = inState;
        }
    }
}

