/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.framework;

import java.awt.Dimension;
import java.awt.Point;
import java.util.Arrays;
import java.util.HashSet;
import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.NullModel;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

public abstract class AbstractDecoratedModel
implements Model {
    protected Model mModel;

    protected AbstractDecoratedModel() {
        this(NullModel.getInstance());
    }

    protected AbstractDecoratedModel(Model inModel) {
        this.addModel(inModel);
    }

    public void addModel(Model inModel) {
        this.mModel = inModel;
    }

    public final void createBoard(int inWidth, int inHeight) {
        this.createBoardSelf(inWidth, inHeight);
        this.mModel.createBoard(inWidth, inHeight);
    }

    public abstract void createBoardSelf(int var1, int var2);

    public void setProblem(ProblemInfo inProblem) {
        this.mModel.setProblem(inProblem);
    }

    public boolean check() {
        return this.mModel.check();
    }

    public void reset() {
        this.mModel.reset();
    }

    public Dimension getSize() {
        return this.mModel.getSize();
    }

    public int getWidth() {
        return this.mModel.getWidth();
    }

    public int getHeight() {
        return this.mModel.getHeight();
    }

    public State getCurStateAt(int inX, int inY) {
        return this.mModel.getCurStateAt(inX, inY);
    }

    public State getCorrectStateAt(int inX, int inY) {
        return this.mModel.getCorrectStateAt(inX, inY);
    }

    protected abstract boolean isAcceptableEvent(StateEventCode var1);

    public void nextStateAt(int inX, int inY) {
        this.mModel.nextStateAt(inX, inY);
    }

    public final void nextStateAt(int inX, int inY, StateEventCode inCode) {
        if (this.isAcceptableEvent(inCode)) {
            this.nextStateAtSelf(inX, inY, inCode);
        }
        this.mModel.nextStateAt(inX, inY, inCode);
    }

    protected abstract void nextStateAtSelf(int var1, int var2, StateEventCode var3);

    public void prevStateAt(int inX, int inY) {
        this.mModel.prevStateAt(inX, inY);
    }

    public final void prevStateAt(int inX, int inY, StateEventCode inCode) {
        if (this.isAcceptableEvent(inCode)) {
            this.prevStateAtSelf(inX, inY, inCode);
        }
        this.mModel.prevStateAt(inX, inY, inCode);
    }

    protected abstract void prevStateAtSelf(int var1, int var2, StateEventCode var3);

    public final Point[] lastModified() {
        HashSet<Point> aSet = new HashSet<Point>();
        aSet.addAll(Arrays.asList(this.mModel.lastModified()));
        aSet.addAll(Arrays.asList(this.lastModifiedSelf()));
        Point[] aModified = new Point[aSet.size()];
        aSet.toArray(aModified);
        return aModified;
    }

    protected abstract Point[] lastModifiedSelf();

    public boolean contains(int inX, int inY) {
        return this.mModel.contains(inX, inY);
    }

    public boolean isTransitAt(int inX, int inY) {
        return this.mModel.isTransitAt(inX, inY);
    }

    public boolean isTransitAt(int inX, int inY, StateEventCode inTransitCode) {
        return this.mModel.isTransitAt(inX, inY, inTransitCode);
    }

    public boolean isSpaceAt(int inX, int inY) {
        return this.mModel.isSpaceAt(inX, inY);
    }

    public boolean isNumberAt(int inX, int inY) {
        return this.mModel.isNumberAt(inX, inY);
    }

    public final boolean isModified() {
        return this.mModel.isModified() || this.isModifiedSelf();
    }

    protected abstract boolean isModifiedSelf();

    public final void flush() {
        this.mModel.flush();
        this.flushSelf();
    }

    protected abstract void flushSelf();
}

