#include "main.h"

void memInit(struct memory *mem)
{
	mem->frees = 0;
	return;
}

unsigned int memTest(unsigned int start, unsigned int end)
{
	unsigned int e, cr0, i;
	char f486 = 0;
	e = eflagsLoad();
	e |= 0x00040000;		/* AC-bit */
	eflagsStore(e);
	e = eflagsLoad();
	if ((e & 0x00040000) != 0) {
		f486 = 1;
	}
	e &= ~0x00040000;
	eflagsStore(e);

	if (f486 != 0) {
		cr0 = cr0Load();
		cr0 |= 0x60000000;
		cr0Store(cr0);
	}
	i = memTest0(start, end);
	if (f486 != 0) {
		cr0 = cr0Load();
		cr0 &= ~0x60000000;
		cr0Store(cr0);
	}
	return i;
}

unsigned int memStat(struct memory *mem)
{
	unsigned int f = 0, i;
	for (i = 0; i < mem->frees; i++) {
		f += mem->free[i].size;
	}
	return f;
}

unsigned int memAlloc(struct memory *mem, unsigned int size)
{
	unsigned int a, i;
	for (i = 0; i < mem->frees; i++) {
		if (mem->free[i].size >= size) {
			a = mem->free[i].addr;
			mem->free[i].addr += size;
			mem->free[i].size -= size;
			if (mem->free[i].size == 0) {
				mem->frees--;
				for (; i < mem->frees; i++) {
					mem->free[i] = mem->free[i + 1];
				}
			}
			return a;
		}
	}
	return 0;
}

void memFree(struct memory *mem, unsigned int addr, unsigned int size)
{
	int i, j;
	for (i = 0; i < mem->frees; i++) {
		if(mem->free[i].addr > addr) {
			break;
		}
	}

	if (i > 0) {
		if (mem->free[i - 1].addr + mem->free[i - 1].size == addr) {
			mem->free[i - 1].size += size;
			if (i < mem->frees) {
				if(addr + size == mem->free[i].addr) {
					mem->free[i - 1].size += mem->free[i].size;
					mem->frees--;
					for (; i < mem->frees; i++) {
						mem->free[i] = mem->free[i + 1];
					}
				}
			}
			return;
		}
	}
	if (i < mem->frees) {
		if (addr + size == mem->free[i].addr) {
			mem->free[i].addr = addr;
			mem->free[i].size += size;
			return;
		}
	}
	if (mem->frees < MEMORY_FREES) {
		for (j = mem->frees; j > i; j--) {
			mem->free[j] = mem->free[j - 1];
		}
		mem->frees++;
		mem->free[i].addr = addr;
		mem->free[i].size = size;
	}
	return;
}
