[FORMAT "WCOFF"]
[BITS 32]
[INSTRSET "i486p"]
[FILE "low.nas"]
		GLOBAL	_hlt,_cli,_sti,_stihlt,_in8,_out8
		GLOBAL	_eflagsLoad,_eflagsStore,_gdtrLoad,_idtrLoad,_cr0Load
		GLOBAL	_cr0Store,_trLoad,_farjmp,_farcall,_clts
		GLOBAL	_fnsave,_frstor,_appRun,_appEnd,_int07Asm
		GLOBAL	_int0cAsm,_int0dAsm,_int20Asm,_int21Asm,_int27Asm
		GLOBAL	_int2cAsm,_apiAsm,_memTest0,_int26Asm,_cpuid
		EXTERN	_int07,_int0c,_int0d,_int20,_int21
		EXTERN	_int27,_int2c,_api,_int26
[SECTION .text]
_hlt:
		HLT
		RET

_cli:
		CLI
		RET

_sti:
		STI
		RET

_stihlt:
		STI
		HLT
		RET

_in8:
		MOV		EDX,[ESP+4]
		MOV		EAX,0
		IN		AL,DX
		RET

_out8:
		MOV		EDX,[ESP+4]
		MOV		AL,[ESP+8]
		OUT		DX,AL
		RET

_eflagsLoad:
		PUSHFD
		POP		EAX
		RET

_eflagsStore:
		MOV		EAX,[ESP+4]
		PUSH	EAX
		POPFD
		RET

_gdtrLoad:
		MOV		EAX,[ESP+4]
		MOV		[ESP+6],ax
		LGDT	[ESP+6]
		RET

_idtrLoad:
		MOV		EAX,[ESP+4]
		MOV		[ESP+6],ax
		LIDT	[ESP+6]
		RET

_cr0Load:
		MOV		EAX,CR0
		RET

_cr0Store:
		MOV		EAX,[ESP+4]
		MOV		CR0,EAX
		RET

_trLoad:
		LTR		[ESP+4]
		RET

_farjmp:
		JMP		FAR [ESP+4]
		RET

_farcall:
		CALL	FAR [ESP+4]
		RET

_clts:
		CLTS
		RET

_fnsave:
		MOV		EAX,[ESP+4]
		FNSAVE	[EAX]
		RET

_frstor:
		MOV		EAX,[ESP+4]
		FRSTOR	[EAX]
		RET

_appRun:
		PUSHAD
		MOV		EAX,[ESP+36]
		MOV		ECX,[ESP+40]
		MOV		EBX,[ESP+44]
		MOV		EDX,[ESP+48]
		MOV		EBP,[ESP+52]
		MOV		[EBP],ESP
		MOV		[EBP+4],SS
		MOV		ES,BX
		MOV		DS,BX
		MOV		FS,BX
		MOV		GS,BX

		OR		ECX,3
		OR		EBX,3
		PUSH	EBX
		PUSH	EDX
		PUSH	ECX
		PUSH	EAX
		RETF

_appEnd:
		MOV		ESP,[EAX]
		MOV		DWORD [EAX+4],0
		POPAD
		RET

_int07Asm:
		PUSH	ES
		PUSH	DS
		PUSHAD
		MOV		EAX,ESP
		PUSH	EAX
		MOV		AX,SS
		MOV		DS,AX
		MOV		ES,AX
		CALL	_int07
		CMP		EAX,0
		JNE		_appEnd
		POP		EAX
		POPAD
		POP		DS
		POP		ES
		IRETD

_int0cAsm:
		PUSH	ES
		PUSH	DS
		PUSHAD
		MOV		EAX,ESP
		PUSH	EAX
		MOV		AX,SS
		MOV		DS,AX
		MOV		ES,AX
		CALL	_int0c
		CMP		EAX,0
		JNE		_appEnd
		POP		EAX
		POPAD
		POP		DS
		POP		ES
		ADD		ESP,4
		IRETD

_int0dAsm:
		PUSH	ES
		PUSH	DS
		PUSHAD
		MOV		EAX,ESP
		PUSH	EAX
		MOV		AX,SS
		MOV		DS,AX
		MOV		ES,AX
		CALL	_int0d
		CMP		EAX,0
		JNE		_appEnd
		POP		EAX
		POPAD
		POP		DS
		POP		ES
		ADD		ESP,4
		IRETD

_int20Asm:
		PUSH	ES
		PUSH	DS
		PUSHAD
		MOV		EAX,ESP
		PUSH	EAX
		MOV		AX,SS
		MOV		DS,AX
		MOV		ES,AX
		CALL	_int20
		POP		EAX
		POPAD
		POP		DS
		POP		ES
		IRETD

_int21Asm:
		PUSH	ES
		PUSH	DS
		PUSHAD
		MOV		EAX,ESP
		PUSH	EAX
		MOV		AX,SS
		MOV		DS,AX
		MOV		ES,AX
		CALL	_int21
		POP		EAX
		POPAD
		POP		DS
		POP		ES
		IRETD

_int27Asm:
		PUSH	ES
		PUSH	DS
		PUSHAD
		MOV		EAX,ESP
		PUSH	EAX
		MOV		AX,SS
		MOV		DS,AX
		MOV		ES,AX
		CALL	_int27
		POP		EAX
		POPAD
		POP		DS
		POP		ES
		IRETD

_int2cAsm:
		PUSH	ES
		PUSH	DS
		PUSHAD
		MOV		EAX,ESP
		PUSH	EAX
		MOV		AX,SS
		MOV		DS,AX
		MOV		ES,AX
		CALL	_int2c
		POP		EAX
		POPAD
		POP		DS
		POP		ES
		IRETD

_apiAsm:
		STI
		PUSH	DS
		PUSH	ES
		PUSHAD
		PUSHAD
		MOV		AX,SS
		MOV		DS,AX
		MOV		ES,AX
		CALL	_api
		CMP		EAX,0
		JNE		_appEnd
		ADD		ESP,32
		POPAD
		POP		ES
		POP		DS
		IRETD

_memTest0:
		PUSH	EDI
		PUSH	ESI
		PUSH	EBX
		MOV		ESI,0xaa55aa55
		MOV		EDI,0x55aa55aa
		MOV		EAX,[ESP+16]

mt0_loop:
		MOV		EBX,EAX
		ADD		EBX,0x0ffc
		MOV		EDX,[EBX]
		MOV		[EBX],ESI
		XOR		DWORD [EBX],0xffffffff
		CMP		EDI,[EBX]
		JNE		mt0_fin
		XOR		DWORD [EBX],0xffffffff
		CMP		ESI,[EBX]
		JNE		mt0_fin
		MOV		[EBX],EDX
		ADD		EAX,0x1000
		CMP		EAX,[ESP+20]
		JBE		mt0_loop
		POP		EBX
		POP		ESI
		POP		EDI
		RET

mt0_fin:
		MOV		[EBX],EDX
		POP		EBX
		POP		ESI
		POP		EDI
		RET

_int26Asm:
		PUSH	ES
		PUSH	DS
		PUSHAD
		MOV		EAX,ESP
		PUSH	EAX
		MOV		AX,SS
		MOV		DS,AX
		MOV		ES,AX
		CALL	_int26
		POP		EAX
		POPAD
		POP		DS
		POP		ES
		IRETD

_cpuid:
		PUSHAD
		MOV		EAX,[ESP+36]
		MOV		ECX,[ESP+40]
		DB		0x0F, 0xA2		; CPUID
		MOV		EBP,[ESP+44]
		MOV		[EBP],EAX	
		MOV		EBP,[ESP+48]
		MOV		[EBP],EBX	
		MOV		EBP,[ESP+52]
		MOV		[EBP],ECX	
		MOV		EBP,[ESP+56]
		MOV		[EBP],EDX	
		POPAD
		RET
