#include "main.h"
#include <string.h>
#include <math.h>
struct sheets *shts;

void shtInit(void)
{
	struct binfo *binfo = (struct binfo *) BINFO_ADDR;
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	int i;
	shts = (struct sheets *) memAlloc(mem, sizeof (struct sheets));
	shts->map = (unsigned char *) memAlloc(mem, binfo->scrnx * binfo->scrny);
	shts->vram = binfo->vram;
	shts->scrnx = binfo->scrnx;
	shts->scrny = binfo->scrny;
	shts->top = -1;
	for (i = 0; i < SHEETS; i++) {
		shts->sheet[i].flag = 0;
		shts->sheet[i].menu = 0;
	}
	return;
}

struct sheet *shtAlloc(void)
{
	struct sheet *sht;
	int i;
	for (i = 0; i < SHEETS; i++) {
		if (shts->sheet[i].flag == 0) {
			sht = &shts->sheet[i];
			sht->flag = SHEET_USING;
			sht->height = -1;
			sht->task = 0;
			return sht;
		}
	}
	return 0;
}

void shtFree(struct sheet *sht)
{
	tbarRemove(sht);
	if (sht->height >= 0) {
		shtUpdown(sht, -1);
	}
	sht->flag = 0;
	return;
}

void shtSet(struct sheet *sht, unsigned char *buf, int sx, int sy, int cinv)
{
	sht->buf = buf;
	sht->sx = sx;
	sht->sy = sy;
	sht->cinv = cinv;
	return;
}

void shtRefresh0(int x0, int y0, int x1, int y1, int h0, int h1)
{
	struct sheet *sht;
	unsigned char *vram = shts->vram, *map = shts->map, *buf, sid;
	int bx, by, vx, vy, bx0, by0, bx1, by1, bx2, h, sid4, i, i1, *p, *q, *r;
	if (x0 < 0) { x0 = 0; }
	if (y0 < 0) { y0 = 0; }
	if (x1 > shts->scrnx) { x1 = shts->scrnx; }
	if (y1 > shts->scrny) { y1 = shts->scrny; }
	for (h = h0; h <= h1; h++) {
		sht = shts->sht[h];
		buf = sht->buf;
		sid = sht - shts->sheet;
		bx0 = x0 - sht->x;
		by0 = y0 - sht->y;
		bx1 = x1 - sht->x;
		by1 = y1 - sht->y;
		if (bx0 < 0) { bx0 = 0; }
		if (by0 < 0) { by0 = 0; }
		if (bx1 > sht->sx) { bx1 = sht->sx; }
		if (by1 > sht->sy) { by1 = sht->sy; }
		if ((sht->x & 3) == 0) {
			i = (bx0 + 3) / 4;
			i1 = bx1 / 4;
			i1 -= i;
			sid4 = sid | sid << 8 | sid << 16 | sid << 24;
			for (by = by0; by < by1; by++) {
				vy = sht->y + by;
				for (bx = bx0; bx < bx1 && (bx & 3) != 0; bx++) {
					vx = sht->x + bx;
					if (map[vy * shts->scrnx + vx] == sid) {
						vram[vy * shts->scrnx + vx] = buf[by * sht->sx + bx];
					}
				}
				vx = sht->x + bx;
				p = (int *) &map[vy * shts->scrnx + vx];
				q = (int *) &vram[vy * shts->scrnx + vx];
				r = (int *) &buf[by * sht->sx + bx];
				for (i = 0; i < i1; i++) {
					if (p[i] == sid4) {
						q[i] = r[i];
					} else {
						bx2 = bx + i * 4;
						vx = sht->x + bx2;
						if (map[vy * shts->scrnx + vx] == sid) {
							vram[vy * shts->scrnx + vx] = buf[by * sht->sx + bx2];
						}
						if (map[vy * shts->scrnx + vx + 1] == sid) {
							vram[vy * shts->scrnx + vx + 1] = buf[by * sht->sx + bx2 + 1];
						}
						if (map[vy * shts->scrnx + vx + 2] == sid) {
							vram[vy * shts->scrnx + vx + 2] = buf[by * sht->sx + bx2 + 2];
						}
						if (map[vy * shts->scrnx + vx + 3] == sid) {
							vram[vy * shts->scrnx + vx + 3] = buf[by * sht->sx + bx2 + 3];
						}
					}
				}
				for (bx += i1 * 4; bx < bx1; bx++) {
					vx = sht->x + bx;
					if (map[vy * shts->scrnx + vx] == sid) {
						vram[vy * shts->scrnx + vx] = buf[by * sht->sx + bx];
					}
				}
			}
		} else {
			for (by = by0; by < by1; by++) {
				vy = sht->y + by;
				for (bx = bx0; bx < bx1; bx++) {
					vx = sht->x + bx;
					if (map[vy * shts->scrnx + vx] == sid) {
						vram[vy * shts->scrnx + vx] = buf[by * sht->sx + bx];
					}
				}
			}
		}
	}
	return;
}

void shtMap(int x0, int y0, int x1, int y1, int h0)
{
	struct sheet *sht;
	unsigned char *map = shts->map, *buf, sid;
	int bx, by, vx, vy, bx0, by0, bx1, by1, h, sid4, *p;
	if (x0 < 0) { x0 = 0; }
	if (y0 < 0) { y0 = 0; }
	if (x1 > shts->scrnx) { x1 = shts->scrnx; }
	if (y1 > shts->scrny) { y1 = shts->scrny; }
	for (h = h0; h <= shts->top; h++) {
		sht = shts->sht[h];
		sid = sht - shts->sheet;
		buf = sht->buf;
		bx0 = x0 - sht->x;
		by0 = y0 - sht->y;
		bx1 = x1 - sht->x;
		by1 = y1 - sht->y;
		if (bx0 < 0) { bx0 = 0; }
		if (by0 < 0) { by0 = 0; }
		if (bx1 > sht->sx) { bx1 = sht->sx; }
		if (by1 > sht->sy) { by1 = sht->sy; }
 		if (sht->cinv == -1) {
			if ((sht->x & 3) == 0 && (bx0 & 3) == 0 && (bx1 & 3) == 0) {
				bx1 = (bx1 - bx0) / 4;
				sid4 = sid | sid << 8 | sid << 16 | sid << 24;
				for (by = by0; by < by1; by++) {
					vy = sht->y + by;
					vx = sht->x + bx0;
					p = (int *) &map[vy * shts->scrnx + vx];
					for (bx = 0; bx < bx1; bx++) {
						p[bx] = sid4;
					}
				}
			} else {
				for (by = by0; by < by1; by++) {
					vy = sht->y + by;
					for (bx = bx0; bx < bx1; bx++) {
						vx = sht->x + bx;
						map[vy * shts->scrnx + vx] = sid;
					}
				}
			}
		} else {
			for (by = by0; by < by1; by++) {
				vy = sht->y + by;
				for (bx = bx0; bx < bx1; bx++) {
					vx = sht->x + bx;
					if (buf[by * sht->sx + bx] != sht->cinv) {
						map[vy * shts->scrnx + vx] = sid;
					}
				}
			}
		}
	}
	return;
}

void shtRefresh(struct sheet *sht, int x0, int y0, int x1, int y1)
{
	if (sht->height >= 0) {
		shtMap(sht->x + x0, sht->y + y0, sht->x + x1, sht->y + y1, 0);
		shtRefresh0(sht->x + x0, sht->y + y0, sht->x + x1, sht->y + y1, 0, sht->height);
	}
	return;
}

void shtUpdown(struct sheet *sht, int height)
{
	int h, old = sht->height;
	if (height > shts->top + 1) {
		height = shts->top + 1;
	}
	if (height < -1) {
		height = -1;
	}
	sht->height = height;

	if (old > height) {
		if (height >= 0) {
			for (h = old; h > height; h--) {
				shts->sht[h] = shts->sht[h - 1];
				shts->sht[h]->height = h;
			}
			shts->sht[height] = sht;
			shtMap(sht->x, sht->y, sht->x + sht->sx, sht->y + sht->sy, height + 1);
			shtRefresh0(sht->x, sht->y, sht->x + sht->sx, sht->y + sht->sy, height + 1, old);
		} else {
			if (shts->top > old) {
				for (h = old; h < shts->top; h++) {
					shts->sht[h] = shts->sht[h + 1];
					shts->sht[h]->height = h;
				}
			}
			shts->top--;
			shtMap(sht->x, sht->y, sht->x + sht->sx, sht->y + sht->sy, 0);
			shtRefresh0(sht->x, sht->y, sht->x + sht->sx, sht->y + sht->sy, 0, old - 1);
		}
	} else if (old < height) {
		if (old >= 0) {
			for (h = old; h < height; h++) {
				shts->sht[h] = shts->sht[h + 1];
				shts->sht[h]->height = h;
			}
			shts->sht[height] = sht;
		} else {
			for (h = shts->top; h >= height; h--) {
				shts->sht[h + 1] = shts->sht[h];
				shts->sht[h + 1]->height = h + 1;
			}
			shts->sht[height] = sht;
			shts->top++;
		}
		shtMap(sht->x, sht->y, sht->x + sht->sx, sht->y + sht->sy, height);
		shtRefresh0(sht->x, sht->y, sht->x + sht->sx, sht->y + sht->sy, height, height);
	}
	return;
}

void shtSlide(struct sheet *sht, int x, int y)
{
	int ox = sht->x, oy = sht->y;
	sht->x = x;
	sht->y = y;
	if (sht->height >= 0) {
		shtMap(ox, oy, ox + sht->sx, oy + sht->sy, 0);
		shtMap(x, y, x + sht->sx, y + sht->sy, sht->height);
		shtRefresh0(ox, oy, ox + sht->sx, oy + sht->sy, 0, sht->height - 1);
		shtRefresh0(x, y, x + sht->sx, y + sht->sy, sht->height, sht->height);
	}
	return;
}

void shtClean(struct task *task)
{
	struct sheet *sht;
	int i;
	for (i = 0; i < SHEETS; i++) {
		sht = &(shts->sheet[i]);
		if (((sht->flag & SHEET_APP) != 0 || (sht->flag & SHEET_DIALOGUE) != 0) && sht->task == task) {
			shtFree(sht);
		}
	}
	return;
}

void shtApp(struct sheet *sht)
{
	shtSlide(sht, (shts->scrnx - sht->sx) / 2, (shts->scrny - sht->sy) / 2);
	shtUpdown(sht, shts->top);
	return;
}

void shtMclose(void)
{
	struct sheet *sht;
	int i;
	for (i = 0; i < SHEETS; i++) {
		sht = &(shts->sheet[i]);
		if ((sht->flag & SHEET_MENU) != 0) {
			sht->menu->mode = 0;
			shtUpdown(sht, -1);
		}
	}
	return;
}

struct menu *shtMchk(int h)
{
	struct sheet *sht = shts->sht[h];
	if ((sht->flag & SHEET_MENU) != 0) {
		return sht->menu;
	}
	return 0;
}

void shtMupdown(struct sheet *sht)
{
	shtUpdown(sht, shts->top);
	return;
}

void shtTupdown(struct sheet *sht)
{
	if (shts->top > 1 && sht->height != -1) {
		shtUpdown(sht, shts->top - 1);
	} else {
		shtUpdown(sht, shts->top);
	}
	return;
}

void palSet(unsigned char *rgb, int start, int end)
{
	int eflags, i;

	eflags = eflagsLoad();
	cli();
	out8(0x03c8, start);
	for (i = start; i <= end; i++) {
		out8(0x03c9, rgb[0] / 4);
		out8(0x03c9, rgb[1] / 4);
		out8(0x03c9, rgb[2] / 4);
		rgb += 3;
	}
	eflagsStore(eflags);
	return;
}

void palInit(void)
{
	static unsigned char rgb[48] = {
		0x00, 0x00, 0x00,	/*  0  */
		0xff, 0x00, 0x00,	/*  1 邢 */
		0x00, 0xff, 0x00,	/*  2 邢 */
		0xff, 0xff, 0x00,	/*  3 邢F */
		0x00, 0x00, 0xff,	/*  4 邢 */
		0xff, 0x00, 0xff,	/*  5 邢 */
		0x00, 0xff, 0xff,	/*  6 邢F */
		0xff, 0xff, 0xff,	/*  7  */
		0xc6, 0xc6, 0xc6,	/*  8 邢DF */
		0x84, 0x00, 0x00,	/*  9 Â */
		0x00, 0x84, 0x00,	/* 10 Â */
		0x84, 0x84, 0x00,	/* 11 ÂF */
		0x00, 0x00, 0x84,	/* 12 Â */
		0x84, 0x00, 0x84,	/* 13 Â */
		0x00, 0x84, 0x84,	/* 14 ÂF */
		0x84, 0x84, 0x84	/* 15 ÂDF */
	};
	unsigned char rgb2[648];
	int r, g, b;

	palSet(rgb, 0, 15);
	for (b = 0; b < 6; b++) {	/* RGB6iK̐ݒ */
		for (g = 0; g < 6; g++) {
			for (r = 0; r < 6; r++) {
				rgb2[(r + g * 6 + b * 36) * 3] = r * 51;
				rgb2[(r + g * 6 + b * 36) * 3 + 1] = g * 51;
				rgb2[(r + g * 6 + b * 36) * 3 + 2] = b * 51;
			}
		}
	}
	palSet(rgb2, 16, 231);
	return;
}

void screenInit(struct sheet *sht, int *fat)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct DLL_STRPICENV *env = 0;
	struct RGB *pbuf = 0, *q;
	unsigned char *fbuf = 0, *p;
	struct file *file = fileSearch("back.bmp");
	int fsize = 0, info[8], x, y, i, j;
	if (file == 0) {
		file = fileSearch("back.jpg");
		if (file == 0) {
			goto none;
		}
	}
	fsize = file->size;
	fbuf = fileReadTek(fat, file->cno, &fsize);

	env = (struct DLL_STRPICENV *) memAlloc(mem, sizeof(struct DLL_STRPICENV));
	if (info_BMP(env, info, fsize, fbuf) == 0) {
		if (info_JPEG(env, info, fsize, fbuf) == 0) {
			goto none;
		}
	}
	if (info[2] > sht->sx || info[3] > sht->sy) {
		goto none;
	}
	pbuf = (struct RGB *) memAlloc(mem, info[2] * info[3] * sizeof(struct RGB));
	if (info[0] == 1) {
		i = decode0_BMP(env, fsize, fbuf, 4, (char *) pbuf, 0);
	} else {
		i = decode0_JPEG(env, fsize, fbuf, 4, (char *) pbuf, 0);
	}
	if (i != 0) {
		goto none;
	}

	x = (sht->sx - info[2]) / 2;
	y = (sht->sy - info[3]) / 2;
	for (i = y; i < y + info[3]; i++) {
		p = sht->buf + i * sht->sx;
		q = pbuf + (i - y) * info[2];
		for (j = x; j < x + info[2]; j++) {
			p[j] = rgb2pal(j, i, q[j - x].r, q[j - x].g, q[j - x].b);
		}
	}
	goto task;
none:
	graphicBox(sht, _008484, 0,            0, sht->sx - 1, sht->sy - 29);
task:
	graphicBox(sht, _C6C6C6, 0, sht->sy - 28, sht->sx - 1, sht->sy - 28);
	graphicBox(sht, _FFFFFF, 0, sht->sy - 27, sht->sx - 1, sht->sy - 27);
	graphicBox(sht, _C6C6C6, 0, sht->sy - 26, sht->sx - 1,  sht->sy - 1);

	graphicBox(sht, _848484, sht->sx - 47, sht->sy - 24,  sht->sx - 4, sht->sy - 24);
	graphicBox(sht, _848484, sht->sx - 47, sht->sy - 23, sht->sx - 47,  sht->sy - 4);
	graphicBox(sht, _FFFFFF, sht->sx - 47,  sht->sy - 3,  sht->sx - 4,  sht->sy - 3);
	graphicBox(sht, _FFFFFF,  sht->sx - 3, sht->sy - 24,  sht->sx - 3,  sht->sy - 3);

	if (env != 0) {
		memFree(mem, (unsigned int) env, sizeof(struct DLL_STRPICENV));
	}
	if (pbuf != 0) {
		memFree(mem, (unsigned int) pbuf, 786432 * sizeof(struct RGB));
	}
	if (fbuf != 0) {
		memFree(mem, (unsigned int) fbuf, fsize);
	}
	shtRefresh(sht, 0, 0, sht->sx, sht->sy);
	return;
}

void mcurInit(struct sheet *sht)
{
	static char cursor[16][10] = {
		"*.........",
		"**........",
		"*O*.......",
		"*OO*......",
		"*OOO*.....",
		"*OOOO*....",
		"*OOOOO*...",
		"*OOOOOO*..",
		"*OOOOOOO*.",
		"*OOOOO****",
		"*OO*OO*...",
		"*O*.*OO*..",
		"**..*OO*..",
		"*....*OO*.",
		".....*OO*.",
		"......**.."
	};
	int x, y;

	for (y = 0; y < 16; y++) {
		for (x = 0; x < 10; x++) {
			if(cursor[y][x] == '*') {
				sht->buf[y * 10 + x] = _000000;
			} else if (cursor[y][x] == 'O') {
				sht->buf[y * 10 + x] = _FFFFFF;
			} else {
 				sht->buf[y * 10 + x] = sht->cinv;
			}
		}
	}
	return;
}

void graphicLine(struct sheet *sht, unsigned char c, int x0, int y0, int x1, int y1)
{
	int len, dx, dy, x, y, i;
	dx = x1 - x0;
	dy = y1 - y0;
	x = x0 << 10;
	y = y0 << 10;
	if (dx < 0) {
		dx = -dx;
	}
	if (dy < 0) {
		dy = -dy;
	}
	if (dx >= dy) {
		len = dx + 1;
		if (x0 > x1) {
			dx = -1024;
		} else {
			dx = 1024;
		}
		if (y0 <= y1) {
			dy = ((y1 - y0 + 1) << 10) / len;
		} else {
			dy = ((y1 - y0 - 1) << 10) / len;
		}
	} else {
		len = dy + 1;
		if (y0 > y1) {
			dy = -1024;
		} else {
			dy = 1024;
		}
		if (x0 <= x1) {
			dx = ((x1 - x0 + 1) << 10) / len;
		} else {
			dx = ((x1 - x0 - 1) << 10) / len;
		}
	}

	for (i = 0; i < len; i++) {
		sht->buf[(y >> 10) * sht->sx + (x >> 10)] = c;
		x += dx;
		y += dy;
	}
	return;
}

void graphicBox(struct sheet *sht, unsigned char c, int x0, int y0, int x1, int y1)
{
	int x, y;
	for (y = y0; y <= y1; y++) {
		for (x = x0; x <= x1; x++) {
			sht->buf[y * sht->sx + x] = c;
		}
	}
	return;
}

void graphicPutc(struct sheet *sht, unsigned char col, int x, int y, unsigned char *c)
{
	int i;
	unsigned char *p, d;
	for (i = 0; i < 16; i++) {
		p = sht->buf + (y + i) * sht->sx + x;
		d = c[i];
		if ((d & 0x80) != 0) { p[0] = col; }
		if ((d & 0x40) != 0) { p[1] = col; }
		if ((d & 0x20) != 0) { p[2] = col; }
		if ((d & 0x10) != 0) { p[3] = col; }
		if ((d & 0x08) != 0) { p[4] = col; }
		if ((d & 0x04) != 0) { p[5] = col; }
		if ((d & 0x02) != 0) { p[6] = col; }
		if ((d & 0x01) != 0) { p[7] = col; }
	}
	return;
}

void graphicPuts(struct sheet *sht, unsigned char c, int x, int y, unsigned char *s)
{
	struct task *task = taskNow();
	unsigned char *nihongo = (unsigned char *) *((int *) NIHONGO_ADDR), *font;
	int k, t;
	for (; *s != 0x00; s++) {
		if (task->lbyte == 0) {
			if ((0x81 <= *s && *s <= 0x9f) || (0xe0 <= *s && *s <= 0xfc)) {
				task->lbyte = *s;
			} else {
				graphicPutc(sht, c, x, y, nihongo + *s * 16);
			}
		} else {
			if (0x81 <= task->lbyte && task->lbyte <= 0x9f) {
				k = (task->lbyte - 0x81) * 2;
			} else {
				k = 62 + (task->lbyte - 0xe0) * 2 + 62;
			}
			if (0x40 <= *s && *s <= 0x7e) {
				t = *s - 0x40;
			} else if (0x80 <= *s && *s <= 0x9e) {
				t = *s - 0x80 + 63;
			} else {
				t = *s - 0x9f;
				k++;
			}
			task->lbyte = 0;
			font = nihongo + 256 * 16 + (k * 94 + t) * 32;
			graphicPutc(sht, c, x - 8, y, font);
			graphicPutc(sht, c, x, y, font + 16);
		}
		x += 8;
	}
	return;
}

void graphicPutsl(struct sheet *sht, unsigned char c, int x, int y, unsigned char *s, int l)
{
	struct task *task = taskNow();
	unsigned char *nihongo = (unsigned char *) *((int *) NIHONGO_ADDR), *font;
	int k, t, i;
	for (i = 0; i < l; s++) {
		if (task->lbyte == 0) {
			if ((0x81 <= *s && *s <= 0x9f) || (0xe0 <= *s && *s <= 0xfc)) {
				task->lbyte = *s;
			} else {
				graphicPutc(sht, c, x, y, nihongo + *s * 16);
			}
		} else {
			if (0x81 <= task->lbyte && task->lbyte <= 0x9f) {
				k = (task->lbyte - 0x81) * 2;
			} else {
				k = 62 + (task->lbyte - 0xe0) * 2 + 62;
			}
			if (0x40 <= *s && *s <= 0x7e) {
				t = *s - 0x40;
			} else if (0x80 <= *s && *s <= 0x9e) {
				t = *s - 0x80 + 63;
			} else {
				t = *s - 0x9f;
				k++;
			}
			task->lbyte = 0;
			font = nihongo + 256 * 16 + (k * 94 + t) * 32;
			graphicPutc(sht, c, x - 8, y, font);
			graphicPutc(sht, c, x, y, font + 16);
		}
		x += 8;
		i++;
	}
	return;
}

void graphicBlock(struct sheet *sht, int x0, int y0, int spx, int spy, unsigned char *buf, int sx)
{
	int x, y;
	for (y = 0; y < spy; y++) {
		for (x = 0; x < spx; x++) {
			sht->buf[(y0 + y) * sht->sx + (x0 + x)] = buf[y * sx + x];
		}
	}
	return;
}

unsigned char rgb2pal(int x, int y, int r, int g, int b)
{
	static int table[4] = { 3, 1, 0, 2 };
	int i;

	x &= 1;	/*  */
	y &= 1;
	i = table[y * 2 + x];	/* ԐFp̒萔 */
	r = (r * 21) / 256;	/* 0 - 20 */
	g = (g * 21) / 256;
	b = (b * 21) / 256;
	r = (r + i) / 4;	/* 0 - 5 */
	g = (g + i) / 4;
	b = (b + i) / 4;
	return 16 + r + g * 6 + b * 36;
}

void graphicButton(struct sheet *sht, int x, int y, int sx, int sy, unsigned char *str, int mode)
{
	struct task *task = taskNow();
	int x1 = x + sx, y1 = y + sy;
	if (mode == 0) {
		graphicBox(sht, _C6C6C6,      x,      y,     x1,     y1);
		graphicBox(sht, _FFFFFF,  x + 1,      y, x1 - 1,      y);
		graphicBox(sht, _FFFFFF,      x,      y,      x, y1 - 1);
		graphicBox(sht, _848484,  x + 1, y1 - 1, x1 - 1, y1 - 1);
		graphicBox(sht, _848484, x1 - 1,  y + 1, x1 - 1, y1 - 2);
		graphicBox(sht, _000000,      x,     y1, x1 - 1,     y1);
		graphicBox(sht, _000000,     x1,      y,     x1,     y1);
		graphicPuts(sht, _000000, x + 3, y + 3, str);
	} else {
		graphicBox(sht, _C6C6C6,      x,     y,     x1,     y1);
		graphicBox(sht, _FFFFFF,      x,    y1,     x1,     y1);
		graphicBox(sht, _FFFFFF,     x1,     y,     x1,     y1);
		graphicBox(sht, _000000,  x + 1,     y,     x1,      y);
		graphicBox(sht, _000000,      x,     y,      x,     y1);
		graphicBox(sht, _848484,  x + 1, y + 1, x1 - 1,  y + 1);
		graphicBox(sht, _848484,  x + 1, y + 1,  x + 1, y1 - 1);
		graphicPuts(sht, _000000, x + 4, y + 4, str);
	}
	task->lbyte = 0;
	return;
}

void winAlloc0(struct sheet *sht, unsigned char *title, char m)
{
	static unsigned char bcls[14][16] = {
		"OOOOOOOOOOOOOOO@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQ@@QQQQ@@QQ$@",
		"OQQQQ@@QQ@@QQQ$@",
		"OQQQQQ@@@@QQQQ$@",
		"OQQQQQQ@@QQQQQ$@",
		"OQQQQQ@@@@QQQQ$@",
		"OQQQQ@@QQ@@QQQ$@",
		"OQQQ@@QQQQ@@QQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"O$$$$$$$$$$$$$$@",
		"@@@@@@@@@@@@@@@@"
	};
	static unsigned char mcls[14][16] = {
		"OOOOOOOOOOOOOOO@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQ@@@@@@@QQQ$@",
		"OQQQ@@@@@@@QQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"O$$$$$$$$$$$$$$@",
		"@@@@@@@@@@@@@@@@"
	};
	int x, y;
	unsigned char tc, tbc, c;
	if (m != 0) {
		tc = _FFFFFF;
		tbc = _000084;
	} else {
		tc = _C6C6C6;
		tbc = _848484;
	}
	graphicBox(sht, tbc, 3, 3, sht->sx - 4, 20);
	graphicPuts(sht, tc, 24, 4, title);

	for (y = 0; y < 14; y++) {
		for (x = 0; x < 16; x++) {
			c = bcls[y][x];
			if (c == '@') { c = _000000; }
			else if (c == '$') { c = _848484; }
			else if (c == 'Q') { c = _C6C6C6; }
			else { c = _FFFFFF; }
			sht->buf[(5 + y) * sht->sx + (sht->sx - 21 + x)] = c;
		}
	}
	for (y = 0; y < 14; y++) {
		for (x = 0; x < 16; x++) {
			c = mcls[y][x];
			if (c == '@') { c = _000000; }
			else if (c == '$') { c = _848484; }
			else if (c == 'Q') { c = _C6C6C6; }
			else { c = _FFFFFF; }
			sht->buf[(5 + y) * sht->sx + (sht->sx - 39 + x)] = c;
		}
	}
	return;
}

void winAlloc(struct sheet *sht, unsigned char *title, char m)
{
	graphicBox(sht, _C6C6C6,           0,           0, sht->sx - 1,           0);
	graphicBox(sht, _FFFFFF,           1,           1, sht->sx - 2,           1);
	graphicBox(sht, _C6C6C6,           0,           0,           0, sht->sy - 1);
	graphicBox(sht, _FFFFFF,           1,           1,           1, sht->sy - 2);
	graphicBox(sht, _848484, sht->sx - 2,           1, sht->sx - 2, sht->sy - 2);
	graphicBox(sht, _000000, sht->sx - 1,           0, sht->sx - 1, sht->sy - 1);
	graphicBox(sht, _C6C6C6,           2,           2, sht->sx - 3, sht->sy - 3);
	graphicBox(sht, _848484,           1, sht->sy - 2, sht->sx - 2, sht->sy - 2);
	graphicBox(sht, _000000,           0, sht->sy - 1, sht->sx - 1, sht->sy - 1);
	winAlloc0(sht, title, m);
	tbarAdd(sht, title);
	return;
}

void winChange(struct sheet *sht, char m)
{
	int x, y;
	unsigned char ntb, ntc, otb, otc, c;
	if (m != 0) {
		ntc = _FFFFFF;
		ntb = _000084;
		otc = _C6C6C6;
		otb = _848484;
	} else {
		ntc = _C6C6C6;
		ntb = _848484;
		otc = _FFFFFF;
		otb = _000084;
	}

	for (y = 3; y <= 20; y++) {
		for (x = 3; x <= sht->sx - 4; x++) {
			c = sht->buf[y * sht->sx + x];
			if (c == otc && x <= sht->sx - 39) {
				c = ntc;
			} else if (c == otb) {
				if (y < 5 || 18 < y) {
					c = ntb;
				} else {
					if ((x < sht->sx - 39 || sht->sx - 24 < x) && (x < sht->sx - 21 || sht->sx - 6 < x)) {
						c = ntb;
					}
				}
			}
			sht->buf[y * sht->sx + x] = c;
		}
	}
	shtRefresh(sht, 3, 3, sht->sx, 21);
	return;
}

void textbox(struct sheet *sht, unsigned char c, int x0, int y0, int sx, int sy)
{
	int x1 = x0 + sx, y1 = y0 + sy;

	graphicBox(sht, _848484, x0 - 2, y0 - 3, x1 + 1, y0 - 3);
	graphicBox(sht, _848484, x0 - 3, y0 - 3, x0 - 3, y1 + 1);
	graphicBox(sht, _FFFFFF, x0 - 3, y1 + 2, x1 + 1, y1 + 2);
	graphicBox(sht, _FFFFFF, x1 + 2, y0 - 3, x1 + 2, y1 + 2);
	graphicBox(sht, _000000, x0 - 1, y0 - 2, x1 + 0, y0 - 2);
	graphicBox(sht, _000000, x0 - 2, y0 - 2, x0 - 2, y1 + 0);
	graphicBox(sht, _C6C6C6, x0 - 2, y1 + 1, x1 + 0, y1 + 1);
	graphicBox(sht, _C6C6C6, x1 + 1, y0 - 2, x1 + 1, y1 + 1);
	graphicBox(sht,            c, x0 - 1, y0 - 1, x1 + 0, y1 + 0);
	return;
}

void winOn(struct sheet *skey)
{
	winChange(skey, 1);
	if ((skey->flag & SHEET_CUR) != 0) {
		fifoPut(&skey->task->fifo, 2);
	}
	tbarSelect(skey);
	return;
}

void winOff(struct sheet *skey)
{
	if (skey != 0) {
		winChange(skey, 0);
		if ((skey->flag & SHEET_CUR) != 0) {
			fifoPut(&skey->task->fifo, 3);
		}
		tbarUnselect();
	}
	return;
}

void winRefresh(void)
{
	struct fifo *fifo = (struct fifo *) *((int *) FIFO_ADDR);
	fifoPut(fifo, 2);
	return;
}

void dialog(char *s)
{
	struct task *task = taskNow();
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct sheet *sht;
	unsigned char *sbuf, str[65];
	int i, j = 0, k, x = 0, y = 1;
	for (i = 0; s[i] != 0x00; i++) {
		if (s[i] == 0x0a) {
			if (x < j) {
				x = j;
			}
			j = 0;
			y++;
		} else if (s[i] != 0x0d) {
			j++;
		}
	}
	if (x < j) {
		x = j;
	}
	if (64 < x) {
		return;
	}
	x = 16 + 8 * x;
	if (x < 160) {
		x = 160;
	}
	y = 36 + 16 * y;
	sht = shtAlloc();
	sbuf = (unsigned char *) memAlloc(mem, x * y);
	shtSet(sht, sbuf, x, y, -1);
	winAlloc(sht, "_CAO", 0);
	j = 0;
	k = 28;
	for (i = 0; s[i] != 0x00; i++) {
		if (s[i] == 0x0a) {
			str[j] = 0;
			graphicPuts(sht, _000000, 8, k, str);
			k += 16;
			j = 0;
		} else if (s[i] != 0x0d) {
			str[j] = s[i];
			j++;
		}
	}
	str[j] = 0;
	graphicPuts(sht, _000000, 8, k, str);
	sht->task = task;
	sht->flag |= SHEET_DIALOGUE;
	shtApp(sht);
	winRefresh();
	for (;;) {
		cli();
		if ((sht->flag & SHEET_DIALOGUE) == 0) {
			sti();
			break;
		} else {
			if (fifoStat(&task->fifo) == 0) {
				taskSleep(task);
				sti();
			} else {
				i = fifoGet(&task->fifo);
				sti();
//				if (i == 256 + 0x0a) {
//					break;
//				}
			}
		}
	}
	sht->flag &= ~SHEET_DIALOGUE;
	shtFree(sht);
	memFree(mem, (unsigned int) sbuf, x * y);
	return;
}

int inputDialog(char *buf, int n)
{
	struct task *task = taskNow();
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct sheet *sht = shtAlloc();
	unsigned char *sbuf = (unsigned char *) memAlloc(mem, (16 + n * 8) * 56), s[2];
	int i, j, x = 8;
	shtSet(sht, sbuf, (16 + n * 8), 54, -1);
	winAlloc(sht, "̓_CAO", 0);
	textbox(sht, _FFFFFF, 8, 28, n * 8, 18);
	graphicBox(sht, _000000, x, 28, x + 7, 43);
	sht->task = task;
	sht->flag |= SHEET_DIALOGUE | SHEET_CUR;
	shtApp(sht);
	winRefresh();
	s[1] = 0;
	j = _000000;
	for (;;) {
		cli();
		if ((sht->flag & SHEET_DIALOGUE) == 0) {
			sti();
			x = 8;
			break;
		} else {
			if (fifoStat(&task->fifo) == 0) {
				taskSleep(task);
				sti();
			} else {
				i = fifoGet(&task->fifo);
				sti();
				if (i == 2) {
					j = _000000;
				} else if (i == 3) {
					j = _FFFFFF;
				} else if (256 <= i && i < 512) {
					i -= 256;
					if (i == 0x08) {
						if (8 < x) {
							graphicBox(sht, _FFFFFF, x, 28, x + 7, 43);
							shtRefresh(sht, x, 28, x + 8, 44);
							buf[x] = 0x00;
							x -= 8;
						}
					} else if (i == 0x0a) {
						break;
					} else {
						if (((x - 8) / 8) < n - 1) {
							buf[(x - 8) / 8] = i;
							s[0] = i;
							graphicBox(sht, _FFFFFF, x, 28, x + 7, 43);
							graphicPuts(sht, _000000, x, 28, s);
							shtRefresh(sht, x, 28, x + 8, 44);
							x += 8;
						}
					}
				}
				graphicBox(sht, j, x, 28, x + 7, 43);
				shtRefresh(sht, x, 28, x + 8, 44);
			}
		}
	}
	sht->flag &= ~(SHEET_DIALOGUE | SHEET_CUR);
	buf[(x - 8) / 8] = 0;
	shtFree(sht);
	memFree(mem, (unsigned int) sbuf, (16 + n * 8) * 56);
	return (x - 8) / 8;
}

int ssaverWait(int time)
{
	struct task *task = taskNow();
	struct timer *timer = timerAlloc();
	int i;
	timerInit(timer, &task->fifo);
	timerSet(timer, time, 1);
	for (;;) {
		cli();
		if (fifoStat(&task->fifo) == 0) {
			taskSleep(task);
			sti();
		} else {
			i = fifoGet(&task->fifo);
			sti();
			if (i == 1) {
				return 0;
			} else if (i == 2) {
				timerCancel(timer);
				return 1;
			}
		}
	}
}

void ssaverDraw(struct sheet *sht, unsigned char j, int x, int y)
{
 	struct binfo *binfo = (struct binfo *) BINFO_ADDR;
	int vx = x * 2 + binfo->scrnx / 2, vy = y * 2 + binfo->scrny / 2;
	graphicBox(sht, j, vx, vy, vx + 1, vy + 1);
	shtRefresh(sht, vx, vy, vx + 2, vy + 2);
	return;
}

void ssaverTask(struct sheet *sht)
{
	extern struct sheets *shts;
 	struct binfo *binfo = (struct binfo *) BINFO_ADDR;
	struct task *task = taskNow();
	struct timer *timer = timerAlloc();
	int i, j, mode = 0;
	double rd;
	timerInit(timer, &task->fifo);
	timerSet(timer, 5 * 60 * 100, 1);
	for (;;) {
		cli();
		if (fifoStat(&task->fifo) == 0) {
			taskSleep(task);
			sti();
		} else {
			i = fifoGet(&task->fifo);
			sti();
			if (i == 1) {
				mode = 1;
				shtUpdown(sht, shts->top + 1);
restart:
				graphicBox(sht, _000000, 0, 0, binfo->scrnx - 1, binfo->scrny - 1);
				shtRefresh(sht, 0, 0, binfo->scrnx, binfo->scrny);
				for (i = 0; i < 360; i++) {
					rd = 3.14159 * i / 180;
					for (j = 0; j < 8; j++) {
						ssaverDraw(sht, j, cos(rd) * cos(6 * rd) * (j + 1) * 10, sin(rd) * cos(6 * rd) * (j + 1) * 10);
					}
					if (ssaverWait(2) != 0) {
						goto off;
					}
				}
				if (ssaverWait(1) != 0) {
					goto off;
				}
				goto restart;
			} else if (i == 2) {
off:
				if (mode != 0) {
					shtUpdown(sht, -1);
					mode = 0;
				}
				timerCancel(timer);
				timerSet(timer, 5 * 60 * 100, 1);
			}
		}
	}
}

struct task *ssaverInit(void)
{
 	struct binfo *binfo = (struct binfo *) BINFO_ADDR;
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct task *task = taskAlloc("Screen-saver");
	struct sheet *sht = shtAlloc();
	unsigned char *sbuf = (unsigned char *) memAlloc(mem, binfo->scrnx * binfo->scrny);
	int *fbuf = (int *) memAlloc(mem, 128 * 4);
	task->stack = memAlloc(mem, 64 * 1024);
	task->tss.esp = task->stack + 64 * 1024 - 8;
	task->tss.eip = (int) &ssaverTask;
	task->tss.es = 1 * 8;
	task->tss.cs = 2 * 8;
	task->tss.ss = 1 * 8;
	task->tss.ds = 1 * 8;
	task->tss.fs = 1 * 8;
	task->tss.gs = 1 * 8;
	*((int *) (task->tss.esp + 4)) = (int) sht;
	fifoInit(&task->fifo, fbuf, 128, task);
	shtSet(sht, sbuf, binfo->scrnx, binfo->scrny, -1);
	shtSlide(sht, 0, 0);
	taskRun(task, 2, 2);
	return task;
}
