#include "../api.h"
#include <stdio.h>
#include <string.h>
#define WIN_X	60
#define WIN_Y	20
#define TAB		4
#define TEMP	512
struct line {
	struct line *next;
	int no, size;
	unsigned char *str;
};
struct memo {
	int win, skipx, skipy, cx, cy;
	unsigned char *wbuf, c2b, change;
	struct line *text;
};

struct line *lineMake(void)
{
	struct line *line = (struct line *) malloc(sizeof(struct line));
	line->next = 0;
	line->no = 0;
	line->size = 1;
	line->str = malloc(line->size);
	line->str[line->size - 1] = 0;
	return line;
}

void linePutc(struct line *line, int col, unsigned char c)
{
	struct line *l;
	unsigned char *p;
	int i;
	if (c == 0x0a) {
		l = line->next;
		line->next = lineMake();
		line->next->next = l;
		return;
	}
	if (col >= line->size - 1) {
		line->size++;
		col = line->size - 2;
		p = malloc(line->size);
		for (i = 0; i < line->size - 1; i++) {
			p[i] = line->str[i];
		}
		p[i] = 0;
		free(line->str);
		line->str = p;
	}
	line->str[col] = c;
	return;
}

void lineDelc(struct line *line, int col)
{
	unsigned char *p;
	int i;
	for (i = col; i < line->size - 1; i++) {
		line->str[i] = line->str[i + 1];
	}
	p = malloc(line->size - 1);
	for (i = 0; i <= line->size - 1; i++) {
		p[i] = line->str[i];
	}
	free(line->str);
	line->str = p;
	line->size--;
	line->str[line->size - 1] = 0;
	return;
}

struct line *lineInit(unsigned char *text)
{
	struct line *line = lineMake(), *l = line;
	int col = 0, i;
	for (i = 0; text[i] != 0x00; i++) {
		if (text[i] != 0x0d) {
			linePutc(l, col, text[i]);
		}
		col++;
		if (text[i] == 0x0a) {
			l->next = lineMake();
			l = l->next;
			col = 0;
		}
	}
	return line;
}

void puttab(int *x, int skipx, unsigned char *s)
{
	for (;;) {
		if (0 <= *x && *x < WIN_X) {
			s[*x] = ' ';
		}
		(*x)++;
		if ((skipx + *x) % TAB == 0) {
			return;
		}
	}
}

void lview(int win, int y, int skipx, unsigned char *p)
{
	int x = -skipx;
	unsigned char s[WIN_X];
	for (;;) {
		if (*p == 0) {
			break;
		} else if (*p == 0x09) {
			puttab(&x, skipx, s);
			p++;
		} else if (*p == 0x0a) {
			p++;
			break;
		} else if ((0x81 <= *p && *p <= 0x9f) || (0xe0 <= *p && *p <= 0xfc)) {
			if (x == -1) {
				s[0] = ' ';
			} else if (0 <= x && x < WIN_X) {
				s[x] = *p;
				s[x + 1] = p[1];
			} else if (x == WIN_X) {
				s[x] = ' ';
			}
			x += 2;
			p += 2;
		} else {
			if (0 <= x && x < WIN_X) {
				s[x] = *p;
			}
			x++;
			p++;
		}
	}
	if (x > WIN_X) {
		x = WIN_X;
	}
	if (x > 0) {
		tWputs(win, _000000, 8, y * 16 + 28, s, x);
	}
	return;
}

struct line *getlAtnum(struct memo *memo, int no)
{
	struct line *line = memo->text;
	int i;
	for (i = 0; i < no; i++) {
		line = line->next;
	}
	return line;
}

int isKanji(unsigned char c)
{
	if ((0x81 <= c && c <= 0x9f) || (0xe0 <= c && c <= 0xfc)) {
		return 1;
	}
	return 0;
}

int curPrint(struct memo *memo)
{
	struct line *line = getlAtnum(memo, memo->cy - memo->skipy);
	int x = 0, x0, y0, x1, i, j, k;
	if (memo->cy - memo->skipy < 0 || memo->cy - memo->skipy >= WIN_Y) {
		memo->skipy = memo->cy - WIN_Y + 1;
		return 1;
	}
	if (memo->cx - memo->skipx < 0) {
		memo->skipx = memo->cx - WIN_X + 1;
		return 1;
	}
	if (isKanji(line->str[memo->cx]) != 0) {
		memo->c2b = 1;
		for (i = 1; memo->cx - i >= 0 && isKanji(line->str[memo->cx - i]) != 0; i++) { }
		if (memo->cx > 0 && (i % 2) == 0) {
			memo->cx--;
			if (memo->cx - memo->skipx < 0) {
				memo->skipx = memo->cx - WIN_X + 1;
			}
			return 1;
		}
	} else {
		memo->c2b = 0;
		if (memo->cx > 0 && isKanji(line->str[memo->cx - 1]) != 0) {
			memo->cx--;
			memo->c2b = 1;
			if (memo->cx - memo->skipx < 0) {
				memo->skipx = memo->cx - WIN_X + 1;
			}
			return 1;
		}
	}
	j = memo->skipx;
	k = memo->skipx;
	for (i = memo->skipx; i < memo->cx; i++) {
		if (line->str[i] == 0x09) {
			x += 4;
		} else {
			x++;
		}
		if (isKanji(line->str[i]) != 0) {
			if (x + 1 >= WIN_X) {
				k = (x + 1) - WIN_X + 1;
			}
		}
		if (x >= WIN_X) {
			k = x - WIN_X + 1;
		}
	}
	if (j != k) {
		memo->skipx = k;
		return 1;
	}
	x0 = 8 + x * 8;
	y0 = 28 + (memo->cy - memo->skipy) * 16;
	if (memo->c2b == 0) {
		x1 = x0 + 8;
	} else {
		x1 = x0 + 16;
	}
	for (i = y0; i < y0 + 16; i++) {
		for (j = x0; j < x1; j++) {
			if (memo->wbuf[i * (WIN_X * 8 + 16) + j] == _000000) {
				memo->wbuf[i * (WIN_X * 8 + 16) + j] = _FFFFFF;
			} else {
				memo->wbuf[i * (WIN_X * 8 + 16) + j] = _000000;
			}
		}
	}
	return 0;
}

void tview(struct memo *memo)
{
	struct line *line;
	char s[32];
	int i, j;
	for (;;) {
		line = getlAtnum(memo, memo->skipy);
		if (memo->skipx < 0) {
			memo->skipx = 0;
		}
		if (memo->skipy < 0) {
			memo->skipy = 0;
		}
		tTbox(memo->win + 1, _FFFFFF, 8, 28, WIN_X * 8, WIN_Y * 16);
		for (i = 0; i < WIN_Y; i++) {
			lview(memo->win + 1, i, memo->skipx, line->str);
			if (line->next == 0) {
				break;
			}
			line = line->next;
		}
		if (curPrint(memo) == 0) {
			sprintf(s, "%ds %d  SJIS  CRLF", memo->cy + 1, memo->cx + 1);
			j = strlen(s);
			tWbox(memo->win, _C6C6C6, WIN_X * 8 + 8 - j * 8, WIN_Y * 16 + 37, WIN_X * 8 + 8, WIN_Y * 16 + 37 + 16);
			if (memo->change != 0) {
				tWputs(memo->win, _FF0000, WIN_X * 8 + 8 - j * 8, WIN_Y * 16 + 37, s, -1);
			} else {
				tWputs(memo->win, _000000, WIN_X * 8 + 8 - j * 8, WIN_Y * 16 + 37, s, -1);
			}
			tWrefresh(memo->win, 5, 25, WIN_X * 8 + 10, WIN_Y * 16 + 37 + 16);
			return;
		}
	}
}

void putcAtcur(struct memo *memo, unsigned char c)
{
	struct line *line = getlAtnum(memo, memo->cy), *l;
	unsigned char *p;
	int i;
	if (c == 0x0a) {
		l = lineMake();
		for (i = memo->cx; line->str[i] != 0x00; i++) {
			linePutc(l, i - memo->cx, line->str[i]);
		}
		l->next = line->next;
		line->next = l;
		line->size = memo->cx + 1;
		p = malloc(line->size);
		for (i = 0; i < line->size - 1; i++) {
			p[i] = line->str[i];
		}
		p[i] = 0;
		free(line->str);
		line->str = p;
		memo->cx = 0;
		memo->cy++;
	} else {
		linePutc(line, line->size, ' ');
		for (i = line->size - 2; i > memo->cx; i--) {
			line->str[i] = line->str[i - 1];
		}
		linePutc(line, memo->cx, c);
		memo->cx++;
	}
	return;
}

void delcAtcur(struct memo *memo)
{
	struct line *line = getlAtnum(memo, memo->cy), *l;
	int i, j;
	if (memo->cx == 0 && memo->cy == 0) {
		return;
	}
	if (memo->cx == 0) {
		for (l = memo->text; l->next != line; l = l->next) { }
		j = l->size - 1;
		for (i = memo->cx; line->str[i] != 0x00; i++) {
			linePutc(l, l->size, line->str[i]);
		}
		l->next = line->next;
		free(line->str);
		free(line);
		memo->cx = j;
		memo->cy--;
		return;
	}
	if (memo->cx >= 2 && isKanji(line->str[memo->cx - 2]) != 0) {
		lineDelc(line, memo->cx - 1);
		memo->cx--;
	}
	lineDelc(line, memo->cx - 1);
	if (line->size == 1) {
		for (l = memo->text; l->next != line; l = l->next) { }
		l->next = line->next;
		free(line->str);
		free(line);
		memo->cx = 0;
		return;
	}
	memo->cx--;
	return;
}

void flush(struct memo *memo, char *name)
{
	struct line *line;
	int fh;
char s[32];
	fh = tFopen(name);
	if (fh == 0) {
		tDialog("t@C֏o܂B\n");
		return;
	}
	tFdelete(fh);
	fh = tFcreate(name);
	for (line = memo->text; line != 0; line = line->next) {
		tFwrite(fh, line->str, line->size - 1);
		tFwrite(fh, "\015\012", 2);
	}
	tFclose(fh);
	return;
}

void HariMain(void)
{
	struct memo memo;
	struct line *t, *u;
	unsigned char wbuf[(WIN_X * 8 + 16) * (WIN_Y * 16 + 37 + 24)], tbuf[TEMP * 1024];
	unsigned char line[31], s[31], *p, *q = 0;
	int i = 0, j;
	i = tFinput(line, 31);
	j = tFsize(i, 0);
	if (j >= TEMP * 1024 - 1) {
		j = TEMP * 1024 - 1;
	}
	j = tFread(i, tbuf, j);
	tFclose(i);
	tbuf[j] = 0;
	q = tbuf;
	for (p = tbuf; *p != 0; p++) {
		if (*p != 0x0d) {
			*q = *p;
			q++;
		}
	}
	*q = 0;
	memo.text = lineInit(tbuf);
	sprintf(s, "%s - ", line);
	memo.win = tWopen(wbuf, WIN_X * 8 + 16, WIN_Y * 16 + 37 + 24, -1, s);
	memo.skipx = 0;
	memo.cx = 0;
	memo.cy = 0;
	memo.c2b = 0;
	memo.change = 0;
	memo.skipx = 0;
	memo.skipy = 0;
	memo.wbuf = wbuf;

	t = memo.text;
	for (;;) {
		tview(&memo);
		i = tGetc(1);
		if (i == KEY_LEFT) {
			for (;;) {
				if (memo.cx > 0) {
					memo.cx--;
				} else {
					u = memo.text;
					if (t != u) {
						for (; u->next != t; u = u->next) { }
					}
					if (u != t || t != memo.text) {
						t = u;
						memo.cy--;
						memo.cx = t->size - 1;
					}
				}
				if (tGetc(0) != KEY_LEFT) {
					break;
				}
			}
		} else if (i == KEY_RIGHT) {
			for (;;) {
				if (memo.cx < t->size - 1) {
					memo.cx++;
					if (memo.c2b != 0 && memo.cx < t->size - 1) {
						memo.cx++;
					}
				} else {
					if (t->next != 0) {
						memo.cy++;
						t = t->next;
						memo.cx = 0;
					}
				}
				if (tGetc(0) != KEY_RIGHT) {
					break;
				}
			}
		} else if (i == KEY_UP) {
			for (;;) {
				u = memo.text;
				if (t != u) {
					for (; u->next != t; u = u->next) { }
				}
				if (u != t || t != memo.text) {
					t = u;
					memo.cy--;
					if (memo.cx > t->size - 1) {
						memo.cx = t->size - 1;
					}
				}
				if (tGetc(0) != KEY_UP) {
					break;
				}
			}
		} else if (i == KEY_DOWN) {
			for (;;) {
				if (t->next != 0) {
					t = t->next;
					memo.cy++;
					if (memo.cx > t->size - 1) {
						memo.cx = t->size - 1;
					}
				}
				if (tGetc(0) != KEY_DOWN) {
					break;
				}
			}
		} else if (i == 0x08) {
			memo.change = 1;
			delcAtcur(&memo);
			t = getlAtnum(&memo, memo.cy);
		} else if ((0x20 <= i && i <= 0x7e) || i == 0x09 || i == 0x0a) {
			memo.change = 1;
			putcAtcur(&memo, i);
			t = getlAtnum(&memo, memo.cy);
		} else if (i == 0xff) {
			flush(&memo, line);
			memo.change = 0;
		}
	}
}
