; HariboteOS IPL

CYLS	equ 4	; ǂݍރV_

	org 0x7c00	; vO̊JnAhX

; WFAT12tH[}bǧ`
	jmp entry		; tH[}bg΂
	db 0x90			; sȒl
	db "TBITOS  "		; u[gZN^̖O
	dw 512			; ZN^̑傫
	db 1			; ZN^Pʂ̃NX^̑傫
	dw 1			; FAT̊JnZN^ԍ
	db 2			; FAT̐
	dw 224			; [gfBNg̈̑傫
	dw 2880			; ZN^Pʂ̃hCȗ傫
	db 0xf0			; fBA^Cv
	dw 9			; ZN^PʂFAT̑傫
	dw 18			; ZN^Pʂ̃gbN̑傫
	dw 2			; wbh̐
	dd 0			; p[eBV̐
	dd 2880			; ZN^Pʂ̃hCȗ傫
	db 0, 0, 0x29		; sȒl
	dd 0xffffffff		; {[VAԍ
	db "TBITOS     "	; fBXN̖O
	db "FAT12   "		; tH[}bg̖O
	resb 18

; vO
entry:
; WX^̏
	mov ax, 0
	mov ss, ax
	mov sp, 0x7c00
	mov ds, ax

; fBXNǂ
	mov ax, 0x0820
	mov es, ax
	mov ch, 0			; V_0
	mov dh, 0			; wbh0
	mov cl, 2			; ZN^2
	mov bx, 18 * 2 * CYLS - 1	; ǂݍ݂vZN^
	call readfast			; ǂݍ

; haribote.syss
	mov byte [0x0ff0], CYLS	; 0x0ff0ɓǂݍ񂾃V_
	jmp 0xc200		; OSփWv

fin:
; I
	hlt
	jmp fin

error:
; [hG[̕\
	mov ax, 0
	mov es, ax
	mov si, msg

putloop:
	mov al, [si]
	inc si
	cmp al, 0
	je fin
	mov ah, 0x0e
	mov bx, 15	; J[R[h
	int 0x10	; ꕶ\
	jmp putloop

readfast:	; axgĂł邾܂Ƃ߂ēǂݏo
		; es:ǂݍݔԒn, ch:V_, dh:wbh, cl:ZN^, bx:ǂݍ݃ZN^
	mov ax, es	; ESAL̍őlvZ
	shl ax, 3	; AX32ŊǍʂAH֓ꂽƂɂȂiփVtgj
	and ah, 0x7f	; AHAH128Ŋ܂i512 * 128 = 64Kj
	mov al, 128	; AL = 128 - AH; ԋ߂64KBE܂ōő剽ZN^邩
	sub al, ah

	mov ah, bl	; bxal̍őlahɌvZ
	cmp bh, 0	; if(bh != 0) { ah = 18; }
	je .skip1
	mov ah, 18

.skip1:
	cmp al, ah	; if(al > ah) { al = ah; }
	jbe .skip2
	mov al, ah

.skip2:
	mov ah, 19	; clal̍őlahɌvZ
	sub ah, cl	; ah = 19 - cl;
	cmp al, ah	; if(al > ah) { al = ah; }
	jbe .skip3
	mov al, ah

.skip3:
	push bx
	mov si, 0	; G[JE^

retry:
	mov ah, 0x02
	mov bx, 0
	mov dl, 0x00	; AhCu
	push es
	push dx
	push cx
	push ax
	int 0x13	; fBXN̓ǂݏo
	jnc next	; Ȃnext
	inc si
	cmp si, 5
	jae error	; 5sĂȂerror
	mov ah, 0x00
	mov dl, 0x00	; AhCu
	int 0x13	; hCũZbg
	pop ax
	pop cx
	pop dx
	pop es
	jmp retry

next:
	pop ax
	pop cx
	pop dx
	pop bx		; es̓ebxŎ󂯎
	shr bx, 5	; bx16oCgPʂ512oCgPʂ
	mov ah, 0
	add bx, ax	; bx += al;
	shl bx, 5	; bx512oCgPʂ16oCgPʂ
	mov es, bx	; es += al * 0x20; ̑
	pop bx
	sub bx, ax
	jz .ret
	add cl, al
	cmp cl, 18
	jbe readfast	; 18ZN^ǂ
	mov cl, 1
	inc dh
	cmp dh, 2
	jb readfast	; ʓǂ
	mov dh, 0
	inc ch
	jmp readfast

.ret:
	ret

msg:	; ǂݍ݃G[̂Ƃ̃bZ[W
	db 0x0a, 0x0a
	db "Load error."
	db 0x0a, 0

	resb 0x7dfe - $	; 0x7dfe܂0x00Ŗ߂
	db 0x55, 0xaa
