/* O֌W */

#include "bootpack.h"
#include <stdio.h>

int *except_fpu(int *esp)
{
	struct task *task = task_now();

	cli();
	clts();
	if(tasks->tfpu != task) {
		if(tasks->tfpu != 0) {
			fnsave(tasks->tfpu->fpu);
		}
		frstor(task->fpu);
		tasks->tfpu = task;
	}
	sti();
	return 0;
}

int *except_stack(int *esp)
{
	struct task *task = task_now();
	struct console *cons = task->cons;
	char s[30];

	cons_fonts(cons, "\nint 0x0c:\ñvO̓X^bNیOɂAI܂B\n");
	sprintf(s, "eip = 0x%08x\n", esp[11]);
	cons_fonts(cons, s);
	sprintf(s, "ss  = 0x%08x\n", esp[15]);
	cons_fonts(cons, s);
	sprintf(s, "esp = 0x%08x\n", esp[14]);
	cons_fonts(cons, s);
	return &(task->tss.esp0);
}

int *except_general(int *esp)
{
	struct task *task = task_now();
	struct console *cons = task->cons;
	char s[30];

	cons_fonts(cons, "\nint 0x0d:\ñvOAʕیOɂAI܂B\n");
	sprintf(s, "eip = 0x%08x\n", esp[11]);
	cons_fonts(cons, s);
	sprintf(s, "ss  = 0x%08x\n", esp[15]);
	cons_fonts(cons, s);
	sprintf(s, "esp = 0x%08x", esp[14]);
	cons_fonts(cons, s);
	return &(task->tss.esp0);
}

void except_dfint(int *esp)
{
	/* PIC0̕sS荞ݑ΍ */
	outb(PIC0_OCW2, 0x67);	/* IRQ-07tPICɒʒm */
	return;
}
